"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePack = void 0;
var _reactQuery = require("@tanstack/react-query");
var _constants = require("../../common/constants");
var _kibana = require("../common/lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const usePack = ({
  packId,
  skip = false
}) => {
  const {
    http
  } = (0, _kibana.useKibana)().services;
  return (0, _reactQuery.useQuery)(['pack', {
    packId
  }], () => http.get(`/api/osquery/packs/${packId}`, {
    version: _constants.API_VERSIONS.public.v1
  }), {
    select: response => response === null || response === void 0 ? void 0 : response.data,
    keepPreviousData: true,
    enabled: !!(!skip && packId)
  });
};
exports.usePack = usePack;