"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useOsqueryIntegrationStatus = void 0;
var _i18n = require("@kbn/i18n");
var _reactQuery = require("@tanstack/react-query");
var _constants = require("../../../common/constants");
var _kibana = require("../lib/kibana");
var _use_error_toast = require("./use_error_toast");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useOsqueryIntegrationStatus = () => {
  const {
    http
  } = (0, _kibana.useKibana)().services;
  const setErrorToast = (0, _use_error_toast.useErrorToast)();
  return (0, _reactQuery.useQuery)(['integration'], () => http.get('/internal/osquery/status', {
    version: _constants.API_VERSIONS.internal.v1
  }), {
    onError: error => setErrorToast(error, {
      title: _i18n.i18n.translate('xpack.osquery.osquery_integration.fetchError', {
        defaultMessage: 'Error while fetching osquery integration'
      })
    }),
    refetchOnReconnect: false,
    refetchOnWindowFocus: false
  });
};
exports.useOsqueryIntegrationStatus = useOsqueryIntegrationStatus;