"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TOO_MANY_AGENT_IDS = exports.PARAMETER_NOT_FOUND = exports.LICENSE_TOO_LOW = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LICENSE_TOO_LOW = exports.LICENSE_TOO_LOW = _i18n.i18n.translate('xpack.osquery.liveQueryActions.error.licenseTooLow', {
  defaultMessage: 'At least Platinum license is required to use Response Actions.'
});
const PARAMETER_NOT_FOUND = exports.PARAMETER_NOT_FOUND = _i18n.i18n.translate('xpack.osquery.liveQueryActions.error.notFoundParameters', {
  defaultMessage: "This query hasn't been called due to parameter used and its value not found in the alert."
});
const TOO_MANY_AGENT_IDS = exports.TOO_MANY_AGENT_IDS = _i18n.i18n.translate('xpack.osquery.actionResults.error.tooManyAgentIds', {
  defaultMessage: 'Too many agent IDs in URL (max 100). Either reduce the list or omit agentIds to query all agents from the action.'
});