"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.withConverseSpan = withConverseSpan;
var _rxjs = require("rxjs");
var _std = require("@kbn/std");
var _inferenceTracing = require("@kbn/inference-tracing");
var _onechatCommon = require("@kbn/onechat-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function withConverseSpan({
  agentId,
  conversationId
}, cb) {
  return (0, _inferenceTracing.withActiveInferenceSpan)('Converse', {
    attributes: {
      [_inferenceTracing.ElasticGenAIAttributes.InferenceSpanKind]: 'CHAIN',
      [_inferenceTracing.ElasticGenAIAttributes.AgentId]: agentId,
      [_inferenceTracing.ElasticGenAIAttributes.AgentConversationId]: conversationId
    }
  }, span => {
    if (!span) {
      return cb();
    }
    return cb(span).pipe((0, _rxjs.tap)({
      next: event => {
        if ((0, _onechatCommon.isRoundCompleteEvent)(event)) {
          var _safeJsonStringify;
          span.setAttribute('output.value', (_safeJsonStringify = (0, _std.safeJsonStringify)(event.data)) !== null && _safeJsonStringify !== void 0 ? _safeJsonStringify : 'unknown');
        }
      }
    }));
  });
}