"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateToolSelection = validateToolSelection;
var _onechatCommon = require("@kbn/onechat-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function validateToolSelection({
  toolRegistry,
  toolSelection
}) {
  const errors = [];
  for (const selection of toolSelection) {
    const {
      tool_ids: toolIds
    } = selection;
    for (const toolId of toolIds) {
      if (toolId === _onechatCommon.allToolsSelectionWildcard) {
        // Wildcard selection is valid as long as tools exist
        continue;
      } else {
        // Specific tool selection - check if tool exists
        const exists = await toolRegistry.has(toolId);
        if (!exists) {
          errors.push(`Tool id '${toolId}' does not exist.`);
        }
      }
    }
  }
  return errors;
}