"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStepsFromPrevRounds = exports.useHasActiveConversation = exports.useConversationTitle = exports.useConversationStatus = exports.useConversationRounds = exports.useConversation = exports.useAgentId = void 0;
var _reactQuery = require("@tanstack/react-query");
var _react = require("react");
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
var _onechatCommon = require("@kbn/onechat-common");
var _query_keys = require("../query_keys");
var _new_conversation = require("../utils/new_conversation");
var _use_conversation_id = require("./use_conversation_id");
var _use_is_sending_message = require("./use_is_sending_message");
var _use_onechat_service = require("./use_onechat_service");
var _storage_keys = require("../storage_keys");
var _send_message_context = require("../context/send_message/send_message_context");
var _use_validate_agent_id = require("./agents/use_validate_agent_id");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useConversation = () => {
  const conversationId = (0, _use_conversation_id.useConversationId)();
  const {
    conversationsService
  } = (0, _use_onechat_service.useOnechatServices)();
  const queryKey = _query_keys.queryKeys.conversations.byId(conversationId !== null && conversationId !== void 0 ? conversationId : _new_conversation.newConversationId);
  const isSendingMessage = (0, _use_is_sending_message.useIsSendingMessage)();
  const {
    data: conversation,
    isLoading,
    isFetching,
    isFetched
  } = (0, _reactQuery.useQuery)({
    queryKey,
    // Disable query if we are on a new conversation or if there is a message currently being sent
    // Otherwise a refetch will overwrite our optimistic updates
    enabled: Boolean(conversationId) && !isSendingMessage,
    queryFn: () => {
      if (!conversationId) {
        return Promise.reject(new Error('Invalid conversation id'));
      }
      return conversationsService.get({
        conversationId
      });
    }
  });
  return {
    conversation,
    isLoading,
    isFetching,
    isFetched
  };
};
exports.useConversation = useConversation;
const useConversationStatus = () => {
  const {
    isLoading,
    isFetching,
    isFetched
  } = useConversation();
  return {
    isLoading,
    isFetching,
    isFetched
  };
};
exports.useConversationStatus = useConversationStatus;
const useGetNewConversationAgentId = () => {
  const [agentIdStorage] = (0, _useLocalStorage.default)(_storage_keys.storageKeys.agentId);
  const validateAgentId = (0, _use_validate_agent_id.useValidateAgentId)();

  // Ensure we always return a string
  return () => {
    const isAgentIdValid = validateAgentId(agentIdStorage);
    if (isAgentIdValid) {
      return agentIdStorage;
    }
    return _onechatCommon.oneChatDefaultAgentId;
  };
};
const useAgentId = () => {
  const {
    conversation
  } = useConversation();
  const agentId = conversation === null || conversation === void 0 ? void 0 : conversation.agent_id;
  const conversationId = (0, _use_conversation_id.useConversationId)();
  const isNewConversation = !conversationId;
  const getNewConversationAgentId = useGetNewConversationAgentId();
  if (agentId) {
    return agentId;
  }

  // For new conversations, agent id must be defined
  if (isNewConversation) {
    return getNewConversationAgentId();
  }
  return undefined;
};
exports.useAgentId = useAgentId;
const useConversationTitle = () => {
  var _conversation$title;
  const {
    conversation,
    isLoading
  } = useConversation();
  return {
    title: (_conversation$title = conversation === null || conversation === void 0 ? void 0 : conversation.title) !== null && _conversation$title !== void 0 ? _conversation$title : '',
    isLoading
  };
};
exports.useConversationTitle = useConversationTitle;
const useConversationRounds = () => {
  const {
    conversation
  } = useConversation();
  const {
    pendingMessage,
    error
  } = (0, _send_message_context.useSendMessage)();
  const conversationRounds = (0, _react.useMemo)(() => {
    var _conversation$rounds;
    const rounds = (_conversation$rounds = conversation === null || conversation === void 0 ? void 0 : conversation.rounds) !== null && _conversation$rounds !== void 0 ? _conversation$rounds : [];
    if (Boolean(error) && pendingMessage) {
      return [...rounds, {
        id: '',
        input: {
          message: pendingMessage
        },
        response: {
          message: ''
        },
        steps: []
      }];
    }
    return rounds;
  }, [conversation === null || conversation === void 0 ? void 0 : conversation.rounds, error, pendingMessage]);
  return conversationRounds;
};

// Returns a flattened list of all steps across all rounds.
// CAUTION: This uses `conversationRounds.length` as useMemo key to prevent re-renders during streaming. This will return stale data for the last round. It will only contain the complete set of steps up until the previous round.
exports.useConversationRounds = useConversationRounds;
const useStepsFromPrevRounds = () => {
  const conversationRounds = useConversationRounds();
  return (0, _react.useMemo)(() => {
    return conversationRounds.flatMap(({
      steps
    }) => steps);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [conversationRounds.length]); // only depend on length to avoid re-renders during streaming
};
exports.useStepsFromPrevRounds = useStepsFromPrevRounds;
const useHasActiveConversation = () => {
  const conversationId = (0, _use_conversation_id.useConversationId)();
  const conversationRounds = useConversationRounds();
  return Boolean(conversationId || conversationRounds.length > 0);
};
exports.useHasActiveConversation = useHasActiveConversation;