"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddDataPanel = AddDataPanel;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability_shared/public/components/add_data_panel/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/* eslint-disable @elastic/eui/href-or-on-click */
const tryItDefaultLabel = _i18n.i18n.translate('xpack.observabilityShared.addDataPabel.tryItButtonLabel', {
  defaultMessage: 'Try it now in our demo cluster'
});
const learnMoreDefaultLabel = _i18n.i18n.translate('xpack.observabilityShared.addDataPabel.learnMoreLinkLabel', {
  defaultMessage: 'Learn more'
});
function AddDataPanel({
  content,
  actions,
  onDismiss,
  onLearnMore,
  onTryIt,
  onAddData,
  'data-test-subj': dataTestSubj
}) {
  var _content$img, _content$img2, _actions$secondary, _actions$link, _content$img3, _content$img4;
  const {
    euiTheme,
    colorMode
  } = (0, _eui.useEuiTheme)();
  const imgSrc = `${(_content$img = content.img) === null || _content$img === void 0 ? void 0 : _content$img.baseFolderPath}/${colorMode === _eui.COLOR_MODES_STANDARD.dark ? 'dark' : 'light'}/${(_content$img2 = content.img) === null || _content$img2 === void 0 ? void 0 : _content$img2.name}`;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    paddingSize: "xl",
    style: {
      position: 'relative'
    },
    "data-test-subj": dataTestSubj,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 15
    }
  }, content.title)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 13
    }
  }, content.content), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 13
    }
  }, actions.primary.href && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "AddDataPanelAddDataButton",
    fill: true,
    href: actions.primary.href,
    onClick: onAddData,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 19
    }
  }, actions.primary.label)), ((_actions$secondary = actions.secondary) === null || _actions$secondary === void 0 ? void 0 : _actions$secondary.href) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "AddDataPanelTryItNowButton",
    iconType: "launch",
    iconSide: "right",
    href: actions.secondary.href,
    onClick: onTryIt,
    target: "_blank",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 19
    }
  }, actions.secondary.label || tryItDefaultLabel)), ((_actions$link = actions.link) === null || _actions$link === void 0 ? void 0 : _actions$link.href) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: actions.link.href,
    onClick: onLearnMore,
    target: "_blank",
    "data-test-subj": "AddDataPanelLearnMoreButton",
    external: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 19
    }
  }, actions.link.label || learnMoreDefaultLabel)))), content.img && ((_content$img3 = content.img) === null || _content$img3 === void 0 ? void 0 : _content$img3.position) === 'inside' && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      maxHeight: `${euiTheme.base * 16}px`,
      overflow: 'hidden',
      borderRadius: `${euiTheme.border.radius.medium}`,
      border: `${euiTheme.border.thin}`
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
    src: imgSrc,
    alt: content.content,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 15
    }
  })), onDismiss && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    style: {
      position: 'absolute',
      top: `${euiTheme.size.s}`,
      right: `${euiTheme.size.s}`
    },
    "data-test-subj": "AddDataPanelDismissButton",
    iconType: "cross",
    onClick: onDismiss,
    "aria-label": _i18n.i18n.translate('xpack.observabilityShared.addDataPabel.dismissButtonAriaLabel', {
      defaultMessage: 'Dismiss panel'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 13
    }
  }))), content.img && ((_content$img4 = content.img) === null || _content$img4 === void 0 ? void 0 : _content$img4.position) === 'below' && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
    src: imgSrc,
    alt: content.content,
    size: "fullWidth",
    style: {
      opacity: 0.4
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 11
    }
  })));
}