"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getGroupStats = void 0;
var _ruleDataUtils = require("@kbn/rule-data-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getGroupStats = (selectedGroup, bucket) => {
  var _bucket$sourceCountAg, _bucket$sourceCountAg2, _bucket$rulesCountAgg, _bucket$rulesCountAgg2, _bucket$rulesCountAgg3, _bucket$rulesCountAgg4;
  const defaultBadges = [{
    title: 'Alerts:',
    badge: {
      value: bucket.doc_count,
      width: 50
    }
  }];
  switch (selectedGroup) {
    case _ruleDataUtils.ALERT_RULE_NAME:
      return [{
        title: 'Sources:',
        badge: {
          value: (_bucket$sourceCountAg = (_bucket$sourceCountAg2 = bucket.sourceCountAggregation) === null || _bucket$sourceCountAg2 === void 0 ? void 0 : _bucket$sourceCountAg2.value) !== null && _bucket$sourceCountAg !== void 0 ? _bucket$sourceCountAg : 0,
          width: 50
        }
      }, ...defaultBadges];
    case _ruleDataUtils.ALERT_INSTANCE_ID:
      return [{
        title: 'Rules:',
        badge: {
          value: (_bucket$rulesCountAgg = (_bucket$rulesCountAgg2 = bucket.rulesCountAggregation) === null || _bucket$rulesCountAgg2 === void 0 ? void 0 : _bucket$rulesCountAgg2.value) !== null && _bucket$rulesCountAgg !== void 0 ? _bucket$rulesCountAgg : 0,
          width: 50
        }
      }, ...defaultBadges];
  }
  return [{
    title: 'Rules:',
    badge: {
      value: (_bucket$rulesCountAgg3 = (_bucket$rulesCountAgg4 = bucket.rulesCountAggregation) === null || _bucket$rulesCountAgg4 === void 0 ? void 0 : _bucket$rulesCountAgg4.value) !== null && _bucket$rulesCountAgg3 !== void 0 ? _bucket$rulesCountAgg3 : 0,
      width: 50
    }
  }, ...defaultBadges];
};
exports.getGroupStats = getGroupStats;