"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.vertexFactory = vertexFactory;
var _plugin_vertex = require("./plugin_vertex");
var _if_vertex = require("./if_vertex");
var _queue_vertex = require("./queue_vertex");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function vertexFactory(graph, vertexJson) {
  const type = vertexJson.type;
  switch (type) {
    case 'plugin':
      return new _plugin_vertex.PluginVertex(graph, vertexJson);
    case 'if':
      return new _if_vertex.IfVertex(graph, vertexJson);
    case 'queue':
      return new _queue_vertex.QueueVertex(graph, vertexJson);
    default:
      throw new Error(`Unknown vertex type ${type}! This shouldn't happen!`);
  }
}