"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexDetailStatus = IndexDetailStatus;
var _react = _interopRequireWildcard(require("react"));
var _summary_status = require("../../summary_status");
var _status_icon = require("../status_icon");
var _format_number = require("../../../lib/format_number");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _status = require("../../../alerts/status");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/components/elasticsearch/index_detail_status/index.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function IndexDetailStatus({
  stats,
  alerts = {}
}) {
  const {
    dataSize,
    documents: documentCount,
    totalShards,
    unassignedShards,
    status
  } = stats;
  const metrics = [{
    label: _i18n.i18n.translate('xpack.monitoring.elasticsearch.indexDetailStatus.alerts', {
      defaultMessage: 'Alerts'
    }),
    value: /*#__PURE__*/_react.default.createElement(_status.AlertsStatus, {
      alerts: alerts,
      showOnlyCount: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 24,
        columnNumber: 14
      }
    })
  }, {
    label: _i18n.i18n.translate('xpack.monitoring.elasticsearch.indexDetailStatus.totalTitle', {
      defaultMessage: 'Total'
    }),
    value: (0, _format_number.formatMetric)(dataSize.total, '0.0 b'),
    'data-test-subj': 'dataSize'
  }, {
    label: _i18n.i18n.translate('xpack.monitoring.elasticsearch.indexDetailStatus.primariesTitle', {
      defaultMessage: 'Primaries'
    }),
    value: (0, _format_number.formatMetric)(dataSize.primaries, '0.0 b'),
    'data-test-subj': 'dataSizePrimaries'
  }, {
    label: _i18n.i18n.translate('xpack.monitoring.elasticsearch.indexDetailStatus.documentsTitle', {
      defaultMessage: 'Documents'
    }),
    value: (0, _format_number.formatMetric)(documentCount, '0.[0]a'),
    'data-test-subj': 'documentCount'
  }, {
    label: _i18n.i18n.translate('xpack.monitoring.elasticsearch.indexDetailStatus.totalShardsTitle', {
      defaultMessage: 'Total shards'
    }),
    value: (0, _format_number.formatMetric)(totalShards, 'int_commas'),
    'data-test-subj': 'totalShards'
  }, {
    label: _i18n.i18n.translate('xpack.monitoring.elasticsearch.indexDetailStatus.unassignedShardsTitle', {
      defaultMessage: 'Unassigned shards'
    }),
    value: (0, _format_number.formatMetric)(unassignedShards, 'int_commas'),
    'data-test-subj': 'unassignedShards'
  }];
  const IconComponent = ({
    status
  }) => /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.elasticsearch.indexDetailStatus.iconStatusLabel",
    defaultMessage: "Health: {elasticsearchStatusIcon}",
    values: {
      elasticsearchStatusIcon: /*#__PURE__*/_react.default.createElement(_status_icon.ElasticsearchStatusIcon, {
        status: status,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 72,
          columnNumber: 36
        }
      })
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 7
    }
  }));
  return /*#__PURE__*/_react.default.createElement(_summary_status.SummaryStatus, {
    metrics: metrics,
    status: status,
    IconComponent: IconComponent,
    "data-test-subj": "elasticsearchIndexDetailStatus",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 5
    }
  });
}