"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RunControls = RunControls;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _states = require("../../../../../common/constants/states");
var _forecasting_modal = require("./forecasting_modal");
var _forecast_progress = require("./forecast_progress");
var _check_capabilities = require("../../../capabilities/check_capabilities");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/timeseriesexplorer/components/forecasting_modal/run_controls.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/*
 * Renders the controls used for running a forecast.
 */
function getRunInputDisabledState(job, isForecastRequested, mlNodesAvailable, jobState) {
  // Disable the 'run forecast' text field and button if any of the conditions are met:
  // - No ML nodes are available
  // - No canForecastJob permission
  // - Job is not in an OPENED or CLOSED state
  // - A new forecast has been requested
  if (mlNodesAvailable === false) {
    return {
      isDisabled: true,
      isDisabledToolTipText: _i18n.i18n.translate('xpack.ml.timeSeriesExplorer.runControls.noMLNodesAvailableTooltip', {
        defaultMessage: 'There are no ML nodes available.'
      })
    };
  }

  // TODO - use simpler interface to permission checking once it has been refactored.
  if ((0, _check_capabilities.checkPermission)('canForecastJob') === false) {
    return {
      isDisabled: true,
      isDisabledToolTipText: (0, _check_capabilities.createPermissionFailureMessage)('canForecastJob')
    };
  }
  if (jobState !== _states.JOB_STATE.OPENED && jobState !== _states.JOB_STATE.CLOSED) {
    return {
      isDisabled: true,
      isDisabledToolTipText: _i18n.i18n.translate('xpack.ml.timeSeriesExplorer.runControls.forecastsCanNotBeRunOnJobsTooltip', {
        defaultMessage: 'Forecasts cannot be run on {jobState} jobs',
        values: {
          jobState: jobState
        }
      })
    };
  }
  return {
    isDisabled: isForecastRequested
  };
}
function RunControls({
  job,
  mlNodesAvailable,
  newForecastDuration,
  isNewForecastDurationValid,
  newForecastDurationErrors,
  neverExpires,
  onNeverExpiresChange,
  onNewForecastDurationChange,
  runForecast,
  isForecastRequested,
  forecastProgress,
  jobOpeningState,
  jobClosingState,
  jobState
}) {
  const disabledState = getRunInputDisabledState(job, isForecastRequested, mlNodesAvailable, jobState);
  const durationInput = /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    name: "forecastDuration",
    value: newForecastDuration,
    disabled: disabledState.isDisabled,
    isInvalid: !isNewForecastDurationValid,
    onChange: onNewForecastDurationChange,
    fullWidth: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 5
    }
  });
  const runButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: runForecast,
    isDisabled: disabledState.isDisabled || !isNewForecastDurationValid,
    "data-test-subj": "mlModalForecastButtonRun",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.timeSeriesExplorer.runControls.runButtonLabel",
    defaultMessage: "Run",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 7
    }
  }));
  return /*#__PURE__*/_react.default.createElement("div", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.timeSeriesExplorer.runControls.runNewForecastTitle",
    defaultMessage: "Run a new forecast",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.timeSeriesExplorer.runControls.durationLabel",
      defaultMessage: "Duration",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 143,
        columnNumber: 17
      }
    }),
    fullWidth: true,
    isInvalid: !isNewForecastDurationValid,
    error: newForecastDurationErrors,
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.timeSeriesExplorer.runControls.forecastMaximumLengthHelpText",
      defaultMessage: "Length of forecast, up to a maximum of {maximumForecastDurationDays} days. Use s for seconds, m for minutes, h for hours, d for days, w for weeks.",
      values: {
        maximumForecastDurationDays: _forecasting_modal.FORECAST_DURATION_MAX_DAYS
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 152,
        columnNumber: 17
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 13
    }
  }, disabledState.isDisabledToolTipText === undefined ? durationInput : /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "right",
    content: disabledState.isDisabledToolTipText,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 17
    }
  }, durationInput))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    helpText: _i18n.i18n.translate('xpack.ml.timeSeriesExplorer.runControls.neverExpireHelpText', {
      defaultMessage: 'If disabled, forecasts will be retained for 14 days.'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    "data-test-subj": "mlModalForecastNeverExpireSwitch",
    disabled: disabledState.isDisabled,
    label: _i18n.i18n.translate('xpack.ml.timeSeriesExplorer.runControls.neverExpireLabel', {
      defaultMessage: 'Never expire'
    }),
    checked: neverExpires,
    onChange: onNeverExpiresChange,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 19
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    hasEmptyLabelSpace: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 17
    }
  }, disabledState.isDisabledToolTipText === undefined ? runButton : /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "left",
    content: disabledState.isDisabledToolTipText,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 21
    }
  }, runButton))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 209,
      columnNumber: 7
    }
  }), isForecastRequested === true && /*#__PURE__*/_react.default.createElement(_forecast_progress.ForecastProgress, {
    forecastProgress: forecastProgress,
    jobOpeningState: jobOpeningState,
    jobClosingState: jobClosingState,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 9
    }
  }));
}
RunControls.propType = {
  job: _propTypes.default.object,
  newForecastDuration: _propTypes.default.string,
  isNewForecastDurationValid: _propTypes.default.bool,
  newForecastDurationErrors: _propTypes.default.array,
  neverExpires: _propTypes.default.bool.isRequired,
  onNewForecastDurationChange: _propTypes.default.func.isRequired,
  onNeverExpiresChange: _propTypes.default.func.isRequired,
  runForecast: _propTypes.default.func.isRequired,
  isForecastRequested: _propTypes.default.bool,
  forecastProgress: _propTypes.default.number,
  jobOpeningState: _propTypes.default.number,
  jobClosingState: _propTypes.default.number
};