"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TextEmbeddingInference = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _mlTrainedModelsUtils = require("@kbn/ml-trained-models-utils");
var _inference_base = require("../inference_base");
var _text_input = require("../text_input");
var _text_embedding_output = require("./text_embedding_output");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class TextEmbeddingInference extends _inference_base.InferenceBase {
  constructor(trainedModelsApi, model, inputType, deploymentId, telemetryClient) {
    super(trainedModelsApi, model, inputType, deploymentId, telemetryClient);
    (0, _defineProperty2.default)(this, "inferenceType", _mlTrainedModelsUtils.SUPPORTED_PYTORCH_TASKS.TEXT_EMBEDDING);
    (0, _defineProperty2.default)(this, "inferenceTypeLabel", _i18n.i18n.translate('xpack.ml.trainedModels.testModelsFlyout.textEmbedding.label', {
      defaultMessage: 'Text embedding'
    }));
    (0, _defineProperty2.default)(this, "info", [_i18n.i18n.translate('xpack.ml.trainedModels.testModelsFlyout.textEmbedding.info1', {
      defaultMessage: 'Test how well the model generates embeddings for your text.'
    })]);
    this.initialize();
  }
  async inferText() {
    return this.runInfer(() => {}, (resp, inputText) => {
      return processTextResponse(resp, inputText);
    });
  }
  async inferIndex() {
    return this.runPipelineSimulate(doc => {
      const inputText = doc._source[this.getInputField()];
      return processIndexResponse(doc._source[this.inferenceType], inputText);
    });
  }
  getProcessors() {
    return this.getBasicProcessors();
  }
  getInputComponent() {
    if (this.inputType === _inference_base.INPUT_TYPE.TEXT) {
      const placeholder = _i18n.i18n.translate('xpack.ml.trainedModels.testModelsFlyout.textEmbedding.inputText', {
        defaultMessage: 'Enter a phrase to test'
      });
      return (0, _text_input.getGeneralInputComponent)(this, placeholder);
    } else {
      return null;
    }
  }
  getOutputComponent() {
    return (0, _text_embedding_output.getTextEmbeddingOutputComponent)(this);
  }
}
exports.TextEmbeddingInference = TextEmbeddingInference;
function processTextResponse(resp, inputText) {
  const predictedValue = resp.inference_results[0].predicted_value;
  return {
    response: {
      predictedValue
    },
    rawResponse: resp,
    inputText
  };
}
function processIndexResponse(resp, inputText) {
  const predictedValue = resp.predicted_value;
  return {
    response: {
      predictedValue
    },
    rawResponse: {
      inference_results: [{
        predicted_value: predictedValue
      }]
    },
    inputText
  };
}