"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PROGRESS_REFRESH_INTERVAL_MS = exports.CreateStepFooter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _mlDataFrameAnalyticsUtils = require("@kbn/ml-data-frame-analytics-utils");
var _common = require("../../../analytics_management/components/analytics_list/common");
var _get_analytics = require("../../../analytics_management/services/analytics_service/get_analytics");
var _kibana = require("../../../../../contexts/kibana");
var _back_to_list_panel = require("../back_to_list_panel");
var _view_results_panel = require("../view_results_panel");
var _progress_stats = require("./progress_stats");
var _jobs_awaiting_node_warning = require("../../../../../components/jobs_awaiting_node_warning");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/data_frame_analytics/pages/analytics_creation/components/create_step_footer/create_step_footer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PROGRESS_REFRESH_INTERVAL_MS = exports.PROGRESS_REFRESH_INTERVAL_MS = 1000;
const CreateStepFooter = ({
  jobId,
  jobType,
  showProgress
}) => {
  const [initialized, setInitialized] = (0, _react.useState)(false);
  const [failedJobMessage, setFailedJobMessage] = (0, _react.useState)(undefined);
  const [jobFinished, setJobFinished] = (0, _react.useState)(false);
  const [currentProgress, setCurrentProgress] = (0, _react.useState)(undefined);
  const [showJobAssignWarning, setShowJobAssignWarning] = (0, _react.useState)(false);
  const {
    services: {
      notifications
    }
  } = (0, _kibana.useMlKibana)();
  const mlApi = (0, _kibana.useMlApi)();
  (0, _react.useEffect)(() => {
    setInitialized(true);
  }, []);
  (0, _react.useEffect)(() => {
    if (showProgress === false) return;
    const interval = setInterval(async () => {
      try {
        const analyticsStats = await mlApi.dataFrameAnalytics.getDataFrameAnalyticsStats(jobId);
        const jobStats = (0, _get_analytics.isGetDataFrameAnalyticsStatsResponseOk)(analyticsStats) ? analyticsStats.data_frame_analytics[0] : undefined;
        setShowJobAssignWarning((jobStats === null || jobStats === void 0 ? void 0 : jobStats.state) === _mlDataFrameAnalyticsUtils.DATA_FRAME_TASK_STATE.STARTING && (jobStats === null || jobStats === void 0 ? void 0 : jobStats.node) === undefined);
        if (jobStats !== undefined) {
          const progressStats = (0, _common.getDataFrameAnalyticsProgressPhase)(jobStats);
          if (jobStats.state === _mlDataFrameAnalyticsUtils.DATA_FRAME_TASK_STATE.FAILED) {
            clearInterval(interval);
            setFailedJobMessage(jobStats.failure_reason || _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.analyticsProgressCalloutMessage', {
              defaultMessage: 'Analytics job {jobId} has failed.',
              values: {
                jobId
              }
            }));
          }
          setCurrentProgress(progressStats);
          // Clear if job is completed or stopped (after having started)
          if (progressStats.currentPhase === progressStats.totalPhases && progressStats.progress === 100 || jobStats.state === _mlDataFrameAnalyticsUtils.DATA_FRAME_TASK_STATE.STOPPED && !(progressStats.currentPhase === 1 && progressStats.progress === 0)) {
            clearInterval(interval);
            // Check job has started. Jobs that fail to start will also have STOPPED state
            setJobFinished(progressStats.currentPhase === progressStats.totalPhases && progressStats.progress === 100);
          }
        } else {
          clearInterval(interval);
        }
      } catch (e) {
        notifications.toasts.addDanger(_i18n.i18n.translate('xpack.ml.dataframe.analytics.create.analyticsProgressErrorMessage', {
          defaultMessage: 'An error occurred getting progress stats for analytics job {jobId}',
          values: {
            jobId
          }
        }));
        clearInterval(interval);
      }
    }, PROGRESS_REFRESH_INTERVAL_MS);
    return () => clearInterval(interval);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [initialized]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, showJobAssignWarning && /*#__PURE__*/_react.default.createElement(_jobs_awaiting_node_warning.NewJobAwaitingNodeWarning, {
    jobType: "data-frame-analytics",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 32
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 9
    }
  }, showProgress && /*#__PURE__*/_react.default.createElement(_progress_stats.ProgressStats, {
    currentProgress: currentProgress,
    failedJobMessage: failedJobMessage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_back_to_list_panel.BackToListPanel, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 15
    }
  })), jobFinished === true ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_view_results_panel.ViewResultsPanel, {
    jobId: jobId,
    analysisType: jobType,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 17
    }
  })) : null))));
};
exports.CreateStepFooter = CreateStepFooter;