"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CannotImportJobsCallout = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/components/import_export_jobs/import_jobs_flyout/cannot_import_jobs_callout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const CannotImportJobsCallout = ({
  jobs,
  autoExpand = false
}) => {
  if (jobs.length === 0) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.ml.importExport.importFlyout.cannotImportJobCallout.title', {
      defaultMessage: '{num, plural, one {# job} other {# jobs}} cannot be imported',
      values: {
        num: jobs.length
      }
    }),
    color: "warning",
    "data-test-subj": "mlJobMgmtImportJobsCannotBeImportedCallout",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 7
    }
  }, autoExpand ? /*#__PURE__*/_react.default.createElement(SkippedJobList, {
    jobs: jobs,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "advancedOptions",
    paddingSize: "s",
    "aria-label": _i18n.i18n.translate('xpack.ml.importExport.importFlyout.cannotImportJobCallout.jobListAria', {
      defaultMessage: 'view jobs'
    }),
    buttonContent: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.importExport.importFlyout.cannotImportJobCallout.jobListButton",
      defaultMessage: "View jobs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 49,
        columnNumber: 15
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(SkippedJobList, {
    jobs: jobs,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 7
    }
  }));
};
exports.CannotImportJobsCallout = CannotImportJobsCallout;
const SkippedJobList = ({
  jobs
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, jobs.length > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, jobs.map(({
  jobId,
  missingIndices,
  missingFilters
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 70,
    columnNumber: 11
  }
}, /*#__PURE__*/_react.default.createElement("h5", {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 71,
    columnNumber: 13
  }
}, jobId), missingIndices.length > 0 && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.ml.importExport.importFlyout.cannotImportJobCallout.missingIndex",
  defaultMessage: "Missing index {num, plural, one {pattern} other {patterns}}: {indices}",
  values: {
    num: missingIndices.length,
    indices: missingIndices.join(',')
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 73,
    columnNumber: 15
  }
}), missingFilters.length > 0 && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.ml.importExport.importFlyout.cannotImportJobCallout.missingFilters",
  defaultMessage: "Missing filter {num, plural, one {list} other {lists}}: {filters}",
  values: {
    num: missingFilters.length,
    filters: missingFilters.join(',')
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 80,
    columnNumber: 15
  }
})))));