"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useChartTooltipStyles = void 0;
var _react = require("@emotion/react");
var _eui = require("@elastic/eui");
var _tool_tip = require("@elastic/eui/lib/components/tool_tip/tool_tip.styles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// @ts-expect-error style types not defined

const useChartTooltipStyles = () => {
  const theme = (0, _eui.useEuiTheme)();
  const {
    euiTheme
  } = theme;
  const euiStyles = (0, _tool_tip.euiToolTipStyles)(theme);
  const euiFontSizeXS = (0, _eui.useEuiFontSize)('xs').fontSize;
  return {
    mlChartTooltip: (0, _react.css)([euiStyles.euiToolTip, {
      fontSize: euiFontSizeXS,
      padding: 0,
      transition: `opacity ${euiTheme.animation.normal}`,
      pointerEvents: 'none',
      userSelect: 'none',
      maxWidth: '512px',
      position: 'relative'
    }]),
    mlChartTooltipList: (0, _react.css)({
      margin: euiTheme.size.xs,
      paddingBottom: euiTheme.size.xs
    }),
    mlChartTooltipHeader: (0, _react.css)({
      fontWeight: euiTheme.font.weight.bold,
      padding: `${euiTheme.size.xs} ${(0, _eui.mathWithUnits)(euiTheme.size.xs, x => x * 2)}`,
      marginBottom: euiTheme.size.xs,
      borderBottom: `1px solid ${(0, _eui.transparentize)(euiTheme.border.color, 0.8)}`
    }),
    mlChartTooltipItem: (0, _react.css)({
      display: 'flex',
      padding: '3px',
      boxSizing: 'border-box',
      borderLeft: `${euiTheme.size.xs} solid transparent`
    }),
    mlChartTooltipLabel: (0, _react.css)({
      minWidth: '1px'
    }),
    mlChartTooltipValue: (0, _react.css)({
      fontWeight: euiTheme.font.weight.bold,
      textAlign: 'right',
      fontFeatureSettings: 'tnum',
      marginLeft: '8px'
    })
  };
};
exports.useChartTooltipStyles = useChartTooltipStyles;