"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HostMetricsTable = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _shared = require("../shared");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/metrics_data_access/public/components/infrastructure_node_metrics_tables/host/host_metrics_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const HostMetricsTable = props => {
  const {
    data,
    isLoading,
    setCurrentPageIndex,
    setSortState,
    sortState,
    timerange
  } = props;
  const columns = (0, _react.useMemo)(() => hostMetricsColumns(timerange), [timerange]);
  const sortSettings = {
    enableAllColumns: true,
    sort: sortState
  };
  const onTableSortChange = (0, _react.useCallback)(({
    sort
  }) => {
    if (!sort) {
      return;
    }
    setSortState(sort);
    setCurrentPageIndex(0);
  }, [setSortState, setCurrentPageIndex]);
  if (data.state === 'error') {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, data.errors.map(error => /*#__PURE__*/_react.default.createElement(_shared.MetricsTableErrorContent, {
      error: error,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 66,
        columnNumber: 11
      }
    })));
  } else if (isLoading && data.state !== 'data') {
    return /*#__PURE__*/_react.default.createElement(_shared.MetricsTableLoadingContent, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 71,
        columnNumber: 12
      }
    });
  } else if (data.state === 'no-indices') {
    return /*#__PURE__*/_react.default.createElement(_shared.MetricsTableNoIndicesContent, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 12
      }
    });
  } else if (data.state === 'empty-indices') {
    return /*#__PURE__*/_react.default.createElement(_shared.MetricsTableEmptyIndicesContent, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 12
      }
    });
  } else if (data.state === 'data') {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
      tableCaption: _i18n.i18n.translate('xpack.metricsData.metricsTable.host.tableCaption', {
        defaultMessage: 'Infrastructure metrics for hosts'
      }),
      items: data.rows,
      columns: columns,
      sorting: sortSettings,
      onChange: onTableSortChange,
      loading: isLoading,
      noItemsMessage: /*#__PURE__*/_react.default.createElement(_shared.MetricsTableLoadingContent, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 88,
          columnNumber: 27
        }
      }),
      "data-test-subj": "hostMetricsTable",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 79,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 91,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "flexEnd",
      alignItems: "center",
      responsive: false,
      wrap: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 92,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 93,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_shared.StepwisePagination, {
      ariaLabel: _i18n.i18n.translate('xpack.metricsData.metricsTable.host.paginationAriaLabel', {
        defaultMessage: 'Host metrics pagination'
      }),
      pageCount: data.pageCount,
      currentPageIndex: data.currentPageIndex,
      setCurrentPageIndex: setCurrentPageIndex,
      "data-test-subj": "hostMetricsTablePagination",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 94,
        columnNumber: 13
      }
    }))));
  } else {
    return null;
  }
};
exports.HostMetricsTable = HostMetricsTable;
function hostMetricsColumns(timerange) {
  return [{
    name: _i18n.i18n.translate('xpack.metricsData.metricsTable.host.nameColumnHeader', {
      defaultMessage: 'Name'
    }),
    field: 'name',
    truncateText: true,
    textOnly: true,
    render: name => /*#__PURE__*/_react.default.createElement(_shared.MetricsNodeDetailsLink, {
      id: name,
      label: name,
      nodeType: 'host',
      timerange: timerange,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 124,
        columnNumber: 9
      }
    })
  }, {
    name: _i18n.i18n.translate('xpack.metricsData.metricsTable.host.CpuCountColumnHeader', {
      defaultMessage: '# of CPUs'
    }),
    field: 'cpuCount',
    align: 'right',
    render: cpuCount => /*#__PURE__*/_react.default.createElement(_shared.NumberCell, {
      value: cpuCount,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 133,
        columnNumber: 37
      }
    })
  }, {
    name: _i18n.i18n.translate('xpack.metricsData.metricsTable.host.averageCpuUsagePercentColumnHeader', {
      defaultMessage: 'CPU usage (avg.)'
    }),
    field: 'averageCpuUsagePercent',
    align: 'right',
    render: averageCpuUsagePercent => /*#__PURE__*/_react.default.createElement(_shared.NumberCell, {
      value: averageCpuUsagePercent,
      unit: "%",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 145,
        columnNumber: 9
      }
    })
  }, {
    name: _i18n.i18n.translate('xpack.metricsData.metricsTable.host.totalMemoryMegabytesColumnHeader', {
      defaultMessage: 'Memory total'
    }),
    field: 'totalMemoryMegabytes',
    align: 'right',
    render: totalMemoryMegabytes => /*#__PURE__*/_react.default.createElement(_shared.NumberCell, {
      value: totalMemoryMegabytes,
      unit: " MB",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 155,
        columnNumber: 9
      }
    })
  }, {
    name: _i18n.i18n.translate('xpack.metricsData.metricsTable.host.averageMemoryUsagePercentColumnHeader', {
      defaultMessage: 'Memory usage (avg.)'
    }),
    field: 'averageMemoryUsagePercent',
    align: 'right',
    render: averageMemoryUsagePercent => /*#__PURE__*/_react.default.createElement(_shared.NumberCell, {
      value: averageMemoryUsagePercent,
      unit: "%",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 168,
        columnNumber: 9
      }
    })
  }];
}