"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.synchronizeMovementAction = void 0;
var _i18n = require("@kbn/i18n");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _public = require("@kbn/ui-actions-plugin/public");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _public2 = require("@kbn/lens-plugin/public");
var _public3 = require("@kbn/visualizations-plugin/public");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _kibana_services = require("../../kibana_services");
var _is_legacy_map = require("../../legacy_visualizations/is_legacy_map");
var _constants = require("../../../common/constants");
var _map_embeddables_singleton = require("../../react_embeddable/map_embeddables_singleton");
var _constants2 = require("./constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/trigger_actions/synchronize_movement/action.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const synchronizeMovementAction = exports.synchronizeMovementAction = (0, _public.createAction)({
  id: _constants2.SYNCHRONIZE_MOVEMENT_ACTION,
  type: _constants2.SYNCHRONIZE_MOVEMENT_ACTION,
  order: 21,
  getDisplayName: () => _i18n.i18n.translate('xpack.maps.synchronizeMovementAction.title', {
    defaultMessage: 'Synchronize map movement'
  }),
  getDisplayNameTooltip: () => _i18n.i18n.translate('xpack.maps.synchronizeMovementAction.tooltipContent', {
    defaultMessage: 'Synchronize maps, so that if you zoom and pan in one map, the movement is reflected in other maps'
  }),
  getIconType: () => 'crosshairs',
  isCompatible: async ({
    embeddable
  }) => {
    var _embeddable$getSavedV;
    return _map_embeddables_singleton.mapEmbeddablesSingleton.hasMultipleMaps() && ((0, _presentationPublishing.apiIsOfType)(embeddable, _constants.MAP_SAVED_OBJECT_TYPE) || (0, _public2.isLensApi)(embeddable) && ((_embeddable$getSavedV = embeddable.getSavedVis()) === null || _embeddable$getSavedV === void 0 ? void 0 : _embeddable$getSavedV.visualizationType) === 'lnsChoropleth' || (0, _public3.apiHasVisualizeConfig)(embeddable) && (0, _is_legacy_map.isLegacyMapApi)(embeddable));
  },
  execute: async () => {
    const core = (0, _kibana_services.getCore)();
    const LazyModal = /*#__PURE__*/(0, _react.lazy)(async () => {
      const {
        SynchronizeMovementModal
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./modal')));
      return {
        default: SynchronizeMovementModal
      };
    });
    const overlayRef = core.overlays.openModal((0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_react.Suspense, {
      fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 58,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 59,
          columnNumber: 15
        }
      })),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 56,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(LazyModal, {
      onClose: () => overlayRef.close(),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 11
      }
    })), core));
  }
});