"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.extractLayerDescriptorParams = extractLayerDescriptorParams;
var _region_map_vis_type = require("./region_map_vis_type");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getEmsLayerId(id, layerId) {
  if (typeof id === 'string') {
    return id;
  }

  // Region maps from 6.x will have numerical EMS id refering to S3 bucket id.
  // In this case, use layerId with contains the EMS layer name.
  const split = layerId.split('.');
  return split.length === 2 ? split[1] : undefined;
}
function extractLayerDescriptorParams(vis) {
  var _vis$data$indexPatter, _vis$data, _vis$data$aggs, _vis$data2, _vis$data2$aggs;
  const params = {
    label: vis.title ? vis.title : _region_map_vis_type.title,
    emsLayerId: vis.params.selectedLayer.isEMS ? getEmsLayerId(vis.params.selectedLayer.id, vis.params.selectedLayer.layerId) : undefined,
    leftFieldName: vis.params.selectedLayer.isEMS ? vis.params.selectedJoinField.name : undefined,
    colorSchema: vis.params.colorSchema,
    indexPatternId: (_vis$data$indexPatter = vis.data.indexPattern) === null || _vis$data$indexPatter === void 0 ? void 0 : _vis$data$indexPatter.id,
    metricAgg: 'count'
  };
  const bucketAggs = (_vis$data = vis.data) === null || _vis$data === void 0 ? void 0 : (_vis$data$aggs = _vis$data.aggs) === null || _vis$data$aggs === void 0 ? void 0 : _vis$data$aggs.byType('buckets');
  if (bucketAggs !== null && bucketAggs !== void 0 && bucketAggs.length && bucketAggs[0].type.dslName === 'terms') {
    var _bucketAggs$0$getFiel;
    params.termsFieldName = (_bucketAggs$0$getFiel = bucketAggs[0].getField()) === null || _bucketAggs$0$getFiel === void 0 ? void 0 : _bucketAggs$0$getFiel.name;
    params.termsSize = bucketAggs[0].getParam('size');
  }
  const metricAggs = (_vis$data2 = vis.data) === null || _vis$data2 === void 0 ? void 0 : (_vis$data2$aggs = _vis$data2.aggs) === null || _vis$data2$aggs === void 0 ? void 0 : _vis$data2$aggs.byType('metrics');
  if (metricAggs !== null && metricAggs !== void 0 && metricAggs.length) {
    var _metricAggs$0$getFiel;
    params.metricAgg = metricAggs[0].type.dslName;
    params.metricFieldName = (_metricAggs$0$getFiel = metricAggs[0].getField()) === null || _metricAggs$0$getFiel === void 0 ? void 0 : _metricAggs$0$getFiel.name;
  }
  return params;
}