"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VectorStyleEditor = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = _interopRequireDefault(require("lodash"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _vector_style_color_editor = require("./color/vector_style_color_editor");
var _vector_style_size_editor = require("./size/vector_style_size_editor");
var _vector_style_symbolize_as_editor = require("./symbol/vector_style_symbolize_as_editor");
var _vector_style_icon_editor = require("./symbol/vector_style_icon_editor");
var _vector_style_label_editor = require("./label/vector_style_label_editor");
var _label_zoom_range_editor = require("./label/label_zoom_range_editor");
var _label_position_editor = require("./label/label_position_editor");
var _vector_style_label_border_size_editor = require("./label/vector_style_label_border_size_editor");
var _orientation_editor = require("./orientation/orientation_editor");
var _vector_style_defaults = require("../vector_style_defaults");
var _color_palettes = require("../../color_palettes");
var _constants = require("../../../../../common/constants");
var _style_fields_helper = require("../style_fields_helper");
var _style_util = require("../style_util");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/classes/styles/vector/components/vector_style_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class VectorStyleEditor extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "_isMounted", false);
    (0, _defineProperty2.default)(this, "_handleSelectedFeatureChange", selectedFeature => {
      this.setState({
        selectedFeature: selectedFeature
      });
    });
    (0, _defineProperty2.default)(this, "_onIsTimeAwareChange", event => {
      this.props.onIsTimeAwareChange(event.target.checked);
    });
    (0, _defineProperty2.default)(this, "_onStaticStyleChange", (propertyName, options) => {
      const styleDescriptor = {
        type: _constants.STYLE_TYPE.STATIC,
        options
      };
      this.props.handlePropertyChange(propertyName, styleDescriptor);
    });
    (0, _defineProperty2.default)(this, "_onDynamicStyleChange", (propertyName, options) => {
      const styleDescriptor = {
        type: _constants.STYLE_TYPE.DYNAMIC,
        options
      };
      this.props.handlePropertyChange(propertyName, styleDescriptor);
    });
    let _selectedFeature = _constants.VECTOR_SHAPE_TYPE.POLYGON;
    if (props.isPointsOnly) {
      _selectedFeature = _constants.VECTOR_SHAPE_TYPE.POINT;
    } else if (props.isLinesOnly) {
      _selectedFeature = _constants.VECTOR_SHAPE_TYPE.LINE;
    }
    this.state = {
      styleFields: [],
      defaultDynamicProperties: (0, _vector_style_defaults.getDefaultDynamicProperties)(),
      defaultStaticProperties: (0, _vector_style_defaults.getDefaultStaticProperties)(),
      supportedFeatures: [],
      selectedFeature: _selectedFeature
    };
  }
  componentWillUnmount() {
    this._isMounted = false;
  }
  componentDidMount() {
    this._isMounted = true;
    this._loadFields();
    this._loadSupportedFeatures();
  }
  componentDidUpdate() {
    this._loadFields();
    this._loadSupportedFeatures();
  }
  async _loadFields() {
    const styleFieldsHelper = await (0, _style_fields_helper.createStyleFieldsHelper)(await this.props.layer.getStyleEditorFields());
    const styleFields = styleFieldsHelper.getStyleFields();
    if (!this._isMounted || _lodash.default.isEqual(styleFields, this.state.styleFields) && this.state.styleFieldsHelper !== undefined) {
      return;
    }
    this.setState({
      styleFields,
      styleFieldsHelper
    });
  }
  async _loadSupportedFeatures() {
    const supportedFeatures = await this.props.layer.getSource().getSupportedShapeTypes();
    if (this._isMounted && !_lodash.default.isEqual(supportedFeatures, this.state.supportedFeatures)) {
      this.setState({
        supportedFeatures
      });
    }
  }
  _hasMarkerOrIcon() {
    const iconSize = this.props.styleProperties[_constants.VECTOR_STYLES.ICON_SIZE];
    return iconSize.isDynamic() || iconSize.getOptions().size > 0;
  }
  _hasLabelBorder() {
    const labelBorderSize = this.props.styleProperties[_constants.VECTOR_STYLES.LABEL_BORDER_SIZE];
    return labelBorderSize.getOptions().size !== _constants.LABEL_BORDER_SIZES.NONE;
  }
  _isLayerSourceMvt() {
    return this.props.layer.getSource().isMvt();
  }
  _renderFillColor(isPointFillColor = false) {
    const styleProperty = this.props.styleProperties[_constants.VECTOR_STYLES.FILL_COLOR];
    return /*#__PURE__*/_react.default.createElement(_vector_style_color_editor.VectorStyleColorEditor, {
      disabled: isPointFillColor && !this._hasMarkerOrIcon(),
      disabledBy: _constants.VECTOR_STYLES.ICON_SIZE,
      swatches: _color_palettes.DEFAULT_FILL_COLORS,
      onStaticStyleChange: this._onStaticStyleChange,
      onDynamicStyleChange: this._onDynamicStyleChange,
      styleProperty: styleProperty,
      fields: this.state.styleFieldsHelper.getFieldsForStyle(styleProperty, this._isLayerSourceMvt()),
      defaultStaticStyleOptions: this.state.defaultStaticProperties[_constants.VECTOR_STYLES.FILL_COLOR].options,
      defaultDynamicStyleOptions: this.state.defaultDynamicProperties[_constants.VECTOR_STYLES.FILL_COLOR].options,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 194,
        columnNumber: 7
      }
    });
  }
  _renderLineColor(isPointBorderColor = false) {
    const disabledByIconSize = isPointBorderColor && !this._hasMarkerOrIcon();
    const styleProperty = this.props.styleProperties[_constants.VECTOR_STYLES.LINE_COLOR];
    return /*#__PURE__*/_react.default.createElement(_vector_style_color_editor.VectorStyleColorEditor, {
      disabled: disabledByIconSize || !this.props.hasBorder,
      disabledBy: disabledByIconSize ? _constants.VECTOR_STYLES.ICON_SIZE : _constants.VECTOR_STYLES.LINE_WIDTH,
      swatches: _color_palettes.DEFAULT_LINE_COLORS,
      onStaticStyleChange: this._onStaticStyleChange,
      onDynamicStyleChange: this._onDynamicStyleChange,
      styleProperty: styleProperty,
      fields: this.state.styleFieldsHelper.getFieldsForStyle(styleProperty, this._isLayerSourceMvt()),
      defaultStaticStyleOptions: this.state.defaultStaticProperties[_constants.VECTOR_STYLES.LINE_COLOR].options,
      defaultDynamicStyleOptions: this.state.defaultDynamicProperties[_constants.VECTOR_STYLES.LINE_COLOR].options,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 222,
        columnNumber: 7
      }
    });
  }
  _renderLineWidth(isPointBorderWidth = false) {
    const styleProperty = this.props.styleProperties[_constants.VECTOR_STYLES.LINE_WIDTH];
    return /*#__PURE__*/_react.default.createElement(_vector_style_size_editor.VectorStyleSizeEditor, {
      disabled: isPointBorderWidth && !this._hasMarkerOrIcon(),
      disabledBy: _constants.VECTOR_STYLES.ICON_SIZE,
      onStaticStyleChange: this._onStaticStyleChange,
      onDynamicStyleChange: this._onDynamicStyleChange,
      styleProperty: styleProperty,
      fields: this.state.styleFieldsHelper.getFieldsForStyle(styleProperty, this._isLayerSourceMvt()),
      defaultStaticStyleOptions: this.state.defaultStaticProperties[_constants.VECTOR_STYLES.LINE_WIDTH].options,
      defaultDynamicStyleOptions: this.state.defaultDynamicProperties[_constants.VECTOR_STYLES.LINE_WIDTH].options,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 249,
        columnNumber: 7
      }
    });
  }
  _renderLabelProperties(isPoint) {
    const hasLabel = (0, _style_util.getHasLabel)(this.props.styleProperties[_constants.VECTOR_STYLES.LABEL_TEXT]);
    const hasLabelBorder = this._hasLabelBorder();
    const labelStyleProperty = this.props.styleProperties[_constants.VECTOR_STYLES.LABEL_TEXT];
    const labelColorStyleProperty = this.props.styleProperties[_constants.VECTOR_STYLES.LABEL_COLOR];
    const labelSizeStyleProperty = this.props.styleProperties[_constants.VECTOR_STYLES.LABEL_SIZE];
    const labelBorderColorProperty = this.props.styleProperties[_constants.VECTOR_STYLES.LABEL_BORDER_COLOR];
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 291,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_vector_style_label_editor.VectorStyleLabelEditor, {
      onStaticStyleChange: this._onStaticStyleChange,
      onDynamicStyleChange: this._onDynamicStyleChange,
      styleProperty: labelStyleProperty,
      fields: this.state.styleFieldsHelper.getFieldsForStyle(labelStyleProperty, this._isLayerSourceMvt()),
      defaultStaticStyleOptions: this.state.defaultStaticProperties[_constants.VECTOR_STYLES.LABEL_TEXT].options,
      defaultDynamicStyleOptions: this.state.defaultDynamicProperties[_constants.VECTOR_STYLES.LABEL_TEXT].options,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 292,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 309,
        columnNumber: 9
      }
    }), isPoint ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_label_position_editor.LabelPositionEditor, {
      hasLabel: hasLabel,
      handlePropertyChange: this.props.handlePropertyChange,
      styleProperty: this.props.styleProperties[_constants.VECTOR_STYLES.LABEL_POSITION],
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 313,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 320,
        columnNumber: 13
      }
    })) : null, /*#__PURE__*/_react.default.createElement(_label_zoom_range_editor.LabelZoomRangeEditor, {
      disabled: !hasLabel,
      disabledBy: _constants.VECTOR_STYLES.LABEL_TEXT,
      handlePropertyChange: this.props.handlePropertyChange,
      styleProperty: this.props.styleProperties[_constants.VECTOR_STYLES.LABEL_ZOOM_RANGE],
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 324,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 332,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_vector_style_color_editor.VectorStyleColorEditor, {
      disabled: !hasLabel,
      disabledBy: _constants.VECTOR_STYLES.LABEL_TEXT,
      swatches: _color_palettes.DEFAULT_LINE_COLORS,
      onStaticStyleChange: this._onStaticStyleChange,
      onDynamicStyleChange: this._onDynamicStyleChange,
      styleProperty: labelColorStyleProperty,
      fields: this.state.styleFieldsHelper.getFieldsForStyle(labelColorStyleProperty, this._isLayerSourceMvt()),
      defaultStaticStyleOptions: this.state.defaultStaticProperties[_constants.VECTOR_STYLES.LABEL_COLOR].options,
      defaultDynamicStyleOptions: this.state.defaultDynamicProperties[_constants.VECTOR_STYLES.LABEL_COLOR].options,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 334,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 354,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_vector_style_size_editor.VectorStyleSizeEditor, {
      disabled: !hasLabel,
      disabledBy: _constants.VECTOR_STYLES.LABEL_TEXT,
      onStaticStyleChange: this._onStaticStyleChange,
      onDynamicStyleChange: this._onDynamicStyleChange,
      styleProperty: labelSizeStyleProperty,
      fields: this.state.styleFieldsHelper.getFieldsForStyle(labelSizeStyleProperty, this._isLayerSourceMvt()),
      defaultStaticStyleOptions: this.state.defaultStaticProperties[_constants.VECTOR_STYLES.LABEL_SIZE].options,
      defaultDynamicStyleOptions: this.state.defaultDynamicProperties[_constants.VECTOR_STYLES.LABEL_SIZE].options,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 356,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 375,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_vector_style_color_editor.VectorStyleColorEditor, {
      disabled: !hasLabel || !hasLabelBorder,
      disabledBy: hasLabel ? _constants.VECTOR_STYLES.LABEL_BORDER_SIZE : _constants.VECTOR_STYLES.LABEL_TEXT,
      swatches: _color_palettes.DEFAULT_LINE_COLORS,
      onStaticStyleChange: this._onStaticStyleChange,
      onDynamicStyleChange: this._onDynamicStyleChange,
      styleProperty: labelBorderColorProperty,
      fields: this.state.styleFieldsHelper.getFieldsForStyle(labelBorderColorProperty, this._isLayerSourceMvt()),
      defaultStaticStyleOptions: this.state.defaultStaticProperties[_constants.VECTOR_STYLES.LABEL_BORDER_COLOR].options,
      defaultDynamicStyleOptions: this.state.defaultDynamicProperties[_constants.VECTOR_STYLES.LABEL_BORDER_COLOR].options,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 377,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 397,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_vector_style_label_border_size_editor.VectorStyleLabelBorderSizeEditor, {
      disabled: !hasLabel,
      disabledBy: _constants.VECTOR_STYLES.LABEL_TEXT,
      handlePropertyChange: this.props.handlePropertyChange,
      styleProperty: this.props.styleProperties[_constants.VECTOR_STYLES.LABEL_BORDER_SIZE],
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 399,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 405,
        columnNumber: 9
      }
    }));
  }
  _renderPointProperties() {
    const hasMarkerOrIcon = this._hasMarkerOrIcon();
    let iconOrientationEditor;
    let iconEditor;
    if (this.props.styleProperties[_constants.VECTOR_STYLES.SYMBOLIZE_AS].isSymbolizedAsIcon()) {
      const orientationStyleProperty = this.props.styleProperties[_constants.VECTOR_STYLES.ICON_ORIENTATION];
      const iconStyleProperty = this.props.styleProperties[_constants.VECTOR_STYLES.ICON];
      iconOrientationEditor = /*#__PURE__*/_react.default.createElement(_react.Fragment, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 424,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_orientation_editor.OrientationEditor, {
        disabled: !hasMarkerOrIcon,
        disabledBy: _constants.VECTOR_STYLES.ICON_SIZE,
        onStaticStyleChange: this._onStaticStyleChange,
        onDynamicStyleChange: this._onDynamicStyleChange,
        styleProperty: orientationStyleProperty,
        fields: this.state.styleFieldsHelper.getFieldsForStyle(orientationStyleProperty, this._isLayerSourceMvt()),
        defaultStaticStyleOptions: this.state.defaultStaticProperties[_constants.VECTOR_STYLES.ICON_ORIENTATION].options,
        defaultDynamicStyleOptions: this.state.defaultDynamicProperties[_constants.VECTOR_STYLES.ICON_ORIENTATION].options,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 425,
          columnNumber: 11
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "m",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 442,
          columnNumber: 11
        }
      }));
      iconEditor = /*#__PURE__*/_react.default.createElement(_react.Fragment, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 446,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_vector_style_icon_editor.VectorStyleIconEditor, {
        disabled: !hasMarkerOrIcon,
        disabledBy: _constants.VECTOR_STYLES.ICON_SIZE,
        customIcons: this.props.customIcons,
        onStaticStyleChange: this._onStaticStyleChange,
        onDynamicStyleChange: this._onDynamicStyleChange,
        onCustomIconsChange: this.props.onCustomIconsChange,
        styleProperty: iconStyleProperty,
        fields: this.state.styleFieldsHelper.getFieldsForStyle(iconStyleProperty, this._isLayerSourceMvt()),
        defaultStaticStyleOptions: this.state.defaultStaticProperties[_constants.VECTOR_STYLES.ICON].options,
        defaultDynamicStyleOptions: this.state.defaultDynamicProperties[_constants.VECTOR_STYLES.ICON].options,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 447,
          columnNumber: 11
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "m",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 466,
          columnNumber: 11
        }
      }));
    }
    const iconSizeStyleProperty = this.props.styleProperties[_constants.VECTOR_STYLES.ICON_SIZE];
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 475,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_vector_style_symbolize_as_editor.VectorStyleSymbolizeAsEditor, {
      disabled: !hasMarkerOrIcon,
      disabledBy: _constants.VECTOR_STYLES.ICON_SIZE,
      styleProperty: this.props.styleProperties[_constants.VECTOR_STYLES.SYMBOLIZE_AS],
      handlePropertyChange: this.props.handlePropertyChange,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 476,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 482,
        columnNumber: 9
      }
    }), iconEditor, this._renderFillColor(true), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 487,
        columnNumber: 9
      }
    }), this._renderLineColor(true), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 490,
        columnNumber: 9
      }
    }), this._renderLineWidth(true), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 493,
        columnNumber: 9
      }
    }), iconOrientationEditor, /*#__PURE__*/_react.default.createElement(_vector_style_size_editor.VectorStyleSizeEditor, {
      onStaticStyleChange: this._onStaticStyleChange,
      onDynamicStyleChange: this._onDynamicStyleChange,
      styleProperty: iconSizeStyleProperty,
      fields: this.state.styleFieldsHelper.getFieldsForStyle(iconSizeStyleProperty, this._isLayerSourceMvt()),
      defaultStaticStyleOptions: this.state.defaultStaticProperties[_constants.VECTOR_STYLES.ICON_SIZE].options,
      defaultDynamicStyleOptions: this.state.defaultDynamicProperties[_constants.VECTOR_STYLES.ICON_SIZE].options,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 497,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 513,
        columnNumber: 9
      }
    }), this._renderLabelProperties(true));
  }
  _renderLineProperties() {
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 522,
        columnNumber: 7
      }
    }, this._renderLineColor(), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 524,
        columnNumber: 9
      }
    }), this._renderLineWidth(), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 527,
        columnNumber: 9
      }
    }), this._renderLabelProperties(false));
  }
  _renderPolygonProperties() {
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 536,
        columnNumber: 7
      }
    }, this._renderFillColor(), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 538,
        columnNumber: 9
      }
    }), this._renderLineColor(), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 541,
        columnNumber: 9
      }
    }), this._renderLineWidth(), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 544,
        columnNumber: 9
      }
    }), this._renderLabelProperties(false));
  }
  _renderProperties() {
    const {
      supportedFeatures,
      selectedFeature,
      styleFieldsHelper
    } = this.state;
    if (supportedFeatures.length === 0 || !styleFieldsHelper) {
      return null;
    }
    if (supportedFeatures.length === 1) {
      switch (supportedFeatures[0]) {
        case _constants.VECTOR_SHAPE_TYPE.POINT:
          return this._renderPointProperties();
        case _constants.VECTOR_SHAPE_TYPE.LINE:
          return this._renderLineProperties();
        case _constants.VECTOR_SHAPE_TYPE.POLYGON:
          return this._renderPolygonProperties();
      }
    }
    const featureButtons = [{
      id: _constants.VECTOR_SHAPE_TYPE.POINT,
      label: _i18n.i18n.translate('xpack.maps.vectorStyleEditor.pointLabel', {
        defaultMessage: 'Points'
      })
    }, {
      id: _constants.VECTOR_SHAPE_TYPE.LINE,
      label: _i18n.i18n.translate('xpack.maps.vectorStyleEditor.lineLabel', {
        defaultMessage: 'Lines'
      })
    }, {
      id: _constants.VECTOR_SHAPE_TYPE.POLYGON,
      label: _i18n.i18n.translate('xpack.maps.vectorStyleEditor.polygonLabel', {
        defaultMessage: 'Polygons'
      })
    }];
    let styleProperties = this._renderPolygonProperties();
    if (selectedFeature === _constants.VECTOR_SHAPE_TYPE.LINE) {
      styleProperties = this._renderLineProperties();
    } else if (selectedFeature === _constants.VECTOR_SHAPE_TYPE.POINT) {
      styleProperties = this._renderPointProperties();
    }
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 598,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
      legend: _i18n.i18n.translate('xpack.maps.vectorStyleEditor.featureTypeButtonGroupLegend', {
        defaultMessage: 'vector feature button group'
      }),
      options: featureButtons,
      idSelected: selectedFeature,
      onChange: this._handleSelectedFeatureChange,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 599,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 608,
        columnNumber: 9
      }
    }), styleProperties);
  }
  _renderIsTimeAwareSwitch() {
    if (!this.props.showIsTimeAware) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      display: "columnCompressed",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 621,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      label: _i18n.i18n.translate('xpack.maps.vectorStyleEditor.isTimeAwareLabel', {
        defaultMessage: 'Apply global time to style metadata requests'
      }),
      checked: this.props.isTimeAware,
      onChange: this._onIsTimeAwareChange,
      compressed: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 622,
        columnNumber: 9
      }
    }));
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 636,
        columnNumber: 7
      }
    }, this._renderProperties(), this._renderIsTimeAwareSwitch());
  }
}
exports.VectorStyleEditor = VectorStyleEditor;