"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ColorGradient = void 0;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _use_memo_css = require("@kbn/css-utils/public/use_memo_css");
var _color_palettes = require("../../../color_palettes");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/classes/styles/heatmap/components/legend/color_gradient.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const componentStyles = {
  mapColorGradientStyles: ({
    euiTheme
  }) => (0, _react2.css)({
    width: '100%',
    height: euiTheme.size.xs,
    position: 'relative',
    top: 0,
    right: 0,
    bottom: 0,
    left: 0
  })
};
const ColorGradient = ({
  colorPaletteId
}) => {
  const palette = (0, _color_palettes.getColorPalette)(colorPaletteId);
  const styles = (0, _use_memo_css.useMemoCss)(componentStyles);
  return palette.length ? /*#__PURE__*/_react.default.createElement("div", {
    css: styles.mapColorGradientStyles,
    style: {
      background: (0, _color_palettes.getLinearGradient)(palette)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 5
    }
  }) : null;
};
exports.ColorGradient = ColorGradient;