"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.processDistanceResponse = processDistanceResponse;
var _constants = require("../../../../../common/constants");
var _elasticsearch_util = require("../../../../../common/elasticsearch_util");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const IGNORE_LIST = [_constants.COUNT_PROP_NAME];
function processDistanceResponse(response, countPropertyName) {
  var _response$aggregation, _response$aggregation2, _response$aggregation3;
  const propertiesMap = new Map();
  const buckets = (_response$aggregation = response === null || response === void 0 ? void 0 : (_response$aggregation2 = response.aggregations) === null || _response$aggregation2 === void 0 ? void 0 : (_response$aggregation3 = _response$aggregation2.distance) === null || _response$aggregation3 === void 0 ? void 0 : _response$aggregation3.buckets) !== null && _response$aggregation !== void 0 ? _response$aggregation : {};
  for (const docId in buckets) {
    if (Object.hasOwn(buckets, docId)) {
      const bucket = buckets[docId];

      // skip empty buckets
      if (bucket[_constants.COUNT_PROP_NAME] === 0) {
        continue;
      }
      const properties = (0, _elasticsearch_util.extractPropertiesFromBucket)(bucket, IGNORE_LIST);
      // Manually set 'doc_count' so join name, like '__kbnjoin__count__673ff994', is used
      properties[countPropertyName] = bucket[_constants.COUNT_PROP_NAME];
      propertiesMap.set(docId, properties);
    }
  }
  return propertiesMap;
}