"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PipelineListItem = void 0;
var _lodash = require("lodash");
var _moment = _interopRequireDefault(require("moment"));
var _get_search_value = require("../../lib/get_search_value");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Represents the model for listing pipelines in the UI
 * @param {string} props.id Named Id of the pipeline
 * @param {string} props.description Description for the pipeline
 * @param {string} props.lastModified Timestamp when the config was last modified
 * @param {string} props.username User who created or updated the pipeline
 */
class PipelineListItem {
  constructor(props) {
    this.id = props.id;
    this.origin = props.origin;
    this.description = props.description;
    this.username = props.username;
    if (props.lastModified) {
      this.lastModified = getMomentDate(props.lastModified);
      this.lastModifiedHumanized = (0, _lodash.upperFirst)(this.lastModified.fromNow());
    }
  }
  get searchValue() {
    return (0, _get_search_value.getSearchValue)(this, ['id']);
  }
  get isCentrallyManaged() {
    return this.origin === _constants.PIPELINE.ORIGIN.CCM;
  }
  static fromUpstreamJSON(pipelineListItem) {
    const props = (0, _lodash.pick)(pipelineListItem, ['id', 'description', 'username']);
    props.origin = _constants.PIPELINE.ORIGIN.CCM;
    props.lastModified = pipelineListItem.last_modified;
    return new PipelineListItem(props);
  }
  static fromUpstreamMonitoringJSON(pipelineListItem) {
    const props = (0, _lodash.pick)(pipelineListItem, ['id']);
    props.origin = _constants.PIPELINE.ORIGIN.OTHER;
    return new PipelineListItem(props);
  }
}
exports.PipelineListItem = PipelineListItem;
function getMomentDate(date) {
  if (!date) {
    return null;
  }
  return (0, _moment.default)(date);
}