"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createLogDataService = createLogDataService;
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createLogDataService(params) {
  const {
    logSourcesService,
    deps
  } = params;
  async function getStatus() {
    const logSourcesIndex = await logSourcesService.getFlattenedLogSources();
    const status = await (0, _rxjs.lastValueFrom)(deps.search.search({
      params: {
        ignore_unavailable: true,
        allow_no_indices: true,
        index: logSourcesIndex,
        size: 0,
        terminate_after: 1,
        track_total_hits: 1
      }
    })).then(({
      rawResponse
    }) => {
      if (rawResponse._shards.total <= 0) {
        return 'missing';
      }
      const totalHits = rawResponse.hits.total;
      if (hasTotalHits(totalHits)) {
        return 'available';
      }
      return 'empty';
    }, err => {
      if (err.status === 404) {
        return 'missing';
      }
      throw new Error(`Failed to check status of log indices of "${logSourcesIndex}": ${err}`);
    });
    return {
      status,
      hasData: status === 'available'
    };
  }
  return {
    getStatus
  };
}
const hasTotalHits = totalHits => typeof totalHits === 'number' ? totalHits > 0 : Number(totalHits === null || totalHits === void 0 ? void 0 : totalHits.value) > 0;