"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertToRunTimeState = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const convertToRunTimeState = state => {
  // Remove legacy state properties if they exist
  const {
    secondaryPrefix,
    valuesTextAlign,
    ...restState
  } = state;
  let newState = {
    ...restState
  };
  if (valuesTextAlign) {
    var _state$primaryAlign, _state$secondaryAlign;
    newState = {
      ...newState,
      primaryAlign: (_state$primaryAlign = state.primaryAlign) !== null && _state$primaryAlign !== void 0 ? _state$primaryAlign : valuesTextAlign,
      secondaryAlign: (_state$secondaryAlign = state.secondaryAlign) !== null && _state$secondaryAlign !== void 0 ? _state$secondaryAlign : valuesTextAlign
    };
  }
  if (secondaryPrefix && !newState.secondaryLabel) {
    newState = {
      ...newState,
      secondaryLabel: secondaryPrefix
    };
  }
  return newState;
};
exports.convertToRunTimeState = convertToRunTimeState;