"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HeatmapToolbar = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _chartExpressionsCommon = require("@kbn/chart-expressions-common");
var _chartIcons = require("@kbn/chart-icons");
var _visualizationUtils = require("@kbn/visualization-utils");
var _shared_components = require("../../../shared_components");
var _datasource_default_values = require("../../../shared_components/datasource_default_values");
var _style_settings = require("./style_settings");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/visualizations/heatmap/toolbar_component/toolbar_component.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PANEL_STYLE = {
  width: '500px'
};
const legendOptions = [{
  id: `heatmap_legend_show`,
  value: 'show',
  label: _i18n.i18n.translate('xpack.lens.heatmapChart.legendVisibility.show', {
    defaultMessage: 'Show'
  })
}, {
  id: `heatmap_legend_hide`,
  value: 'hide',
  label: _i18n.i18n.translate('xpack.lens.heatmapChart.legendVisibility.hide', {
    defaultMessage: 'Hide'
  })
}];
const HeatmapToolbar = exports.HeatmapToolbar = /*#__PURE__*/(0, _react.memo)(props => {
  var _state$legend$shouldT;
  const {
    state,
    setState,
    frame
  } = props;
  const legendMode = state.legend.isVisible ? 'show' : 'hide';
  const defaultTruncationValue = (0, _datasource_default_values.getDefaultVisualValuesForLayer)(state, frame.datasourceLayers).truncateText;
  const legendSize = state === null || state === void 0 ? void 0 : state.legend.legendSize;
  const [hadAutoLegendSize] = (0, _react.useState)(() => legendSize === _chartExpressionsCommon.LegendSize.AUTO);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_shared_components.ToolbarPopover, {
    title: _i18n.i18n.translate('xpack.lens.shared.titlesAndTextLabel', {
      defaultMessage: 'Titles and text'
    }),
    type: "titlesAndText",
    buttonDataTestSubj: "lnsTextOptionsButton",
    "data-test-subj": "lnsTextOptionsPopover",
    panelStyle: PANEL_STYLE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_style_settings.HeatmapTitlesAndTextSettings, (0, _extends2.default)({}, props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_visualizationUtils.TooltipWrapper, {
    tooltipContent: _i18n.i18n.translate('xpack.lens.heatmap.verticalAxisDisabledHelpText', {
      defaultMessage: 'This setting only applies when vertical axis is enabled.'
    }),
    condition: !Boolean(state === null || state === void 0 ? void 0 : state.yAccessor),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_shared_components.ToolbarPopover, {
    title: _i18n.i18n.translate('xpack.lens.heatmap.verticalAxisLabel', {
      defaultMessage: 'Vertical axis'
    }),
    type: _chartIcons.EuiIconAxisLeft,
    groupPosition: "left",
    isDisabled: !Boolean(state === null || state === void 0 ? void 0 : state.yAccessor),
    buttonDataTestSubj: "lnsHeatmapVerticalAxisButton",
    panelStyle: PANEL_STYLE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_style_settings.HeatmapVerticalAxisSettings, (0, _extends2.default)({}, props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 17
    }
  })))), /*#__PURE__*/_react.default.createElement(_visualizationUtils.TooltipWrapper, {
    tooltipContent: _i18n.i18n.translate('xpack.lens.heatmap.horizontalAxisDisabledHelpText', {
      defaultMessage: 'This setting only applies when horizontal axis is enabled.'
    }),
    condition: !Boolean(state === null || state === void 0 ? void 0 : state.xAccessor),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_shared_components.ToolbarPopover, {
    title: _i18n.i18n.translate('xpack.lens.heatmap.horizontalAxisLabel', {
      defaultMessage: 'Horizontal axis'
    }),
    type: _chartIcons.EuiIconAxisBottom,
    groupPosition: "center",
    isDisabled: !Boolean(state === null || state === void 0 ? void 0 : state.xAccessor),
    buttonDataTestSubj: "lnsHeatmapHorizontalAxisButton",
    panelStyle: PANEL_STYLE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_style_settings.HeatmapHorizontalAxisSettings, (0, _extends2.default)({}, props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 17
    }
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_shared_components.LegendSettingsPopover, {
    legendOptions: legendOptions,
    mode: legendMode,
    onDisplayChange: optionId => {
      const newMode = legendOptions.find(({
        id
      }) => id === optionId).value;
      if (newMode === 'show') {
        setState({
          ...state,
          legend: {
            ...state.legend,
            isVisible: true
          }
        });
      } else if (newMode === 'hide') {
        setState({
          ...state,
          legend: {
            ...state.legend,
            isVisible: false
          }
        });
      }
    },
    position: state === null || state === void 0 ? void 0 : state.legend.position,
    onPositionChange: id => {
      setState({
        ...state,
        legend: {
          ...state.legend,
          position: id
        }
      });
    },
    maxLines: state === null || state === void 0 ? void 0 : state.legend.maxLines,
    onMaxLinesChange: val => {
      setState({
        ...state,
        legend: {
          ...state.legend,
          maxLines: val
        }
      });
    },
    shouldTruncate: (_state$legend$shouldT = state === null || state === void 0 ? void 0 : state.legend.shouldTruncate) !== null && _state$legend$shouldT !== void 0 ? _state$legend$shouldT : defaultTruncationValue,
    onTruncateLegendChange: () => {
      var _state$legend$shouldT2;
      const current = (_state$legend$shouldT2 = state.legend.shouldTruncate) !== null && _state$legend$shouldT2 !== void 0 ? _state$legend$shouldT2 : defaultTruncationValue;
      setState({
        ...state,
        legend: {
          ...state.legend,
          shouldTruncate: !current
        }
      });
    },
    legendSize: legendSize,
    onLegendSizeChange: newLegendSize => {
      setState({
        ...state,
        legend: {
          ...state.legend,
          legendSize: newLegendSize
        }
      });
    },
    showAutoLegendSizeOption: hadAutoLegendSize,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 11
    }
  })));
});