"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSuggestions = void 0;
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/expression-gauge-plugin/common");
var _chartIcons = require("@kbn/chart-icons");
var _public = require("@kbn/expression-xy-plugin/public");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isNotNumericMetric = table => {
  var _table$columns, _table$columns$;
  return ((_table$columns = table.columns) === null || _table$columns === void 0 ? void 0 : (_table$columns$ = _table$columns[0]) === null || _table$columns$ === void 0 ? void 0 : _table$columns$.operation.dataType) !== 'number' || table.columns.some(col => col.operation.isBucketed);
};
const hasLayerMismatch = (keptLayerIds, table) => keptLayerIds.length > 1 || keptLayerIds.length && table.layerId !== keptLayerIds[0];
const getSuggestions = ({
  table,
  state,
  keptLayerIds
}) => {
  var _state$shape;
  const isGauge = Boolean(state && (state.minAccessor || state.maxAccessor || state.goalAccessor || state.metricAccessor));
  const numberOfAccessors = state && [state.minAccessor, state.maxAccessor, state.goalAccessor, state.metricAccessor].filter(Boolean).length;
  if (hasLayerMismatch(keptLayerIds, table) || isNotNumericMetric(table) || state && !isGauge && table.columns.length > 1 || isGauge && (numberOfAccessors !== table.columns.length || table.changeType === 'initial')) {
    return [];
  }
  const baseSuggestion = {
    state: {
      ...state,
      shape: (_state$shape = state === null || state === void 0 ? void 0 : state.shape) !== null && _state$shape !== void 0 ? _state$shape : _common.GaugeShapes.HORIZONTAL_BULLET,
      layerId: table.layerId,
      layerType: _public.LayerTypes.DATA,
      ticksPosition: _common.GaugeTicksPositions.AUTO,
      labelMajorMode: _common.GaugeLabelMajorModes.AUTO
    },
    title: _i18n.i18n.translate('xpack.lens.gauge.gaugeLabel', {
      defaultMessage: 'Gauge'
    }),
    previewIcon: _chartIcons.IconChartHorizontalBullet,
    score: 0.5,
    hide: !isGauge || (state === null || state === void 0 ? void 0 : state.metricAccessor) === undefined,
    // only display for gauges for beta
    incomplete: (state === null || state === void 0 ? void 0 : state.metricAccessor) === undefined
  };
  const suggestions = isGauge ? [{
    ...baseSuggestion,
    title: _constants.gaugeTitlesByType.verticalBullet,
    previewIcon: _chartIcons.IconChartVerticalBullet,
    state: {
      ...baseSuggestion.state,
      ...state,
      shape: _common.GaugeShapes.VERTICAL_BULLET
    },
    score: 1
  }, {
    ...baseSuggestion,
    title: _constants.gaugeTitlesByType.horizontalBullet,
    previewIcon: _chartIcons.IconChartHorizontalBullet,
    state: {
      ...baseSuggestion.state,
      ...state,
      shape: _common.GaugeShapes.HORIZONTAL_BULLET
    },
    score: 1
  }, {
    ...baseSuggestion,
    title: _constants.gaugeTitlesByType.semiCircle,
    previewIcon: _chartIcons.IconChartGaugeSemiCircle,
    state: {
      ...baseSuggestion.state,
      ...state,
      shape: _common.GaugeShapes.SEMI_CIRCLE
    },
    score: 0.1
  }, {
    ...baseSuggestion,
    title: _constants.gaugeTitlesByType.arc,
    previewIcon: _chartIcons.IconChartGaugeArc,
    state: {
      ...baseSuggestion.state,
      ...state,
      shape: _common.GaugeShapes.ARC
    }
  }, {
    ...baseSuggestion,
    title: _constants.gaugeTitlesByType.circle,
    previewIcon: _chartIcons.IconChartGaugeCircle,
    state: {
      ...baseSuggestion.state,
      ...state,
      shape: _common.GaugeShapes.CIRCLE
    },
    score: 0.1
  }].filter(s => s.state.shape !== (state === null || state === void 0 ? void 0 : state.shape)) : [{
    ...baseSuggestion,
    state: {
      ...baseSuggestion.state,
      metricAccessor: table.columns[0].columnId
    }
  }, {
    ...baseSuggestion,
    previewIcon: (state === null || state === void 0 ? void 0 : state.shape) === _common.GaugeShapes.VERTICAL_BULLET ? _chartIcons.IconChartHorizontalBullet : _chartIcons.IconChartVerticalBullet,
    state: {
      ...baseSuggestion.state,
      metricAccessor: table.columns[0].columnId,
      shape: (state === null || state === void 0 ? void 0 : state.shape) === _common.GaugeShapes.VERTICAL_BULLET ? _common.GaugeShapes.HORIZONTAL_BULLET : _common.GaugeShapes.VERTICAL_BULLET
    }
  }];
  return suggestions;
};
exports.getSuggestions = getSuggestions;