"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getOpenLayerSettingsAction = void 0;
var _i18n = require("@kbn/i18n");
var _order_bounds = require("./order_bounds");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getOpenLayerSettingsAction = props => {
  const displayName = _i18n.i18n.translate('xpack.lens.layerActions.layerSettingsAction', {
    defaultMessage: 'Layer settings'
  });
  return {
    displayName,
    execute: props.openLayerSettings,
    icon: 'gear',
    isCompatible: props.hasLayerSettings,
    'data-test-subj': 'lnsLayerSettings',
    order: _order_bounds.FIRST_ACTION_ORDER
  };
};
exports.getOpenLayerSettingsAction = getOpenLayerSettingsAction;