"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.redirectToDashboard = void 0;
var _uuid = require("uuid");
var _controlsConstants = require("@kbn/controls-constants");
var _constants = require("../../common/constants");
var _embeddable_factory = require("../../common/embeddable_factory");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Transforms control panels state into controls group state format.
 * @param controlsState - The control panels state to transform
 * @returns Array of control configurations for the controls group
 */
function transformControlPanelsToControlsGroup(controlsState) {
  const controls = [];
  Object.values(controlsState !== null && controlsState !== void 0 ? controlsState : {}).forEach((panel, idx) => {
    const {
      width,
      grow,
      type,
      ...controlConfig
    } = panel;
    const id = (0, _uuid.v4)();
    controls.push({
      id,
      grow,
      order: idx,
      type,
      width,
      controlConfig
    });
  });
  return controls;
}
const redirectToDashboard = ({
  embeddableInput: rawState,
  dashboardId,
  originatingApp,
  getOriginatingPath,
  stateTransfer,
  controlsState
}) => {
  var _getOriginatingPath;
  const {
    references
  } = (0, _embeddable_factory.extract)(rawState);
  const appId = originatingApp || 'dashboards';
  const controls = transformControlPanelsToControlsGroup(controlsState);
  const embeddablePackages = [{
    type: _constants.LENS_EMBEDDABLE_TYPE,
    serializedState: {
      rawState,
      references
    }
  }];

  // Only add controls group if they exist
  if (controls.length > 0) {
    embeddablePackages.push({
      type: _controlsConstants.CONTROLS_GROUP_TYPE,
      serializedState: {
        rawState: {
          labelPosition: _controlsConstants.DEFAULT_CONTROLS_LABEL_POSITION,
          chainingSystem: _controlsConstants.DEFAULT_CONTROLS_CHAINING,
          autoApplySelections: _controlsConstants.DEFAULT_AUTO_APPLY_SELECTIONS,
          ignoreParentSettings: _controlsConstants.DEFAULT_IGNORE_PARENT_SETTINGS,
          controls
        },
        references: []
      }
    });
  }
  stateTransfer.navigateToWithEmbeddablePackages(appId, {
    state: embeddablePackages,
    path: (_getOriginatingPath = getOriginatingPath === null || getOriginatingPath === void 0 ? void 0 : getOriginatingPath(dashboardId)) !== null && _getOriginatingPath !== void 0 ? _getOriginatingPath : dashboardId === 'new' ? '#/create' : `#/view/${dashboardId}`
  });
};
exports.redirectToDashboard = redirectToDashboard;