"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InspectOverlay = void 0;
var _react = _interopRequireWildcard(require("react"));
var _css = require("@emotion/css");
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _keyboard_shortcut = require("../../../lib/keyboard_shortcut/keyboard_shortcut");
var _find_first_fiber_with_debug_source = require("../../../lib/fiber/find_first_fiber_with_debug_source");
var _handle_event_propagation = require("../../../lib/dom/handle_event_propagation");
var _get_inspected_element_data = require("../../../lib/get_inspected_element_data");
var _get_element_from_point = require("../../../lib/dom/get_element_from_point");
var _find_source_component = require("../../../lib/fiber/find_source_component");
var _inspect_flyout = require("../flyout/inspect_flyout");
var _inspect_highlight = require("./inspect_highlight");
var _constants = require("../../../lib/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/private/inspect_component/public/components/inspect/overlay/inspect_overlay.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * InspectOverlay renders an overlay over the entire viewport when inspect mode is enabled.
 * It highlights HTML elements as they get hovered over.
 */
const InspectOverlay = ({
  core,
  branch,
  setFlyoutOverlayRef,
  setIsInspecting
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [highlightPosition, setHighlightPosition] = (0, _react.useState)({});
  const [sourceComponent, setSourceComponent] = (0, _react.useState)(null);
  const [targetFiberNode, setTargetFiberNode] = (0, _react.useState)(null);

  /**
   * 'pointer-events: none' is required for {@link handleEventPropagation} to work properly.
   */
  const overlayCss = (0, _react.useMemo)(() => (0, _css.css)`
      background-color: ${(0, _eui.transparentize)(euiTheme.colors.backgroundFilledText, 0.2)};
      inset: 0;
      position: fixed;
      z-index: ${Number(euiTheme.levels.toast) + 1};
      pointer-events: none;
    `, [euiTheme.colors.backgroundFilledText, euiTheme.levels.toast]);
  const handleKeydown = (0, _react.useCallback)(event => {
    if ((0, _keyboard_shortcut.isEscapeKey)(event)) {
      event.preventDefault();
      setIsInspecting(false);
    }
  }, [setIsInspecting]);
  const handlePointerMove = (0, _react.useCallback)(event => {
    const target = (0, _get_element_from_point.getElementFromPoint)(event);
    if (!target) {
      return;
    }
    const {
      top,
      left,
      width,
      height
    } = target.getBoundingClientRect();
    const fiberNode = (0, _find_first_fiber_with_debug_source.findFirstFiberWithDebugSource)(target);
    if (!fiberNode) {
      return;
    }
    setTargetFiberNode(fiberNode);
    const sourceComponentResult = (0, _find_source_component.findSourceComponent)(fiberNode);
    setSourceComponent(sourceComponentResult);
    setHighlightPosition({
      width: `${width}px`,
      height: `${height}px`,
      transform: `translate(${left}px, ${top}px)`
    });
  }, []);
  const handleClickAtPositionOfInspectedElement = (0, _react.useCallback)(async event => {
    const target = (0, _get_element_from_point.getElementFromPoint)(event);
    if (!target) {
      setIsInspecting(false);
      return;
    }
    const componentData = await (0, _get_inspected_element_data.getInspectedElementData)({
      httpService: core.http,
      targetFiberNode,
      sourceComponent
    });
    if (!componentData) {
      setIsInspecting(false);
      return;
    }
    const flyout = core.overlays.openFlyout((0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_inspect_flyout.InspectFlyout, {
      componentData: componentData,
      target: target,
      branch: branch,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 118,
        columnNumber: 11
      }
    }), core.rendering), _inspect_flyout.flyoutOptions);
    flyout.onClose.then(() => {
      setFlyoutOverlayRef(null);
    });
    setFlyoutOverlayRef(flyout);
    setIsInspecting(false);
  }, [core, branch, sourceComponent, targetFiberNode, setIsInspecting, setFlyoutOverlayRef]);
  (0, _react.useEffect)(() => {
    /**
     * Capture all click events on the document and stop them from propagating.
     * 'EuiWindowEvent' can't be used here as it doesn't allow for setting 'capture: true'.
     */
    const handleMouseEvent = event => {
      (0, _handle_event_propagation.handleEventPropagation)({
        event,
        callback: handleClickAtPositionOfInspectedElement
      });
    };
    document.addEventListener('pointerdown', handleMouseEvent, true);
    document.addEventListener('click', handleMouseEvent, true);
    return () => {
      document.removeEventListener('pointerdown', handleMouseEvent, true);
      document.removeEventListener('click', handleMouseEvent, true);
    };
  }, [handleClickAtPositionOfInspectedElement]);
  const overlayContent = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_react2.Global, {
    styles: {
      // This is a workaround which forces the crosshair cursor when inspecting.
      'body *': {
        cursor: 'crosshair !important'
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: overlayCss,
    id: _constants.INSPECT_OVERLAY_ID,
    "data-test-subj": "inspectOverlayContainer",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiWindowEvent, {
    event: "keydown",
    handler: handleKeydown,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiWindowEvent, {
    event: "pointermove",
    handler: handlePointerMove,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_inspect_highlight.InspectHighlight, {
    currentPosition: highlightPosition,
    path: (sourceComponent === null || sourceComponent === void 0 ? void 0 : sourceComponent.type) || null,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 11
    }
  }))), [overlayCss, highlightPosition, sourceComponent === null || sourceComponent === void 0 ? void 0 : sourceComponent.type, handlePointerMove, handleKeydown]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 10
    }
  }, overlayContent);
};
exports.InspectOverlay = InspectOverlay;