"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.callValidateIndicesAPI = void 0;
var _ioTsUtils = require("@kbn/io-ts-utils");
var _http_api = require("../../../../../common/http_api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const callValidateIndicesAPI = async (requestArgs, fetch) => {
  const {
    indices,
    fields,
    runtimeMappings
  } = requestArgs;
  const response = await fetch(_http_api.LOG_ANALYSIS_VALIDATE_INDICES_PATH, {
    method: 'POST',
    body: JSON.stringify(
    // @ts-expect-error TODO: fix after elasticsearch-js bump
    _http_api.validationIndicesRequestPayloadRT.encode({
      data: {
        indices,
        fields,
        runtimeMappings
      }
    })),
    version: '1'
  });
  return (0, _ioTsUtils.decodeOrThrow)(_http_api.validationIndicesResponsePayloadRT)(response);
};
exports.callValidateIndicesAPI = callValidateIndicesAPI;