"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexSetupRow = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _index_setup_dataset_filter = require("./index_setup_dataset_filter");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/components/logging/log_analysis_setup/initial_configuration_step/index_setup_row.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const IndexSetupRow = ({
  index,
  isDisabled,
  onChangeDatasetFilter,
  onChangeIsSelected,
  previousQualityWarnings
}) => {
  const changeIsSelected = (0, _react.useCallback)(event => {
    onChangeIsSelected(index.name, event.currentTarget.checked);
  }, [index.name, onChangeIsSelected]);
  const changeDatasetFilter = (0, _react.useCallback)(datasetFilter => onChangeDatasetFilter(index.name, datasetFilter), [index.name, onChangeDatasetFilter]);
  const datasets = (0, _react.useMemo)(() => index.validity === 'valid' ? index.availableDatasets.map(availableDataset => ({
    dataset: availableDataset,
    warnings: previousQualityWarnings.filter(({
      dataset
    }) => dataset === availableDataset)
  })) : [], [index, previousQualityWarnings]);
  const datasetIndependentQualityWarnings = (0, _react.useMemo)(() => previousQualityWarnings.filter(({
    dataset
  }) => dataset === ''), [previousQualityWarnings]);
  const hasWarnings = (0, _react.useMemo)(() => datasetIndependentQualityWarnings.length > 0 || datasets.some(({
    warnings
  }) => warnings.length > 0), [datasetIndependentQualityWarnings, datasets]);
  const isSelected = index.validity === 'valid' && index.isSelected;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    key: index.name,
    id: index.name,
    label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, index.name, index.validity === 'valid' && hasWarnings ? /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.infra.logs.analsysisSetup.indexQualityWarningTooltipMessage",
        defaultMessage: "While analyzing the log messages from these indices we've detected some problems which might indicate a reduced quality of the results. Consider excluding these indices or problematic datasets from the analysis.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 76,
          columnNumber: 19
        }
      }),
      type: "warning",
      color: "warning",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 15
      }
    }) : null),
    onChange: changeIsSelected,
    checked: isSelected,
    disabled: isDisabled || index.validity === 'invalid',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, index.validity === 'invalid' ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "textSubduedColor",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 11
    }
  }, formatValidationError(index.errors)) : index.validity === 'valid' ? /*#__PURE__*/_react.default.createElement(_index_setup_dataset_filter.IndexSetupDatasetFilter, {
    availableDatasets: datasets,
    datasetFilter: index.datasetFilter,
    isDisabled: !isSelected || isDisabled,
    onChangeDatasetFilter: changeDatasetFilter,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 11
    }
  }) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 7
    }
  }));
};
exports.IndexSetupRow = IndexSetupRow;
const formatValidationError = errors => {
  return errors.map(error => {
    switch (error.error) {
      case 'INDEX_NOT_FOUND':
        return /*#__PURE__*/_react.default.createElement("p", {
          key: `${error.error}-${error.index}`,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 115,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.infra.analysisSetup.indicesSelectionIndexNotFound",
          defaultMessage: "No indices match the pattern {index}",
          values: {
            index: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 119,
                columnNumber: 32
              }
            }, error.index)
          },
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 116,
            columnNumber: 13
          }
        }));
      case 'FIELD_NOT_FOUND':
        return /*#__PURE__*/_react.default.createElement("p", {
          key: `${error.error}-${error.index}-${error.field}`,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 126,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.infra.analysisSetup.indicesSelectionNoTimestampField",
          defaultMessage: "At least one index matching {index} lacks a required field {field}.",
          values: {
            index: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 131,
                columnNumber: 24
              }
            }, error.index),
            field: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 132,
                columnNumber: 24
              }
            }, error.field)
          },
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 127,
            columnNumber: 13
          }
        }));
      case 'FIELD_NOT_VALID':
        return /*#__PURE__*/_react.default.createElement("p", {
          key: `${error.error}-${error.index}-${error.field}`,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 140,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.infra.analysisSetup.indicesSelectionTimestampNotValid",
          defaultMessage: "At least one index matching {index} has a field called {field} without the correct type.",
          values: {
            index: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 145,
                columnNumber: 24
              }
            }, error.index),
            field: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 146,
                columnNumber: 24
              }
            }, error.field)
          },
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 141,
            columnNumber: 13
          }
        }));
      default:
        return '';
    }
  });
};