"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetadataSummaryListCompact = exports.MetadataSummaryList = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _translations = require("../../../translations");
var _use_tab_switcher = require("../../../hooks/use_tab_switcher");
var _types = require("../../../types");
var _expandable_content = require("../../../components/expandable_content");
var _metadata_header = require("./metadata_header");
var _metadata_explanation = require("../../../components/metadata_explanation");
var _section_title = require("../../../components/section_title");
var _section = require("../../../components/section");
var _metadata_by_schema = require("./metadata_by_schema");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/components/asset_details/tabs/overview/metadata_summary/metadata_summary_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const MetadataSummaryListWrapper = ({
  loading: metadataLoading,
  visibleMetadata,
  entityType,
  schema
}) => {
  const {
    showTab
  } = (0, _use_tab_switcher.useTabSwitcherContext)();
  const onClick = () => {
    showTab(_types.ContentTabIds.METADATA);
  };
  return /*#__PURE__*/_react.default.createElement(_section.Section, {
    title: /*#__PURE__*/_react.default.createElement(_section_title.SectionTitle, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.infra.assetDetails.overview.metadataSectionTitle",
        defaultMessage: "Metadata",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 69,
          columnNumber: 13
        }
      }),
      "data-test-subj": "infraAssetDetailsMetadataTitle",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 67,
        columnNumber: 9
      }
    }),
    collapsible: true,
    "data-test-subj": "infraAssetDetailsMetadataCollapsible",
    id: "metadata",
    extraAction: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "aria-label": _i18n.i18n.translate('xpack.infra.assetDetails.metadataSummary.showAllMetadataButton.ariaLabel', {
        defaultMessage: 'Show all metadata'
      }),
      "data-test-subj": "infraAssetDetailsMetadataShowAllButton",
      onClick: onClick,
      size: "xs",
      flush: "both",
      iconSide: "right",
      iconType: "sortRight",
      key: "metadata-link",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 81,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.assetDetails.metadataSummary.showAllMetadataButton",
      defaultMessage: "Show all",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 96,
        columnNumber: 11
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_metadata_explanation.MetadataExplanationMessage, {
    entityType: entityType,
    schema: schema,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 9
    }
  }, visibleMetadata.filter(metadataValue => metadataValue).map(metadataValue => {
    var _metadataValue$value;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: metadataValue.field,
      grow: false,
      css: {
        width: '200px'
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 110,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
      "data-test-subj": "infraMetadataSummaryItem",
      compressed: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 111,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_metadata_header.MetadataHeader, {
      metadataValue: metadataValue,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 112,
        columnNumber: 19
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 113,
        columnNumber: 19
      }
    }, metadataLoading && !metadataValue.value ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 115,
        columnNumber: 23
      }
    }) : /*#__PURE__*/_react.default.createElement(_expandable_content.ExpandableContent, {
      values: (_metadataValue$value = metadataValue.value) !== null && _metadataValue$value !== void 0 ? _metadataValue$value : _translations.NOT_AVAILABLE_LABEL,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 117,
        columnNumber: 23
      }
    }))));
  }))));
};
const MetadataSummaryList = ({
  metadata,
  loading,
  entityType,
  schema
}) => {
  const host = (0, _metadata_by_schema.getHostMetadataBySchema)(metadata === null || metadata === void 0 ? void 0 : metadata.info, schema);
  const container = (0, _metadata_by_schema.getContainerMetadata)(metadata === null || metadata === void 0 ? void 0 : metadata.info);
  switch (entityType) {
    case 'host':
      return /*#__PURE__*/_react.default.createElement(MetadataSummaryListWrapper, {
        visibleMetadata: [...host.metadata, ...host.extended],
        loading: loading,
        entityType: entityType,
        schema: schema,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 140,
          columnNumber: 9
        }
      });
    case 'container':
      return /*#__PURE__*/_react.default.createElement(MetadataSummaryListWrapper, {
        visibleMetadata: [...container.metadata, ...container.extended],
        loading: loading,
        entityType: entityType,
        schema: schema,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 149,
          columnNumber: 9
        }
      });
    default:
      return /*#__PURE__*/_react.default.createElement(MetadataSummaryListWrapper, {
        visibleMetadata: [],
        loading: loading,
        entityType: entityType,
        schema: schema,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 158,
          columnNumber: 9
        }
      });
  }
};
exports.MetadataSummaryList = MetadataSummaryList;
const MetadataSummaryListCompact = ({
  metadata,
  loading,
  entityType,
  schema
}) => {
  const host = (0, _metadata_by_schema.getHostMetadataBySchema)(metadata === null || metadata === void 0 ? void 0 : metadata.info, schema);
  const container = (0, _metadata_by_schema.getContainerMetadata)(metadata === null || metadata === void 0 ? void 0 : metadata.info);
  switch (entityType) {
    case 'host':
      return /*#__PURE__*/_react.default.createElement(MetadataSummaryListWrapper, {
        visibleMetadata: host.metadata,
        loading: loading,
        entityType: entityType,
        schema: schema,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 180,
          columnNumber: 9
        }
      });
    case 'container':
      return /*#__PURE__*/_react.default.createElement(MetadataSummaryListWrapper, {
        visibleMetadata: container.metadata,
        loading: loading,
        entityType: entityType,
        schema: schema,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 189,
          columnNumber: 9
        }
      });
    default:
      return /*#__PURE__*/_react.default.createElement(MetadataSummaryListWrapper, {
        visibleMetadata: [],
        loading: loading,
        entityType: entityType,
        schema: schema,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 198,
          columnNumber: 9
        }
      });
  }
};
exports.MetadataSummaryListCompact = MetadataSummaryListCompact;