"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DatePickerProvider = void 0;
exports.useDatePicker = useDatePicker;
exports.useDatePickerContext = void 0;
var _constate = _interopRequireDefault(require("constate"));
var _react = require("react");
var _useEffectOnce = _interopRequireDefault(require("react-use/lib/useEffectOnce"));
var _rxjs = require("rxjs");
var _use_waffle_options = require("../../../pages/metrics/inventory_view/hooks/use_waffle_options");
var _use_unified_search = require("../../../pages/metrics/hosts/hooks/use_unified_search");
var _use_reload_request_time = require("../../../hooks/use_reload_request_time");
var _datemath = require("../../../utils/datemath");
var _utils = require("../utils");
var _use_asset_details_url_state = require("./use_asset_details_url_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useDatePicker({
  dateRange = (0, _utils.getDefaultDateRange)(),
  autoRefresh
}) {
  var _urlState$dateRange, _urlState$autoRefresh, _urlState$dateRange2;
  const {
    updateReloadRequestTime
  } = (0, _use_reload_request_time.useReloadRequestTimeContext)();
  const autoRefreshTick$ = (0, _react.useMemo)(() => new _rxjs.BehaviorSubject(null), []);
  const autoRefreshConfig$ = (0, _react.useMemo)(() => new _rxjs.BehaviorSubject(undefined), []);
  const {
    searchCriteria
  } = (0, _use_unified_search.useUnifiedSearchContext)();
  const {
    preferredSchema
  } = (0, _use_waffle_options.useWaffleOptionsContext)();
  const autoRefreshEnabled = autoRefresh && !autoRefresh.isPaused;
  const [urlState, setUrlState] = (0, _use_asset_details_url_state.useAssetDetailsUrlState)();
  const [parsedDateRange, setParsedDateRange] = (0, _react.useState)((0, _datemath.parseDateRange)((_urlState$dateRange = urlState === null || urlState === void 0 ? void 0 : urlState.dateRange) !== null && _urlState$dateRange !== void 0 ? _urlState$dateRange : dateRange));
  (0, _useEffectOnce.default)(() => {
    var _ref, _searchCriteria$prefe;
    autoRefreshConfig$.next(urlState !== null && urlState !== void 0 && urlState.autoRefresh ? urlState.autoRefresh : autoRefresh);
    setUrlState({
      ...(!(urlState !== null && urlState !== void 0 && urlState.dateRange) ? {
        dateRange
      } : undefined),
      ...(!(urlState !== null && urlState !== void 0 && urlState.autoRefresh) ? {
        autoRefresh
      } : undefined),
      // this is needed since both /hosts and /inventory use different URL state
      preferredSchema: (_ref = (_searchCriteria$prefe = searchCriteria === null || searchCriteria === void 0 ? void 0 : searchCriteria.preferredSchema) !== null && _searchCriteria$prefe !== void 0 ? _searchCriteria$prefe : preferredSchema) !== null && _ref !== void 0 ? _ref : 'semconv'
    });
  });
  const setDateRange = (0, _react.useCallback)(newDateRange => {
    setUrlState({
      dateRange: newDateRange
    });
    setParsedDateRange((0, _datemath.parseDateRange)(newDateRange));
    updateReloadRequestTime();
  }, [setUrlState, updateReloadRequestTime]);
  const onRefresh = (0, _react.useCallback)(newDateRange => {
    // auto-refresh updates the search session id when the date range changes
    if (autoRefreshEnabled) {
      autoRefreshTick$.next(null);
    } else {
      setDateRange(newDateRange);
    }
  }, [autoRefreshEnabled, autoRefreshTick$, setDateRange]);
  const setAutoRefresh = (0, _react.useCallback)(newAutoRefresh => {
    autoRefreshConfig$.next(newAutoRefresh);
    setUrlState({
      autoRefresh: newAutoRefresh
    });
  }, [autoRefreshConfig$, setUrlState]);
  const getParsedDateRange = (0, _react.useCallback)(() => {
    const defaultDateRange = (0, _utils.getDefaultDateRange)();
    const {
      from = defaultDateRange.from,
      to = defaultDateRange.to
    } = parsedDateRange;
    return {
      from,
      to
    };
  }, [parsedDateRange]);
  const getDateRangeInTimestamp = (0, _react.useCallback)(() => (0, _utils.toTimestampRange)(getParsedDateRange()), [getParsedDateRange]);
  return {
    autoRefresh: (_urlState$autoRefresh = urlState === null || urlState === void 0 ? void 0 : urlState.autoRefresh) !== null && _urlState$autoRefresh !== void 0 ? _urlState$autoRefresh : autoRefresh,
    autoRefreshTick$,
    autoRefreshConfig$,
    dateRange: (_urlState$dateRange2 = urlState === null || urlState === void 0 ? void 0 : urlState.dateRange) !== null && _urlState$dateRange2 !== void 0 ? _urlState$dateRange2 : dateRange,
    getDateRangeInTimestamp,
    getParsedDateRange,
    onRefresh,
    setAutoRefresh,
    setDateRange
  };
}
const [DatePickerProvider, useDatePickerContext] = (0, _constate.default)(useDatePicker);
exports.useDatePickerContext = useDatePickerContext;
exports.DatePickerProvider = DatePickerProvider;