"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetadataErrorCallout = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _use_metadata_state = require("../hooks/use_metadata_state");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/components/asset_details/components/metadata_error_callout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const MetadataErrorCallout = () => {
  const {
    refresh
  } = (0, _use_metadata_state.useMetadataStateContext)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.infra.metadataEmbeddable.errorTitle', {
      defaultMessage: 'Sorry, there was an error'
    }),
    color: "danger",
    iconType: "error",
    "data-test-subj": "infraAssetDetailsMetadataErrorCallout",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 17,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.metadataEmbeddable.errorMessage",
    defaultMessage: "There was an error loading your data. Try to {refetch} and open the host details again.",
    values: {
      refetch: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "infraMetadataReloadPageLink",
        onClick: refresh,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 30,
          columnNumber: 13
        }
      }, _i18n.i18n.translate('xpack.infra.metadataEmbeddable.errorAction', {
        defaultMessage: 'refetch the metadata'
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 25,
      columnNumber: 7
    }
  }));
};
exports.MetadataErrorCallout = MetadataErrorCallout;