"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sizeRT = exports.servicesFiltersRT = exports.ServicesAPIResponseRT = exports.ServicesAPIQueryAggregationRT = exports.ServiceRT = exports.GetServicesRequestQueryRT = void 0;
var _ioTsUtils = require("@kbn/io-ts-utils");
var rt = _interopRequireWildcard(require("io-ts"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const sizeRT = exports.sizeRT = rt.union([(0, _ioTsUtils.inRangeFromStringRt)(1, 100), (0, _ioTsUtils.createLiteralValueFromUndefinedRT)(10)]);
const servicesFiltersRT = exports.servicesFiltersRT = rt.strict({
  ['host.name']: rt.string
});
const GetServicesRequestQueryRT = exports.GetServicesRequestQueryRT = rt.intersection([rt.strict({
  from: _ioTsUtils.isoToEpochRt,
  to: _ioTsUtils.isoToEpochRt,
  filters: rt.string
}), rt.partial({
  size: sizeRT,
  validatedFilters: servicesFiltersRT
})]);
const AgentNameRT = rt.union([rt.string, rt.null]);
const ServicesAPIQueryAggregationRT = exports.ServicesAPIQueryAggregationRT = rt.type({
  services: rt.type({
    buckets: rt.array(rt.type({
      key: rt.string,
      latestAgent: rt.type({
        top: rt.array(rt.type({
          sort: rt.array(rt.string),
          metrics: rt.type({
            'agent.name': AgentNameRT
          })
        }))
      })
    }))
  })
});
const ServiceRT = exports.ServiceRT = rt.type({
  serviceName: rt.string,
  agentName: AgentNameRT
});
const ServicesAPIResponseRT = exports.ServicesAPIResponseRT = rt.type({
  services: rt.array(ServiceRT)
});