"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getChatSpan = getChatSpan;
var _openinferenceSemanticConventions = require("@arizeai/openinference-semantic-conventions");
var _lodash = require("lodash");
var _types = require("../types");
var _flatten_attributes = require("../util/flatten_attributes");
var _unflatten_attributes = require("../util/unflatten_attributes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getChatSpan(span) {
  var _inputEvents$find, _inputEvents$find$att, _span$attributes$LLM_, _span$attributes$LLM_2;
  const [inputEvents, outputEvents] = (0, _lodash.partition)(span.events.filter(event => event.name !== 'exception'), event => event.name !== _types.GenAISemanticConventions.GenAIChoice);
  span.attributes[_openinferenceSemanticConventions.LLM_MODEL_NAME] = span.attributes[_types.GenAISemanticConventions.GenAIResponseModel];
  span.attributes[_openinferenceSemanticConventions.INPUT_MIME_TYPE] = _openinferenceSemanticConventions.MimeType.JSON;
  span.attributes[_openinferenceSemanticConventions.LLM_INVOCATION_PARAMETERS] = JSON.stringify({
    system: (_inputEvents$find = inputEvents.find(event => event.name === _types.GenAISemanticConventions.GenAISystemMessage)) === null || _inputEvents$find === void 0 ? void 0 : (_inputEvents$find$att = _inputEvents$find.attributes) === null || _inputEvents$find$att === void 0 ? void 0 : _inputEvents$find$att.content
  });
  span.attributes[_openinferenceSemanticConventions.LLM_SYSTEM] = span.attributes[_types.GenAISemanticConventions.GenAISystem];
  span.attributes[_openinferenceSemanticConventions.LLM_PROVIDER] = span.attributes[_types.GenAISemanticConventions.GenAISystem];
  span.attributes[_openinferenceSemanticConventions.LLM_TOKEN_COUNT_COMPLETION] = span.attributes[_types.GenAISemanticConventions.GenAIUsageOutputTokens];
  span.attributes[_openinferenceSemanticConventions.LLM_TOKEN_COUNT_PROMPT] = span.attributes[_types.GenAISemanticConventions.GenAIUsageInputTokens];
  span.attributes[_openinferenceSemanticConventions.LLM_TOKEN_COUNT_PROMPT_DETAILS_CACHE_READ] = span.attributes[_types.GenAISemanticConventions.GenAIUsageCachedInputTokens];
  span.attributes[_openinferenceSemanticConventions.LLM_TOKEN_COUNT_TOTAL] = Number((_span$attributes$LLM_ = span.attributes[_openinferenceSemanticConventions.LLM_TOKEN_COUNT_COMPLETION]) !== null && _span$attributes$LLM_ !== void 0 ? _span$attributes$LLM_ : 0) + Number((_span$attributes$LLM_2 = span.attributes[_openinferenceSemanticConventions.LLM_TOKEN_COUNT_PROMPT]) !== null && _span$attributes$LLM_2 !== void 0 ? _span$attributes$LLM_2 : 0);
  span.attributes[_openinferenceSemanticConventions.PROMPT_ID] = span.attributes['gen_ai.prompt.id'];
  span.attributes[_openinferenceSemanticConventions.PROMPT_TEMPLATE_TEMPLATE] = span.attributes['gen_ai.prompt.template.template'];

  // double stringify for Phoenix
  span.attributes[_openinferenceSemanticConventions.PROMPT_TEMPLATE_VARIABLES] = span.attributes['gen_ai.prompt.template.variables'] ? JSON.stringify(span.attributes['gen_ai.prompt.template.variables']) : undefined;
  span.attributes[_openinferenceSemanticConventions.INPUT_VALUE] = JSON.stringify(inputEvents.map(event => {
    var _event$attributes;
    return (0, _unflatten_attributes.unflattenAttributes)((_event$attributes = event.attributes) !== null && _event$attributes !== void 0 ? _event$attributes : {});
  }));
  const parsedTools = span.attributes[_types.ElasticGenAIAttributes.Tools] ? JSON.parse(String(span.attributes[_types.ElasticGenAIAttributes.Tools])) : {};
  span.attributes[_openinferenceSemanticConventions.LLM_TOOLS] = JSON.stringify(Object.entries(parsedTools).map(([name, definition]) => {
    return {
      'tool.name': name,
      'tool.description': definition.description,
      'tool.json_schema': definition.schema
    };
  }));
  span.attributes[_openinferenceSemanticConventions.OUTPUT_VALUE] = JSON.stringify(outputEvents.map(event => {
    var _event$attributes2;
    const {
      message,
      ...rest
    } = (0, _unflatten_attributes.unflattenAttributes)((_event$attributes2 = event.attributes) !== null && _event$attributes2 !== void 0 ? _event$attributes2 : {});
    return {
      ...(0, _lodash.omit)(rest, 'finish_reason', 'index'),
      ...message
    };
  })[0]);
  if (outputEvents.length) {
    var _outputEvents$0$attri, _outputUnflattened$me;
    const outputUnflattened = (0, _unflatten_attributes.unflattenAttributes)((_outputEvents$0$attri = outputEvents[0].attributes) !== null && _outputEvents$0$attri !== void 0 ? _outputEvents$0$attri : {});
    Object.assign(span.attributes, (0, _flatten_attributes.flattenAttributes)({
      [`${_openinferenceSemanticConventions.LLM_OUTPUT_MESSAGES}.0`]: {
        [_openinferenceSemanticConventions.MESSAGE_ROLE]: 'assistant',
        [_openinferenceSemanticConventions.MESSAGE_CONTENT]: outputUnflattened.message.content,
        [_openinferenceSemanticConventions.MESSAGE_TOOL_CALLS]: (_outputUnflattened$me = outputUnflattened.message.tool_calls) === null || _outputUnflattened$me === void 0 ? void 0 : _outputUnflattened$me.map(toolCall => {
          return {
            [_openinferenceSemanticConventions.TOOL_CALL_ID]: toolCall.id,
            [_openinferenceSemanticConventions.TOOL_CALL_FUNCTION_NAME]: toolCall.function.name,
            [_openinferenceSemanticConventions.TOOL_CALL_FUNCTION_ARGUMENTS_JSON]: toolCall.function.arguments
          };
        })
      }
    }));
  }
  const messageEvents = inputEvents.filter(event => event.name === _types.GenAISemanticConventions.GenAIAssistantMessage || event.name === _types.GenAISemanticConventions.GenAIUserMessage || event.name === _types.GenAISemanticConventions.GenAIToolMessage || event.name === _types.GenAISemanticConventions.GenAISystemMessage);
  const llmInputMessages = messageEvents.map(message => {
    var _message$attributes, _unflattened$tool_cal;
    const unflattened = (0, _unflatten_attributes.unflattenAttributes)((_message$attributes = message.attributes) !== null && _message$attributes !== void 0 ? _message$attributes : {});
    const role = unflattened.role;
    const content = unflattened.content;
    unflattened[_openinferenceSemanticConventions.SemanticConventions.MESSAGE_ROLE] = role;
    unflattened[_openinferenceSemanticConventions.SemanticConventions.MESSAGE_CONTENT] = content !== null && content !== void 0 ? content : '';
    unflattened[_openinferenceSemanticConventions.MESSAGE_TOOL_CALLS] = role === 'assistant' && 'tool_calls' in unflattened ? (_unflattened$tool_cal = unflattened.tool_calls) === null || _unflattened$tool_cal === void 0 ? void 0 : _unflattened$tool_cal.map(toolCall => {
      return {
        [_openinferenceSemanticConventions.SemanticConventions.TOOL_CALL_ID]: toolCall.id,
        [_openinferenceSemanticConventions.SemanticConventions.TOOL_CALL_FUNCTION_NAME]: toolCall.function.name,
        [_openinferenceSemanticConventions.SemanticConventions.TOOL_CALL_FUNCTION_ARGUMENTS_JSON]: toolCall.function.arguments
      };
    }) : [];
    if (unflattened.role === 'tool') {
      unflattened[_openinferenceSemanticConventions.MESSAGE_TOOL_CALL_ID] = unflattened.id;
    }
    return (0, _lodash.omit)(unflattened, 'role', 'content');
  });
  const flattenedInputMessages = (0, _flatten_attributes.flattenAttributes)(Object.fromEntries(llmInputMessages.map((message, index) => {
    return [`${_openinferenceSemanticConventions.LLM_INPUT_MESSAGES}.${index}`, message];
  })));
  Object.assign(span.attributes, flattenedInputMessages);
  return span;
}