"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.allSupportedConnectorTypes = exports.InferenceConnectorType = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * The list of connector types that can be used with the inference APIs
 */
let InferenceConnectorType = exports.InferenceConnectorType = /*#__PURE__*/function (InferenceConnectorType) {
  InferenceConnectorType["OpenAI"] = ".gen-ai";
  InferenceConnectorType["Bedrock"] = ".bedrock";
  InferenceConnectorType["Gemini"] = ".gemini";
  InferenceConnectorType["Inference"] = ".inference";
  return InferenceConnectorType;
}({});
const allSupportedConnectorTypes = exports.allSupportedConnectorTypes = Object.values(InferenceConnectorType);

/**
 * Represents a stack connector that can be used for inference.
 */

/**
 * Connector types are living in the actions plugin and we can't afford
 * having dependencies from this package to some mid-level plugin,
 * so we're just using our own connector mixin type.
 */