"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ComponentTemplates = void 0;
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _components = require("./components");
var _component_templates_list = require("./component_templates_list");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/components/component_templates/component_template_selector/component_templates.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const useStyles = ({
  isSearchResultEmpty
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const heightHeader = `calc(${euiTheme.size.l} * 2)`;
  return {
    container: (0, _react.css)`
      border: ${euiTheme.border.thin};
      border-radius: ${euiTheme.border.radius.medium};
      border-top: none;
      height: 100%;
    `,
    header: (0, _react.css)`
      height: ${heightHeader};

      .euiFormControlLayout {
        max-width: initial;
      }
    `,
    searchBox: (0, _react.css)`
      border-bottom: ${euiTheme.border.thin};
      border-top: ${euiTheme.border.thin};
      border-top-right-radius: 0;
      border-bottom-right-radius: 0;
      box-shadow: none;
      max-width: initial;
    `,
    filterListButton: (0, _react.css)`
      box-shadow: none;
      height: ${euiTheme.size.xxl}; /* Align the height with the search input height */

      &,
      & > :first-child .euiFilterButton {
        /* EUI specificity override */
        border-top-left-radius: 0;
        border-bottom-left-radius: 0;
      }

      &::after {
        border: ${euiTheme.border.thin};
      }
    `,
    listWrapper: (0, _react.css)`
      height: calc(100% - ${heightHeader});

      ${isSearchResultEmpty && (0, _react.css)`
        display: flex; /* Will center vertically the empty search result */
      `}
    `
  };
};

/**
 * Copied from https://stackoverflow.com/a/9310752
 */
function escapeRegExp(text) {
  return text.replace(/[-\[\]{}()*+?.,\\^$|#\s]/g, '\\$&');
}
function fuzzyMatch(searchValue, text) {
  const pattern = `.*${searchValue.split('').map(escapeRegExp).join('.*')}.*`;
  const regex = new RegExp(pattern);
  return regex.test(text);
}
const i18nTexts = {
  filters: {
    settings: _i18n.i18n.translate('xpack.idxMgmt.componentTemplatesSelector.filters.indexSettingsLabel', {
      defaultMessage: 'Index settings'
    }),
    mappings: _i18n.i18n.translate('xpack.idxMgmt.componentTemplatesSelector.filters.mappingsLabel', {
      defaultMessage: 'Mappings'
    }),
    aliases: _i18n.i18n.translate('xpack.idxMgmt.componentTemplatesSelector.filters.aliasesLabel', {
      defaultMessage: 'Aliases'
    })
  },
  searchBoxPlaceholder: _i18n.i18n.translate('xpack.idxMgmt.componentTemplatesSelector.searchBox.placeholder', {
    defaultMessage: 'Search component templates'
  })
};
const getInitialFilters = () => ({
  settings: {
    name: i18nTexts.filters.settings,
    checked: 'off'
  },
  mappings: {
    name: i18nTexts.filters.mappings,
    checked: 'off'
  },
  aliases: {
    name: i18nTexts.filters.aliases,
    checked: 'off'
  }
});
const ComponentTemplates = ({
  isLoading,
  components,
  listItemProps
}) => {
  const [searchValue, setSearchValue] = (0, _react2.useState)('');
  const [filters, setFilters] = (0, _react2.useState)(getInitialFilters);
  const filteredComponents = (0, _react2.useMemo)(() => {
    if (isLoading) {
      return [];
    }
    return components.filter(component => {
      if (filters.settings.checked === 'on' && !component.hasSettings) {
        return false;
      }
      if (filters.mappings.checked === 'on' && !component.hasMappings) {
        return false;
      }
      if (filters.aliases.checked === 'on' && !component.hasAliases) {
        return false;
      }
      if (searchValue.trim() === '') {
        return true;
      }
      const match = fuzzyMatch(searchValue, component.name);
      return match;
    }).sort((a, b) => {
      if (a.name < b.name) {
        return -1;
      } else if (a.name > b.name) {
        return 1;
      }
      return 0;
    });
  }, [isLoading, components, searchValue, filters]);
  const isSearchResultEmpty = filteredComponents.length === 0 && components.length > 0;
  const styles = useStyles({
    isSearchResultEmpty
  });
  if (isLoading) {
    return null;
  }
  const clearSearch = () => {
    setSearchValue('');
    setFilters(getInitialFilters());
  };
  const renderEmptyResult = () => {
    return /*#__PURE__*/_react2.default.createElement(_eui.EuiEmptyPrompt, {
      iconType: "search",
      title: /*#__PURE__*/_react2.default.createElement("h3", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 193,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.componentTemplatesSelector.searchResult.emptyPromptTitle",
        defaultMessage: "No components match your search",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 194,
          columnNumber: 13
        }
      })),
      actions: /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
        onClick: clearSearch,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 201,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.componentTemplatesSelector.searchResult.emptyPrompt.clearSearchButtonLabel",
        defaultMessage: "Clear search",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 202,
          columnNumber: 13
        }
      })),
      "data-test-subj": "emptySearchResult",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 190,
        columnNumber: 7
      }
    });
  };
  return /*#__PURE__*/_react2.default.createElement("div", {
    css: styles.container,
    "data-test-subj": "componentTemplates",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 214,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement("div", {
    css: styles.header,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 215,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 216,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFieldSearch, {
    placeholder: i18nTexts.searchBoxPlaceholder,
    value: searchValue,
    onChange: e => {
      setSearchValue(e.target.value);
    },
    "aria-label": i18nTexts.searchBoxPlaceholder,
    css: styles.searchBox,
    "data-test-subj": "componentTemplateSearchBox",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 229,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_components.FilterListButton, {
    filters: filters,
    onChange: setFilters,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 230,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react2.default.createElement("div", {
    css: [styles.listWrapper],
    className: "eui-yScrollWithShadows",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 234,
      columnNumber: 7
    }
  }, isSearchResultEmpty ? renderEmptyResult() : /*#__PURE__*/_react2.default.createElement(_component_templates_list.ComponentTemplatesList, {
    components: filteredComponents,
    listItemProps: listItemProps,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 238,
      columnNumber: 11
    }
  })));
};
exports.ComponentTemplates = ComponentTemplates;