"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.determineDataTierAllocationType = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const determineDataTierAllocationType = (actions = {}) => {
  const {
    allocate,
    migrate
  } = actions;
  if ((migrate === null || migrate === void 0 ? void 0 : migrate.enabled) === false) {
    return 'none';
  }
  if (!allocate) {
    return 'node_roles';
  }
  if (allocate.require && Object.keys(allocate.require).length || allocate.include && Object.keys(allocate.include).length || allocate.exclude && Object.keys(allocate.exclude).length) {
    return 'node_attrs';
  }
  return 'node_roles';
};
exports.determineDataTierAllocationType = determineDataTierAllocationType;