"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RemoteSyncedIntegrationsStatusSchema = exports.GetRemoteSyncedIntegrationsStatusResponseSchema = exports.CustomAssetsDataSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _types = require("../../../common/types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RemoteSyncedIntegrationsBaseSchema = _configSchema.schema.object({
  id: _configSchema.schema.maybe(_configSchema.schema.string()),
  package_name: _configSchema.schema.maybe(_configSchema.schema.string()),
  package_version: _configSchema.schema.maybe(_configSchema.schema.string())
});
const RemoteSyncedIntegrationsStatusSchema = exports.RemoteSyncedIntegrationsStatusSchema = RemoteSyncedIntegrationsBaseSchema.extends({
  sync_status: _configSchema.schema.oneOf([_configSchema.schema.literal(_types.SyncStatus.COMPLETED), _configSchema.schema.literal(_types.SyncStatus.SYNCHRONIZING), _configSchema.schema.literal(_types.SyncStatus.FAILED), _configSchema.schema.literal(_types.SyncStatus.WARNING)]),
  error: _configSchema.schema.maybe(_configSchema.schema.string()),
  warning: _configSchema.schema.maybe(_configSchema.schema.object({
    title: _configSchema.schema.string(),
    message: _configSchema.schema.maybe(_configSchema.schema.string())
  })),
  updated_at: _configSchema.schema.maybe(_configSchema.schema.string()),
  install_status: _configSchema.schema.object({
    main: _configSchema.schema.string(),
    remote: _configSchema.schema.maybe(_configSchema.schema.string())
  })
});
const CustomAssetsDataSchema = exports.CustomAssetsDataSchema = _configSchema.schema.object({
  type: _configSchema.schema.string(),
  name: _configSchema.schema.string(),
  package_name: _configSchema.schema.string(),
  package_version: _configSchema.schema.string(),
  sync_status: _configSchema.schema.oneOf([_configSchema.schema.literal(_types.SyncStatus.COMPLETED), _configSchema.schema.literal(_types.SyncStatus.SYNCHRONIZING), _configSchema.schema.literal(_types.SyncStatus.FAILED), _configSchema.schema.literal(_types.SyncStatus.WARNING)]),
  error: _configSchema.schema.maybe(_configSchema.schema.string()),
  is_deleted: _configSchema.schema.maybe(_configSchema.schema.boolean())
});
const GetRemoteSyncedIntegrationsStatusResponseSchema = exports.GetRemoteSyncedIntegrationsStatusResponseSchema = _configSchema.schema.object({
  integrations: _configSchema.schema.arrayOf(RemoteSyncedIntegrationsStatusSchema),
  custom_assets: _configSchema.schema.maybe(_configSchema.schema.recordOf(_configSchema.schema.string(), CustomAssetsDataSchema)),
  error: _configSchema.schema.maybe(_configSchema.schema.string()),
  warning: _configSchema.schema.maybe(_configSchema.schema.object({
    title: _configSchema.schema.string(),
    message: _configSchema.schema.maybe(_configSchema.schema.string())
  }))
});