"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentlessEnrollmentFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../constants");
var _hooks = require("../../hooks");
var _step_confirm_enrollment = require("./step_confirm_enrollment");
var _step_confirm_data = require("./step_confirm_data");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/components/agentless_enrollment_flyout/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const REFRESH_INTERVAL_MS = 30000;

/**
 * This component displays additional status details of an agentless agent enrolled
 * the chosen package policy (and its agent policy).
 * It also displays confirmation that the agentless agent is ingesting data from
 * the chosen package policy.
 */
const AgentlessEnrollmentFlyout = ({
  onClose,
  packagePolicy,
  agentPolicy
}) => {
  const core = (0, _hooks.useStartServices)();
  const {
    notifications
  } = core;
  const [confirmEnrollmentStatus, setConfirmEnrollmentStatus] = (0, _react.useState)('loading');
  const [confirmDataStatus, setConfirmDataStatus] = (0, _react.useState)('disabled');
  const [agentData, setAgentData] = (0, _react.useState)();

  // Clear agent data polling
  // Called when component is unmounted or when agent is healthy
  const agentDataInterval = (0, _react.useRef)();
  const clearAgentDataPolling = (0, _react.useMemo)(() => {
    return () => {
      if (agentDataInterval.current) {
        clearInterval(agentDataInterval.current);
      }
    };
  }, [agentDataInterval]);

  // Fetch agent(s) data for the first associated agent policy
  // Polls every 30 seconds until agent is found and healthy
  (0, _react.useEffect)(() => {
    const fetchAgents = async () => {
      var _agentsData$items;
      const {
        data: agentsData,
        error
      } = await (0, _hooks.sendGetAgents)({
        kuery: `${_constants.AGENTS_PREFIX}.policy_id: "${packagePolicy.policy_ids[0]}"`
      });
      if (error) {
        notifications.toasts.addError(error, {
          title: _i18n.i18n.translate('xpack.fleet.epm.packageDetails.integrationList.agentlessStatusError', {
            defaultMessage: 'Error fetching agentless status information'
          })
        });
      }
      if (agentsData !== null && agentsData !== void 0 && (_agentsData$items = agentsData.items) !== null && _agentsData$items !== void 0 && _agentsData$items[0]) {
        var _agentsData$items2;
        setAgentData((_agentsData$items2 = agentsData.items) === null || _agentsData$items2 === void 0 ? void 0 : _agentsData$items2[0]);
      }
    };
    fetchAgents();
    agentDataInterval.current = setInterval(() => {
      fetchAgents();
    }, REFRESH_INTERVAL_MS);
    return () => clearAgentDataPolling();
  }, [clearAgentDataPolling, notifications.toasts, packagePolicy.policy_ids]);

  // Watches agent data and updates step statuses and clears polling when agent is healthy
  (0, _react.useEffect)(() => {
    if (agentData) {
      if (agentData.status === 'online') {
        setConfirmEnrollmentStatus('complete');
        setConfirmDataStatus('loading');
        clearAgentDataPolling();
      } else if (agentData.status === 'error' || agentData.status === 'degraded') {
        setConfirmEnrollmentStatus('danger');
        setConfirmDataStatus('disabled');
      } else {
        setConfirmEnrollmentStatus('loading');
        setConfirmDataStatus('disabled');
      }
    } else {
      setConfirmEnrollmentStatus('loading');
      setConfirmDataStatus('disabled');
    }
  }, [agentData, clearAgentDataPolling]);

  // Calculate integration title from the base package info and what
  // is configured on the package policy.
  const {
    data: packageInfoData
  } = (0, _hooks.useGetPackageInfoByKeyQuery)(packagePolicy.package.name, packagePolicy.package.version, {
    prerelease: true
  });
  const integrationTitle = (0, _react.useMemo)(() => {
    if (packageInfoData !== null && packageInfoData !== void 0 && packageInfoData.item) {
      var _packagePolicy$inputs;
      const enabledInputs = (_packagePolicy$inputs = packagePolicy.inputs) === null || _packagePolicy$inputs === void 0 ? void 0 : _packagePolicy$inputs.filter(input => input.enabled);

      // If only one input is enabled, find the input name from the package info and
      // and use that for integration title. Otherwise, use the package name.
      if (enabledInputs.length === 1 && enabledInputs[0].policy_template) {
        var _packageInfoData$item, _policyTemplate$input;
        const policyTemplate = (_packageInfoData$item = packageInfoData.item.policy_templates) === null || _packageInfoData$item === void 0 ? void 0 : _packageInfoData$item.find(template => template.name === enabledInputs[0].policy_template);
        const input = policyTemplate && 'inputs' in policyTemplate ? (_policyTemplate$input = policyTemplate.inputs) === null || _policyTemplate$input === void 0 ? void 0 : _policyTemplate$input.find(i => i.type === enabledInputs[0].type) : null;
        return (input === null || input === void 0 ? void 0 : input.title) || packageInfoData.item.title;
      } else {
        return packageInfoData.item.title;
      }
    }
    return packagePolicy.name;
  }, [packageInfoData, packagePolicy]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    "data-test-subj": "agentlessEnrollmentFlyout",
    onClose: onClose,
    maxWidth: _constants.MAX_FLYOUT_WIDTH,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    "aria-labelledby": "FleetAgentlessEnrollmentFlyoutTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: "FleetAgentlessEnrollmentFlyoutTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 11
    }
  }, packagePolicy.name))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
    steps: [{
      title: _i18n.i18n.translate('xpack.fleet.agentlessEnrollmentFlyout.stepConfirmEnrollmentTitle', {
        defaultMessage: 'Confirm agentless enrollment'
      }),
      children: /*#__PURE__*/_react.default.createElement(_step_confirm_enrollment.AgentlessStepConfirmEnrollment, {
        agent: agentData,
        agentPolicy: agentPolicy,
        integrationTitle: integrationTitle,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 171,
          columnNumber: 17
        }
      }),
      status: confirmEnrollmentStatus
    }, {
      title: _i18n.i18n.translate('xpack.fleet.agentlessEnrollmentFlyout.stepConfirmDataTitle', {
        defaultMessage: 'Confirm incoming data'
      }),
      children: agentData && confirmEnrollmentStatus === 'complete' ? /*#__PURE__*/_react.default.createElement(_step_confirm_data.AgentlessStepConfirmData, {
        agent: agentData,
        packagePolicy: packagePolicy,
        policyTemplates: packageInfoData === null || packageInfoData === void 0 ? void 0 : packageInfoData.item.policy_templates,
        setConfirmDataStatus: setConfirmDataStatus,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 185,
          columnNumber: 19
        }
      }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null) // Avoids React error about null children prop
      ,
      status: confirmDataStatus
    }],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexStart",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onClose,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentlessEnrollmentFlyout.closeFlyoutButtonLabel",
    defaultMessage: "Close",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 15
    }
  }))))));
};
exports.AgentlessEnrollmentFlyout = AgentlessEnrollmentFlyout;