"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PackageListGrid = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _hooks = require("../../../../hooks");
var _utils = require("../utils");
var _controls = require("./controls");
var _grid = require("./grid");
var _missing_integrations = require("./missing_integrations");
var _search_box = require("./search_box");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/integrations/sections/epm/components/package_list_grid/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StickySidebar = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  position: sticky;
  top: calc(
    var(--kbn-application--sticky-headers-offset, 96px) +
      ${props => props.theme.eui.euiSizeL /* 24px */}
  );
`;
const PackageListGrid = ({
  isLoading,
  controls,
  emptyStateStyles,
  title,
  list,
  searchTerm,
  setSearchTerm,
  selectedCategory,
  setCategory,
  categories,
  availableSubCategories,
  setSelectedSubCategory,
  selectedSubCategory,
  setUrlandReplaceHistory,
  setUrlandPushHistory,
  showMissingIntegrationMessage = false,
  onlyAgentlessFilter = false,
  sortByFeaturedIntegrations = true,
  callout,
  calloutTopSpacerSize = 'l',
  // Default EUI spacer size
  showCardLabels = true,
  showControls = true,
  showSearchTools = true,
  spacer = true,
  scrollElementId
}) => {
  const euiTheme = (0, _eui.useEuiTheme)();
  const localSearch = (0, _hooks.useLocalSearch)(list, !!isLoading);
  const [isPopoverOpen, setPopover] = (0, _react.useState)(false);
  const MAX_SUBCATEGORIES_NUMBER = 6;
  const onButtonClick = () => {
    setPopover(!isPopoverOpen);
  };
  const closePopover = () => {
    setPopover(false);
  };
  const resetQuery = () => {
    setSearchTerm('');
    setUrlandReplaceHistory({
      searchString: '',
      categoryId: '',
      subCategoryId: '',
      onlyAgentless: onlyAgentlessFilter
    });
  };
  const onSubCategoryClick = (0, _react.useCallback)(subCategory => {
    if (setSelectedSubCategory) setSelectedSubCategory(subCategory);
    setUrlandPushHistory({
      categoryId: selectedCategory,
      subCategoryId: subCategory,
      onlyAgentless: onlyAgentlessFilter
    });
  }, [selectedCategory, setSelectedSubCategory, setUrlandPushHistory, onlyAgentlessFilter]);
  const filteredPromotedList = (0, _react.useMemo)(() => {
    var _map;
    if (isLoading) return [];
    const searchResults = (_map = (localSearch === null || localSearch === void 0 ? void 0 : localSearch.search(searchTerm)).map(match => match[_hooks.searchIdField])) !== null && _map !== void 0 ? _map : [];
    const filteredList = searchTerm ? list.filter(item => {
      var _searchResults$includ;
      return (_searchResults$includ = searchResults.includes(item[_hooks.searchIdField])) !== null && _searchResults$includ !== void 0 ? _searchResults$includ : [];
    }) : list;
    return sortByFeaturedIntegrations ? (0, _utils.promoteFeaturedIntegrations)(filteredList, selectedCategory) : filteredList;
  }, [isLoading, list, localSearch, searchTerm, selectedCategory, sortByFeaturedIntegrations]);
  const splitSubcategories = subcategories => {
    if (!subcategories) return {};else if (subcategories && (subcategories === null || subcategories === void 0 ? void 0 : subcategories.length) < MAX_SUBCATEGORIES_NUMBER) {
      return {
        visibleSubCategories: subcategories,
        hiddenSubCategories: []
      };
    } else if (subcategories && (subcategories === null || subcategories === void 0 ? void 0 : subcategories.length) >= MAX_SUBCATEGORIES_NUMBER) {
      return {
        visibleSubCategories: subcategories.slice(0, MAX_SUBCATEGORIES_NUMBER),
        hiddenSubCategories: subcategories.slice(MAX_SUBCATEGORIES_NUMBER)
      };
    }
    return {};
  };
  const splitSubcat = splitSubcategories(availableSubCategories);
  const {
    visibleSubCategories
  } = splitSubcat;
  const hiddenSubCategoriesItems = (0, _react.useMemo)(() => {
    var _splitSubcat$hiddenSu;
    return splitSubcat === null || splitSubcat === void 0 ? void 0 : (_splitSubcat$hiddenSu = splitSubcat.hiddenSubCategories) === null || _splitSubcat$hiddenSu === void 0 ? void 0 : _splitSubcat$hiddenSu.map(subCategory => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        key: subCategory.id,
        onClick: () => {
          onSubCategoryClick(subCategory.id);
          closePopover();
        },
        icon: selectedSubCategory === subCategory.id ? 'check' : 'empty',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 185,
          columnNumber: 9
        }
      }, subCategory.title);
    });
  }, [onSubCategoryClick, selectedSubCategory, splitSubcat === null || splitSubcat === void 0 ? void 0 : splitSubcat.hiddenSubCategories]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    alignItems: "flexStart",
    gutterSize: "xl",
    "data-test-subj": "epmList.integrationCards",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 5
    }
  }, showControls && /*#__PURE__*/_react.default.createElement(StickySidebar, {
    "data-test-subj": "epmList.controlsSideColumn",
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_controls.ControlsColumn, {
    controls: controls,
    title: title,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 5,
    "data-test-subj": "epmList.mainColumn",
    style: {
      position: 'relative',
      backgroundColor: euiTheme.euiTheme.colors.backgroundBasePlain,
      alignSelf: 'stretch'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 212,
      columnNumber: 7
    }
  }, showSearchTools && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 222,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_search_box.SearchBox, {
    searchTerm: searchTerm,
    setSearchTerm: setSearchTerm,
    selectedCategory: selectedCategory,
    setCategory: setCategory,
    categories: categories,
    availableSubCategories: availableSubCategories,
    setSelectedSubCategory: setSelectedSubCategory,
    selectedSubCategory: selectedSubCategory,
    setUrlandReplaceHistory: setUrlandReplaceHistory,
    onlyAgentlessFilter: onlyAgentlessFilter,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 223,
      columnNumber: 13
    }
  })), availableSubCategories !== null && availableSubCategories !== void 0 && availableSubCategories.length ? /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 238,
      columnNumber: 43
    }
  }) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 240,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "epmList.subcategoriesRow",
    justifyContent: "flexStart",
    direction: "row",
    gutterSize: "s",
    style: {
      maxWidth: '100%',
      flexWrap: 'wrap'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 241,
      columnNumber: 11
    }
  }, visibleSubCategories === null || visibleSubCategories === void 0 ? void 0 : visibleSubCategories.map(subCategory => {
    const isSelected = subCategory.id === selectedSubCategory;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      key: subCategory.id,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 254,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      css: isSelected ? 'color: white' : '',
      color: isSelected ? 'accent' : 'text',
      fill: isSelected,
      "aria-label": subCategory === null || subCategory === void 0 ? void 0 : subCategory.title,
      onClick: () => onSubCategoryClick(subCategory.id),
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 255,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.epmList.subcategoriesButton",
      defaultMessage: "{subcategory}",
      values: {
        subcategory: subCategory.title
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 263,
        columnNumber: 21
      }
    })));
  }), hiddenSubCategoriesItems !== null && hiddenSubCategoriesItems !== void 0 && hiddenSubCategoriesItems.length ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 275,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    "data-test-subj": "epmList.showMoreSubCategoriesButton",
    id: "moreSubCategories",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      display: "base",
      onClick: onButtonClick,
      iconType: "boxesHorizontal",
      "aria-label": "Show more subcategories",
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 280,
        columnNumber: 21
      }
    }),
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    anchorPosition: "downLeft",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 276,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    size: "s",
    items: hiddenSubCategoriesItems,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 293,
      columnNumber: 19
    }
  }))) : null)), callout ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: calloutTopSpacerSize,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 301,
      columnNumber: 13
    }
  }), callout) : null, spacer && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 305,
      columnNumber: 20
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 306,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_grid.GridColumn, {
    emptyStateStyles: emptyStateStyles,
    isLoading: !!isLoading,
    list: filteredPromotedList,
    showMissingIntegrationMessage: showMissingIntegrationMessage,
    showCardLabels: showCardLabels,
    scrollElementId: scrollElementId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 307,
      columnNumber: 11
    }
  })), showMissingIntegrationMessage && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 318,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_missing_integrations.MissingIntegrationContent, {
    setUrlandPushHistory: setUrlandPushHistory,
    resetQuery: resetQuery,
    setSelectedCategory: setCategory,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 319,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 324,
      columnNumber: 13
    }
  }))));
};
exports.PackageListGrid = PackageListGrid;