"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OutputFormKafkaPartitioning = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _constants = require("../../../../../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/settings/components/edit_output_flyout/output_form_kafka_partitioning.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const kafkaPartitioningOptions = [{
  id: _constants.kafkaPartitionType.Random,
  label: 'Random',
  'data-test-subj': 'kafkaPartitionRandomRadioButton'
}, {
  id: _constants.kafkaPartitionType.RoundRobin,
  label: 'Round robin',
  'data-test-subj': 'kafkaPartitionRoundRobinRadioButton'
}, {
  id: _constants.kafkaPartitionType.Hash,
  label: 'Hash',
  'data-test-subj': 'kafkaPartitionHashRadioButton'
}];
const OutputFormKafkaPartitioning = props => {
  const {
    inputs
  } = props;
  const renderPartitioning = () => {
    switch (inputs.kafkaPartitionTypeInput.value) {
      case _constants.kafkaPartitionType.Random:
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
          fullWidth: true,
          label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.fleet.settings.editOutputFlyout.kafkaPartitionTypeRandomInputLabel",
            defaultMessage: "Number of events",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 53,
              columnNumber: 15
            }
          })
        }, inputs.kafkaPartitionTypeRandomInput.formRowProps, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 50,
            columnNumber: 11
          }
        }), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({
          "data-test-subj": "settingsOutputsFlyout.kafkaPartitionTypeRandomInput",
          fullWidth: true
        }, inputs.kafkaPartitionTypeRandomInput.props, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 60,
            columnNumber: 13
          }
        })));
      case _constants.kafkaPartitionType.RoundRobin:
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
          fullWidth: true,
          label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.fleet.settings.editOutputFlyout.kafkaPartitionTypeRoundRobinInputLabel",
            defaultMessage: "Number of events",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 72,
              columnNumber: 15
            }
          })
        }, inputs.kafkaPartitionTypeRoundRobinInput.formRowProps, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 69,
            columnNumber: 11
          }
        }), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({
          "data-test-subj": "settingsOutputsFlyout.kafkaPartitionTypeRoundRobinInput",
          fullWidth: true
        }, inputs.kafkaPartitionTypeRoundRobinInput.props, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 79,
            columnNumber: 13
          }
        })));
      case _constants.kafkaPartitionType.Hash:
      default:
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
          fullWidth: true,
          label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.fleet.settings.editOutputFlyout.kafkaPartitionTypeHashInputLabel",
            defaultMessage: "List of fields",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 92,
              columnNumber: 15
            }
          }),
          helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.fleet.settings.editOutputFlyout.kafkaPartitionTypeHashHelpTextLabel",
            defaultMessage: "Comma separated.",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 98,
              columnNumber: 15
            }
          }),
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 89,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({
          "data-test-subj": "settingsOutputsFlyout.kafkaPartitionTypeHashInput",
          fullWidth: true
        }, inputs.kafkaPartitionTypeHashInput.props, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 105,
            columnNumber: 15
          }
        }))));
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    borderRadius: "m",
    hasShadow: false,
    paddingSize: 'm',
    color: 'subdued',
    "data-test-subj": "settingsOutputsFlyout.kafkaPartitionPanel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    id: "FleetEditOutputFlyoutKafkaPartitionTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.editOutputFlyout.kafkaPartitionTitle",
    defaultMessage: "Partitioning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editOutputFlyout.kafkaPartitioningInputLabel",
      defaultMessage: "Partitioning strategy",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 136,
        columnNumber: 11
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRadioGroup, (0, _extends2.default)({
    style: {
      flexDirection: 'row',
      flexWrap: 'wrap',
      columnGap: 30
    },
    "data-test-subj": 'settingsOutputsFlyout.kafkaPartitioningRadioInput',
    options: kafkaPartitioningOptions,
    compressed: true,
    name: "kafkaPartitioningStrategy"
  }, inputs.kafkaPartitionTypeInput.props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 9
    }
  }))), renderPartitioning());
};
exports.OutputFormKafkaPartitioning = OutputFormKafkaPartitioning;