"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilterValueLabel = FilterValueLabel;
exports.buildFilterLabel = buildFilterLabel;
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _esQuery = require("@kbn/es-query");
var _public = require("@kbn/unified-search-plugin/public");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/exploratory_view/public/components/shared/filter_value_label/filter_value_label.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function buildFilterLabel({
  field,
  value,
  label,
  dataView,
  negate
}) {
  const indexField = dataView.getFieldByName(field);
  const areMultipleValues = Array.isArray(value) && value.length > 1;
  const filter = areMultipleValues ? (0, _esQuery.buildPhrasesFilter)(indexField, value, dataView) : (0, _esQuery.buildPhraseFilter)(indexField, Array.isArray(value) ? value[0] : value, dataView);
  filter.meta.type = areMultipleValues ? 'phrases' : 'phrase';
  filter.meta.value = Array.isArray(value) ? !areMultipleValues ? `${value[0]}` : undefined : value;
  filter.meta.key = label;
  filter.meta.alias = null;
  filter.meta.negate = negate;
  filter.meta.disabled = false;
  return filter;
}
function FilterValueLabel({
  label,
  field,
  value,
  negate,
  dataView,
  invertFilter,
  removeFilter,
  allowExclusion = true
}) {
  const FilterItemI18n = (0, _i18nReact.injectI18n)(_public.FilterItem);
  const filter = buildFilterLabel({
    field,
    value,
    label,
    dataView,
    negate
  });
  const {
    services: {
      uiSettings,
      docLinks,
      dataViews
    }
  } = (0, _public2.useKibana)();
  return dataView ? /*#__PURE__*/_react.default.createElement(FilterItemI18n, {
    indexPatterns: [dataView],
    id: `${field}-${value}-${negate}`,
    filter: filter,
    onRemove: () => {
      removeFilter(field, value, false);
    },
    onUpdate: filterN => {
      if (filterN.meta.negate !== negate) {
        invertFilter({
          field,
          value,
          negate
        });
      }
    },
    uiSettings: uiSettings,
    docLinks: docLinks,
    hiddenPanelOptions: [...(allowExclusion ? [] : ['negateFilter']), 'pinFilter', 'editFilter', 'disableFilter'],
    dataViews: dataViews,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 5
    }
  }) : null;
}

// eslint-disable-next-line import/no-default-export
var _default = exports.default = FilterValueLabel;