"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.header = exports.hdr = void 0;
var _parser = require("../parser");
var _tag = require("./tag");
var _synth_node = require("./synth_node");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const generator = (src, {
  withFormatting = true,
  ...rest
} = {}) => {
  src = src.trimStart();
  const {
    root
  } = _parser.Parser.parseHeaderCommand(src, {
    withFormatting,
    ...rest
  });

  // The parser returns the header command as ESQLCommand type, but it's actually
  // an ESQLAstSetHeaderCommand at runtime
  const node = _synth_node.SynthNode.from(root);
  return node;
};
const header = exports.header = (0, _tag.createTag)(generator);

/**
 * Short 3-letter alias for DX convenience.
 */
const hdr = exports.hdr = header;