"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.scalarFunctionDefinitions=void 0;var _i18n=require("@kbn/i18n");var _types=require("../../commands_registry/types");var _types2=require("../types");/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 *//**
 * __AUTOGENERATED FILE. DO NOT EDIT THIS FILE DIRECTLY.__
 *
 * @note This file is generated by the `generate_function_definitions.ts`
 * script. Do not edit it manually.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const absDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'abs',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.abs',{defaultMessage:'Returns the absolute value.'}),preview:false,alias:undefined,signatures:[{params:[{name:'number',type:'double',optional:false}],returnType:'double'},{params:[{name:'number',type:'integer',optional:false}],returnType:'integer'},{params:[{name:'number',type:'long',optional:false}],returnType:'long'},{params:[{name:'number',type:'unsigned_long',optional:false}],returnType:'unsigned_long'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW number = -1.0\n| EVAL abs_number = ABS(number)','FROM employees\n| KEEP first_name, last_name, height\n| EVAL abs_height = ABS(0.0 - height)']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const acosDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'acos',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.acos',{defaultMessage:'Returns the arccosine of `n` as an angle, expressed in radians.'}),preview:false,alias:undefined,signatures:[{params:[{name:'number',type:'double',optional:false}],returnType:'double'},{params:[{name:'number',type:'integer',optional:false}],returnType:'double'},{params:[{name:'number',type:'long',optional:false}],returnType:'double'},{params:[{name:'number',type:'unsigned_long',optional:false}],returnType:'double'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW a=.9\n| EVAL acos=ACOS(a)']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const asinDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'asin',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.asin',{defaultMessage:'Returns the arcsine of the input\nnumeric expression as an angle, expressed in radians.'}),preview:false,alias:undefined,signatures:[{params:[{name:'number',type:'double',optional:false}],returnType:'double'},{params:[{name:'number',type:'integer',optional:false}],returnType:'double'},{params:[{name:'number',type:'long',optional:false}],returnType:'double'},{params:[{name:'number',type:'unsigned_long',optional:false}],returnType:'double'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW a=.9\n| EVAL asin=ASIN(a)']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const atanDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'atan',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.atan',{defaultMessage:'Returns the arctangent of the input\nnumeric expression as an angle, expressed in radians.'}),preview:false,alias:undefined,signatures:[{params:[{name:'number',type:'double',optional:false}],returnType:'double'},{params:[{name:'number',type:'integer',optional:false}],returnType:'double'},{params:[{name:'number',type:'long',optional:false}],returnType:'double'},{params:[{name:'number',type:'unsigned_long',optional:false}],returnType:'double'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW a=12.9\n| EVAL atan=ATAN(a)']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const atan2Definition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'atan2',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.atan2',{defaultMessage:'The angle between the positive x-axis and the ray from the\norigin to the point (x , y) in the Cartesian plane, expressed in radians.'}),preview:false,alias:undefined,signatures:[{params:[{name:'y_coordinate',type:'double',optional:false},{name:'x_coordinate',type:'double',optional:false}],returnType:'double'},{params:[{name:'y_coordinate',type:'double',optional:false},{name:'x_coordinate',type:'integer',optional:false}],returnType:'double'},{params:[{name:'y_coordinate',type:'double',optional:false},{name:'x_coordinate',type:'long',optional:false}],returnType:'double'},{params:[{name:'y_coordinate',type:'double',optional:false},{name:'x_coordinate',type:'unsigned_long',optional:false}],returnType:'double'},{params:[{name:'y_coordinate',type:'integer',optional:false},{name:'x_coordinate',type:'double',optional:false}],returnType:'double'},{params:[{name:'y_coordinate',type:'integer',optional:false},{name:'x_coordinate',type:'integer',optional:false}],returnType:'double'},{params:[{name:'y_coordinate',type:'integer',optional:false},{name:'x_coordinate',type:'long',optional:false}],returnType:'double'},{params:[{name:'y_coordinate',type:'integer',optional:false},{name:'x_coordinate',type:'unsigned_long',optional:false}],returnType:'double'},{params:[{name:'y_coordinate',type:'long',optional:false},{name:'x_coordinate',type:'double',optional:false}],returnType:'double'},{params:[{name:'y_coordinate',type:'long',optional:false},{name:'x_coordinate',type:'integer',optional:false}],returnType:'double'},{params:[{name:'y_coordinate',type:'long',optional:false},{name:'x_coordinate',type:'long',optional:false}],returnType:'double'},{params:[{name:'y_coordinate',type:'long',optional:false},{name:'x_coordinate',type:'unsigned_long',optional:false}],returnType:'double'},{params:[{name:'y_coordinate',type:'unsigned_long',optional:false},{name:'x_coordinate',type:'double',optional:false}],returnType:'double'},{params:[{name:'y_coordinate',type:'unsigned_long',optional:false},{name:'x_coordinate',type:'integer',optional:false}],returnType:'double'},{params:[{name:'y_coordinate',type:'unsigned_long',optional:false},{name:'x_coordinate',type:'long',optional:false}],returnType:'double'},{params:[{name:'y_coordinate',type:'unsigned_long',optional:false},{name:'x_coordinate',type:'unsigned_long',optional:false}],returnType:'double'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW y=12.9, x=.6\n| EVAL atan2=ATAN2(y, x)']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const bitLengthDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'bit_length',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.bit_length',{defaultMessage:'Returns the bit length of a string.'}),preview:false,alias:undefined,signatures:[{params:[{name:'string',type:'keyword',optional:false}],returnType:'integer'},{params:[{name:'string',type:'text',optional:false}],returnType:'integer'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['FROM airports\n| WHERE country == "India"\n| KEEP city\n| EVAL fn_length = LENGTH(city), fn_bit_length = BIT_LENGTH(city)']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const byteLengthDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'byte_length',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.byte_length',{defaultMessage:'Returns the byte length of a string.'}),preview:false,alias:undefined,signatures:[{params:[{name:'string',type:'keyword',optional:false}],returnType:'integer'},{params:[{name:'string',type:'text',optional:false}],returnType:'integer'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['FROM airports\n| WHERE country == "India"\n| KEEP city\n| EVAL fn_length = LENGTH(city), fn_byte_length = BYTE_LENGTH(city)']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const cbrtDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'cbrt',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.cbrt',{defaultMessage:'Returns the cube root of a number. The input can be any numeric value, the return value is always a double.\nCube roots of infinities are null.'}),preview:false,alias:undefined,signatures:[{params:[{name:'number',type:'double',optional:false}],returnType:'double'},{params:[{name:'number',type:'integer',optional:false}],returnType:'double'},{params:[{name:'number',type:'long',optional:false}],returnType:'double'},{params:[{name:'number',type:'unsigned_long',optional:false}],returnType:'double'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW d = 1000.0\n| EVAL c = CBRT(d)']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const ceilDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'ceil',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.ceil',{defaultMessage:'Round a number up to the nearest integer.'}),preview:false,alias:undefined,signatures:[{params:[{name:'number',type:'double',optional:false}],returnType:'double'},{params:[{name:'number',type:'integer',optional:false}],returnType:'integer'},{params:[{name:'number',type:'long',optional:false}],returnType:'long'},{params:[{name:'number',type:'unsigned_long',optional:false}],returnType:'unsigned_long'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW a=1.8\n| EVAL a=CEIL(a)']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const cidrMatchDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'cidr_match',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.cidr_match',{defaultMessage:'Returns true if the provided IP is contained in one of the provided CIDR blocks.'}),preview:false,alias:undefined,signatures:[{params:[{name:'ip',type:'ip',optional:false},{name:'blockX',type:'keyword',optional:false}],returnType:'boolean',minParams:2},{params:[{name:'ip',type:'ip',optional:false},{name:'blockX',type:'text',optional:false}],returnType:'boolean',minParams:2}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['FROM hosts\n| WHERE CIDR_MATCH(ip1, "127.0.0.2/32", "127.0.0.3/32")\n| KEEP card, host, ip0, ip1']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const clampDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'clamp',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.clamp',{defaultMessage:'Clamps the values of all samples to have a lower limit of min and an upper limit of max.'}),preview:false,alias:undefined,signatures:[{params:[{name:'field',type:'boolean',optional:false},{name:'min',type:'boolean',optional:false},{name:'max',type:'boolean',optional:false}],returnType:'boolean'},{params:[{name:'field',type:'date',optional:false},{name:'min',type:'date',optional:false},{name:'max',type:'date',optional:false}],returnType:'date'},{params:[{name:'field',type:'double',optional:false},{name:'min',type:'double',optional:false},{name:'max',type:'double',optional:false}],returnType:'double'},{params:[{name:'field',type:'integer',optional:false},{name:'min',type:'integer',optional:false},{name:'max',type:'integer',optional:false}],returnType:'integer'},{params:[{name:'field',type:'ip',optional:false},{name:'min',type:'ip',optional:false},{name:'max',type:'ip',optional:false}],returnType:'ip'},{params:[{name:'field',type:'keyword',optional:false},{name:'min',type:'keyword',optional:false},{name:'max',type:'keyword',optional:false}],returnType:'keyword'},{params:[{name:'field',type:'long',optional:false},{name:'min',type:'long',optional:false},{name:'max',type:'long',optional:false}],returnType:'long'},{params:[{name:'field',type:'unsigned_long',optional:false},{name:'min',type:'unsigned_long',optional:false},{name:'max',type:'unsigned_long',optional:false}],returnType:'unsigned_long'},{params:[{name:'field',type:'version',optional:false},{name:'min',type:'version',optional:false},{name:'max',type:'version',optional:false}],returnType:'version'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['TS k8s\n| STATS bytes_in = sum(network.bytes_in),\n        // our network cards are rate-limited to 200bps so we clamp to that (just an example)\n        clamped_network_bytes_in = sum(clamp(network.bytes_in, 0, 200))\n        BY time_bucket = bucket(@timestamp,1minute)']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const clampMaxDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'clamp_max',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.clamp_max',{defaultMessage:'Returns clamps the values of all input samples clamped to have an upper limit of max.'}),preview:false,alias:undefined,signatures:[{params:[{name:'field',type:'boolean',optional:false},{name:'max',type:'boolean',optional:false}],returnType:'boolean'},{params:[{name:'field',type:'date',optional:false},{name:'max',type:'date',optional:false}],returnType:'date'},{params:[{name:'field',type:'double',optional:false},{name:'max',type:'double',optional:false}],returnType:'double'},{params:[{name:'field',type:'integer',optional:false},{name:'max',type:'integer',optional:false}],returnType:'integer'},{params:[{name:'field',type:'ip',optional:false},{name:'max',type:'ip',optional:false}],returnType:'ip'},{params:[{name:'field',type:'keyword',optional:false},{name:'max',type:'keyword',optional:false}],returnType:'keyword'},{params:[{name:'field',type:'long',optional:false},{name:'max',type:'long',optional:false}],returnType:'long'},{params:[{name:'field',type:'unsigned_long',optional:false},{name:'max',type:'unsigned_long',optional:false}],returnType:'unsigned_long'},{params:[{name:'field',type:'version',optional:false},{name:'max',type:'version',optional:false}],returnType:'version'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['TS k8s\n| EVAL full_clamped_cost = clamp(network.cost, 1, 20)\n| KEEP full_clamped_cost, @timestamp']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const clampMinDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'clamp_min',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.clamp_min',{defaultMessage:'Returns clamps the values of all input samples clamped to have a lower limit of min.'}),preview:false,alias:undefined,signatures:[{params:[{name:'field',type:'boolean',optional:false},{name:'min',type:'boolean',optional:false}],returnType:'boolean'},{params:[{name:'field',type:'date',optional:false},{name:'min',type:'date',optional:false}],returnType:'date'},{params:[{name:'field',type:'double',optional:false},{name:'min',type:'double',optional:false}],returnType:'double'},{params:[{name:'field',type:'integer',optional:false},{name:'min',type:'integer',optional:false}],returnType:'integer'},{params:[{name:'field',type:'ip',optional:false},{name:'min',type:'ip',optional:false}],returnType:'ip'},{params:[{name:'field',type:'keyword',optional:false},{name:'min',type:'keyword',optional:false}],returnType:'keyword'},{params:[{name:'field',type:'long',optional:false},{name:'min',type:'long',optional:false}],returnType:'long'},{params:[{name:'field',type:'unsigned_long',optional:false},{name:'min',type:'unsigned_long',optional:false}],returnType:'unsigned_long'},{params:[{name:'field',type:'version',optional:false},{name:'min',type:'version',optional:false}],returnType:'version'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['FROM k8s\n| STATS full_clamped_cost=sum(clamp(network.cost, 1, 2)), clamped_cost=sum(clamp_max(network.cost, 1)), clamped_min_cost=sum(clamp_min(network.cost, 10)) BY time_bucket = bucket(@timestamp,1minute)']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const coalesceDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'coalesce',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.coalesce',{defaultMessage:'Returns the first of its arguments that is not null. If all arguments are null, it returns `null`.'}),preview:false,alias:undefined,signatures:[{params:[{name:'first',type:'boolean',optional:false}],returnType:'boolean',minParams:1},{params:[{name:'first',type:'boolean',optional:false},{name:'rest',type:'boolean',optional:true}],returnType:'boolean',minParams:1},{params:[{name:'first',type:'cartesian_point',optional:false},{name:'rest',type:'cartesian_point',optional:true}],returnType:'cartesian_point',minParams:1},{params:[{name:'first',type:'cartesian_shape',optional:false},{name:'rest',type:'cartesian_shape',optional:true}],returnType:'cartesian_shape',minParams:1},{params:[{name:'first',type:'date',optional:false},{name:'rest',type:'date',optional:true}],returnType:'date',minParams:1},{params:[{name:'first',type:'date_nanos',optional:false},{name:'rest',type:'date_nanos',optional:true}],returnType:'date_nanos',minParams:1},{params:[{name:'first',type:'geo_point',optional:false},{name:'rest',type:'geo_point',optional:true}],returnType:'geo_point',minParams:1},{params:[{name:'first',type:'geo_shape',optional:false},{name:'rest',type:'geo_shape',optional:true}],returnType:'geo_shape',minParams:1},{params:[{name:'first',type:'geohash',optional:false},{name:'rest',type:'geohash',optional:true}],returnType:'geohash',minParams:1},{params:[{name:'first',type:'geohex',optional:false},{name:'rest',type:'geohex',optional:true}],returnType:'geohex',minParams:1},{params:[{name:'first',type:'geotile',optional:false},{name:'rest',type:'geotile',optional:true}],returnType:'geotile',minParams:1},{params:[{name:'first',type:'integer',optional:false}],returnType:'integer',minParams:1},{params:[{name:'first',type:'integer',optional:false},{name:'rest',type:'integer',optional:true}],returnType:'integer',minParams:1},{params:[{name:'first',type:'ip',optional:false},{name:'rest',type:'ip',optional:true}],returnType:'ip',minParams:1},{params:[{name:'first',type:'keyword',optional:false}],returnType:'keyword',minParams:1},{params:[{name:'first',type:'keyword',optional:false},{name:'rest',type:'keyword',optional:true}],returnType:'keyword',minParams:1},{params:[{name:'first',type:'long',optional:false}],returnType:'long',minParams:1},{params:[{name:'first',type:'long',optional:false},{name:'rest',type:'long',optional:true}],returnType:'long',minParams:1},{params:[{name:'first',type:'text',optional:false}],returnType:'keyword',minParams:1},{params:[{name:'first',type:'text',optional:false},{name:'rest',type:'text',optional:true}],returnType:'keyword',minParams:1},{params:[{name:'first',type:'version',optional:false},{name:'rest',type:'version',optional:true}],returnType:'version',minParams:1}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW a=null, b="b"\n| EVAL COALESCE(a, b)']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const concatDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'concat',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.concat',{defaultMessage:'Concatenates two or more strings.'}),preview:false,alias:undefined,signatures:[{params:[{name:'string1',type:'keyword',optional:false},{name:'string2',type:'keyword',optional:false}],returnType:'keyword',minParams:2},{params:[{name:'string1',type:'keyword',optional:false},{name:'string2',type:'text',optional:false}],returnType:'keyword',minParams:2},{params:[{name:'string1',type:'text',optional:false},{name:'string2',type:'keyword',optional:false}],returnType:'keyword',minParams:2},{params:[{name:'string1',type:'text',optional:false},{name:'string2',type:'text',optional:false}],returnType:'keyword',minParams:2}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['FROM employees\n| KEEP first_name, last_name\n| EVAL fullname = CONCAT(first_name, " ", last_name)']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const containsDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'contains',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.contains',{defaultMessage:'Returns a boolean that indicates whether a keyword substring is within another string.\nReturns `null` if either parameter is null.'}),preview:false,alias:undefined,signatures:[{params:[{name:'string',type:'keyword',optional:false},{name:'substring',type:'keyword',optional:false}],returnType:'boolean'},{params:[{name:'string',type:'keyword',optional:false},{name:'substring',type:'text',optional:false}],returnType:'boolean'},{params:[{name:'string',type:'text',optional:false},{name:'substring',type:'keyword',optional:false}],returnType:'boolean'},{params:[{name:'string',type:'text',optional:false},{name:'substring',type:'text',optional:false}],returnType:'boolean'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW a = "hello"\n| EVAL has_ll = CONTAINS(a, "ll")']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const copySignDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'copy_sign',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.copy_sign',{defaultMessage:"Returns a value with the magnitude of the first argument and the sign of the second argument.\nThis function is similar to Java's Math.copySign(double magnitude, double sign) which is\nsimilar to `copysign` from IEEE 754."}),preview:false,alias:undefined,signatures:[{params:[{name:'magnitude',type:'double',optional:false},{name:'sign',type:'double',optional:false}],returnType:'double'},{params:[{name:'magnitude',type:'double',optional:false},{name:'sign',type:'integer',optional:false}],returnType:'double'},{params:[{name:'magnitude',type:'double',optional:false},{name:'sign',type:'long',optional:false}],returnType:'double'},{params:[{name:'magnitude',type:'integer',optional:false},{name:'sign',type:'double',optional:false}],returnType:'integer'},{params:[{name:'magnitude',type:'integer',optional:false},{name:'sign',type:'integer',optional:false}],returnType:'integer'},{params:[{name:'magnitude',type:'integer',optional:false},{name:'sign',type:'long',optional:false}],returnType:'integer'},{params:[{name:'magnitude',type:'long',optional:false},{name:'sign',type:'double',optional:false}],returnType:'long'},{params:[{name:'magnitude',type:'long',optional:false},{name:'sign',type:'integer',optional:false}],returnType:'long'},{params:[{name:'magnitude',type:'long',optional:false},{name:'sign',type:'long',optional:false}],returnType:'long'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['FROM employees\n| EVAL cs1 = COPY_SIGN(salary, LEAST(salary_change))']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const cosDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'cos',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.cos',{defaultMessage:'Returns the cosine of an angle.'}),preview:false,alias:undefined,signatures:[{params:[{name:'angle',type:'double',optional:false}],returnType:'double'},{params:[{name:'angle',type:'integer',optional:false}],returnType:'double'},{params:[{name:'angle',type:'long',optional:false}],returnType:'double'},{params:[{name:'angle',type:'unsigned_long',optional:false}],returnType:'double'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW a=1.8\n| EVAL cos=COS(a)']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const coshDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'cosh',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.cosh',{defaultMessage:'Returns the hyperbolic cosine of a number.'}),preview:false,alias:undefined,signatures:[{params:[{name:'number',type:'double',optional:false}],returnType:'double'},{params:[{name:'number',type:'integer',optional:false}],returnType:'double'},{params:[{name:'number',type:'long',optional:false}],returnType:'double'},{params:[{name:'number',type:'unsigned_long',optional:false}],returnType:'double'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW a=1.8\n| EVAL cosh=COSH(a)']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const dateDiffDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'date_diff',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.date_diff',{defaultMessage:'Subtracts the `startTimestamp` from the `endTimestamp` and returns the difference in multiples of `unit`.\nIf `startTimestamp` is later than the `endTimestamp`, negative values are returned.'}),preview:false,alias:undefined,signatures:[{params:[{name:'unit',type:'keyword',optional:false,suggestedValues:['year','quarter','month','week','day','hour','minute','second','millisecond','microsecond','nanosecond']},{name:'startTimestamp',type:'date',optional:false},{name:'endTimestamp',type:'date',optional:false}],returnType:'integer'},{params:[{name:'unit',type:'keyword',optional:false,suggestedValues:['year','quarter','month','week','day','hour','minute','second','millisecond','microsecond','nanosecond']},{name:'startTimestamp',type:'date',optional:false},{name:'endTimestamp',type:'date_nanos',optional:false}],returnType:'integer'},{params:[{name:'unit',type:'keyword',optional:false,suggestedValues:['year','quarter','month','week','day','hour','minute','second','millisecond','microsecond','nanosecond']},{name:'startTimestamp',type:'date_nanos',optional:false},{name:'endTimestamp',type:'date',optional:false}],returnType:'integer'},{params:[{name:'unit',type:'keyword',optional:false,suggestedValues:['year','quarter','month','week','day','hour','minute','second','millisecond','microsecond','nanosecond']},{name:'startTimestamp',type:'date_nanos',optional:false},{name:'endTimestamp',type:'date_nanos',optional:false}],returnType:'integer'},{params:[{name:'unit',type:'text',optional:false,suggestedValues:['year','quarter','month','week','day','hour','minute','second','millisecond','microsecond','nanosecond']},{name:'startTimestamp',type:'date',optional:false},{name:'endTimestamp',type:'date',optional:false}],returnType:'integer'},{params:[{name:'unit',type:'text',optional:false,suggestedValues:['year','quarter','month','week','day','hour','minute','second','millisecond','microsecond','nanosecond']},{name:'startTimestamp',type:'date',optional:false},{name:'endTimestamp',type:'date_nanos',optional:false}],returnType:'integer'},{params:[{name:'unit',type:'text',optional:false,suggestedValues:['year','quarter','month','week','day','hour','minute','second','millisecond','microsecond','nanosecond']},{name:'startTimestamp',type:'date_nanos',optional:false},{name:'endTimestamp',type:'date',optional:false}],returnType:'integer'},{params:[{name:'unit',type:'text',optional:false,suggestedValues:['year','quarter','month','week','day','hour','minute','second','millisecond','microsecond','nanosecond']},{name:'startTimestamp',type:'date_nanos',optional:false},{name:'endTimestamp',type:'date_nanos',optional:false}],returnType:'integer'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW date1 = TO_DATETIME("2023-12-02T11:00:00.000Z"),\n    date2 = TO_DATETIME("2023-12-02T11:00:00.001Z")\n| EVAL dd_ms = DATE_DIFF("microseconds", date1, date2)','ROW end_23 = TO_DATETIME("2023-12-31T23:59:59.999Z"),\n  start_24 = TO_DATETIME("2024-01-01T00:00:00.000Z"),\n    end_24 = TO_DATETIME("2024-12-31T23:59:59.999")\n| EVAL end23_to_start24 = DATE_DIFF("year", end_23, start_24)\n| EVAL end23_to_end24   = DATE_DIFF("year", end_23, end_24)\n| EVAL start_to_end_24  = DATE_DIFF("year", start_24, end_24)']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const dateExtractDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'date_extract',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.date_extract',{defaultMessage:'Extracts parts of a date, like year, month, day, hour.'}),preview:false,alias:undefined,signatures:[{params:[{name:'datePart',type:'keyword',optional:false,suggestedValues:['ALIGNED_DAY_OF_WEEK_IN_MONTH','ALIGNED_DAY_OF_WEEK_IN_YEAR','ALIGNED_WEEK_OF_MONTH','ALIGNED_WEEK_OF_YEAR','AMPM_OF_DAY','CLOCK_HOUR_OF_AMPM','CLOCK_HOUR_OF_DAY','DAY_OF_MONTH','DAY_OF_WEEK','DAY_OF_YEAR','EPOCH_DAY','ERA','HOUR_OF_AMPM','HOUR_OF_DAY','INSTANT_SECONDS','MICRO_OF_DAY','MICRO_OF_SECOND','MILLI_OF_DAY','MILLI_OF_SECOND','MINUTE_OF_DAY','MINUTE_OF_HOUR','MONTH_OF_YEAR','NANO_OF_DAY','NANO_OF_SECOND','OFFSET_SECONDS','PROLEPTIC_MONTH','SECOND_OF_DAY','SECOND_OF_MINUTE','YEAR','YEAR_OF_ERA']},{name:'date',type:'date',optional:false}],returnType:'long'},{params:[{name:'datePart',type:'keyword',optional:false,suggestedValues:['ALIGNED_DAY_OF_WEEK_IN_MONTH','ALIGNED_DAY_OF_WEEK_IN_YEAR','ALIGNED_WEEK_OF_MONTH','ALIGNED_WEEK_OF_YEAR','AMPM_OF_DAY','CLOCK_HOUR_OF_AMPM','CLOCK_HOUR_OF_DAY','DAY_OF_MONTH','DAY_OF_WEEK','DAY_OF_YEAR','EPOCH_DAY','ERA','HOUR_OF_AMPM','HOUR_OF_DAY','INSTANT_SECONDS','MICRO_OF_DAY','MICRO_OF_SECOND','MILLI_OF_DAY','MILLI_OF_SECOND','MINUTE_OF_DAY','MINUTE_OF_HOUR','MONTH_OF_YEAR','NANO_OF_DAY','NANO_OF_SECOND','OFFSET_SECONDS','PROLEPTIC_MONTH','SECOND_OF_DAY','SECOND_OF_MINUTE','YEAR','YEAR_OF_ERA']},{name:'date',type:'date_nanos',optional:false}],returnType:'long'},{params:[{name:'datePart',type:'text',optional:false,suggestedValues:['ALIGNED_DAY_OF_WEEK_IN_MONTH','ALIGNED_DAY_OF_WEEK_IN_YEAR','ALIGNED_WEEK_OF_MONTH','ALIGNED_WEEK_OF_YEAR','AMPM_OF_DAY','CLOCK_HOUR_OF_AMPM','CLOCK_HOUR_OF_DAY','DAY_OF_MONTH','DAY_OF_WEEK','DAY_OF_YEAR','EPOCH_DAY','ERA','HOUR_OF_AMPM','HOUR_OF_DAY','INSTANT_SECONDS','MICRO_OF_DAY','MICRO_OF_SECOND','MILLI_OF_DAY','MILLI_OF_SECOND','MINUTE_OF_DAY','MINUTE_OF_HOUR','MONTH_OF_YEAR','NANO_OF_DAY','NANO_OF_SECOND','OFFSET_SECONDS','PROLEPTIC_MONTH','SECOND_OF_DAY','SECOND_OF_MINUTE','YEAR','YEAR_OF_ERA']},{name:'date',type:'date',optional:false}],returnType:'long'},{params:[{name:'datePart',type:'text',optional:false,suggestedValues:['ALIGNED_DAY_OF_WEEK_IN_MONTH','ALIGNED_DAY_OF_WEEK_IN_YEAR','ALIGNED_WEEK_OF_MONTH','ALIGNED_WEEK_OF_YEAR','AMPM_OF_DAY','CLOCK_HOUR_OF_AMPM','CLOCK_HOUR_OF_DAY','DAY_OF_MONTH','DAY_OF_WEEK','DAY_OF_YEAR','EPOCH_DAY','ERA','HOUR_OF_AMPM','HOUR_OF_DAY','INSTANT_SECONDS','MICRO_OF_DAY','MICRO_OF_SECOND','MILLI_OF_DAY','MILLI_OF_SECOND','MINUTE_OF_DAY','MINUTE_OF_HOUR','MONTH_OF_YEAR','NANO_OF_DAY','NANO_OF_SECOND','OFFSET_SECONDS','PROLEPTIC_MONTH','SECOND_OF_DAY','SECOND_OF_MINUTE','YEAR','YEAR_OF_ERA']},{name:'date',type:'date_nanos',optional:false}],returnType:'long'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW date = DATE_PARSE("yyyy-MM-dd", "2022-05-06")\n| EVAL year = DATE_EXTRACT("year", date)','FROM sample_data\n| WHERE DATE_EXTRACT("hour_of_day", @timestamp) < 9\n    AND DATE_EXTRACT("hour_of_day", @timestamp) >= 17']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const dateFormatDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'date_format',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.date_format',{defaultMessage:'Returns a string representation of a date, in the provided format.'}),preview:false,alias:undefined,signatures:[{params:[{name:'dateFormat',type:'date',optional:true}],returnType:'keyword'},{params:[{name:'dateFormat',type:'date_nanos',optional:true}],returnType:'keyword'},{params:[{name:'dateFormat',type:'keyword',optional:true},{name:'date',type:'date',optional:false}],returnType:'keyword'},{params:[{name:'dateFormat',type:'keyword',optional:true},{name:'date',type:'date_nanos',optional:false}],returnType:'keyword'},{params:[{name:'dateFormat',type:'text',optional:true},{name:'date',type:'date',optional:false}],returnType:'keyword'},{params:[{name:'dateFormat',type:'text',optional:true},{name:'date',type:'date_nanos',optional:false}],returnType:'keyword'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['FROM employees\n| KEEP first_name, last_name, hire_date\n| EVAL hired = DATE_FORMAT("yyyy-MM-dd", hire_date)']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const dateParseDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'date_parse',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.date_parse',{defaultMessage:'Returns a date by parsing the second argument using the format specified in the first argument.'}),preview:false,alias:undefined,signatures:[{params:[{name:'datePattern',type:'keyword',optional:true},{name:'dateString',type:'keyword',optional:false}],returnType:'date'},{params:[{name:'datePattern',type:'keyword',optional:true},{name:'dateString',type:'text',optional:false}],returnType:'date'},{params:[{name:'datePattern',type:'text',optional:true},{name:'dateString',type:'keyword',optional:false}],returnType:'date'},{params:[{name:'datePattern',type:'text',optional:true},{name:'dateString',type:'text',optional:false}],returnType:'date'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW date_string = "2022-05-06"\n| EVAL date = DATE_PARSE("yyyy-MM-dd", date_string)']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const dateTruncDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'date_trunc',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.date_trunc',{defaultMessage:'Rounds down a date to the closest interval since epoch, which starts at `0001-01-01T00:00:00Z`.'}),preview:false,alias:undefined,signatures:[{params:[{name:'interval',type:'date_period',optional:false},{name:'date',type:'date',optional:false}],returnType:'date'},{params:[{name:'interval',type:'date_period',optional:false},{name:'date',type:'date_nanos',optional:false}],returnType:'date_nanos'},{params:[{name:'interval',type:'time_duration',optional:false},{name:'date',type:'date',optional:false}],returnType:'date'},{params:[{name:'interval',type:'time_duration',optional:false},{name:'date',type:'date_nanos',optional:false}],returnType:'date_nanos'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['FROM employees\n| KEEP first_name, last_name, hire_date\n| EVAL year_hired = DATE_TRUNC(1 year, hire_date)','FROM employees\n| EVAL year = DATE_TRUNC(1 year, hire_date)\n| STATS hires = COUNT(emp_no) BY year\n| SORT year','FROM sample_data\n| EVAL error = CASE(message LIKE "*error*", 1, 0)\n| EVAL hour = DATE_TRUNC(1 hour, @timestamp)\n| STATS error_rate = AVG(error) by hour\n| SORT hour']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const dayNameDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'day_name',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.day_name',{defaultMessage:'Returns the name of the weekday for date based on the configured Locale.'}),preview:false,alias:undefined,signatures:[{params:[{name:'date',type:'date',optional:false}],returnType:'keyword'},{params:[{name:'date',type:'date_nanos',optional:false}],returnType:'keyword'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW dt = to_datetime("1953-09-02T00:00:00.000Z")\n| EVAL weekday = DAY_NAME(dt);']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const decayDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'decay',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.decay',{defaultMessage:'Calculates a relevance score that decays based on the distance of a numeric, spatial or date type value from a target origin, using configurable decay functions.'}),preview:true,alias:undefined,signatures:[{params:[{name:'value',type:'cartesian_point',optional:false},{name:'origin',type:'cartesian_point',optional:false},{name:'scale',type:'double',optional:false},{name:'options',type:'function_named_parameters',mapParams:"{name='offset', values=[], description='Distance from the origin where no decay occurs.'}, {name='type', values=[], description='Decay function to use: linear, exponential or gaussian.'}, {name='decay', values=[], description='Multiplier value returned at the scale distance from the origin.'}",optional:true}],returnType:'double'},{params:[{name:'value',type:'date',optional:false},{name:'origin',type:'date',optional:false},{name:'scale',type:'time_duration',optional:false},{name:'options',type:'function_named_parameters',mapParams:"{name='offset', values=[], description='Distance from the origin where no decay occurs.'}, {name='type', values=[], description='Decay function to use: linear, exponential or gaussian.'}, {name='decay', values=[], description='Multiplier value returned at the scale distance from the origin.'}",optional:true}],returnType:'double'},{params:[{name:'value',type:'date_nanos',optional:false},{name:'origin',type:'date_nanos',optional:false},{name:'scale',type:'time_duration',optional:false},{name:'options',type:'function_named_parameters',mapParams:"{name='offset', values=[], description='Distance from the origin where no decay occurs.'}, {name='type', values=[], description='Decay function to use: linear, exponential or gaussian.'}, {name='decay', values=[], description='Multiplier value returned at the scale distance from the origin.'}",optional:true}],returnType:'double'},{params:[{name:'value',type:'double',optional:false},{name:'origin',type:'double',optional:false},{name:'scale',type:'double',optional:false},{name:'options',type:'function_named_parameters',mapParams:"{name='offset', values=[], description='Distance from the origin where no decay occurs.'}, {name='type', values=[], description='Decay function to use: linear, exponential or gaussian.'}, {name='decay', values=[], description='Multiplier value returned at the scale distance from the origin.'}",optional:true}],returnType:'double'},{params:[{name:'value',type:'geo_point',optional:false},{name:'origin',type:'geo_point',optional:false},{name:'scale',type:'keyword',optional:false},{name:'options',type:'function_named_parameters',mapParams:"{name='offset', values=[], description='Distance from the origin where no decay occurs.'}, {name='type', values=[], description='Decay function to use: linear, exponential or gaussian.'}, {name='decay', values=[], description='Multiplier value returned at the scale distance from the origin.'}",optional:true}],returnType:'double'},{params:[{name:'value',type:'geo_point',optional:false},{name:'origin',type:'geo_point',optional:false},{name:'scale',type:'text',optional:false},{name:'options',type:'function_named_parameters',mapParams:"{name='offset', values=[], description='Distance from the origin where no decay occurs.'}, {name='type', values=[], description='Decay function to use: linear, exponential or gaussian.'}, {name='decay', values=[], description='Multiplier value returned at the scale distance from the origin.'}",optional:true}],returnType:'double'},{params:[{name:'value',type:'integer',optional:false},{name:'origin',type:'integer',optional:false},{name:'scale',type:'integer',optional:false},{name:'options',type:'function_named_parameters',mapParams:"{name='offset', values=[], description='Distance from the origin where no decay occurs.'}, {name='type', values=[], description='Decay function to use: linear, exponential or gaussian.'}, {name='decay', values=[], description='Multiplier value returned at the scale distance from the origin.'}",optional:true}],returnType:'double'},{params:[{name:'value',type:'long',optional:false},{name:'origin',type:'long',optional:false},{name:'scale',type:'long',optional:false},{name:'options',type:'function_named_parameters',mapParams:"{name='offset', values=[], description='Distance from the origin where no decay occurs.'}, {name='type', values=[], description='Decay function to use: linear, exponential or gaussian.'}, {name='decay', values=[], description='Multiplier value returned at the scale distance from the origin.'}",optional:true}],returnType:'double'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['FROM employees\n| EVAL decay_result = decay(salary, 0, 100000, {"offset": 5, "decay": 0.5, "type": "linear"})\n| SORT decay_result DESC']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const eDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'e',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.e',{defaultMessage:'Returns Euler’s number.'}),preview:false,alias:undefined,signatures:[{params:[],returnType:'double'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW E()']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const endsWithDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'ends_with',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.ends_with',{defaultMessage:'Returns a boolean that indicates whether a keyword string ends with another string.'}),preview:false,alias:undefined,signatures:[{params:[{name:'str',type:'keyword',optional:false},{name:'suffix',type:'keyword',optional:false}],returnType:'boolean'},{params:[{name:'str',type:'keyword',optional:false},{name:'suffix',type:'text',optional:false}],returnType:'boolean'},{params:[{name:'str',type:'text',optional:false},{name:'suffix',type:'keyword',optional:false}],returnType:'boolean'},{params:[{name:'str',type:'text',optional:false},{name:'suffix',type:'text',optional:false}],returnType:'boolean'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['FROM employees\n| KEEP last_name\n| EVAL ln_E = ENDS_WITH(last_name, "d")']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const expDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'exp',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.exp',{defaultMessage:'Returns the value of e raised to the power of the given number.'}),preview:false,alias:undefined,signatures:[{params:[{name:'number',type:'double',optional:false}],returnType:'double'},{params:[{name:'number',type:'integer',optional:false}],returnType:'double'},{params:[{name:'number',type:'long',optional:false}],returnType:'double'},{params:[{name:'number',type:'unsigned_long',optional:false}],returnType:'double'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW d = 5.0\n| EVAL s = EXP(d)']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const floorDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'floor',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.floor',{defaultMessage:'Round a number down to the nearest integer.'}),preview:false,alias:undefined,signatures:[{params:[{name:'number',type:'double',optional:false}],returnType:'double'},{params:[{name:'number',type:'integer',optional:false}],returnType:'integer'},{params:[{name:'number',type:'long',optional:false}],returnType:'long'},{params:[{name:'number',type:'unsigned_long',optional:false}],returnType:'unsigned_long'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW a=1.8\n| EVAL a=FLOOR(a)']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const fromBase64Definition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'from_base64',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.from_base64',{defaultMessage:'Decode a base64 string.'}),preview:false,alias:undefined,signatures:[{params:[{name:'string',type:'keyword',optional:false}],returnType:'keyword'},{params:[{name:'string',type:'text',optional:false}],returnType:'keyword'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW a = "ZWxhc3RpYw=="\n| EVAL d = FROM_BASE64(a)']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const greatestDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'greatest',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.greatest',{defaultMessage:'Returns the maximum value from multiple columns. This is similar to `MV_MAX`\nexcept it is intended to run on multiple columns at once.'}),preview:false,alias:undefined,signatures:[{params:[{name:'first',type:'boolean',optional:false}],returnType:'boolean',minParams:1},{params:[{name:'first',type:'boolean',optional:false},{name:'rest',type:'boolean',optional:true}],returnType:'boolean',minParams:1},{params:[{name:'first',type:'date',optional:false},{name:'rest',type:'date',optional:true}],returnType:'date',minParams:1},{params:[{name:'first',type:'date_nanos',optional:false},{name:'rest',type:'date_nanos',optional:true}],returnType:'date_nanos',minParams:1},{params:[{name:'first',type:'double',optional:false},{name:'rest',type:'double',optional:true}],returnType:'double',minParams:1},{params:[{name:'first',type:'integer',optional:false}],returnType:'integer',minParams:1},{params:[{name:'first',type:'integer',optional:false},{name:'rest',type:'integer',optional:true}],returnType:'integer',minParams:1},{params:[{name:'first',type:'ip',optional:false},{name:'rest',type:'ip',optional:true}],returnType:'ip',minParams:1},{params:[{name:'first',type:'keyword',optional:false}],returnType:'keyword',minParams:1},{params:[{name:'first',type:'keyword',optional:false},{name:'rest',type:'keyword',optional:true}],returnType:'keyword',minParams:1},{params:[{name:'first',type:'long',optional:false}],returnType:'long',minParams:1},{params:[{name:'first',type:'long',optional:false},{name:'rest',type:'long',optional:true}],returnType:'long',minParams:1},{params:[{name:'first',type:'text',optional:false}],returnType:'keyword',minParams:1},{params:[{name:'first',type:'text',optional:false},{name:'rest',type:'text',optional:true}],returnType:'keyword',minParams:1},{params:[{name:'first',type:'version',optional:false},{name:'rest',type:'version',optional:true}],returnType:'version',minParams:1}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW a = 10, b = 20\n| EVAL g = GREATEST(a, b)']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const hashDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'hash',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.hash',{defaultMessage:'Computes the hash of the input using various algorithms such as MD5, SHA, SHA-224, SHA-256, SHA-384, SHA-512.'}),preview:false,alias:undefined,signatures:[{params:[{name:'algorithm',type:'keyword',optional:false},{name:'input',type:'keyword',optional:false}],returnType:'keyword'},{params:[{name:'algorithm',type:'keyword',optional:false},{name:'input',type:'text',optional:false}],returnType:'keyword'},{params:[{name:'algorithm',type:'text',optional:false},{name:'input',type:'keyword',optional:false}],returnType:'keyword'},{params:[{name:'algorithm',type:'text',optional:false},{name:'input',type:'text',optional:false}],returnType:'keyword'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['FROM sample_data\n| WHERE message != "Connection error"\n| EVAL md5 = hash("md5", message), sha256 = hash("sha256", message)\n| KEEP message, md5, sha256']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const hypotDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'hypot',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.hypot',{defaultMessage:'Returns the hypotenuse of two numbers. The input can be any numeric values, the return value is always a double.\nHypotenuses of infinities are null.'}),preview:false,alias:undefined,signatures:[{params:[{name:'number1',type:'double',optional:false},{name:'number2',type:'double',optional:false}],returnType:'double'},{params:[{name:'number1',type:'double',optional:false},{name:'number2',type:'integer',optional:false}],returnType:'double'},{params:[{name:'number1',type:'double',optional:false},{name:'number2',type:'long',optional:false}],returnType:'double'},{params:[{name:'number1',type:'double',optional:false},{name:'number2',type:'unsigned_long',optional:false}],returnType:'double'},{params:[{name:'number1',type:'integer',optional:false},{name:'number2',type:'double',optional:false}],returnType:'double'},{params:[{name:'number1',type:'integer',optional:false},{name:'number2',type:'integer',optional:false}],returnType:'double'},{params:[{name:'number1',type:'integer',optional:false},{name:'number2',type:'long',optional:false}],returnType:'double'},{params:[{name:'number1',type:'integer',optional:false},{name:'number2',type:'unsigned_long',optional:false}],returnType:'double'},{params:[{name:'number1',type:'long',optional:false},{name:'number2',type:'double',optional:false}],returnType:'double'},{params:[{name:'number1',type:'long',optional:false},{name:'number2',type:'integer',optional:false}],returnType:'double'},{params:[{name:'number1',type:'long',optional:false},{name:'number2',type:'long',optional:false}],returnType:'double'},{params:[{name:'number1',type:'long',optional:false},{name:'number2',type:'unsigned_long',optional:false}],returnType:'double'},{params:[{name:'number1',type:'unsigned_long',optional:false},{name:'number2',type:'double',optional:false}],returnType:'double'},{params:[{name:'number1',type:'unsigned_long',optional:false},{name:'number2',type:'integer',optional:false}],returnType:'double'},{params:[{name:'number1',type:'unsigned_long',optional:false},{name:'number2',type:'long',optional:false}],returnType:'double'},{params:[{name:'number1',type:'unsigned_long',optional:false},{name:'number2',type:'unsigned_long',optional:false}],returnType:'double'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW a = 3.0, b = 4.0\n| EVAL c = HYPOT(a, b)']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const ipPrefixDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'ip_prefix',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.ip_prefix',{defaultMessage:'Truncates an IP to a given prefix length.'}),preview:false,alias:undefined,signatures:[{params:[{name:'ip',type:'ip',optional:false},{name:'prefixLengthV4',type:'integer',optional:false},{name:'prefixLengthV6',type:'integer',optional:false}],returnType:'ip'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW ip4 = to_ip("1.2.3.4"), ip6 = TO_IP("fe80::cae2:65ff:fece:feb9")\n| EVAL ip4_prefix = IP_PREFIX(ip4, 24, 0), ip6_prefix = IP_PREFIX(ip6, 0, 112);']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const knnDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'knn',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.knn',{defaultMessage:'Finds the k nearest vectors to a query vector, as measured by a similarity metric. knn function finds nearest vectors through approximate search on indexed dense_vectors or semantic_text fields.'}),preview:true,alias:undefined,signatures:[{params:[{name:'field',type:'dense_vector',optional:false},{name:'query',type:'dense_vector',optional:false},{name:'options',type:'function_named_parameters',mapParams:"{name='boost', values=[2.5], description='Floating point number used to decrease or increase the relevance scores of the query.Defaults to 1.0.'}, {name='min_candidates', values=[10], description='The minimum number of nearest neighbor candidates to consider per shard while doing knn search.  KNN may use a higher number of candidates in case the query can't use a approximate results. Cannot exceed 10,000. Increasing min_candidates tends to improve the accuracy of the final results. Defaults to 1.5 * LIMIT used for the query.'}, {name='rescore_oversample', values=[3.5], description='Applies the specified oversampling for rescoring quantized vectors. See [oversampling and rescoring quantized vectors](docs-content://solutions/search/vector/knn.md#dense-vector-knn-search-rescoring) for details.'}, {name='similarity', values=[0.01], description='The minimum similarity required for a document to be considered a match. The similarity value calculated relates to the raw similarity used, not the document score.'}",optional:true}],returnType:'boolean'},{params:[{name:'field',type:'text',optional:false},{name:'query',type:'dense_vector',optional:false},{name:'options',type:'function_named_parameters',mapParams:"{name='boost', values=[2.5], description='Floating point number used to decrease or increase the relevance scores of the query.Defaults to 1.0.'}, {name='min_candidates', values=[10], description='The minimum number of nearest neighbor candidates to consider per shard while doing knn search.  KNN may use a higher number of candidates in case the query can't use a approximate results. Cannot exceed 10,000. Increasing min_candidates tends to improve the accuracy of the final results. Defaults to 1.5 * LIMIT used for the query.'}, {name='rescore_oversample', values=[3.5], description='Applies the specified oversampling for rescoring quantized vectors. See [oversampling and rescoring quantized vectors](docs-content://solutions/search/vector/knn.md#dense-vector-knn-search-rescoring) for details.'}, {name='similarity', values=[0.01], description='The minimum similarity required for a document to be considered a match. The similarity value calculated relates to the raw similarity used, not the document score.'}",optional:true}],returnType:'boolean'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['from colors metadata _score\n| where knn(rgb_vector, [0, 120, 0])\n| sort _score desc, color asc']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const kqlDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'kql',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.kql',{defaultMessage:'Performs a KQL query. Returns true if the provided KQL query string matches the row.'}),preview:false,alias:undefined,signatures:[{params:[{name:'query',type:'keyword',optional:false,constantOnly:true}],returnType:'boolean'},{params:[{name:'query',type:'keyword',optional:false,constantOnly:true},{name:'options',type:'function_named_parameters',mapParams:"{name='boost', values=[2.5], description='Floating point number used to decrease or increase the relevance scores of the query. Defaults to 1.0.'}, {name='time_zone', values=[UTC, Europe/Paris, America/New_York], description='UTC offset or IANA time zone used to interpret date literals in the query string.'}, {name='case_insensitive', values=[true, false], description='If true, performs case-insensitive matching for keyword fields. Defaults to false.'}, {name='default_field', values=[*, logs.*, title], description='Default field to search if no field is provided in the query string. Supports wildcards (*).'}",optional:true,constantOnly:true}],returnType:'boolean'},{params:[{name:'query',type:'text',optional:false,constantOnly:true}],returnType:'boolean'},{params:[{name:'query',type:'text',optional:false,constantOnly:true},{name:'options',type:'function_named_parameters',mapParams:"{name='boost', values=[2.5], description='Floating point number used to decrease or increase the relevance scores of the query. Defaults to 1.0.'}, {name='time_zone', values=[UTC, Europe/Paris, America/New_York], description='UTC offset or IANA time zone used to interpret date literals in the query string.'}, {name='case_insensitive', values=[true, false], description='If true, performs case-insensitive matching for keyword fields. Defaults to false.'}, {name='default_field', values=[*, logs.*, title], description='Default field to search if no field is provided in the query string. Supports wildcards (*).'}",optional:true,constantOnly:true}],returnType:'boolean'}],locationsAvailable:[_types.Location.WHERE,_types.Location.STATS_WHERE],examples:['FROM books\n| WHERE KQL("author: Faulkner")','FROM employees\n| WHERE KQL("mary", {"case_insensitive": true, "default_field": "first_name", "boost": 1.5})'],customParametersSnippet:'"""$0"""'};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const leastDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'least',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.least',{defaultMessage:'Returns the minimum value from multiple columns. This is similar to `MV_MIN` except it is intended to run on multiple columns at once.'}),preview:false,alias:undefined,signatures:[{params:[{name:'first',type:'boolean',optional:false}],returnType:'boolean',minParams:1},{params:[{name:'first',type:'boolean',optional:false},{name:'rest',type:'boolean',optional:true}],returnType:'boolean',minParams:1},{params:[{name:'first',type:'date',optional:false},{name:'rest',type:'date',optional:true}],returnType:'date',minParams:1},{params:[{name:'first',type:'date_nanos',optional:false},{name:'rest',type:'date_nanos',optional:true}],returnType:'date_nanos',minParams:1},{params:[{name:'first',type:'double',optional:false},{name:'rest',type:'double',optional:true}],returnType:'double',minParams:1},{params:[{name:'first',type:'integer',optional:false}],returnType:'integer',minParams:1},{params:[{name:'first',type:'integer',optional:false},{name:'rest',type:'integer',optional:true}],returnType:'integer',minParams:1},{params:[{name:'first',type:'ip',optional:false},{name:'rest',type:'ip',optional:true}],returnType:'ip',minParams:1},{params:[{name:'first',type:'keyword',optional:false}],returnType:'keyword',minParams:1},{params:[{name:'first',type:'keyword',optional:false},{name:'rest',type:'keyword',optional:true}],returnType:'keyword',minParams:1},{params:[{name:'first',type:'long',optional:false}],returnType:'long',minParams:1},{params:[{name:'first',type:'long',optional:false},{name:'rest',type:'long',optional:true}],returnType:'long',minParams:1},{params:[{name:'first',type:'text',optional:false}],returnType:'keyword',minParams:1},{params:[{name:'first',type:'text',optional:false},{name:'rest',type:'text',optional:true}],returnType:'keyword',minParams:1},{params:[{name:'first',type:'version',optional:false},{name:'rest',type:'version',optional:true}],returnType:'version',minParams:1}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW a = 10, b = 20\n| EVAL l = LEAST(a, b)']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const leftDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'left',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.left',{defaultMessage:'Returns the substring that extracts *length* chars from *string* starting from the left.'}),preview:false,alias:undefined,signatures:[{params:[{name:'string',type:'keyword',optional:false},{name:'length',type:'integer',optional:false}],returnType:'keyword'},{params:[{name:'string',type:'text',optional:false},{name:'length',type:'integer',optional:false}],returnType:'keyword'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['FROM employees\n| KEEP last_name\n| EVAL left = LEFT(last_name, 3)']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const lengthDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'length',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.length',{defaultMessage:'Returns the character length of a string.'}),preview:false,alias:undefined,signatures:[{params:[{name:'string',type:'keyword',optional:false}],returnType:'integer'},{params:[{name:'string',type:'text',optional:false}],returnType:'integer'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['FROM airports\n| WHERE country == "India"\n| KEEP city\n| EVAL fn_length = LENGTH(city)']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const locateDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'locate',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.locate',{defaultMessage:'Returns an integer that indicates the position of a keyword substring within another string.\nReturns `0` if the substring cannot be found.\nNote that string positions start from `1`.'}),preview:false,alias:undefined,signatures:[{params:[{name:'string',type:'keyword',optional:false},{name:'substring',type:'keyword',optional:false}],returnType:'integer'},{params:[{name:'string',type:'keyword',optional:false},{name:'substring',type:'keyword',optional:false},{name:'start',type:'integer',optional:true}],returnType:'integer'},{params:[{name:'string',type:'keyword',optional:false},{name:'substring',type:'text',optional:false}],returnType:'integer'},{params:[{name:'string',type:'keyword',optional:false},{name:'substring',type:'text',optional:false},{name:'start',type:'integer',optional:true}],returnType:'integer'},{params:[{name:'string',type:'text',optional:false},{name:'substring',type:'keyword',optional:false}],returnType:'integer'},{params:[{name:'string',type:'text',optional:false},{name:'substring',type:'keyword',optional:false},{name:'start',type:'integer',optional:true}],returnType:'integer'},{params:[{name:'string',type:'text',optional:false},{name:'substring',type:'text',optional:false}],returnType:'integer'},{params:[{name:'string',type:'text',optional:false},{name:'substring',type:'text',optional:false},{name:'start',type:'integer',optional:true}],returnType:'integer'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW a = "hello"\n| EVAL a_ll = LOCATE(a, "ll")']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const logDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'log',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.log',{defaultMessage:'Returns the logarithm of a value to a base. The input can be any numeric value, the return value is always a double.\n\nLogs of zero, negative numbers, and base of one return `null` as well as a warning.'}),preview:false,alias:undefined,signatures:[{params:[{name:'base',type:'double',optional:true}],returnType:'double'},{params:[{name:'base',type:'double',optional:true},{name:'number',type:'double',optional:false}],returnType:'double'},{params:[{name:'base',type:'double',optional:true},{name:'number',type:'integer',optional:false}],returnType:'double'},{params:[{name:'base',type:'double',optional:true},{name:'number',type:'long',optional:false}],returnType:'double'},{params:[{name:'base',type:'double',optional:true},{name:'number',type:'unsigned_long',optional:false}],returnType:'double'},{params:[{name:'base',type:'integer',optional:true}],returnType:'double'},{params:[{name:'base',type:'integer',optional:true},{name:'number',type:'double',optional:false}],returnType:'double'},{params:[{name:'base',type:'integer',optional:true},{name:'number',type:'integer',optional:false}],returnType:'double'},{params:[{name:'base',type:'integer',optional:true},{name:'number',type:'long',optional:false}],returnType:'double'},{params:[{name:'base',type:'integer',optional:true},{name:'number',type:'unsigned_long',optional:false}],returnType:'double'},{params:[{name:'base',type:'long',optional:true}],returnType:'double'},{params:[{name:'base',type:'long',optional:true},{name:'number',type:'double',optional:false}],returnType:'double'},{params:[{name:'base',type:'long',optional:true},{name:'number',type:'integer',optional:false}],returnType:'double'},{params:[{name:'base',type:'long',optional:true},{name:'number',type:'long',optional:false}],returnType:'double'},{params:[{name:'base',type:'long',optional:true},{name:'number',type:'unsigned_long',optional:false}],returnType:'double'},{params:[{name:'base',type:'unsigned_long',optional:true}],returnType:'double'},{params:[{name:'base',type:'unsigned_long',optional:true},{name:'number',type:'double',optional:false}],returnType:'double'},{params:[{name:'base',type:'unsigned_long',optional:true},{name:'number',type:'integer',optional:false}],returnType:'double'},{params:[{name:'base',type:'unsigned_long',optional:true},{name:'number',type:'long',optional:false}],returnType:'double'},{params:[{name:'base',type:'unsigned_long',optional:true},{name:'number',type:'unsigned_long',optional:false}],returnType:'double'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW base = 2.0, value = 8.0\n| EVAL s = LOG(base, value)','ROW value = 100\n| EVAL s = LOG(value);']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const log10Definition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'log10',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.log10',{defaultMessage:'Returns the logarithm of a value to base 10. The input can be any numeric value, the return value is always a double.\n\nLogs of 0 and negative numbers return `null` as well as a warning.'}),preview:false,alias:undefined,signatures:[{params:[{name:'number',type:'double',optional:false}],returnType:'double'},{params:[{name:'number',type:'integer',optional:false}],returnType:'double'},{params:[{name:'number',type:'long',optional:false}],returnType:'double'},{params:[{name:'number',type:'unsigned_long',optional:false}],returnType:'double'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW d = 1000.0\n| EVAL s = LOG10(d)']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const ltrimDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'ltrim',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.ltrim',{defaultMessage:'Removes leading whitespaces from a string.'}),preview:false,alias:undefined,signatures:[{params:[{name:'string',type:'keyword',optional:false}],returnType:'keyword'},{params:[{name:'string',type:'text',optional:false}],returnType:'keyword'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW message = "   some text  ",  color = " red "\n| EVAL message = LTRIM(message)\n| EVAL color = LTRIM(color)\n| EVAL message = CONCAT("\'", message, "\'")\n| EVAL color = CONCAT("\'", color, "\'")']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const matchDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'match',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.match',{defaultMessage:'Use `MATCH` to perform a match query on the specified field.\nUsing `MATCH` is equivalent to using the `match` query in the Elasticsearch Query DSL.'}),preview:false,alias:undefined,signatures:[{params:[{name:'field',type:'boolean',optional:false,fieldsOnly:true},{name:'query',type:'boolean',optional:false,constantOnly:true},{name:'options',type:'function_named_parameters',mapParams:"{name='fuzziness', values=[AUTO, 1, 2], description='Maximum edit distance allowed for matching.'}, {name='auto_generate_synonyms_phrase_query', values=[true, false], description='If true, match phrase queries are automatically created for multi-term synonyms. Defaults to true.'}, {name='analyzer', values=[standard], description='Analyzer used to convert the text in the query value into token. Defaults to the index-time analyzer mapped for the field. If no analyzer is mapped, the index’s default analyzer is used.'}, {name='minimum_should_match', values=[2], description='Minimum number of clauses that must match for a document to be returned.'}, {name='zero_terms_query', values=[none, all], description='Indicates whether all documents or none are returned if the analyzer removes all tokens, such as when using a stop filter. Defaults to none.'}, {name='boost', values=[2.5], description='Floating point number used to decrease or increase the relevance scores of the query. Defaults to 1.0.'}, {name='fuzzy_transpositions', values=[true, false], description='If true, edits for fuzzy matching include transpositions of two adjacent characters (ab → ba). Defaults to true.'}, {name='fuzzy_rewrite', values=[constant_score_blended, constant_score, constant_score_boolean, top_terms_blended_freqs_N, top_terms_boost_N, top_terms_N], description='Method used to rewrite the query. See the rewrite parameter for valid values and more information. If the fuzziness parameter is not 0, the match query uses a fuzzy_rewrite method of top_terms_blended_freqs_${max_expansions} by default.'}, {name='prefix_length', values=[1], description='Number of beginning characters left unchanged for fuzzy matching. Defaults to 0.'}, {name='lenient', values=[true, false], description='If false, format-based errors, such as providing a text query value for a numeric field, are returned. Defaults to false.'}, {name='operator', values=[AND, OR], description='Boolean logic used to interpret text in the query value. Defaults to OR.'}, {name='max_expansions', values=[50], description='Maximum number of terms to which the query will expand. Defaults to 50.'}",optional:true,constantOnly:true}],returnType:'boolean'},{params:[{name:'field',type:'boolean',optional:false,fieldsOnly:true},{name:'query',type:'keyword',optional:false,constantOnly:true},{name:'options',type:'function_named_parameters',mapParams:"{name='fuzziness', values=[AUTO, 1, 2], description='Maximum edit distance allowed for matching.'}, {name='auto_generate_synonyms_phrase_query', values=[true, false], description='If true, match phrase queries are automatically created for multi-term synonyms. Defaults to true.'}, {name='analyzer', values=[standard], description='Analyzer used to convert the text in the query value into token. Defaults to the index-time analyzer mapped for the field. If no analyzer is mapped, the index’s default analyzer is used.'}, {name='minimum_should_match', values=[2], description='Minimum number of clauses that must match for a document to be returned.'}, {name='zero_terms_query', values=[none, all], description='Indicates whether all documents or none are returned if the analyzer removes all tokens, such as when using a stop filter. Defaults to none.'}, {name='boost', values=[2.5], description='Floating point number used to decrease or increase the relevance scores of the query. Defaults to 1.0.'}, {name='fuzzy_transpositions', values=[true, false], description='If true, edits for fuzzy matching include transpositions of two adjacent characters (ab → ba). Defaults to true.'}, {name='fuzzy_rewrite', values=[constant_score_blended, constant_score, constant_score_boolean, top_terms_blended_freqs_N, top_terms_boost_N, top_terms_N], description='Method used to rewrite the query. See the rewrite parameter for valid values and more information. If the fuzziness parameter is not 0, the match query uses a fuzzy_rewrite method of top_terms_blended_freqs_${max_expansions} by default.'}, {name='prefix_length', values=[1], description='Number of beginning characters left unchanged for fuzzy matching. Defaults to 0.'}, {name='lenient', values=[true, false], description='If false, format-based errors, such as providing a text query value for a numeric field, are returned. Defaults to false.'}, {name='operator', values=[AND, OR], description='Boolean logic used to interpret text in the query value. Defaults to OR.'}, {name='max_expansions', values=[50], description='Maximum number of terms to which the query will expand. Defaults to 50.'}",optional:true,constantOnly:true}],returnType:'boolean'},{params:[{name:'field',type:'date',optional:false,fieldsOnly:true},{name:'query',type:'date',optional:false,constantOnly:true},{name:'options',type:'function_named_parameters',mapParams:"{name='fuzziness', values=[AUTO, 1, 2], description='Maximum edit distance allowed for matching.'}, {name='auto_generate_synonyms_phrase_query', values=[true, false], description='If true, match phrase queries are automatically created for multi-term synonyms. Defaults to true.'}, {name='analyzer', values=[standard], description='Analyzer used to convert the text in the query value into token. Defaults to the index-time analyzer mapped for the field. If no analyzer is mapped, the index’s default analyzer is used.'}, {name='minimum_should_match', values=[2], description='Minimum number of clauses that must match for a document to be returned.'}, {name='zero_terms_query', values=[none, all], description='Indicates whether all documents or none are returned if the analyzer removes all tokens, such as when using a stop filter. Defaults to none.'}, {name='boost', values=[2.5], description='Floating point number used to decrease or increase the relevance scores of the query. Defaults to 1.0.'}, {name='fuzzy_transpositions', values=[true, false], description='If true, edits for fuzzy matching include transpositions of two adjacent characters (ab → ba). Defaults to true.'}, {name='fuzzy_rewrite', values=[constant_score_blended, constant_score, constant_score_boolean, top_terms_blended_freqs_N, top_terms_boost_N, top_terms_N], description='Method used to rewrite the query. See the rewrite parameter for valid values and more information. If the fuzziness parameter is not 0, the match query uses a fuzzy_rewrite method of top_terms_blended_freqs_${max_expansions} by default.'}, {name='prefix_length', values=[1], description='Number of beginning characters left unchanged for fuzzy matching. Defaults to 0.'}, {name='lenient', values=[true, false], description='If false, format-based errors, such as providing a text query value for a numeric field, are returned. Defaults to false.'}, {name='operator', values=[AND, OR], description='Boolean logic used to interpret text in the query value. Defaults to OR.'}, {name='max_expansions', values=[50], description='Maximum number of terms to which the query will expand. Defaults to 50.'}",optional:true,constantOnly:true}],returnType:'boolean'},{params:[{name:'field',type:'date',optional:false,fieldsOnly:true},{name:'query',type:'keyword',optional:false,constantOnly:true},{name:'options',type:'function_named_parameters',mapParams:"{name='fuzziness', values=[AUTO, 1, 2], description='Maximum edit distance allowed for matching.'}, {name='auto_generate_synonyms_phrase_query', values=[true, false], description='If true, match phrase queries are automatically created for multi-term synonyms. Defaults to true.'}, {name='analyzer', values=[standard], description='Analyzer used to convert the text in the query value into token. Defaults to the index-time analyzer mapped for the field. If no analyzer is mapped, the index’s default analyzer is used.'}, {name='minimum_should_match', values=[2], description='Minimum number of clauses that must match for a document to be returned.'}, {name='zero_terms_query', values=[none, all], description='Indicates whether all documents or none are returned if the analyzer removes all tokens, such as when using a stop filter. Defaults to none.'}, {name='boost', values=[2.5], description='Floating point number used to decrease or increase the relevance scores of the query. Defaults to 1.0.'}, {name='fuzzy_transpositions', values=[true, false], description='If true, edits for fuzzy matching include transpositions of two adjacent characters (ab → ba). Defaults to true.'}, {name='fuzzy_rewrite', values=[constant_score_blended, constant_score, constant_score_boolean, top_terms_blended_freqs_N, top_terms_boost_N, top_terms_N], description='Method used to rewrite the query. See the rewrite parameter for valid values and more information. If the fuzziness parameter is not 0, the match query uses a fuzzy_rewrite method of top_terms_blended_freqs_${max_expansions} by default.'}, {name='prefix_length', values=[1], description='Number of beginning characters left unchanged for fuzzy matching. Defaults to 0.'}, {name='lenient', values=[true, false], description='If false, format-based errors, such as providing a text query value for a numeric field, are returned. Defaults to false.'}, {name='operator', values=[AND, OR], description='Boolean logic used to interpret text in the query value. Defaults to OR.'}, {name='max_expansions', values=[50], description='Maximum number of terms to which the query will expand. Defaults to 50.'}",optional:true,constantOnly:true}],returnType:'boolean'},{params:[{name:'field',type:'date_nanos',optional:false,fieldsOnly:true},{name:'query',type:'date_nanos',optional:false,constantOnly:true},{name:'options',type:'function_named_parameters',mapParams:"{name='fuzziness', values=[AUTO, 1, 2], description='Maximum edit distance allowed for matching.'}, {name='auto_generate_synonyms_phrase_query', values=[true, false], description='If true, match phrase queries are automatically created for multi-term synonyms. Defaults to true.'}, {name='analyzer', values=[standard], description='Analyzer used to convert the text in the query value into token. Defaults to the index-time analyzer mapped for the field. If no analyzer is mapped, the index’s default analyzer is used.'}, {name='minimum_should_match', values=[2], description='Minimum number of clauses that must match for a document to be returned.'}, {name='zero_terms_query', values=[none, all], description='Indicates whether all documents or none are returned if the analyzer removes all tokens, such as when using a stop filter. Defaults to none.'}, {name='boost', values=[2.5], description='Floating point number used to decrease or increase the relevance scores of the query. Defaults to 1.0.'}, {name='fuzzy_transpositions', values=[true, false], description='If true, edits for fuzzy matching include transpositions of two adjacent characters (ab → ba). Defaults to true.'}, {name='fuzzy_rewrite', values=[constant_score_blended, constant_score, constant_score_boolean, top_terms_blended_freqs_N, top_terms_boost_N, top_terms_N], description='Method used to rewrite the query. See the rewrite parameter for valid values and more information. If the fuzziness parameter is not 0, the match query uses a fuzzy_rewrite method of top_terms_blended_freqs_${max_expansions} by default.'}, {name='prefix_length', values=[1], description='Number of beginning characters left unchanged for fuzzy matching. Defaults to 0.'}, {name='lenient', values=[true, false], description='If false, format-based errors, such as providing a text query value for a numeric field, are returned. Defaults to false.'}, {name='operator', values=[AND, OR], description='Boolean logic used to interpret text in the query value. Defaults to OR.'}, {name='max_expansions', values=[50], description='Maximum number of terms to which the query will expand. Defaults to 50.'}",optional:true,constantOnly:true}],returnType:'boolean'},{params:[{name:'field',type:'date_nanos',optional:false,fieldsOnly:true},{name:'query',type:'keyword',optional:false,constantOnly:true},{name:'options',type:'function_named_parameters',mapParams:"{name='fuzziness', values=[AUTO, 1, 2], description='Maximum edit distance allowed for matching.'}, {name='auto_generate_synonyms_phrase_query', values=[true, false], description='If true, match phrase queries are automatically created for multi-term synonyms. Defaults to true.'}, {name='analyzer', values=[standard], description='Analyzer used to convert the text in the query value into token. Defaults to the index-time analyzer mapped for the field. If no analyzer is mapped, the index’s default analyzer is used.'}, {name='minimum_should_match', values=[2], description='Minimum number of clauses that must match for a document to be returned.'}, {name='zero_terms_query', values=[none, all], description='Indicates whether all documents or none are returned if the analyzer removes all tokens, such as when using a stop filter. Defaults to none.'}, {name='boost', values=[2.5], description='Floating point number used to decrease or increase the relevance scores of the query. Defaults to 1.0.'}, {name='fuzzy_transpositions', values=[true, false], description='If true, edits for fuzzy matching include transpositions of two adjacent characters (ab → ba). Defaults to true.'}, {name='fuzzy_rewrite', values=[constant_score_blended, constant_score, constant_score_boolean, top_terms_blended_freqs_N, top_terms_boost_N, top_terms_N], description='Method used to rewrite the query. See the rewrite parameter for valid values and more information. If the fuzziness parameter is not 0, the match query uses a fuzzy_rewrite method of top_terms_blended_freqs_${max_expansions} by default.'}, {name='prefix_length', values=[1], description='Number of beginning characters left unchanged for fuzzy matching. Defaults to 0.'}, {name='lenient', values=[true, false], description='If false, format-based errors, such as providing a text query value for a numeric field, are returned. Defaults to false.'}, {name='operator', values=[AND, OR], description='Boolean logic used to interpret text in the query value. Defaults to OR.'}, {name='max_expansions', values=[50], description='Maximum number of terms to which the query will expand. Defaults to 50.'}",optional:true,constantOnly:true}],returnType:'boolean'},{params:[{name:'field',type:'double',optional:false,fieldsOnly:true},{name:'query',type:'double',optional:false,constantOnly:true},{name:'options',type:'function_named_parameters',mapParams:"{name='fuzziness', values=[AUTO, 1, 2], description='Maximum edit distance allowed for matching.'}, {name='auto_generate_synonyms_phrase_query', values=[true, false], description='If true, match phrase queries are automatically created for multi-term synonyms. Defaults to true.'}, {name='analyzer', values=[standard], description='Analyzer used to convert the text in the query value into token. Defaults to the index-time analyzer mapped for the field. If no analyzer is mapped, the index’s default analyzer is used.'}, {name='minimum_should_match', values=[2], description='Minimum number of clauses that must match for a document to be returned.'}, {name='zero_terms_query', values=[none, all], description='Indicates whether all documents or none are returned if the analyzer removes all tokens, such as when using a stop filter. Defaults to none.'}, {name='boost', values=[2.5], description='Floating point number used to decrease or increase the relevance scores of the query. Defaults to 1.0.'}, {name='fuzzy_transpositions', values=[true, false], description='If true, edits for fuzzy matching include transpositions of two adjacent characters (ab → ba). Defaults to true.'}, {name='fuzzy_rewrite', values=[constant_score_blended, constant_score, constant_score_boolean, top_terms_blended_freqs_N, top_terms_boost_N, top_terms_N], description='Method used to rewrite the query. See the rewrite parameter for valid values and more information. If the fuzziness parameter is not 0, the match query uses a fuzzy_rewrite method of top_terms_blended_freqs_${max_expansions} by default.'}, {name='prefix_length', values=[1], description='Number of beginning characters left unchanged for fuzzy matching. Defaults to 0.'}, {name='lenient', values=[true, false], description='If false, format-based errors, such as providing a text query value for a numeric field, are returned. Defaults to false.'}, {name='operator', values=[AND, OR], description='Boolean logic used to interpret text in the query value. Defaults to OR.'}, {name='max_expansions', values=[50], description='Maximum number of terms to which the query will expand. Defaults to 50.'}",optional:true,constantOnly:true}],returnType:'boolean'},{params:[{name:'field',type:'double',optional:false,fieldsOnly:true},{name:'query',type:'integer',optional:false,constantOnly:true},{name:'options',type:'function_named_parameters',mapParams:"{name='fuzziness', values=[AUTO, 1, 2], description='Maximum edit distance allowed for matching.'}, {name='auto_generate_synonyms_phrase_query', values=[true, false], description='If true, match phrase queries are automatically created for multi-term synonyms. Defaults to true.'}, {name='analyzer', values=[standard], description='Analyzer used to convert the text in the query value into token. Defaults to the index-time analyzer mapped for the field. If no analyzer is mapped, the index’s default analyzer is used.'}, {name='minimum_should_match', values=[2], description='Minimum number of clauses that must match for a document to be returned.'}, {name='zero_terms_query', values=[none, all], description='Indicates whether all documents or none are returned if the analyzer removes all tokens, such as when using a stop filter. Defaults to none.'}, {name='boost', values=[2.5], description='Floating point number used to decrease or increase the relevance scores of the query. Defaults to 1.0.'}, {name='fuzzy_transpositions', values=[true, false], description='If true, edits for fuzzy matching include transpositions of two adjacent characters (ab → ba). Defaults to true.'}, {name='fuzzy_rewrite', values=[constant_score_blended, constant_score, constant_score_boolean, top_terms_blended_freqs_N, top_terms_boost_N, top_terms_N], description='Method used to rewrite the query. See the rewrite parameter for valid values and more information. If the fuzziness parameter is not 0, the match query uses a fuzzy_rewrite method of top_terms_blended_freqs_${max_expansions} by default.'}, {name='prefix_length', values=[1], description='Number of beginning characters left unchanged for fuzzy matching. Defaults to 0.'}, {name='lenient', values=[true, false], description='If false, format-based errors, such as providing a text query value for a numeric field, are returned. Defaults to false.'}, {name='operator', values=[AND, OR], description='Boolean logic used to interpret text in the query value. Defaults to OR.'}, {name='max_expansions', values=[50], description='Maximum number of terms to which the query will expand. Defaults to 50.'}",optional:true,constantOnly:true}],returnType:'boolean'},{params:[{name:'field',type:'double',optional:false,fieldsOnly:true},{name:'query',type:'keyword',optional:false,constantOnly:true},{name:'options',type:'function_named_parameters',mapParams:"{name='fuzziness', values=[AUTO, 1, 2], description='Maximum edit distance allowed for matching.'}, {name='auto_generate_synonyms_phrase_query', values=[true, false], description='If true, match phrase queries are automatically created for multi-term synonyms. Defaults to true.'}, {name='analyzer', values=[standard], description='Analyzer used to convert the text in the query value into token. Defaults to the index-time analyzer mapped for the field. If no analyzer is mapped, the index’s default analyzer is used.'}, {name='minimum_should_match', values=[2], description='Minimum number of clauses that must match for a document to be returned.'}, {name='zero_terms_query', values=[none, all], description='Indicates whether all documents or none are returned if the analyzer removes all tokens, such as when using a stop filter. Defaults to none.'}, {name='boost', values=[2.5], description='Floating point number used to decrease or increase the relevance scores of the query. Defaults to 1.0.'}, {name='fuzzy_transpositions', values=[true, false], description='If true, edits for fuzzy matching include transpositions of two adjacent characters (ab → ba). Defaults to true.'}, {name='fuzzy_rewrite', values=[constant_score_blended, constant_score, constant_score_boolean, top_terms_blended_freqs_N, top_terms_boost_N, top_terms_N], description='Method used to rewrite the query. See the rewrite parameter for valid values and more information. If the fuzziness parameter is not 0, the match query uses a fuzzy_rewrite method of top_terms_blended_freqs_${max_expansions} by default.'}, {name='prefix_length', values=[1], description='Number of beginning characters left unchanged for fuzzy matching. Defaults to 0.'}, {name='lenient', values=[true, false], description='If false, format-based errors, such as providing a text query value for a numeric field, are returned. Defaults to false.'}, {name='operator', values=[AND, OR], description='Boolean logic used to interpret text in the query value. Defaults to OR.'}, {name='max_expansions', values=[50], description='Maximum number of terms to which the query will expand. Defaults to 50.'}",optional:true,constantOnly:true}],returnType:'boolean'},{params:[{name:'field',type:'double',optional:false,fieldsOnly:true},{name:'query',type:'long',optional:false,constantOnly:true},{name:'options',type:'function_named_parameters',mapParams:"{name='fuzziness', values=[AUTO, 1, 2], description='Maximum edit distance allowed for matching.'}, {name='auto_generate_synonyms_phrase_query', values=[true, false], description='If true, match phrase queries are automatically created for multi-term synonyms. Defaults to true.'}, {name='analyzer', values=[standard], description='Analyzer used to convert the text in the query value into token. Defaults to the index-time analyzer mapped for the field. If no analyzer is mapped, the index’s default analyzer is used.'}, {name='minimum_should_match', values=[2], description='Minimum number of clauses that must match for a document to be returned.'}, {name='zero_terms_query', values=[none, all], description='Indicates whether all documents or none are returned if the analyzer removes all tokens, such as when using a stop filter. Defaults to none.'}, {name='boost', values=[2.5], description='Floating point number used to decrease or increase the relevance scores of the query. Defaults to 1.0.'}, {name='fuzzy_transpositions', values=[true, false], description='If true, edits for fuzzy matching include transpositions of two adjacent characters (ab → ba). Defaults to true.'}, {name='fuzzy_rewrite', values=[constant_score_blended, constant_score, constant_score_boolean, top_terms_blended_freqs_N, top_terms_boost_N, top_terms_N], description='Method used to rewrite the query. See the rewrite parameter for valid values and more information. If the fuzziness parameter is not 0, the match query uses a fuzzy_rewrite method of top_terms_blended_freqs_${max_expansions} by default.'}, {name='prefix_length', values=[1], description='Number of beginning characters left unchanged for fuzzy matching. Defaults to 0.'}, {name='lenient', values=[true, false], description='If false, format-based errors, such as providing a text query value for a numeric field, are returned. Defaults to false.'}, {name='operator', values=[AND, OR], description='Boolean logic used to interpret text in the query value. Defaults to OR.'}, {name='max_expansions', values=[50], description='Maximum number of terms to which the query will expand. Defaults to 50.'}",optional:true,constantOnly:true}],returnType:'boolean'},{params:[{name:'field',type:'integer',optional:false,fieldsOnly:true},{name:'query',type:'double',optional:false,constantOnly:true},{name:'options',type:'function_named_parameters',mapParams:"{name='fuzziness', values=[AUTO, 1, 2], description='Maximum edit distance allowed for matching.'}, {name='auto_generate_synonyms_phrase_query', values=[true, false], description='If true, match phrase queries are automatically created for multi-term synonyms. Defaults to true.'}, {name='analyzer', values=[standard], description='Analyzer used to convert the text in the query value into token. Defaults to the index-time analyzer mapped for the field. If no analyzer is mapped, the index’s default analyzer is used.'}, {name='minimum_should_match', values=[2], description='Minimum number of clauses that must match for a document to be returned.'}, {name='zero_terms_query', values=[none, all], description='Indicates whether all documents or none are returned if the analyzer removes all tokens, such as when using a stop filter. Defaults to none.'}, {name='boost', values=[2.5], description='Floating point number used to decrease or increase the relevance scores of the query. Defaults to 1.0.'}, {name='fuzzy_transpositions', values=[true, false], description='If true, edits for fuzzy matching include transpositions of two adjacent characters (ab → ba). Defaults to true.'}, {name='fuzzy_rewrite', values=[constant_score_blended, constant_score, constant_score_boolean, top_terms_blended_freqs_N, top_terms_boost_N, top_terms_N], description='Method used to rewrite the query. See the rewrite parameter for valid values and more information. If the fuzziness parameter is not 0, the match query uses a fuzzy_rewrite method of top_terms_blended_freqs_${max_expansions} by default.'}, {name='prefix_length', values=[1], description='Number of beginning characters left unchanged for fuzzy matching. Defaults to 0.'}, {name='lenient', values=[true, false], description='If false, format-based errors, such as providing a text query value for a numeric field, are returned. Defaults to false.'}, {name='operator', values=[AND, OR], description='Boolean logic used to interpret text in the query value. Defaults to OR.'}, {name='max_expansions', values=[50], description='Maximum number of terms to which the query will expand. Defaults to 50.'}",optional:true,constantOnly:true}],returnType:'boolean'},{params:[{name:'field',type:'integer',optional:false,fieldsOnly:true},{name:'query',type:'integer',optional:false,constantOnly:true},{name:'options',type:'function_named_parameters',mapParams:"{name='fuzziness', values=[AUTO, 1, 2], description='Maximum edit distance allowed for matching.'}, {name='auto_generate_synonyms_phrase_query', values=[true, false], description='If true, match phrase queries are automatically created for multi-term synonyms. Defaults to true.'}, {name='analyzer', values=[standard], description='Analyzer used to convert the text in the query value into token. Defaults to the index-time analyzer mapped for the field. If no analyzer is mapped, the index’s default analyzer is used.'}, {name='minimum_should_match', values=[2], description='Minimum number of clauses that must match for a document to be returned.'}, {name='zero_terms_query', values=[none, all], description='Indicates whether all documents or none are returned if the analyzer removes all tokens, such as when using a stop filter. Defaults to none.'}, {name='boost', values=[2.5], description='Floating point number used to decrease or increase the relevance scores of the query. Defaults to 1.0.'}, {name='fuzzy_transpositions', values=[true, false], description='If true, edits for fuzzy matching include transpositions of two adjacent characters (ab → ba). Defaults to true.'}, {name='fuzzy_rewrite', values=[constant_score_blended, constant_score, constant_score_boolean, top_terms_blended_freqs_N, top_terms_boost_N, top_terms_N], description='Method used to rewrite the query. See the rewrite parameter for valid values and more information. If the fuzziness parameter is not 0, the match query uses a fuzzy_rewrite method of top_terms_blended_freqs_${max_expansions} by default.'}, {name='prefix_length', values=[1], description='Number of beginning characters left unchanged for fuzzy matching. Defaults to 0.'}, {name='lenient', values=[true, false], description='If false, format-based errors, such as providing a text query value for a numeric field, are returned. Defaults to false.'}, {name='operator', values=[AND, OR], description='Boolean logic used to interpret text in the query value. Defaults to OR.'}, {name='max_expansions', values=[50], description='Maximum number of terms to which the query will expand. Defaults to 50.'}",optional:true,constantOnly:true}],returnType:'boolean'},{params:[{name:'field',type:'integer',optional:false,fieldsOnly:true},{name:'query',type:'keyword',optional:false,constantOnly:true},{name:'options',type:'function_named_parameters',mapParams:"{name='fuzziness', values=[AUTO, 1, 2], description='Maximum edit distance allowed for matching.'}, {name='auto_generate_synonyms_phrase_query', values=[true, false], description='If true, match phrase queries are automatically created for multi-term synonyms. Defaults to true.'}, {name='analyzer', values=[standard], description='Analyzer used to convert the text in the query value into token. Defaults to the index-time analyzer mapped for the field. If no analyzer is mapped, the index’s default analyzer is used.'}, {name='minimum_should_match', values=[2], description='Minimum number of clauses that must match for a document to be returned.'}, {name='zero_terms_query', values=[none, all], description='Indicates whether all documents or none are returned if the analyzer removes all tokens, such as when using a stop filter. Defaults to none.'}, {name='boost', values=[2.5], description='Floating point number used to decrease or increase the relevance scores of the query. Defaults to 1.0.'}, {name='fuzzy_transpositions', values=[true, false], description='If true, edits for fuzzy matching include transpositions of two adjacent characters (ab → ba). Defaults to true.'}, {name='fuzzy_rewrite', values=[constant_score_blended, constant_score, constant_score_boolean, top_terms_blended_freqs_N, top_terms_boost_N, top_terms_N], description='Method used to rewrite the query. See the rewrite parameter for valid values and more information. If the fuzziness parameter is not 0, the match query uses a fuzzy_rewrite method of top_terms_blended_freqs_${max_expansions} by default.'}, {name='prefix_length', values=[1], description='Number of beginning characters left unchanged for fuzzy matching. Defaults to 0.'}, {name='lenient', values=[true, false], description='If false, format-based errors, such as providing a text query value for a numeric field, are returned. Defaults to false.'}, {name='operator', values=[AND, OR], description='Boolean logic used to interpret text in the query value. Defaults to OR.'}, {name='max_expansions', values=[50], description='Maximum number of terms to which the query will expand. Defaults to 50.'}",optional:true,constantOnly:true}],returnType:'boolean'},{params:[{name:'field',type:'integer',optional:false,fieldsOnly:true},{name:'query',type:'long',optional:false,constantOnly:true},{name:'options',type:'function_named_parameters',mapParams:"{name='fuzziness', values=[AUTO, 1, 2], description='Maximum edit distance allowed for matching.'}, {name='auto_generate_synonyms_phrase_query', values=[true, false], description='If true, match phrase queries are automatically created for multi-term synonyms. Defaults to true.'}, {name='analyzer', values=[standard], description='Analyzer used to convert the text in the query value into token. Defaults to the index-time analyzer mapped for the field. If no analyzer is mapped, the index’s default analyzer is used.'}, {name='minimum_should_match', values=[2], description='Minimum number of clauses that must match for a document to be returned.'}, {name='zero_terms_query', values=[none, all], description='Indicates whether all documents or none are returned if the analyzer removes all tokens, such as when using a stop filter. Defaults to none.'}, {name='boost', values=[2.5], description='Floating point number used to decrease or increase the relevance scores of the query. Defaults to 1.0.'}, {name='fuzzy_transpositions', values=[true, false], description='If true, edits for fuzzy matching include transpositions of two adjacent characters (ab → ba). Defaults to true.'}, {name='fuzzy_rewrite', values=[constant_score_blended, constant_score, constant_score_boolean, top_terms_blended_freqs_N, top_terms_boost_N, top_terms_N], description='Method used to rewrite the query. See the rewrite parameter for valid values and more information. If the fuzziness parameter is not 0, the match query uses a fuzzy_rewrite method of top_terms_blended_freqs_${max_expansions} by default.'}, {name='prefix_length', values=[1], description='Number of beginning characters left unchanged for fuzzy matching. Defaults to 0.'}, {name='lenient', values=[true, false], description='If false, format-based errors, such as providing a text query value for a numeric field, are returned. Defaults to false.'}, {name='operator', values=[AND, OR], description='Boolean logic used to interpret text in the query value. Defaults to OR.'}, {name='max_expansions', values=[50], description='Maximum number of terms to which the query will expand. Defaults to 50.'}",optional:true,constantOnly:true}],returnType:'boolean'},{params:[{name:'field',type:'ip',optional:false,fieldsOnly:true},{name:'query',type:'ip',optional:false,constantOnly:true},{name:'options',type:'function_named_parameters',mapParams:"{name='fuzziness', values=[AUTO, 1, 2], description='Maximum edit distance allowed for matching.'}, {name='auto_generate_synonyms_phrase_query', values=[true, false], description='If true, match phrase queries are automatically created for multi-term synonyms. Defaults to true.'}, {name='analyzer', values=[standard], description='Analyzer used to convert the text in the query value into token. Defaults to the index-time analyzer mapped for the field. If no analyzer is mapped, the index’s default analyzer is used.'}, {name='minimum_should_match', values=[2], description='Minimum number of clauses that must match for a document to be returned.'}, {name='zero_terms_query', values=[none, all], description='Indicates whether all documents or none are returned if the analyzer removes all tokens, such as when using a stop filter. Defaults to none.'}, {name='boost', values=[2.5], description='Floating point number used to decrease or increase the relevance scores of the query. Defaults to 1.0.'}, {name='fuzzy_transpositions', values=[true, false], description='If true, edits for fuzzy matching include transpositions of two adjacent characters (ab → ba). Defaults to true.'}, {name='fuzzy_rewrite', values=[constant_score_blended, constant_score, constant_score_boolean, top_terms_blended_freqs_N, top_terms_boost_N, top_terms_N], description='Method used to rewrite the query. See the rewrite parameter for valid values and more information. If the fuzziness parameter is not 0, the match query uses a fuzzy_rewrite method of top_terms_blended_freqs_${max_expansions} by default.'}, {name='prefix_length', values=[1], description='Number of beginning characters left unchanged for fuzzy matching. Defaults to 0.'}, {name='lenient', values=[true, false], description='If false, format-based errors, such as providing a text query value for a numeric field, are returned. Defaults to false.'}, {name='operator', values=[AND, OR], description='Boolean logic used to interpret text in the query value. Defaults to OR.'}, {name='max_expansions', values=[50], description='Maximum number of terms to which the query will expand. Defaults to 50.'}",optional:true,constantOnly:true}],returnType:'boolean'},{params:[{name:'field',type:'ip',optional:false,fieldsOnly:true},{name:'query',type:'keyword',optional:false,constantOnly:true},{name:'options',type:'function_named_parameters',mapParams:"{name='fuzziness', values=[AUTO, 1, 2], description='Maximum edit distance allowed for matching.'}, {name='auto_generate_synonyms_phrase_query', values=[true, false], description='If true, match phrase queries are automatically created for multi-term synonyms. Defaults to true.'}, {name='analyzer', values=[standard], description='Analyzer used to convert the text in the query value into token. Defaults to the index-time analyzer mapped for the field. If no analyzer is mapped, the index’s default analyzer is used.'}, {name='minimum_should_match', values=[2], description='Minimum number of clauses that must match for a document to be returned.'}, {name='zero_terms_query', values=[none, all], description='Indicates whether all documents or none are returned if the analyzer removes all tokens, such as when using a stop filter. Defaults to none.'}, {name='boost', values=[2.5], description='Floating point number used to decrease or increase the relevance scores of the query. Defaults to 1.0.'}, {name='fuzzy_transpositions', values=[true, false], description='If true, edits for fuzzy matching include transpositions of two adjacent characters (ab → ba). Defaults to true.'}, {name='fuzzy_rewrite', values=[constant_score_blended, constant_score, constant_score_boolean, top_terms_blended_freqs_N, top_terms_boost_N, top_terms_N], description='Method used to rewrite the query. See the rewrite parameter for valid values and more information. If the fuzziness parameter is not 0, the match query uses a fuzzy_rewrite method of top_terms_blended_freqs_${max_expansions} by default.'}, {name='prefix_length', values=[1], description='Number of beginning characters left unchanged for fuzzy matching. Defaults to 0.'}, {name='lenient', values=[true, false], description='If false, format-based errors, such as providing a text query value for a numeric field, are returned. Defaults to false.'}, {name='operator', values=[AND, OR], description='Boolean logic used to interpret text in the query value. Defaults to OR.'}, {name='max_expansions', values=[50], description='Maximum number of terms to which the query will expand. Defaults to 50.'}",optional:true,constantOnly:true}],returnType:'boolean'},{params:[{name:'field',type:'keyword',optional:false,fieldsOnly:true},{name:'query',type:'keyword',optional:false,constantOnly:true},{name:'options',type:'function_named_parameters',mapParams:"{name='fuzziness', values=[AUTO, 1, 2], description='Maximum edit distance allowed for matching.'}, {name='auto_generate_synonyms_phrase_query', values=[true, false], description='If true, match phrase queries are automatically created for multi-term synonyms. Defaults to true.'}, {name='analyzer', values=[standard], description='Analyzer used to convert the text in the query value into token. Defaults to the index-time analyzer mapped for the field. If no analyzer is mapped, the index’s default analyzer is used.'}, {name='minimum_should_match', values=[2], description='Minimum number of clauses that must match for a document to be returned.'}, {name='zero_terms_query', values=[none, all], description='Indicates whether all documents or none are returned if the analyzer removes all tokens, such as when using a stop filter. Defaults to none.'}, {name='boost', values=[2.5], description='Floating point number used to decrease or increase the relevance scores of the query. Defaults to 1.0.'}, {name='fuzzy_transpositions', values=[true, false], description='If true, edits for fuzzy matching include transpositions of two adjacent characters (ab → ba). Defaults to true.'}, {name='fuzzy_rewrite', values=[constant_score_blended, constant_score, constant_score_boolean, top_terms_blended_freqs_N, top_terms_boost_N, top_terms_N], description='Method used to rewrite the query. See the rewrite parameter for valid values and more information. If the fuzziness parameter is not 0, the match query uses a fuzzy_rewrite method of top_terms_blended_freqs_${max_expansions} by default.'}, {name='prefix_length', values=[1], description='Number of beginning characters left unchanged for fuzzy matching. Defaults to 0.'}, {name='lenient', values=[true, false], description='If false, format-based errors, such as providing a text query value for a numeric field, are returned. Defaults to false.'}, {name='operator', values=[AND, OR], description='Boolean logic used to interpret text in the query value. Defaults to OR.'}, {name='max_expansions', values=[50], description='Maximum number of terms to which the query will expand. Defaults to 50.'}",optional:true,constantOnly:true}],returnType:'boolean'},{params:[{name:'field',type:'long',optional:false,fieldsOnly:true},{name:'query',type:'double',optional:false,constantOnly:true},{name:'options',type:'function_named_parameters',mapParams:"{name='fuzziness', values=[AUTO, 1, 2], description='Maximum edit distance allowed for matching.'}, {name='auto_generate_synonyms_phrase_query', values=[true, false], description='If true, match phrase queries are automatically created for multi-term synonyms. Defaults to true.'}, {name='analyzer', values=[standard], description='Analyzer used to convert the text in the query value into token. Defaults to the index-time analyzer mapped for the field. If no analyzer is mapped, the index’s default analyzer is used.'}, {name='minimum_should_match', values=[2], description='Minimum number of clauses that must match for a document to be returned.'}, {name='zero_terms_query', values=[none, all], description='Indicates whether all documents or none are returned if the analyzer removes all tokens, such as when using a stop filter. Defaults to none.'}, {name='boost', values=[2.5], description='Floating point number used to decrease or increase the relevance scores of the query. Defaults to 1.0.'}, {name='fuzzy_transpositions', values=[true, false], description='If true, edits for fuzzy matching include transpositions of two adjacent characters (ab → ba). Defaults to true.'}, {name='fuzzy_rewrite', values=[constant_score_blended, constant_score, constant_score_boolean, top_terms_blended_freqs_N, top_terms_boost_N, top_terms_N], description='Method used to rewrite the query. See the rewrite parameter for valid values and more information. If the fuzziness parameter is not 0, the match query uses a fuzzy_rewrite method of top_terms_blended_freqs_${max_expansions} by default.'}, {name='prefix_length', values=[1], description='Number of beginning characters left unchanged for fuzzy matching. Defaults to 0.'}, {name='lenient', values=[true, false], description='If false, format-based errors, such as providing a text query value for a numeric field, are returned. Defaults to false.'}, {name='operator', values=[AND, OR], description='Boolean logic used to interpret text in the query value. Defaults to OR.'}, {name='max_expansions', values=[50], description='Maximum number of terms to which the query will expand. Defaults to 50.'}",optional:true,constantOnly:true}],returnType:'boolean'},{params:[{name:'field',type:'long',optional:false,fieldsOnly:true},{name:'query',type:'integer',optional:false,constantOnly:true},{name:'options',type:'function_named_parameters',mapParams:"{name='fuzziness', values=[AUTO, 1, 2], description='Maximum edit distance allowed for matching.'}, {name='auto_generate_synonyms_phrase_query', values=[true, false], description='If true, match phrase queries are automatically created for multi-term synonyms. Defaults to true.'}, {name='analyzer', values=[standard], description='Analyzer used to convert the text in the query value into token. Defaults to the index-time analyzer mapped for the field. If no analyzer is mapped, the index’s default analyzer is used.'}, {name='minimum_should_match', values=[2], description='Minimum number of clauses that must match for a document to be returned.'}, {name='zero_terms_query', values=[none, all], description='Indicates whether all documents or none are returned if the analyzer removes all tokens, such as when using a stop filter. Defaults to none.'}, {name='boost', values=[2.5], description='Floating point number used to decrease or increase the relevance scores of the query. Defaults to 1.0.'}, {name='fuzzy_transpositions', values=[true, false], description='If true, edits for fuzzy matching include transpositions of two adjacent characters (ab → ba). Defaults to true.'}, {name='fuzzy_rewrite', values=[constant_score_blended, constant_score, constant_score_boolean, top_terms_blended_freqs_N, top_terms_boost_N, top_terms_N], description='Method used to rewrite the query. See the rewrite parameter for valid values and more information. If the fuzziness parameter is not 0, the match query uses a fuzzy_rewrite method of top_terms_blended_freqs_${max_expansions} by default.'}, {name='prefix_length', values=[1], description='Number of beginning characters left unchanged for fuzzy matching. Defaults to 0.'}, {name='lenient', values=[true, false], description='If false, format-based errors, such as providing a text query value for a numeric field, are returned. Defaults to false.'}, {name='operator', values=[AND, OR], description='Boolean logic used to interpret text in the query value. Defaults to OR.'}, {name='max_expansions', values=[50], description='Maximum number of terms to which the query will expand. Defaults to 50.'}",optional:true,constantOnly:true}],returnType:'boolean'},{params:[{name:'field',type:'long',optional:false,fieldsOnly:true},{name:'query',type:'keyword',optional:false,constantOnly:true},{name:'options',type:'function_named_parameters',mapParams:"{name='fuzziness', values=[AUTO, 1, 2], description='Maximum edit distance allowed for matching.'}, {name='auto_generate_synonyms_phrase_query', values=[true, false], description='If true, match phrase queries are automatically created for multi-term synonyms. Defaults to true.'}, {name='analyzer', values=[standard], description='Analyzer used to convert the text in the query value into token. Defaults to the index-time analyzer mapped for the field. If no analyzer is mapped, the index’s default analyzer is used.'}, {name='minimum_should_match', values=[2], description='Minimum number of clauses that must match for a document to be returned.'}, {name='zero_terms_query', values=[none, all], description='Indicates whether all documents or none are returned if the analyzer removes all tokens, such as when using a stop filter. Defaults to none.'}, {name='boost', values=[2.5], description='Floating point number used to decrease or increase the relevance scores of the query. Defaults to 1.0.'}, {name='fuzzy_transpositions', values=[true, false], description='If true, edits for fuzzy matching include transpositions of two adjacent characters (ab → ba). Defaults to true.'}, {name='fuzzy_rewrite', values=[constant_score_blended, constant_score, constant_score_boolean, top_terms_blended_freqs_N, top_terms_boost_N, top_terms_N], description='Method used to rewrite the query. See the rewrite parameter for valid values and more information. If the fuzziness parameter is not 0, the match query uses a fuzzy_rewrite method of top_terms_blended_freqs_${max_expansions} by default.'}, {name='prefix_length', values=[1], description='Number of beginning characters left unchanged for fuzzy matching. Defaults to 0.'}, {name='lenient', values=[true, false], description='If false, format-based errors, such as providing a text query value for a numeric field, are returned. Defaults to false.'}, {name='operator', values=[AND, OR], description='Boolean logic used to interpret text in the query value. Defaults to OR.'}, {name='max_expansions', values=[50], description='Maximum number of terms to which the query will expand. Defaults to 50.'}",optional:true,constantOnly:true}],returnType:'boolean'},{params:[{name:'field',type:'long',optional:false,fieldsOnly:true},{name:'query',type:'long',optional:false,constantOnly:true},{name:'options',type:'function_named_parameters',mapParams:"{name='fuzziness', values=[AUTO, 1, 2], description='Maximum edit distance allowed for matching.'}, {name='auto_generate_synonyms_phrase_query', values=[true, false], description='If true, match phrase queries are automatically created for multi-term synonyms. Defaults to true.'}, {name='analyzer', values=[standard], description='Analyzer used to convert the text in the query value into token. Defaults to the index-time analyzer mapped for the field. If no analyzer is mapped, the index’s default analyzer is used.'}, {name='minimum_should_match', values=[2], description='Minimum number of clauses that must match for a document to be returned.'}, {name='zero_terms_query', values=[none, all], description='Indicates whether all documents or none are returned if the analyzer removes all tokens, such as when using a stop filter. Defaults to none.'}, {name='boost', values=[2.5], description='Floating point number used to decrease or increase the relevance scores of the query. Defaults to 1.0.'}, {name='fuzzy_transpositions', values=[true, false], description='If true, edits for fuzzy matching include transpositions of two adjacent characters (ab → ba). Defaults to true.'}, {name='fuzzy_rewrite', values=[constant_score_blended, constant_score, constant_score_boolean, top_terms_blended_freqs_N, top_terms_boost_N, top_terms_N], description='Method used to rewrite the query. See the rewrite parameter for valid values and more information. If the fuzziness parameter is not 0, the match query uses a fuzzy_rewrite method of top_terms_blended_freqs_${max_expansions} by default.'}, {name='prefix_length', values=[1], description='Number of beginning characters left unchanged for fuzzy matching. Defaults to 0.'}, {name='lenient', values=[true, false], description='If false, format-based errors, such as providing a text query value for a numeric field, are returned. Defaults to false.'}, {name='operator', values=[AND, OR], description='Boolean logic used to interpret text in the query value. Defaults to OR.'}, {name='max_expansions', values=[50], description='Maximum number of terms to which the query will expand. Defaults to 50.'}",optional:true,constantOnly:true}],returnType:'boolean'},{params:[{name:'field',type:'text',optional:false,fieldsOnly:true},{name:'query',type:'keyword',optional:false,constantOnly:true},{name:'options',type:'function_named_parameters',mapParams:"{name='fuzziness', values=[AUTO, 1, 2], description='Maximum edit distance allowed for matching.'}, {name='auto_generate_synonyms_phrase_query', values=[true, false], description='If true, match phrase queries are automatically created for multi-term synonyms. Defaults to true.'}, {name='analyzer', values=[standard], description='Analyzer used to convert the text in the query value into token. Defaults to the index-time analyzer mapped for the field. If no analyzer is mapped, the index’s default analyzer is used.'}, {name='minimum_should_match', values=[2], description='Minimum number of clauses that must match for a document to be returned.'}, {name='zero_terms_query', values=[none, all], description='Indicates whether all documents or none are returned if the analyzer removes all tokens, such as when using a stop filter. Defaults to none.'}, {name='boost', values=[2.5], description='Floating point number used to decrease or increase the relevance scores of the query. Defaults to 1.0.'}, {name='fuzzy_transpositions', values=[true, false], description='If true, edits for fuzzy matching include transpositions of two adjacent characters (ab → ba). Defaults to true.'}, {name='fuzzy_rewrite', values=[constant_score_blended, constant_score, constant_score_boolean, top_terms_blended_freqs_N, top_terms_boost_N, top_terms_N], description='Method used to rewrite the query. See the rewrite parameter for valid values and more information. If the fuzziness parameter is not 0, the match query uses a fuzzy_rewrite method of top_terms_blended_freqs_${max_expansions} by default.'}, {name='prefix_length', values=[1], description='Number of beginning characters left unchanged for fuzzy matching. Defaults to 0.'}, {name='lenient', values=[true, false], description='If false, format-based errors, such as providing a text query value for a numeric field, are returned. Defaults to false.'}, {name='operator', values=[AND, OR], description='Boolean logic used to interpret text in the query value. Defaults to OR.'}, {name='max_expansions', values=[50], description='Maximum number of terms to which the query will expand. Defaults to 50.'}",optional:true,constantOnly:true}],returnType:'boolean'},{params:[{name:'field',type:'unsigned_long',optional:false,fieldsOnly:true},{name:'query',type:'double',optional:false,constantOnly:true},{name:'options',type:'function_named_parameters',mapParams:"{name='fuzziness', values=[AUTO, 1, 2], description='Maximum edit distance allowed for matching.'}, {name='auto_generate_synonyms_phrase_query', values=[true, false], description='If true, match phrase queries are automatically created for multi-term synonyms. Defaults to true.'}, {name='analyzer', values=[standard], description='Analyzer used to convert the text in the query value into token. Defaults to the index-time analyzer mapped for the field. If no analyzer is mapped, the index’s default analyzer is used.'}, {name='minimum_should_match', values=[2], description='Minimum number of clauses that must match for a document to be returned.'}, {name='zero_terms_query', values=[none, all], description='Indicates whether all documents or none are returned if the analyzer removes all tokens, such as when using a stop filter. Defaults to none.'}, {name='boost', values=[2.5], description='Floating point number used to decrease or increase the relevance scores of the query. Defaults to 1.0.'}, {name='fuzzy_transpositions', values=[true, false], description='If true, edits for fuzzy matching include transpositions of two adjacent characters (ab → ba). Defaults to true.'}, {name='fuzzy_rewrite', values=[constant_score_blended, constant_score, constant_score_boolean, top_terms_blended_freqs_N, top_terms_boost_N, top_terms_N], description='Method used to rewrite the query. See the rewrite parameter for valid values and more information. If the fuzziness parameter is not 0, the match query uses a fuzzy_rewrite method of top_terms_blended_freqs_${max_expansions} by default.'}, {name='prefix_length', values=[1], description='Number of beginning characters left unchanged for fuzzy matching. Defaults to 0.'}, {name='lenient', values=[true, false], description='If false, format-based errors, such as providing a text query value for a numeric field, are returned. Defaults to false.'}, {name='operator', values=[AND, OR], description='Boolean logic used to interpret text in the query value. Defaults to OR.'}, {name='max_expansions', values=[50], description='Maximum number of terms to which the query will expand. Defaults to 50.'}",optional:true,constantOnly:true}],returnType:'boolean'},{params:[{name:'field',type:'unsigned_long',optional:false,fieldsOnly:true},{name:'query',type:'integer',optional:false,constantOnly:true},{name:'options',type:'function_named_parameters',mapParams:"{name='fuzziness', values=[AUTO, 1, 2], description='Maximum edit distance allowed for matching.'}, {name='auto_generate_synonyms_phrase_query', values=[true, false], description='If true, match phrase queries are automatically created for multi-term synonyms. Defaults to true.'}, {name='analyzer', values=[standard], description='Analyzer used to convert the text in the query value into token. Defaults to the index-time analyzer mapped for the field. If no analyzer is mapped, the index’s default analyzer is used.'}, {name='minimum_should_match', values=[2], description='Minimum number of clauses that must match for a document to be returned.'}, {name='zero_terms_query', values=[none, all], description='Indicates whether all documents or none are returned if the analyzer removes all tokens, such as when using a stop filter. Defaults to none.'}, {name='boost', values=[2.5], description='Floating point number used to decrease or increase the relevance scores of the query. Defaults to 1.0.'}, {name='fuzzy_transpositions', values=[true, false], description='If true, edits for fuzzy matching include transpositions of two adjacent characters (ab → ba). Defaults to true.'}, {name='fuzzy_rewrite', values=[constant_score_blended, constant_score, constant_score_boolean, top_terms_blended_freqs_N, top_terms_boost_N, top_terms_N], description='Method used to rewrite the query. See the rewrite parameter for valid values and more information. If the fuzziness parameter is not 0, the match query uses a fuzzy_rewrite method of top_terms_blended_freqs_${max_expansions} by default.'}, {name='prefix_length', values=[1], description='Number of beginning characters left unchanged for fuzzy matching. Defaults to 0.'}, {name='lenient', values=[true, false], description='If false, format-based errors, such as providing a text query value for a numeric field, are returned. Defaults to false.'}, {name='operator', values=[AND, OR], description='Boolean logic used to interpret text in the query value. Defaults to OR.'}, {name='max_expansions', values=[50], description='Maximum number of terms to which the query will expand. Defaults to 50.'}",optional:true,constantOnly:true}],returnType:'boolean'},{params:[{name:'field',type:'unsigned_long',optional:false,fieldsOnly:true},{name:'query',type:'keyword',optional:false,constantOnly:true},{name:'options',type:'function_named_parameters',mapParams:"{name='fuzziness', values=[AUTO, 1, 2], description='Maximum edit distance allowed for matching.'}, {name='auto_generate_synonyms_phrase_query', values=[true, false], description='If true, match phrase queries are automatically created for multi-term synonyms. Defaults to true.'}, {name='analyzer', values=[standard], description='Analyzer used to convert the text in the query value into token. Defaults to the index-time analyzer mapped for the field. If no analyzer is mapped, the index’s default analyzer is used.'}, {name='minimum_should_match', values=[2], description='Minimum number of clauses that must match for a document to be returned.'}, {name='zero_terms_query', values=[none, all], description='Indicates whether all documents or none are returned if the analyzer removes all tokens, such as when using a stop filter. Defaults to none.'}, {name='boost', values=[2.5], description='Floating point number used to decrease or increase the relevance scores of the query. Defaults to 1.0.'}, {name='fuzzy_transpositions', values=[true, false], description='If true, edits for fuzzy matching include transpositions of two adjacent characters (ab → ba). Defaults to true.'}, {name='fuzzy_rewrite', values=[constant_score_blended, constant_score, constant_score_boolean, top_terms_blended_freqs_N, top_terms_boost_N, top_terms_N], description='Method used to rewrite the query. See the rewrite parameter for valid values and more information. If the fuzziness parameter is not 0, the match query uses a fuzzy_rewrite method of top_terms_blended_freqs_${max_expansions} by default.'}, {name='prefix_length', values=[1], description='Number of beginning characters left unchanged for fuzzy matching. Defaults to 0.'}, {name='lenient', values=[true, false], description='If false, format-based errors, such as providing a text query value for a numeric field, are returned. Defaults to false.'}, {name='operator', values=[AND, OR], description='Boolean logic used to interpret text in the query value. Defaults to OR.'}, {name='max_expansions', values=[50], description='Maximum number of terms to which the query will expand. Defaults to 50.'}",optional:true,constantOnly:true}],returnType:'boolean'},{params:[{name:'field',type:'unsigned_long',optional:false,fieldsOnly:true},{name:'query',type:'long',optional:false,constantOnly:true},{name:'options',type:'function_named_parameters',mapParams:"{name='fuzziness', values=[AUTO, 1, 2], description='Maximum edit distance allowed for matching.'}, {name='auto_generate_synonyms_phrase_query', values=[true, false], description='If true, match phrase queries are automatically created for multi-term synonyms. Defaults to true.'}, {name='analyzer', values=[standard], description='Analyzer used to convert the text in the query value into token. Defaults to the index-time analyzer mapped for the field. If no analyzer is mapped, the index’s default analyzer is used.'}, {name='minimum_should_match', values=[2], description='Minimum number of clauses that must match for a document to be returned.'}, {name='zero_terms_query', values=[none, all], description='Indicates whether all documents or none are returned if the analyzer removes all tokens, such as when using a stop filter. Defaults to none.'}, {name='boost', values=[2.5], description='Floating point number used to decrease or increase the relevance scores of the query. Defaults to 1.0.'}, {name='fuzzy_transpositions', values=[true, false], description='If true, edits for fuzzy matching include transpositions of two adjacent characters (ab → ba). Defaults to true.'}, {name='fuzzy_rewrite', values=[constant_score_blended, constant_score, constant_score_boolean, top_terms_blended_freqs_N, top_terms_boost_N, top_terms_N], description='Method used to rewrite the query. See the rewrite parameter for valid values and more information. If the fuzziness parameter is not 0, the match query uses a fuzzy_rewrite method of top_terms_blended_freqs_${max_expansions} by default.'}, {name='prefix_length', values=[1], description='Number of beginning characters left unchanged for fuzzy matching. Defaults to 0.'}, {name='lenient', values=[true, false], description='If false, format-based errors, such as providing a text query value for a numeric field, are returned. Defaults to false.'}, {name='operator', values=[AND, OR], description='Boolean logic used to interpret text in the query value. Defaults to OR.'}, {name='max_expansions', values=[50], description='Maximum number of terms to which the query will expand. Defaults to 50.'}",optional:true,constantOnly:true}],returnType:'boolean'},{params:[{name:'field',type:'unsigned_long',optional:false,fieldsOnly:true},{name:'query',type:'unsigned_long',optional:false,constantOnly:true},{name:'options',type:'function_named_parameters',mapParams:"{name='fuzziness', values=[AUTO, 1, 2], description='Maximum edit distance allowed for matching.'}, {name='auto_generate_synonyms_phrase_query', values=[true, false], description='If true, match phrase queries are automatically created for multi-term synonyms. Defaults to true.'}, {name='analyzer', values=[standard], description='Analyzer used to convert the text in the query value into token. Defaults to the index-time analyzer mapped for the field. If no analyzer is mapped, the index’s default analyzer is used.'}, {name='minimum_should_match', values=[2], description='Minimum number of clauses that must match for a document to be returned.'}, {name='zero_terms_query', values=[none, all], description='Indicates whether all documents or none are returned if the analyzer removes all tokens, such as when using a stop filter. Defaults to none.'}, {name='boost', values=[2.5], description='Floating point number used to decrease or increase the relevance scores of the query. Defaults to 1.0.'}, {name='fuzzy_transpositions', values=[true, false], description='If true, edits for fuzzy matching include transpositions of two adjacent characters (ab → ba). Defaults to true.'}, {name='fuzzy_rewrite', values=[constant_score_blended, constant_score, constant_score_boolean, top_terms_blended_freqs_N, top_terms_boost_N, top_terms_N], description='Method used to rewrite the query. See the rewrite parameter for valid values and more information. If the fuzziness parameter is not 0, the match query uses a fuzzy_rewrite method of top_terms_blended_freqs_${max_expansions} by default.'}, {name='prefix_length', values=[1], description='Number of beginning characters left unchanged for fuzzy matching. Defaults to 0.'}, {name='lenient', values=[true, false], description='If false, format-based errors, such as providing a text query value for a numeric field, are returned. Defaults to false.'}, {name='operator', values=[AND, OR], description='Boolean logic used to interpret text in the query value. Defaults to OR.'}, {name='max_expansions', values=[50], description='Maximum number of terms to which the query will expand. Defaults to 50.'}",optional:true,constantOnly:true}],returnType:'boolean'},{params:[{name:'field',type:'version',optional:false,fieldsOnly:true},{name:'query',type:'keyword',optional:false,constantOnly:true},{name:'options',type:'function_named_parameters',mapParams:"{name='fuzziness', values=[AUTO, 1, 2], description='Maximum edit distance allowed for matching.'}, {name='auto_generate_synonyms_phrase_query', values=[true, false], description='If true, match phrase queries are automatically created for multi-term synonyms. Defaults to true.'}, {name='analyzer', values=[standard], description='Analyzer used to convert the text in the query value into token. Defaults to the index-time analyzer mapped for the field. If no analyzer is mapped, the index’s default analyzer is used.'}, {name='minimum_should_match', values=[2], description='Minimum number of clauses that must match for a document to be returned.'}, {name='zero_terms_query', values=[none, all], description='Indicates whether all documents or none are returned if the analyzer removes all tokens, such as when using a stop filter. Defaults to none.'}, {name='boost', values=[2.5], description='Floating point number used to decrease or increase the relevance scores of the query. Defaults to 1.0.'}, {name='fuzzy_transpositions', values=[true, false], description='If true, edits for fuzzy matching include transpositions of two adjacent characters (ab → ba). Defaults to true.'}, {name='fuzzy_rewrite', values=[constant_score_blended, constant_score, constant_score_boolean, top_terms_blended_freqs_N, top_terms_boost_N, top_terms_N], description='Method used to rewrite the query. See the rewrite parameter for valid values and more information. If the fuzziness parameter is not 0, the match query uses a fuzzy_rewrite method of top_terms_blended_freqs_${max_expansions} by default.'}, {name='prefix_length', values=[1], description='Number of beginning characters left unchanged for fuzzy matching. Defaults to 0.'}, {name='lenient', values=[true, false], description='If false, format-based errors, such as providing a text query value for a numeric field, are returned. Defaults to false.'}, {name='operator', values=[AND, OR], description='Boolean logic used to interpret text in the query value. Defaults to OR.'}, {name='max_expansions', values=[50], description='Maximum number of terms to which the query will expand. Defaults to 50.'}",optional:true,constantOnly:true}],returnType:'boolean'},{params:[{name:'field',type:'version',optional:false,fieldsOnly:true},{name:'query',type:'version',optional:false,constantOnly:true},{name:'options',type:'function_named_parameters',mapParams:"{name='fuzziness', values=[AUTO, 1, 2], description='Maximum edit distance allowed for matching.'}, {name='auto_generate_synonyms_phrase_query', values=[true, false], description='If true, match phrase queries are automatically created for multi-term synonyms. Defaults to true.'}, {name='analyzer', values=[standard], description='Analyzer used to convert the text in the query value into token. Defaults to the index-time analyzer mapped for the field. If no analyzer is mapped, the index’s default analyzer is used.'}, {name='minimum_should_match', values=[2], description='Minimum number of clauses that must match for a document to be returned.'}, {name='zero_terms_query', values=[none, all], description='Indicates whether all documents or none are returned if the analyzer removes all tokens, such as when using a stop filter. Defaults to none.'}, {name='boost', values=[2.5], description='Floating point number used to decrease or increase the relevance scores of the query. Defaults to 1.0.'}, {name='fuzzy_transpositions', values=[true, false], description='If true, edits for fuzzy matching include transpositions of two adjacent characters (ab → ba). Defaults to true.'}, {name='fuzzy_rewrite', values=[constant_score_blended, constant_score, constant_score_boolean, top_terms_blended_freqs_N, top_terms_boost_N, top_terms_N], description='Method used to rewrite the query. See the rewrite parameter for valid values and more information. If the fuzziness parameter is not 0, the match query uses a fuzzy_rewrite method of top_terms_blended_freqs_${max_expansions} by default.'}, {name='prefix_length', values=[1], description='Number of beginning characters left unchanged for fuzzy matching. Defaults to 0.'}, {name='lenient', values=[true, false], description='If false, format-based errors, such as providing a text query value for a numeric field, are returned. Defaults to false.'}, {name='operator', values=[AND, OR], description='Boolean logic used to interpret text in the query value. Defaults to OR.'}, {name='max_expansions', values=[50], description='Maximum number of terms to which the query will expand. Defaults to 50.'}",optional:true,constantOnly:true}],returnType:'boolean'}],locationsAvailable:[_types.Location.WHERE,_types.Location.STATS_WHERE],examples:['FROM books\n| WHERE MATCH(author, "Faulkner")','FROM books\n| WHERE MATCH(title, "Hobbit Back Again", {"operator": "AND"})\n| KEEP title;']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const matchPhraseDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'match_phrase',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.match_phrase',{defaultMessage:'Use `MATCH_PHRASE` to perform a `match_phrase` on the\nspecified field.\nUsing `MATCH_PHRASE` is equivalent to using the `match_phrase` query in the Elasticsearch Query DSL.'}),preview:false,alias:undefined,signatures:[{params:[{name:'field',type:'keyword',optional:false},{name:'query',type:'keyword',optional:false},{name:'options',type:'function_named_parameters',mapParams:"{name='zero_terms_query', values=[none, all], description='Indicates whether all documents or none are returned if the analyzer removes all tokens, such as when using a stop filter. Defaults to none.'}, {name='boost', values=[2.5], description='Floating point number used to decrease or increase the relevance scores of the query. Defaults to 1.0.'}, {name='analyzer', values=[standard], description='Analyzer used to convert the text in the query value into token. Defaults to the index-time analyzer mapped for the field. If no analyzer is mapped, the index’s default analyzer is used.'}, {name='slop', values=[1], description='Maximum number of positions allowed between matching tokens. Defaults to 0. Transposed terms have a slop of 2.'}",optional:true}],returnType:'boolean'},{params:[{name:'field',type:'text',optional:false},{name:'query',type:'keyword',optional:false},{name:'options',type:'function_named_parameters',mapParams:"{name='zero_terms_query', values=[none, all], description='Indicates whether all documents or none are returned if the analyzer removes all tokens, such as when using a stop filter. Defaults to none.'}, {name='boost', values=[2.5], description='Floating point number used to decrease or increase the relevance scores of the query. Defaults to 1.0.'}, {name='analyzer', values=[standard], description='Analyzer used to convert the text in the query value into token. Defaults to the index-time analyzer mapped for the field. If no analyzer is mapped, the index’s default analyzer is used.'}, {name='slop', values=[1], description='Maximum number of positions allowed between matching tokens. Defaults to 0. Transposed terms have a slop of 2.'}",optional:true}],returnType:'boolean'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['FROM books\n| WHERE MATCH_PHRASE(author, "William Faulkner")']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const md5Definition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'md5',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.md5',{defaultMessage:'Computes the MD5 hash of the input (if the MD5 hash is available on the JVM).'}),preview:false,alias:undefined,signatures:[{params:[{name:'input',type:'keyword',optional:false}],returnType:'keyword'},{params:[{name:'input',type:'text',optional:false}],returnType:'keyword'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['FROM sample_data\n| WHERE message != "Connection error"\n| EVAL md5 = md5(message)\n| KEEP message, md5']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const monthNameDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'month_name',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.month_name',{defaultMessage:'Returns the month name for the provided date based on the configured Locale.'}),preview:false,alias:undefined,signatures:[{params:[{name:'date',type:'date',optional:false}],returnType:'keyword'},{params:[{name:'date',type:'date_nanos',optional:false}],returnType:'keyword'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW dt = to_datetime("1996-03-21T00:00:00.000Z")\n| EVAL monthName = MONTH_NAME(dt);']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const multiMatchDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'multi_match',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.multi_match',{defaultMessage:'Use `MULTI_MATCH` to perform a multi-match query on the specified field.\nThe multi_match query builds on the match query to allow multi-field queries.'}),preview:true,alias:undefined,signatures:[{params:[{name:'query',type:'boolean',optional:false},{name:'fields',type:'boolean',optional:false},{name:'options',type:'function_named_parameters',mapParams:"{name='fuzziness', values=[AUTO, 1, 2], description='Maximum edit distance allowed for matching.'}, {name='auto_generate_synonyms_phrase_query', values=[true, false], description='If true, match phrase queries are automatically created for multi-term synonyms. Defaults to true.'}, {name='minimum_should_match', values=[2], description='Minimum number of clauses that must match for a document to be returned.'}, {name='fuzzy_transpositions', values=[true, false], description='If true, edits for fuzzy matching include transpositions of two adjacent characters (ab → ba). Defaults to true.'}, {name='tie_breaker', values=[0], description='Controls how score is blended together between field groups. Defaults to 0 (best score from each group).'}, {name='type', values=['best_fields'], description='Controls the way multi_match is executed internally. Can be one of `best_fields`, `most_fields`, `cross_fields`, `phrase`, `phrase_prefix` or `bool_prefix`. Defaults to 'best_fields'. See <<multi-match-types,multi_match types>>.'}, {name='lenient', values=[true, false], description='If false, format-based errors, such as providing a text query value for a numeric field, are returned. Defaults to true.'}, {name='operator', values=[AND, OR], description='Boolean logic used to interpret text in the query value. Defaults to OR.'}, {name='max_expansions', values=[50], description='Maximum number of terms to which the query will expand. Defaults to 50.'}, {name='analyzer', values=[standard], description='Analyzer used to convert the text in the query value into token. Defaults to the index-time analyzer mapped for the field. If no analyzer is mapped, the index’s default analyzer is used.'}, {name='boost', values=[2.5], description='Floating point number used to decrease or increase the relevance scores of the query.'}, {name='fuzzy_rewrite', values=[constant_score_blended, constant_score, constant_score_boolean, top_terms_blended_freqs_N, top_terms_boost_N, top_terms_N], description='Method used to rewrite the query. See the rewrite parameter for valid values and more information. If the fuzziness parameter is not 0, the match query uses a fuzzy_rewrite method of top_terms_blended_freqs_${max_expansions} by default.'}, {name='prefix_length', values=[1], description='Number of beginning characters left unchanged for fuzzy matching. Defaults to 0.'}",optional:true}],returnType:'boolean',minParams:2},{params:[{name:'query',type:'boolean',optional:false},{name:'fields',type:'keyword',optional:false},{name:'options',type:'function_named_parameters',mapParams:"{name='fuzziness', values=[AUTO, 1, 2], description='Maximum edit distance allowed for matching.'}, {name='auto_generate_synonyms_phrase_query', values=[true, false], description='If true, match phrase queries are automatically created for multi-term synonyms. Defaults to true.'}, {name='minimum_should_match', values=[2], description='Minimum number of clauses that must match for a document to be returned.'}, {name='fuzzy_transpositions', values=[true, false], description='If true, edits for fuzzy matching include transpositions of two adjacent characters (ab → ba). Defaults to true.'}, {name='tie_breaker', values=[0], description='Controls how score is blended together between field groups. Defaults to 0 (best score from each group).'}, {name='type', values=['best_fields'], description='Controls the way multi_match is executed internally. Can be one of `best_fields`, `most_fields`, `cross_fields`, `phrase`, `phrase_prefix` or `bool_prefix`. Defaults to 'best_fields'. See <<multi-match-types,multi_match types>>.'}, {name='lenient', values=[true, false], description='If false, format-based errors, such as providing a text query value for a numeric field, are returned. Defaults to true.'}, {name='operator', values=[AND, OR], description='Boolean logic used to interpret text in the query value. Defaults to OR.'}, {name='max_expansions', values=[50], description='Maximum number of terms to which the query will expand. Defaults to 50.'}, {name='analyzer', values=[standard], description='Analyzer used to convert the text in the query value into token. Defaults to the index-time analyzer mapped for the field. If no analyzer is mapped, the index’s default analyzer is used.'}, {name='boost', values=[2.5], description='Floating point number used to decrease or increase the relevance scores of the query.'}, {name='fuzzy_rewrite', values=[constant_score_blended, constant_score, constant_score_boolean, top_terms_blended_freqs_N, top_terms_boost_N, top_terms_N], description='Method used to rewrite the query. See the rewrite parameter for valid values and more information. If the fuzziness parameter is not 0, the match query uses a fuzzy_rewrite method of top_terms_blended_freqs_${max_expansions} by default.'}, {name='prefix_length', values=[1], description='Number of beginning characters left unchanged for fuzzy matching. Defaults to 0.'}",optional:true}],returnType:'boolean',minParams:2},{params:[{name:'query',type:'date',optional:false},{name:'fields',type:'date',optional:false},{name:'options',type:'function_named_parameters',mapParams:"{name='fuzziness', values=[AUTO, 1, 2], description='Maximum edit distance allowed for matching.'}, {name='auto_generate_synonyms_phrase_query', values=[true, false], description='If true, match phrase queries are automatically created for multi-term synonyms. Defaults to true.'}, {name='minimum_should_match', values=[2], description='Minimum number of clauses that must match for a document to be returned.'}, {name='fuzzy_transpositions', values=[true, false], description='If true, edits for fuzzy matching include transpositions of two adjacent characters (ab → ba). Defaults to true.'}, {name='tie_breaker', values=[0], description='Controls how score is blended together between field groups. Defaults to 0 (best score from each group).'}, {name='type', values=['best_fields'], description='Controls the way multi_match is executed internally. Can be one of `best_fields`, `most_fields`, `cross_fields`, `phrase`, `phrase_prefix` or `bool_prefix`. Defaults to 'best_fields'. See <<multi-match-types,multi_match types>>.'}, {name='lenient', values=[true, false], description='If false, format-based errors, such as providing a text query value for a numeric field, are returned. Defaults to true.'}, {name='operator', values=[AND, OR], description='Boolean logic used to interpret text in the query value. Defaults to OR.'}, {name='max_expansions', values=[50], description='Maximum number of terms to which the query will expand. Defaults to 50.'}, {name='analyzer', values=[standard], description='Analyzer used to convert the text in the query value into token. Defaults to the index-time analyzer mapped for the field. If no analyzer is mapped, the index’s default analyzer is used.'}, {name='boost', values=[2.5], description='Floating point number used to decrease or increase the relevance scores of the query.'}, {name='fuzzy_rewrite', values=[constant_score_blended, constant_score, constant_score_boolean, top_terms_blended_freqs_N, top_terms_boost_N, top_terms_N], description='Method used to rewrite the query. See the rewrite parameter for valid values and more information. If the fuzziness parameter is not 0, the match query uses a fuzzy_rewrite method of top_terms_blended_freqs_${max_expansions} by default.'}, {name='prefix_length', values=[1], description='Number of beginning characters left unchanged for fuzzy matching. Defaults to 0.'}",optional:true}],returnType:'boolean',minParams:2},{params:[{name:'query',type:'date',optional:false},{name:'fields',type:'keyword',optional:false},{name:'options',type:'function_named_parameters',mapParams:"{name='fuzziness', values=[AUTO, 1, 2], description='Maximum edit distance allowed for matching.'}, {name='auto_generate_synonyms_phrase_query', values=[true, false], description='If true, match phrase queries are automatically created for multi-term synonyms. Defaults to true.'}, {name='minimum_should_match', values=[2], description='Minimum number of clauses that must match for a document to be returned.'}, {name='fuzzy_transpositions', values=[true, false], description='If true, edits for fuzzy matching include transpositions of two adjacent characters (ab → ba). Defaults to true.'}, {name='tie_breaker', values=[0], description='Controls how score is blended together between field groups. Defaults to 0 (best score from each group).'}, {name='type', values=['best_fields'], description='Controls the way multi_match is executed internally. Can be one of `best_fields`, `most_fields`, `cross_fields`, `phrase`, `phrase_prefix` or `bool_prefix`. Defaults to 'best_fields'. See <<multi-match-types,multi_match types>>.'}, {name='lenient', values=[true, false], description='If false, format-based errors, such as providing a text query value for a numeric field, are returned. Defaults to true.'}, {name='operator', values=[AND, OR], description='Boolean logic used to interpret text in the query value. Defaults to OR.'}, {name='max_expansions', values=[50], description='Maximum number of terms to which the query will expand. Defaults to 50.'}, {name='analyzer', values=[standard], description='Analyzer used to convert the text in the query value into token. Defaults to the index-time analyzer mapped for the field. If no analyzer is mapped, the index’s default analyzer is used.'}, {name='boost', values=[2.5], description='Floating point number used to decrease or increase the relevance scores of the query.'}, {name='fuzzy_rewrite', values=[constant_score_blended, constant_score, constant_score_boolean, top_terms_blended_freqs_N, top_terms_boost_N, top_terms_N], description='Method used to rewrite the query. See the rewrite parameter for valid values and more information. If the fuzziness parameter is not 0, the match query uses a fuzzy_rewrite method of top_terms_blended_freqs_${max_expansions} by default.'}, {name='prefix_length', values=[1], description='Number of beginning characters left unchanged for fuzzy matching. Defaults to 0.'}",optional:true}],returnType:'boolean',minParams:2},{params:[{name:'query',type:'date_nanos',optional:false},{name:'fields',type:'date_nanos',optional:false},{name:'options',type:'function_named_parameters',mapParams:"{name='fuzziness', values=[AUTO, 1, 2], description='Maximum edit distance allowed for matching.'}, {name='auto_generate_synonyms_phrase_query', values=[true, false], description='If true, match phrase queries are automatically created for multi-term synonyms. Defaults to true.'}, {name='minimum_should_match', values=[2], description='Minimum number of clauses that must match for a document to be returned.'}, {name='fuzzy_transpositions', values=[true, false], description='If true, edits for fuzzy matching include transpositions of two adjacent characters (ab → ba). Defaults to true.'}, {name='tie_breaker', values=[0], description='Controls how score is blended together between field groups. Defaults to 0 (best score from each group).'}, {name='type', values=['best_fields'], description='Controls the way multi_match is executed internally. Can be one of `best_fields`, `most_fields`, `cross_fields`, `phrase`, `phrase_prefix` or `bool_prefix`. Defaults to 'best_fields'. See <<multi-match-types,multi_match types>>.'}, {name='lenient', values=[true, false], description='If false, format-based errors, such as providing a text query value for a numeric field, are returned. Defaults to true.'}, {name='operator', values=[AND, OR], description='Boolean logic used to interpret text in the query value. Defaults to OR.'}, {name='max_expansions', values=[50], description='Maximum number of terms to which the query will expand. Defaults to 50.'}, {name='analyzer', values=[standard], description='Analyzer used to convert the text in the query value into token. Defaults to the index-time analyzer mapped for the field. If no analyzer is mapped, the index’s default analyzer is used.'}, {name='boost', values=[2.5], description='Floating point number used to decrease or increase the relevance scores of the query.'}, {name='fuzzy_rewrite', values=[constant_score_blended, constant_score, constant_score_boolean, top_terms_blended_freqs_N, top_terms_boost_N, top_terms_N], description='Method used to rewrite the query. See the rewrite parameter for valid values and more information. If the fuzziness parameter is not 0, the match query uses a fuzzy_rewrite method of top_terms_blended_freqs_${max_expansions} by default.'}, {name='prefix_length', values=[1], description='Number of beginning characters left unchanged for fuzzy matching. Defaults to 0.'}",optional:true}],returnType:'boolean',minParams:2},{params:[{name:'query',type:'date_nanos',optional:false},{name:'fields',type:'keyword',optional:false},{name:'options',type:'function_named_parameters',mapParams:"{name='fuzziness', values=[AUTO, 1, 2], description='Maximum edit distance allowed for matching.'}, {name='auto_generate_synonyms_phrase_query', values=[true, false], description='If true, match phrase queries are automatically created for multi-term synonyms. Defaults to true.'}, {name='minimum_should_match', values=[2], description='Minimum number of clauses that must match for a document to be returned.'}, {name='fuzzy_transpositions', values=[true, false], description='If true, edits for fuzzy matching include transpositions of two adjacent characters (ab → ba). Defaults to true.'}, {name='tie_breaker', values=[0], description='Controls how score is blended together between field groups. Defaults to 0 (best score from each group).'}, {name='type', values=['best_fields'], description='Controls the way multi_match is executed internally. Can be one of `best_fields`, `most_fields`, `cross_fields`, `phrase`, `phrase_prefix` or `bool_prefix`. Defaults to 'best_fields'. See <<multi-match-types,multi_match types>>.'}, {name='lenient', values=[true, false], description='If false, format-based errors, such as providing a text query value for a numeric field, are returned. Defaults to true.'}, {name='operator', values=[AND, OR], description='Boolean logic used to interpret text in the query value. Defaults to OR.'}, {name='max_expansions', values=[50], description='Maximum number of terms to which the query will expand. Defaults to 50.'}, {name='analyzer', values=[standard], description='Analyzer used to convert the text in the query value into token. Defaults to the index-time analyzer mapped for the field. If no analyzer is mapped, the index’s default analyzer is used.'}, {name='boost', values=[2.5], description='Floating point number used to decrease or increase the relevance scores of the query.'}, {name='fuzzy_rewrite', values=[constant_score_blended, constant_score, constant_score_boolean, top_terms_blended_freqs_N, top_terms_boost_N, top_terms_N], description='Method used to rewrite the query. See the rewrite parameter for valid values and more information. If the fuzziness parameter is not 0, the match query uses a fuzzy_rewrite method of top_terms_blended_freqs_${max_expansions} by default.'}, {name='prefix_length', values=[1], description='Number of beginning characters left unchanged for fuzzy matching. Defaults to 0.'}",optional:true}],returnType:'boolean',minParams:2},{params:[{name:'query',type:'double',optional:false},{name:'fields',type:'double',optional:false},{name:'options',type:'function_named_parameters',mapParams:"{name='fuzziness', values=[AUTO, 1, 2], description='Maximum edit distance allowed for matching.'}, {name='auto_generate_synonyms_phrase_query', values=[true, false], description='If true, match phrase queries are automatically created for multi-term synonyms. Defaults to true.'}, {name='minimum_should_match', values=[2], description='Minimum number of clauses that must match for a document to be returned.'}, {name='fuzzy_transpositions', values=[true, false], description='If true, edits for fuzzy matching include transpositions of two adjacent characters (ab → ba). Defaults to true.'}, {name='tie_breaker', values=[0], description='Controls how score is blended together between field groups. Defaults to 0 (best score from each group).'}, {name='type', values=['best_fields'], description='Controls the way multi_match is executed internally. Can be one of `best_fields`, `most_fields`, `cross_fields`, `phrase`, `phrase_prefix` or `bool_prefix`. Defaults to 'best_fields'. See <<multi-match-types,multi_match types>>.'}, {name='lenient', values=[true, false], description='If false, format-based errors, such as providing a text query value for a numeric field, are returned. Defaults to true.'}, {name='operator', values=[AND, OR], description='Boolean logic used to interpret text in the query value. Defaults to OR.'}, {name='max_expansions', values=[50], description='Maximum number of terms to which the query will expand. Defaults to 50.'}, {name='analyzer', values=[standard], description='Analyzer used to convert the text in the query value into token. Defaults to the index-time analyzer mapped for the field. If no analyzer is mapped, the index’s default analyzer is used.'}, {name='boost', values=[2.5], description='Floating point number used to decrease or increase the relevance scores of the query.'}, {name='fuzzy_rewrite', values=[constant_score_blended, constant_score, constant_score_boolean, top_terms_blended_freqs_N, top_terms_boost_N, top_terms_N], description='Method used to rewrite the query. See the rewrite parameter for valid values and more information. If the fuzziness parameter is not 0, the match query uses a fuzzy_rewrite method of top_terms_blended_freqs_${max_expansions} by default.'}, {name='prefix_length', values=[1], description='Number of beginning characters left unchanged for fuzzy matching. Defaults to 0.'}",optional:true}],returnType:'boolean',minParams:2},{params:[{name:'query',type:'double',optional:false},{name:'fields',type:'integer',optional:false},{name:'options',type:'function_named_parameters',mapParams:"{name='fuzziness', values=[AUTO, 1, 2], description='Maximum edit distance allowed for matching.'}, {name='auto_generate_synonyms_phrase_query', values=[true, false], description='If true, match phrase queries are automatically created for multi-term synonyms. Defaults to true.'}, {name='minimum_should_match', values=[2], description='Minimum number of clauses that must match for a document to be returned.'}, {name='fuzzy_transpositions', values=[true, false], description='If true, edits for fuzzy matching include transpositions of two adjacent characters (ab → ba). Defaults to true.'}, {name='tie_breaker', values=[0], description='Controls how score is blended together between field groups. Defaults to 0 (best score from each group).'}, {name='type', values=['best_fields'], description='Controls the way multi_match is executed internally. Can be one of `best_fields`, `most_fields`, `cross_fields`, `phrase`, `phrase_prefix` or `bool_prefix`. Defaults to 'best_fields'. See <<multi-match-types,multi_match types>>.'}, {name='lenient', values=[true, false], description='If false, format-based errors, such as providing a text query value for a numeric field, are returned. Defaults to true.'}, {name='operator', values=[AND, OR], description='Boolean logic used to interpret text in the query value. Defaults to OR.'}, {name='max_expansions', values=[50], description='Maximum number of terms to which the query will expand. Defaults to 50.'}, {name='analyzer', values=[standard], description='Analyzer used to convert the text in the query value into token. Defaults to the index-time analyzer mapped for the field. If no analyzer is mapped, the index’s default analyzer is used.'}, {name='boost', values=[2.5], description='Floating point number used to decrease or increase the relevance scores of the query.'}, {name='fuzzy_rewrite', values=[constant_score_blended, constant_score, constant_score_boolean, top_terms_blended_freqs_N, top_terms_boost_N, top_terms_N], description='Method used to rewrite the query. See the rewrite parameter for valid values and more information. If the fuzziness parameter is not 0, the match query uses a fuzzy_rewrite method of top_terms_blended_freqs_${max_expansions} by default.'}, {name='prefix_length', values=[1], description='Number of beginning characters left unchanged for fuzzy matching. Defaults to 0.'}",optional:true}],returnType:'boolean',minParams:2},{params:[{name:'query',type:'double',optional:false},{name:'fields',type:'keyword',optional:false},{name:'options',type:'function_named_parameters',mapParams:"{name='fuzziness', values=[AUTO, 1, 2], description='Maximum edit distance allowed for matching.'}, {name='auto_generate_synonyms_phrase_query', values=[true, false], description='If true, match phrase queries are automatically created for multi-term synonyms. Defaults to true.'}, {name='minimum_should_match', values=[2], description='Minimum number of clauses that must match for a document to be returned.'}, {name='fuzzy_transpositions', values=[true, false], description='If true, edits for fuzzy matching include transpositions of two adjacent characters (ab → ba). Defaults to true.'}, {name='tie_breaker', values=[0], description='Controls how score is blended together between field groups. Defaults to 0 (best score from each group).'}, {name='type', values=['best_fields'], description='Controls the way multi_match is executed internally. Can be one of `best_fields`, `most_fields`, `cross_fields`, `phrase`, `phrase_prefix` or `bool_prefix`. Defaults to 'best_fields'. See <<multi-match-types,multi_match types>>.'}, {name='lenient', values=[true, false], description='If false, format-based errors, such as providing a text query value for a numeric field, are returned. Defaults to true.'}, {name='operator', values=[AND, OR], description='Boolean logic used to interpret text in the query value. Defaults to OR.'}, {name='max_expansions', values=[50], description='Maximum number of terms to which the query will expand. Defaults to 50.'}, {name='analyzer', values=[standard], description='Analyzer used to convert the text in the query value into token. Defaults to the index-time analyzer mapped for the field. If no analyzer is mapped, the index’s default analyzer is used.'}, {name='boost', values=[2.5], description='Floating point number used to decrease or increase the relevance scores of the query.'}, {name='fuzzy_rewrite', values=[constant_score_blended, constant_score, constant_score_boolean, top_terms_blended_freqs_N, top_terms_boost_N, top_terms_N], description='Method used to rewrite the query. See the rewrite parameter for valid values and more information. If the fuzziness parameter is not 0, the match query uses a fuzzy_rewrite method of top_terms_blended_freqs_${max_expansions} by default.'}, {name='prefix_length', values=[1], description='Number of beginning characters left unchanged for fuzzy matching. Defaults to 0.'}",optional:true}],returnType:'boolean',minParams:2},{params:[{name:'query',type:'double',optional:false},{name:'fields',type:'long',optional:false},{name:'options',type:'function_named_parameters',mapParams:"{name='fuzziness', values=[AUTO, 1, 2], description='Maximum edit distance allowed for matching.'}, {name='auto_generate_synonyms_phrase_query', values=[true, false], description='If true, match phrase queries are automatically created for multi-term synonyms. Defaults to true.'}, {name='minimum_should_match', values=[2], description='Minimum number of clauses that must match for a document to be returned.'}, {name='fuzzy_transpositions', values=[true, false], description='If true, edits for fuzzy matching include transpositions of two adjacent characters (ab → ba). Defaults to true.'}, {name='tie_breaker', values=[0], description='Controls how score is blended together between field groups. Defaults to 0 (best score from each group).'}, {name='type', values=['best_fields'], description='Controls the way multi_match is executed internally. Can be one of `best_fields`, `most_fields`, `cross_fields`, `phrase`, `phrase_prefix` or `bool_prefix`. Defaults to 'best_fields'. See <<multi-match-types,multi_match types>>.'}, {name='lenient', values=[true, false], description='If false, format-based errors, such as providing a text query value for a numeric field, are returned. Defaults to true.'}, {name='operator', values=[AND, OR], description='Boolean logic used to interpret text in the query value. Defaults to OR.'}, {name='max_expansions', values=[50], description='Maximum number of terms to which the query will expand. Defaults to 50.'}, {name='analyzer', values=[standard], description='Analyzer used to convert the text in the query value into token. Defaults to the index-time analyzer mapped for the field. If no analyzer is mapped, the index’s default analyzer is used.'}, {name='boost', values=[2.5], description='Floating point number used to decrease or increase the relevance scores of the query.'}, {name='fuzzy_rewrite', values=[constant_score_blended, constant_score, constant_score_boolean, top_terms_blended_freqs_N, top_terms_boost_N, top_terms_N], description='Method used to rewrite the query. See the rewrite parameter for valid values and more information. If the fuzziness parameter is not 0, the match query uses a fuzzy_rewrite method of top_terms_blended_freqs_${max_expansions} by default.'}, {name='prefix_length', values=[1], description='Number of beginning characters left unchanged for fuzzy matching. Defaults to 0.'}",optional:true}],returnType:'boolean',minParams:2},{params:[{name:'query',type:'integer',optional:false},{name:'fields',type:'double',optional:false},{name:'options',type:'function_named_parameters',mapParams:"{name='fuzziness', values=[AUTO, 1, 2], description='Maximum edit distance allowed for matching.'}, {name='auto_generate_synonyms_phrase_query', values=[true, false], description='If true, match phrase queries are automatically created for multi-term synonyms. Defaults to true.'}, {name='minimum_should_match', values=[2], description='Minimum number of clauses that must match for a document to be returned.'}, {name='fuzzy_transpositions', values=[true, false], description='If true, edits for fuzzy matching include transpositions of two adjacent characters (ab → ba). Defaults to true.'}, {name='tie_breaker', values=[0], description='Controls how score is blended together between field groups. Defaults to 0 (best score from each group).'}, {name='type', values=['best_fields'], description='Controls the way multi_match is executed internally. Can be one of `best_fields`, `most_fields`, `cross_fields`, `phrase`, `phrase_prefix` or `bool_prefix`. Defaults to 'best_fields'. See <<multi-match-types,multi_match types>>.'}, {name='lenient', values=[true, false], description='If false, format-based errors, such as providing a text query value for a numeric field, are returned. Defaults to true.'}, {name='operator', values=[AND, OR], description='Boolean logic used to interpret text in the query value. Defaults to OR.'}, {name='max_expansions', values=[50], description='Maximum number of terms to which the query will expand. Defaults to 50.'}, {name='analyzer', values=[standard], description='Analyzer used to convert the text in the query value into token. Defaults to the index-time analyzer mapped for the field. If no analyzer is mapped, the index’s default analyzer is used.'}, {name='boost', values=[2.5], description='Floating point number used to decrease or increase the relevance scores of the query.'}, {name='fuzzy_rewrite', values=[constant_score_blended, constant_score, constant_score_boolean, top_terms_blended_freqs_N, top_terms_boost_N, top_terms_N], description='Method used to rewrite the query. See the rewrite parameter for valid values and more information. If the fuzziness parameter is not 0, the match query uses a fuzzy_rewrite method of top_terms_blended_freqs_${max_expansions} by default.'}, {name='prefix_length', values=[1], description='Number of beginning characters left unchanged for fuzzy matching. Defaults to 0.'}",optional:true}],returnType:'boolean',minParams:2},{params:[{name:'query',type:'integer',optional:false},{name:'fields',type:'integer',optional:false},{name:'options',type:'function_named_parameters',mapParams:"{name='fuzziness', values=[AUTO, 1, 2], description='Maximum edit distance allowed for matching.'}, {name='auto_generate_synonyms_phrase_query', values=[true, false], description='If true, match phrase queries are automatically created for multi-term synonyms. Defaults to true.'}, {name='minimum_should_match', values=[2], description='Minimum number of clauses that must match for a document to be returned.'}, {name='fuzzy_transpositions', values=[true, false], description='If true, edits for fuzzy matching include transpositions of two adjacent characters (ab → ba). Defaults to true.'}, {name='tie_breaker', values=[0], description='Controls how score is blended together between field groups. Defaults to 0 (best score from each group).'}, {name='type', values=['best_fields'], description='Controls the way multi_match is executed internally. Can be one of `best_fields`, `most_fields`, `cross_fields`, `phrase`, `phrase_prefix` or `bool_prefix`. Defaults to 'best_fields'. See <<multi-match-types,multi_match types>>.'}, {name='lenient', values=[true, false], description='If false, format-based errors, such as providing a text query value for a numeric field, are returned. Defaults to true.'}, {name='operator', values=[AND, OR], description='Boolean logic used to interpret text in the query value. Defaults to OR.'}, {name='max_expansions', values=[50], description='Maximum number of terms to which the query will expand. Defaults to 50.'}, {name='analyzer', values=[standard], description='Analyzer used to convert the text in the query value into token. Defaults to the index-time analyzer mapped for the field. If no analyzer is mapped, the index’s default analyzer is used.'}, {name='boost', values=[2.5], description='Floating point number used to decrease or increase the relevance scores of the query.'}, {name='fuzzy_rewrite', values=[constant_score_blended, constant_score, constant_score_boolean, top_terms_blended_freqs_N, top_terms_boost_N, top_terms_N], description='Method used to rewrite the query. See the rewrite parameter for valid values and more information. If the fuzziness parameter is not 0, the match query uses a fuzzy_rewrite method of top_terms_blended_freqs_${max_expansions} by default.'}, {name='prefix_length', values=[1], description='Number of beginning characters left unchanged for fuzzy matching. Defaults to 0.'}",optional:true}],returnType:'boolean',minParams:2},{params:[{name:'query',type:'integer',optional:false},{name:'fields',type:'keyword',optional:false},{name:'options',type:'function_named_parameters',mapParams:"{name='fuzziness', values=[AUTO, 1, 2], description='Maximum edit distance allowed for matching.'}, {name='auto_generate_synonyms_phrase_query', values=[true, false], description='If true, match phrase queries are automatically created for multi-term synonyms. Defaults to true.'}, {name='minimum_should_match', values=[2], description='Minimum number of clauses that must match for a document to be returned.'}, {name='fuzzy_transpositions', values=[true, false], description='If true, edits for fuzzy matching include transpositions of two adjacent characters (ab → ba). Defaults to true.'}, {name='tie_breaker', values=[0], description='Controls how score is blended together between field groups. Defaults to 0 (best score from each group).'}, {name='type', values=['best_fields'], description='Controls the way multi_match is executed internally. Can be one of `best_fields`, `most_fields`, `cross_fields`, `phrase`, `phrase_prefix` or `bool_prefix`. Defaults to 'best_fields'. See <<multi-match-types,multi_match types>>.'}, {name='lenient', values=[true, false], description='If false, format-based errors, such as providing a text query value for a numeric field, are returned. Defaults to true.'}, {name='operator', values=[AND, OR], description='Boolean logic used to interpret text in the query value. Defaults to OR.'}, {name='max_expansions', values=[50], description='Maximum number of terms to which the query will expand. Defaults to 50.'}, {name='analyzer', values=[standard], description='Analyzer used to convert the text in the query value into token. Defaults to the index-time analyzer mapped for the field. If no analyzer is mapped, the index’s default analyzer is used.'}, {name='boost', values=[2.5], description='Floating point number used to decrease or increase the relevance scores of the query.'}, {name='fuzzy_rewrite', values=[constant_score_blended, constant_score, constant_score_boolean, top_terms_blended_freqs_N, top_terms_boost_N, top_terms_N], description='Method used to rewrite the query. See the rewrite parameter for valid values and more information. If the fuzziness parameter is not 0, the match query uses a fuzzy_rewrite method of top_terms_blended_freqs_${max_expansions} by default.'}, {name='prefix_length', values=[1], description='Number of beginning characters left unchanged for fuzzy matching. Defaults to 0.'}",optional:true}],returnType:'boolean',minParams:2},{params:[{name:'query',type:'integer',optional:false},{name:'fields',type:'long',optional:false},{name:'options',type:'function_named_parameters',mapParams:"{name='fuzziness', values=[AUTO, 1, 2], description='Maximum edit distance allowed for matching.'}, {name='auto_generate_synonyms_phrase_query', values=[true, false], description='If true, match phrase queries are automatically created for multi-term synonyms. Defaults to true.'}, {name='minimum_should_match', values=[2], description='Minimum number of clauses that must match for a document to be returned.'}, {name='fuzzy_transpositions', values=[true, false], description='If true, edits for fuzzy matching include transpositions of two adjacent characters (ab → ba). Defaults to true.'}, {name='tie_breaker', values=[0], description='Controls how score is blended together between field groups. Defaults to 0 (best score from each group).'}, {name='type', values=['best_fields'], description='Controls the way multi_match is executed internally. Can be one of `best_fields`, `most_fields`, `cross_fields`, `phrase`, `phrase_prefix` or `bool_prefix`. Defaults to 'best_fields'. See <<multi-match-types,multi_match types>>.'}, {name='lenient', values=[true, false], description='If false, format-based errors, such as providing a text query value for a numeric field, are returned. Defaults to true.'}, {name='operator', values=[AND, OR], description='Boolean logic used to interpret text in the query value. Defaults to OR.'}, {name='max_expansions', values=[50], description='Maximum number of terms to which the query will expand. Defaults to 50.'}, {name='analyzer', values=[standard], description='Analyzer used to convert the text in the query value into token. Defaults to the index-time analyzer mapped for the field. If no analyzer is mapped, the index’s default analyzer is used.'}, {name='boost', values=[2.5], description='Floating point number used to decrease or increase the relevance scores of the query.'}, {name='fuzzy_rewrite', values=[constant_score_blended, constant_score, constant_score_boolean, top_terms_blended_freqs_N, top_terms_boost_N, top_terms_N], description='Method used to rewrite the query. See the rewrite parameter for valid values and more information. If the fuzziness parameter is not 0, the match query uses a fuzzy_rewrite method of top_terms_blended_freqs_${max_expansions} by default.'}, {name='prefix_length', values=[1], description='Number of beginning characters left unchanged for fuzzy matching. Defaults to 0.'}",optional:true}],returnType:'boolean',minParams:2},{params:[{name:'query',type:'ip',optional:false},{name:'fields',type:'ip',optional:false},{name:'options',type:'function_named_parameters',mapParams:"{name='fuzziness', values=[AUTO, 1, 2], description='Maximum edit distance allowed for matching.'}, {name='auto_generate_synonyms_phrase_query', values=[true, false], description='If true, match phrase queries are automatically created for multi-term synonyms. Defaults to true.'}, {name='minimum_should_match', values=[2], description='Minimum number of clauses that must match for a document to be returned.'}, {name='fuzzy_transpositions', values=[true, false], description='If true, edits for fuzzy matching include transpositions of two adjacent characters (ab → ba). Defaults to true.'}, {name='tie_breaker', values=[0], description='Controls how score is blended together between field groups. Defaults to 0 (best score from each group).'}, {name='type', values=['best_fields'], description='Controls the way multi_match is executed internally. Can be one of `best_fields`, `most_fields`, `cross_fields`, `phrase`, `phrase_prefix` or `bool_prefix`. Defaults to 'best_fields'. See <<multi-match-types,multi_match types>>.'}, {name='lenient', values=[true, false], description='If false, format-based errors, such as providing a text query value for a numeric field, are returned. Defaults to true.'}, {name='operator', values=[AND, OR], description='Boolean logic used to interpret text in the query value. Defaults to OR.'}, {name='max_expansions', values=[50], description='Maximum number of terms to which the query will expand. Defaults to 50.'}, {name='analyzer', values=[standard], description='Analyzer used to convert the text in the query value into token. Defaults to the index-time analyzer mapped for the field. If no analyzer is mapped, the index’s default analyzer is used.'}, {name='boost', values=[2.5], description='Floating point number used to decrease or increase the relevance scores of the query.'}, {name='fuzzy_rewrite', values=[constant_score_blended, constant_score, constant_score_boolean, top_terms_blended_freqs_N, top_terms_boost_N, top_terms_N], description='Method used to rewrite the query. See the rewrite parameter for valid values and more information. If the fuzziness parameter is not 0, the match query uses a fuzzy_rewrite method of top_terms_blended_freqs_${max_expansions} by default.'}, {name='prefix_length', values=[1], description='Number of beginning characters left unchanged for fuzzy matching. Defaults to 0.'}",optional:true}],returnType:'boolean',minParams:2},{params:[{name:'query',type:'ip',optional:false},{name:'fields',type:'keyword',optional:false},{name:'options',type:'function_named_parameters',mapParams:"{name='fuzziness', values=[AUTO, 1, 2], description='Maximum edit distance allowed for matching.'}, {name='auto_generate_synonyms_phrase_query', values=[true, false], description='If true, match phrase queries are automatically created for multi-term synonyms. Defaults to true.'}, {name='minimum_should_match', values=[2], description='Minimum number of clauses that must match for a document to be returned.'}, {name='fuzzy_transpositions', values=[true, false], description='If true, edits for fuzzy matching include transpositions of two adjacent characters (ab → ba). Defaults to true.'}, {name='tie_breaker', values=[0], description='Controls how score is blended together between field groups. Defaults to 0 (best score from each group).'}, {name='type', values=['best_fields'], description='Controls the way multi_match is executed internally. Can be one of `best_fields`, `most_fields`, `cross_fields`, `phrase`, `phrase_prefix` or `bool_prefix`. Defaults to 'best_fields'. See <<multi-match-types,multi_match types>>.'}, {name='lenient', values=[true, false], description='If false, format-based errors, such as providing a text query value for a numeric field, are returned. Defaults to true.'}, {name='operator', values=[AND, OR], description='Boolean logic used to interpret text in the query value. Defaults to OR.'}, {name='max_expansions', values=[50], description='Maximum number of terms to which the query will expand. Defaults to 50.'}, {name='analyzer', values=[standard], description='Analyzer used to convert the text in the query value into token. Defaults to the index-time analyzer mapped for the field. If no analyzer is mapped, the index’s default analyzer is used.'}, {name='boost', values=[2.5], description='Floating point number used to decrease or increase the relevance scores of the query.'}, {name='fuzzy_rewrite', values=[constant_score_blended, constant_score, constant_score_boolean, top_terms_blended_freqs_N, top_terms_boost_N, top_terms_N], description='Method used to rewrite the query. See the rewrite parameter for valid values and more information. If the fuzziness parameter is not 0, the match query uses a fuzzy_rewrite method of top_terms_blended_freqs_${max_expansions} by default.'}, {name='prefix_length', values=[1], description='Number of beginning characters left unchanged for fuzzy matching. Defaults to 0.'}",optional:true}],returnType:'boolean',minParams:2},{params:[{name:'query',type:'keyword',optional:false},{name:'fields',type:'keyword',optional:false},{name:'options',type:'function_named_parameters',mapParams:"{name='fuzziness', values=[AUTO, 1, 2], description='Maximum edit distance allowed for matching.'}, {name='auto_generate_synonyms_phrase_query', values=[true, false], description='If true, match phrase queries are automatically created for multi-term synonyms. Defaults to true.'}, {name='minimum_should_match', values=[2], description='Minimum number of clauses that must match for a document to be returned.'}, {name='fuzzy_transpositions', values=[true, false], description='If true, edits for fuzzy matching include transpositions of two adjacent characters (ab → ba). Defaults to true.'}, {name='tie_breaker', values=[0], description='Controls how score is blended together between field groups. Defaults to 0 (best score from each group).'}, {name='type', values=['best_fields'], description='Controls the way multi_match is executed internally. Can be one of `best_fields`, `most_fields`, `cross_fields`, `phrase`, `phrase_prefix` or `bool_prefix`. Defaults to 'best_fields'. See <<multi-match-types,multi_match types>>.'}, {name='lenient', values=[true, false], description='If false, format-based errors, such as providing a text query value for a numeric field, are returned. Defaults to true.'}, {name='operator', values=[AND, OR], description='Boolean logic used to interpret text in the query value. Defaults to OR.'}, {name='max_expansions', values=[50], description='Maximum number of terms to which the query will expand. Defaults to 50.'}, {name='analyzer', values=[standard], description='Analyzer used to convert the text in the query value into token. Defaults to the index-time analyzer mapped for the field. If no analyzer is mapped, the index’s default analyzer is used.'}, {name='boost', values=[2.5], description='Floating point number used to decrease or increase the relevance scores of the query.'}, {name='fuzzy_rewrite', values=[constant_score_blended, constant_score, constant_score_boolean, top_terms_blended_freqs_N, top_terms_boost_N, top_terms_N], description='Method used to rewrite the query. See the rewrite parameter for valid values and more information. If the fuzziness parameter is not 0, the match query uses a fuzzy_rewrite method of top_terms_blended_freqs_${max_expansions} by default.'}, {name='prefix_length', values=[1], description='Number of beginning characters left unchanged for fuzzy matching. Defaults to 0.'}",optional:true}],returnType:'boolean',minParams:2},{params:[{name:'query',type:'long',optional:false},{name:'fields',type:'double',optional:false},{name:'options',type:'function_named_parameters',mapParams:"{name='fuzziness', values=[AUTO, 1, 2], description='Maximum edit distance allowed for matching.'}, {name='auto_generate_synonyms_phrase_query', values=[true, false], description='If true, match phrase queries are automatically created for multi-term synonyms. Defaults to true.'}, {name='minimum_should_match', values=[2], description='Minimum number of clauses that must match for a document to be returned.'}, {name='fuzzy_transpositions', values=[true, false], description='If true, edits for fuzzy matching include transpositions of two adjacent characters (ab → ba). Defaults to true.'}, {name='tie_breaker', values=[0], description='Controls how score is blended together between field groups. Defaults to 0 (best score from each group).'}, {name='type', values=['best_fields'], description='Controls the way multi_match is executed internally. Can be one of `best_fields`, `most_fields`, `cross_fields`, `phrase`, `phrase_prefix` or `bool_prefix`. Defaults to 'best_fields'. See <<multi-match-types,multi_match types>>.'}, {name='lenient', values=[true, false], description='If false, format-based errors, such as providing a text query value for a numeric field, are returned. Defaults to true.'}, {name='operator', values=[AND, OR], description='Boolean logic used to interpret text in the query value. Defaults to OR.'}, {name='max_expansions', values=[50], description='Maximum number of terms to which the query will expand. Defaults to 50.'}, {name='analyzer', values=[standard], description='Analyzer used to convert the text in the query value into token. Defaults to the index-time analyzer mapped for the field. If no analyzer is mapped, the index’s default analyzer is used.'}, {name='boost', values=[2.5], description='Floating point number used to decrease or increase the relevance scores of the query.'}, {name='fuzzy_rewrite', values=[constant_score_blended, constant_score, constant_score_boolean, top_terms_blended_freqs_N, top_terms_boost_N, top_terms_N], description='Method used to rewrite the query. See the rewrite parameter for valid values and more information. If the fuzziness parameter is not 0, the match query uses a fuzzy_rewrite method of top_terms_blended_freqs_${max_expansions} by default.'}, {name='prefix_length', values=[1], description='Number of beginning characters left unchanged for fuzzy matching. Defaults to 0.'}",optional:true}],returnType:'boolean',minParams:2},{params:[{name:'query',type:'long',optional:false},{name:'fields',type:'integer',optional:false},{name:'options',type:'function_named_parameters',mapParams:"{name='fuzziness', values=[AUTO, 1, 2], description='Maximum edit distance allowed for matching.'}, {name='auto_generate_synonyms_phrase_query', values=[true, false], description='If true, match phrase queries are automatically created for multi-term synonyms. Defaults to true.'}, {name='minimum_should_match', values=[2], description='Minimum number of clauses that must match for a document to be returned.'}, {name='fuzzy_transpositions', values=[true, false], description='If true, edits for fuzzy matching include transpositions of two adjacent characters (ab → ba). Defaults to true.'}, {name='tie_breaker', values=[0], description='Controls how score is blended together between field groups. Defaults to 0 (best score from each group).'}, {name='type', values=['best_fields'], description='Controls the way multi_match is executed internally. Can be one of `best_fields`, `most_fields`, `cross_fields`, `phrase`, `phrase_prefix` or `bool_prefix`. Defaults to 'best_fields'. See <<multi-match-types,multi_match types>>.'}, {name='lenient', values=[true, false], description='If false, format-based errors, such as providing a text query value for a numeric field, are returned. Defaults to true.'}, {name='operator', values=[AND, OR], description='Boolean logic used to interpret text in the query value. Defaults to OR.'}, {name='max_expansions', values=[50], description='Maximum number of terms to which the query will expand. Defaults to 50.'}, {name='analyzer', values=[standard], description='Analyzer used to convert the text in the query value into token. Defaults to the index-time analyzer mapped for the field. If no analyzer is mapped, the index’s default analyzer is used.'}, {name='boost', values=[2.5], description='Floating point number used to decrease or increase the relevance scores of the query.'}, {name='fuzzy_rewrite', values=[constant_score_blended, constant_score, constant_score_boolean, top_terms_blended_freqs_N, top_terms_boost_N, top_terms_N], description='Method used to rewrite the query. See the rewrite parameter for valid values and more information. If the fuzziness parameter is not 0, the match query uses a fuzzy_rewrite method of top_terms_blended_freqs_${max_expansions} by default.'}, {name='prefix_length', values=[1], description='Number of beginning characters left unchanged for fuzzy matching. Defaults to 0.'}",optional:true}],returnType:'boolean',minParams:2},{params:[{name:'query',type:'long',optional:false},{name:'fields',type:'keyword',optional:false},{name:'options',type:'function_named_parameters',mapParams:"{name='fuzziness', values=[AUTO, 1, 2], description='Maximum edit distance allowed for matching.'}, {name='auto_generate_synonyms_phrase_query', values=[true, false], description='If true, match phrase queries are automatically created for multi-term synonyms. Defaults to true.'}, {name='minimum_should_match', values=[2], description='Minimum number of clauses that must match for a document to be returned.'}, {name='fuzzy_transpositions', values=[true, false], description='If true, edits for fuzzy matching include transpositions of two adjacent characters (ab → ba). Defaults to true.'}, {name='tie_breaker', values=[0], description='Controls how score is blended together between field groups. Defaults to 0 (best score from each group).'}, {name='type', values=['best_fields'], description='Controls the way multi_match is executed internally. Can be one of `best_fields`, `most_fields`, `cross_fields`, `phrase`, `phrase_prefix` or `bool_prefix`. Defaults to 'best_fields'. See <<multi-match-types,multi_match types>>.'}, {name='lenient', values=[true, false], description='If false, format-based errors, such as providing a text query value for a numeric field, are returned. Defaults to true.'}, {name='operator', values=[AND, OR], description='Boolean logic used to interpret text in the query value. Defaults to OR.'}, {name='max_expansions', values=[50], description='Maximum number of terms to which the query will expand. Defaults to 50.'}, {name='analyzer', values=[standard], description='Analyzer used to convert the text in the query value into token. Defaults to the index-time analyzer mapped for the field. If no analyzer is mapped, the index’s default analyzer is used.'}, {name='boost', values=[2.5], description='Floating point number used to decrease or increase the relevance scores of the query.'}, {name='fuzzy_rewrite', values=[constant_score_blended, constant_score, constant_score_boolean, top_terms_blended_freqs_N, top_terms_boost_N, top_terms_N], description='Method used to rewrite the query. See the rewrite parameter for valid values and more information. If the fuzziness parameter is not 0, the match query uses a fuzzy_rewrite method of top_terms_blended_freqs_${max_expansions} by default.'}, {name='prefix_length', values=[1], description='Number of beginning characters left unchanged for fuzzy matching. Defaults to 0.'}",optional:true}],returnType:'boolean',minParams:2},{params:[{name:'query',type:'long',optional:false},{name:'fields',type:'long',optional:false},{name:'options',type:'function_named_parameters',mapParams:"{name='fuzziness', values=[AUTO, 1, 2], description='Maximum edit distance allowed for matching.'}, {name='auto_generate_synonyms_phrase_query', values=[true, false], description='If true, match phrase queries are automatically created for multi-term synonyms. Defaults to true.'}, {name='minimum_should_match', values=[2], description='Minimum number of clauses that must match for a document to be returned.'}, {name='fuzzy_transpositions', values=[true, false], description='If true, edits for fuzzy matching include transpositions of two adjacent characters (ab → ba). Defaults to true.'}, {name='tie_breaker', values=[0], description='Controls how score is blended together between field groups. Defaults to 0 (best score from each group).'}, {name='type', values=['best_fields'], description='Controls the way multi_match is executed internally. Can be one of `best_fields`, `most_fields`, `cross_fields`, `phrase`, `phrase_prefix` or `bool_prefix`. Defaults to 'best_fields'. See <<multi-match-types,multi_match types>>.'}, {name='lenient', values=[true, false], description='If false, format-based errors, such as providing a text query value for a numeric field, are returned. Defaults to true.'}, {name='operator', values=[AND, OR], description='Boolean logic used to interpret text in the query value. Defaults to OR.'}, {name='max_expansions', values=[50], description='Maximum number of terms to which the query will expand. Defaults to 50.'}, {name='analyzer', values=[standard], description='Analyzer used to convert the text in the query value into token. Defaults to the index-time analyzer mapped for the field. If no analyzer is mapped, the index’s default analyzer is used.'}, {name='boost', values=[2.5], description='Floating point number used to decrease or increase the relevance scores of the query.'}, {name='fuzzy_rewrite', values=[constant_score_blended, constant_score, constant_score_boolean, top_terms_blended_freqs_N, top_terms_boost_N, top_terms_N], description='Method used to rewrite the query. See the rewrite parameter for valid values and more information. If the fuzziness parameter is not 0, the match query uses a fuzzy_rewrite method of top_terms_blended_freqs_${max_expansions} by default.'}, {name='prefix_length', values=[1], description='Number of beginning characters left unchanged for fuzzy matching. Defaults to 0.'}",optional:true}],returnType:'boolean',minParams:2},{params:[{name:'query',type:'text',optional:false},{name:'fields',type:'keyword',optional:false},{name:'options',type:'function_named_parameters',mapParams:"{name='fuzziness', values=[AUTO, 1, 2], description='Maximum edit distance allowed for matching.'}, {name='auto_generate_synonyms_phrase_query', values=[true, false], description='If true, match phrase queries are automatically created for multi-term synonyms. Defaults to true.'}, {name='minimum_should_match', values=[2], description='Minimum number of clauses that must match for a document to be returned.'}, {name='fuzzy_transpositions', values=[true, false], description='If true, edits for fuzzy matching include transpositions of two adjacent characters (ab → ba). Defaults to true.'}, {name='tie_breaker', values=[0], description='Controls how score is blended together between field groups. Defaults to 0 (best score from each group).'}, {name='type', values=['best_fields'], description='Controls the way multi_match is executed internally. Can be one of `best_fields`, `most_fields`, `cross_fields`, `phrase`, `phrase_prefix` or `bool_prefix`. Defaults to 'best_fields'. See <<multi-match-types,multi_match types>>.'}, {name='lenient', values=[true, false], description='If false, format-based errors, such as providing a text query value for a numeric field, are returned. Defaults to true.'}, {name='operator', values=[AND, OR], description='Boolean logic used to interpret text in the query value. Defaults to OR.'}, {name='max_expansions', values=[50], description='Maximum number of terms to which the query will expand. Defaults to 50.'}, {name='analyzer', values=[standard], description='Analyzer used to convert the text in the query value into token. Defaults to the index-time analyzer mapped for the field. If no analyzer is mapped, the index’s default analyzer is used.'}, {name='boost', values=[2.5], description='Floating point number used to decrease or increase the relevance scores of the query.'}, {name='fuzzy_rewrite', values=[constant_score_blended, constant_score, constant_score_boolean, top_terms_blended_freqs_N, top_terms_boost_N, top_terms_N], description='Method used to rewrite the query. See the rewrite parameter for valid values and more information. If the fuzziness parameter is not 0, the match query uses a fuzzy_rewrite method of top_terms_blended_freqs_${max_expansions} by default.'}, {name='prefix_length', values=[1], description='Number of beginning characters left unchanged for fuzzy matching. Defaults to 0.'}",optional:true}],returnType:'boolean',minParams:2},{params:[{name:'query',type:'unsigned_long',optional:false},{name:'fields',type:'double',optional:false},{name:'options',type:'function_named_parameters',mapParams:"{name='fuzziness', values=[AUTO, 1, 2], description='Maximum edit distance allowed for matching.'}, {name='auto_generate_synonyms_phrase_query', values=[true, false], description='If true, match phrase queries are automatically created for multi-term synonyms. Defaults to true.'}, {name='minimum_should_match', values=[2], description='Minimum number of clauses that must match for a document to be returned.'}, {name='fuzzy_transpositions', values=[true, false], description='If true, edits for fuzzy matching include transpositions of two adjacent characters (ab → ba). Defaults to true.'}, {name='tie_breaker', values=[0], description='Controls how score is blended together between field groups. Defaults to 0 (best score from each group).'}, {name='type', values=['best_fields'], description='Controls the way multi_match is executed internally. Can be one of `best_fields`, `most_fields`, `cross_fields`, `phrase`, `phrase_prefix` or `bool_prefix`. Defaults to 'best_fields'. See <<multi-match-types,multi_match types>>.'}, {name='lenient', values=[true, false], description='If false, format-based errors, such as providing a text query value for a numeric field, are returned. Defaults to true.'}, {name='operator', values=[AND, OR], description='Boolean logic used to interpret text in the query value. Defaults to OR.'}, {name='max_expansions', values=[50], description='Maximum number of terms to which the query will expand. Defaults to 50.'}, {name='analyzer', values=[standard], description='Analyzer used to convert the text in the query value into token. Defaults to the index-time analyzer mapped for the field. If no analyzer is mapped, the index’s default analyzer is used.'}, {name='boost', values=[2.5], description='Floating point number used to decrease or increase the relevance scores of the query.'}, {name='fuzzy_rewrite', values=[constant_score_blended, constant_score, constant_score_boolean, top_terms_blended_freqs_N, top_terms_boost_N, top_terms_N], description='Method used to rewrite the query. See the rewrite parameter for valid values and more information. If the fuzziness parameter is not 0, the match query uses a fuzzy_rewrite method of top_terms_blended_freqs_${max_expansions} by default.'}, {name='prefix_length', values=[1], description='Number of beginning characters left unchanged for fuzzy matching. Defaults to 0.'}",optional:true}],returnType:'boolean',minParams:2},{params:[{name:'query',type:'unsigned_long',optional:false},{name:'fields',type:'integer',optional:false},{name:'options',type:'function_named_parameters',mapParams:"{name='fuzziness', values=[AUTO, 1, 2], description='Maximum edit distance allowed for matching.'}, {name='auto_generate_synonyms_phrase_query', values=[true, false], description='If true, match phrase queries are automatically created for multi-term synonyms. Defaults to true.'}, {name='minimum_should_match', values=[2], description='Minimum number of clauses that must match for a document to be returned.'}, {name='fuzzy_transpositions', values=[true, false], description='If true, edits for fuzzy matching include transpositions of two adjacent characters (ab → ba). Defaults to true.'}, {name='tie_breaker', values=[0], description='Controls how score is blended together between field groups. Defaults to 0 (best score from each group).'}, {name='type', values=['best_fields'], description='Controls the way multi_match is executed internally. Can be one of `best_fields`, `most_fields`, `cross_fields`, `phrase`, `phrase_prefix` or `bool_prefix`. Defaults to 'best_fields'. See <<multi-match-types,multi_match types>>.'}, {name='lenient', values=[true, false], description='If false, format-based errors, such as providing a text query value for a numeric field, are returned. Defaults to true.'}, {name='operator', values=[AND, OR], description='Boolean logic used to interpret text in the query value. Defaults to OR.'}, {name='max_expansions', values=[50], description='Maximum number of terms to which the query will expand. Defaults to 50.'}, {name='analyzer', values=[standard], description='Analyzer used to convert the text in the query value into token. Defaults to the index-time analyzer mapped for the field. If no analyzer is mapped, the index’s default analyzer is used.'}, {name='boost', values=[2.5], description='Floating point number used to decrease or increase the relevance scores of the query.'}, {name='fuzzy_rewrite', values=[constant_score_blended, constant_score, constant_score_boolean, top_terms_blended_freqs_N, top_terms_boost_N, top_terms_N], description='Method used to rewrite the query. See the rewrite parameter for valid values and more information. If the fuzziness parameter is not 0, the match query uses a fuzzy_rewrite method of top_terms_blended_freqs_${max_expansions} by default.'}, {name='prefix_length', values=[1], description='Number of beginning characters left unchanged for fuzzy matching. Defaults to 0.'}",optional:true}],returnType:'boolean',minParams:2},{params:[{name:'query',type:'unsigned_long',optional:false},{name:'fields',type:'keyword',optional:false},{name:'options',type:'function_named_parameters',mapParams:"{name='fuzziness', values=[AUTO, 1, 2], description='Maximum edit distance allowed for matching.'}, {name='auto_generate_synonyms_phrase_query', values=[true, false], description='If true, match phrase queries are automatically created for multi-term synonyms. Defaults to true.'}, {name='minimum_should_match', values=[2], description='Minimum number of clauses that must match for a document to be returned.'}, {name='fuzzy_transpositions', values=[true, false], description='If true, edits for fuzzy matching include transpositions of two adjacent characters (ab → ba). Defaults to true.'}, {name='tie_breaker', values=[0], description='Controls how score is blended together between field groups. Defaults to 0 (best score from each group).'}, {name='type', values=['best_fields'], description='Controls the way multi_match is executed internally. Can be one of `best_fields`, `most_fields`, `cross_fields`, `phrase`, `phrase_prefix` or `bool_prefix`. Defaults to 'best_fields'. See <<multi-match-types,multi_match types>>.'}, {name='lenient', values=[true, false], description='If false, format-based errors, such as providing a text query value for a numeric field, are returned. Defaults to true.'}, {name='operator', values=[AND, OR], description='Boolean logic used to interpret text in the query value. Defaults to OR.'}, {name='max_expansions', values=[50], description='Maximum number of terms to which the query will expand. Defaults to 50.'}, {name='analyzer', values=[standard], description='Analyzer used to convert the text in the query value into token. Defaults to the index-time analyzer mapped for the field. If no analyzer is mapped, the index’s default analyzer is used.'}, {name='boost', values=[2.5], description='Floating point number used to decrease or increase the relevance scores of the query.'}, {name='fuzzy_rewrite', values=[constant_score_blended, constant_score, constant_score_boolean, top_terms_blended_freqs_N, top_terms_boost_N, top_terms_N], description='Method used to rewrite the query. See the rewrite parameter for valid values and more information. If the fuzziness parameter is not 0, the match query uses a fuzzy_rewrite method of top_terms_blended_freqs_${max_expansions} by default.'}, {name='prefix_length', values=[1], description='Number of beginning characters left unchanged for fuzzy matching. Defaults to 0.'}",optional:true}],returnType:'boolean',minParams:2},{params:[{name:'query',type:'unsigned_long',optional:false},{name:'fields',type:'long',optional:false},{name:'options',type:'function_named_parameters',mapParams:"{name='fuzziness', values=[AUTO, 1, 2], description='Maximum edit distance allowed for matching.'}, {name='auto_generate_synonyms_phrase_query', values=[true, false], description='If true, match phrase queries are automatically created for multi-term synonyms. Defaults to true.'}, {name='minimum_should_match', values=[2], description='Minimum number of clauses that must match for a document to be returned.'}, {name='fuzzy_transpositions', values=[true, false], description='If true, edits for fuzzy matching include transpositions of two adjacent characters (ab → ba). Defaults to true.'}, {name='tie_breaker', values=[0], description='Controls how score is blended together between field groups. Defaults to 0 (best score from each group).'}, {name='type', values=['best_fields'], description='Controls the way multi_match is executed internally. Can be one of `best_fields`, `most_fields`, `cross_fields`, `phrase`, `phrase_prefix` or `bool_prefix`. Defaults to 'best_fields'. See <<multi-match-types,multi_match types>>.'}, {name='lenient', values=[true, false], description='If false, format-based errors, such as providing a text query value for a numeric field, are returned. Defaults to true.'}, {name='operator', values=[AND, OR], description='Boolean logic used to interpret text in the query value. Defaults to OR.'}, {name='max_expansions', values=[50], description='Maximum number of terms to which the query will expand. Defaults to 50.'}, {name='analyzer', values=[standard], description='Analyzer used to convert the text in the query value into token. Defaults to the index-time analyzer mapped for the field. If no analyzer is mapped, the index’s default analyzer is used.'}, {name='boost', values=[2.5], description='Floating point number used to decrease or increase the relevance scores of the query.'}, {name='fuzzy_rewrite', values=[constant_score_blended, constant_score, constant_score_boolean, top_terms_blended_freqs_N, top_terms_boost_N, top_terms_N], description='Method used to rewrite the query. See the rewrite parameter for valid values and more information. If the fuzziness parameter is not 0, the match query uses a fuzzy_rewrite method of top_terms_blended_freqs_${max_expansions} by default.'}, {name='prefix_length', values=[1], description='Number of beginning characters left unchanged for fuzzy matching. Defaults to 0.'}",optional:true}],returnType:'boolean',minParams:2},{params:[{name:'query',type:'unsigned_long',optional:false},{name:'fields',type:'unsigned_long',optional:false},{name:'options',type:'function_named_parameters',mapParams:"{name='fuzziness', values=[AUTO, 1, 2], description='Maximum edit distance allowed for matching.'}, {name='auto_generate_synonyms_phrase_query', values=[true, false], description='If true, match phrase queries are automatically created for multi-term synonyms. Defaults to true.'}, {name='minimum_should_match', values=[2], description='Minimum number of clauses that must match for a document to be returned.'}, {name='fuzzy_transpositions', values=[true, false], description='If true, edits for fuzzy matching include transpositions of two adjacent characters (ab → ba). Defaults to true.'}, {name='tie_breaker', values=[0], description='Controls how score is blended together between field groups. Defaults to 0 (best score from each group).'}, {name='type', values=['best_fields'], description='Controls the way multi_match is executed internally. Can be one of `best_fields`, `most_fields`, `cross_fields`, `phrase`, `phrase_prefix` or `bool_prefix`. Defaults to 'best_fields'. See <<multi-match-types,multi_match types>>.'}, {name='lenient', values=[true, false], description='If false, format-based errors, such as providing a text query value for a numeric field, are returned. Defaults to true.'}, {name='operator', values=[AND, OR], description='Boolean logic used to interpret text in the query value. Defaults to OR.'}, {name='max_expansions', values=[50], description='Maximum number of terms to which the query will expand. Defaults to 50.'}, {name='analyzer', values=[standard], description='Analyzer used to convert the text in the query value into token. Defaults to the index-time analyzer mapped for the field. If no analyzer is mapped, the index’s default analyzer is used.'}, {name='boost', values=[2.5], description='Floating point number used to decrease or increase the relevance scores of the query.'}, {name='fuzzy_rewrite', values=[constant_score_blended, constant_score, constant_score_boolean, top_terms_blended_freqs_N, top_terms_boost_N, top_terms_N], description='Method used to rewrite the query. See the rewrite parameter for valid values and more information. If the fuzziness parameter is not 0, the match query uses a fuzzy_rewrite method of top_terms_blended_freqs_${max_expansions} by default.'}, {name='prefix_length', values=[1], description='Number of beginning characters left unchanged for fuzzy matching. Defaults to 0.'}",optional:true}],returnType:'boolean',minParams:2},{params:[{name:'query',type:'version',optional:false},{name:'fields',type:'keyword',optional:false},{name:'options',type:'function_named_parameters',mapParams:"{name='fuzziness', values=[AUTO, 1, 2], description='Maximum edit distance allowed for matching.'}, {name='auto_generate_synonyms_phrase_query', values=[true, false], description='If true, match phrase queries are automatically created for multi-term synonyms. Defaults to true.'}, {name='minimum_should_match', values=[2], description='Minimum number of clauses that must match for a document to be returned.'}, {name='fuzzy_transpositions', values=[true, false], description='If true, edits for fuzzy matching include transpositions of two adjacent characters (ab → ba). Defaults to true.'}, {name='tie_breaker', values=[0], description='Controls how score is blended together between field groups. Defaults to 0 (best score from each group).'}, {name='type', values=['best_fields'], description='Controls the way multi_match is executed internally. Can be one of `best_fields`, `most_fields`, `cross_fields`, `phrase`, `phrase_prefix` or `bool_prefix`. Defaults to 'best_fields'. See <<multi-match-types,multi_match types>>.'}, {name='lenient', values=[true, false], description='If false, format-based errors, such as providing a text query value for a numeric field, are returned. Defaults to true.'}, {name='operator', values=[AND, OR], description='Boolean logic used to interpret text in the query value. Defaults to OR.'}, {name='max_expansions', values=[50], description='Maximum number of terms to which the query will expand. Defaults to 50.'}, {name='analyzer', values=[standard], description='Analyzer used to convert the text in the query value into token. Defaults to the index-time analyzer mapped for the field. If no analyzer is mapped, the index’s default analyzer is used.'}, {name='boost', values=[2.5], description='Floating point number used to decrease or increase the relevance scores of the query.'}, {name='fuzzy_rewrite', values=[constant_score_blended, constant_score, constant_score_boolean, top_terms_blended_freqs_N, top_terms_boost_N, top_terms_N], description='Method used to rewrite the query. See the rewrite parameter for valid values and more information. If the fuzziness parameter is not 0, the match query uses a fuzzy_rewrite method of top_terms_blended_freqs_${max_expansions} by default.'}, {name='prefix_length', values=[1], description='Number of beginning characters left unchanged for fuzzy matching. Defaults to 0.'}",optional:true}],returnType:'boolean',minParams:2},{params:[{name:'query',type:'version',optional:false},{name:'fields',type:'version',optional:false},{name:'options',type:'function_named_parameters',mapParams:"{name='fuzziness', values=[AUTO, 1, 2], description='Maximum edit distance allowed for matching.'}, {name='auto_generate_synonyms_phrase_query', values=[true, false], description='If true, match phrase queries are automatically created for multi-term synonyms. Defaults to true.'}, {name='minimum_should_match', values=[2], description='Minimum number of clauses that must match for a document to be returned.'}, {name='fuzzy_transpositions', values=[true, false], description='If true, edits for fuzzy matching include transpositions of two adjacent characters (ab → ba). Defaults to true.'}, {name='tie_breaker', values=[0], description='Controls how score is blended together between field groups. Defaults to 0 (best score from each group).'}, {name='type', values=['best_fields'], description='Controls the way multi_match is executed internally. Can be one of `best_fields`, `most_fields`, `cross_fields`, `phrase`, `phrase_prefix` or `bool_prefix`. Defaults to 'best_fields'. See <<multi-match-types,multi_match types>>.'}, {name='lenient', values=[true, false], description='If false, format-based errors, such as providing a text query value for a numeric field, are returned. Defaults to true.'}, {name='operator', values=[AND, OR], description='Boolean logic used to interpret text in the query value. Defaults to OR.'}, {name='max_expansions', values=[50], description='Maximum number of terms to which the query will expand. Defaults to 50.'}, {name='analyzer', values=[standard], description='Analyzer used to convert the text in the query value into token. Defaults to the index-time analyzer mapped for the field. If no analyzer is mapped, the index’s default analyzer is used.'}, {name='boost', values=[2.5], description='Floating point number used to decrease or increase the relevance scores of the query.'}, {name='fuzzy_rewrite', values=[constant_score_blended, constant_score, constant_score_boolean, top_terms_blended_freqs_N, top_terms_boost_N, top_terms_N], description='Method used to rewrite the query. See the rewrite parameter for valid values and more information. If the fuzziness parameter is not 0, the match query uses a fuzzy_rewrite method of top_terms_blended_freqs_${max_expansions} by default.'}, {name='prefix_length', values=[1], description='Number of beginning characters left unchanged for fuzzy matching. Defaults to 0.'}",optional:true}],returnType:'boolean',minParams:2}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['FROM books\n| WHERE MULTI_MATCH("Faulkner", author, description)\n| KEEP book_no, author\n| SORT book_no\n| LIMIT 5','FROM books\n| WHERE MULTI_MATCH("Hobbit Back Again", title, description, {"operator": "AND"})\n| KEEP title;']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const mvAppendDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'mv_append',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.mv_append',{defaultMessage:'Concatenates values of two multi-value fields.'}),preview:false,alias:undefined,signatures:[{params:[{name:'field1',type:'boolean',optional:false},{name:'field2',type:'boolean',optional:false}],returnType:'boolean'},{params:[{name:'field1',type:'cartesian_point',optional:false},{name:'field2',type:'cartesian_point',optional:false}],returnType:'cartesian_point'},{params:[{name:'field1',type:'cartesian_shape',optional:false},{name:'field2',type:'cartesian_shape',optional:false}],returnType:'cartesian_shape'},{params:[{name:'field1',type:'date',optional:false},{name:'field2',type:'date',optional:false}],returnType:'date'},{params:[{name:'field1',type:'date_nanos',optional:false},{name:'field2',type:'date_nanos',optional:false}],returnType:'date_nanos'},{params:[{name:'field1',type:'double',optional:false},{name:'field2',type:'double',optional:false}],returnType:'double'},{params:[{name:'field1',type:'geo_point',optional:false},{name:'field2',type:'geo_point',optional:false}],returnType:'geo_point'},{params:[{name:'field1',type:'geo_shape',optional:false},{name:'field2',type:'geo_shape',optional:false}],returnType:'geo_shape'},{params:[{name:'field1',type:'geohash',optional:false},{name:'field2',type:'geohash',optional:false}],returnType:'geohash'},{params:[{name:'field1',type:'geohex',optional:false},{name:'field2',type:'geohex',optional:false}],returnType:'geohex'},{params:[{name:'field1',type:'geotile',optional:false},{name:'field2',type:'geotile',optional:false}],returnType:'geotile'},{params:[{name:'field1',type:'integer',optional:false},{name:'field2',type:'integer',optional:false}],returnType:'integer'},{params:[{name:'field1',type:'ip',optional:false},{name:'field2',type:'ip',optional:false}],returnType:'ip'},{params:[{name:'field1',type:'keyword',optional:false},{name:'field2',type:'keyword',optional:false}],returnType:'keyword'},{params:[{name:'field1',type:'keyword',optional:false},{name:'field2',type:'text',optional:false}],returnType:'keyword'},{params:[{name:'field1',type:'long',optional:false},{name:'field2',type:'long',optional:false}],returnType:'long'},{params:[{name:'field1',type:'text',optional:false},{name:'field2',type:'keyword',optional:false}],returnType:'keyword'},{params:[{name:'field1',type:'text',optional:false},{name:'field2',type:'text',optional:false}],returnType:'keyword'},{params:[{name:'field1',type:'unsigned_long',optional:false},{name:'field2',type:'unsigned_long',optional:false}],returnType:'unsigned_long'},{params:[{name:'field1',type:'version',optional:false},{name:'field2',type:'version',optional:false}],returnType:'version'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['FROM employees\n| WHERE emp_no == 10039 OR emp_no == 10040\n| SORT emp_no\n| EVAL dates = MV_APPEND(birth_date, hire_date)\n| KEEP emp_no, birth_date, hire_date, dates']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const mvAvgDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'mv_avg',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.mv_avg',{defaultMessage:'Converts a multivalued field into a single valued field containing the average of all of the values.'}),preview:false,alias:undefined,signatures:[{params:[{name:'number',type:'double',optional:false}],returnType:'double'},{params:[{name:'number',type:'integer',optional:false}],returnType:'double'},{params:[{name:'number',type:'long',optional:false}],returnType:'double'},{params:[{name:'number',type:'unsigned_long',optional:false}],returnType:'double'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW a=[3, 5, 1, 6]\n| EVAL avg_a = MV_AVG(a)']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const mvConcatDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'mv_concat',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.mv_concat',{defaultMessage:'Converts a multivalued string expression into a single valued column containing the concatenation of all values separated by a delimiter.'}),preview:false,alias:undefined,signatures:[{params:[{name:'string',type:'keyword',optional:false},{name:'delim',type:'keyword',optional:false}],returnType:'keyword'},{params:[{name:'string',type:'keyword',optional:false},{name:'delim',type:'text',optional:false}],returnType:'keyword'},{params:[{name:'string',type:'text',optional:false},{name:'delim',type:'keyword',optional:false}],returnType:'keyword'},{params:[{name:'string',type:'text',optional:false},{name:'delim',type:'text',optional:false}],returnType:'keyword'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW a=["foo", "zoo", "bar"]\n| EVAL j = MV_CONCAT(a, ", ")','ROW a=[10, 9, 8]\n| EVAL j = MV_CONCAT(TO_STRING(a), ", ")']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const mvContainsDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'mv_contains',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.mv_contains',{defaultMessage:'Checks if all values yielded by the second multivalue expression are present in the values yielded by the first multivalue expression. Returns a boolean. Null values are treated as an empty set.'}),preview:false,alias:undefined,signatures:[{params:[{name:'superset',type:'boolean',optional:false},{name:'subset',type:'boolean',optional:false}],returnType:'boolean'},{params:[{name:'superset',type:'cartesian_point',optional:false},{name:'subset',type:'cartesian_point',optional:false}],returnType:'boolean'},{params:[{name:'superset',type:'cartesian_shape',optional:false},{name:'subset',type:'cartesian_shape',optional:false}],returnType:'boolean'},{params:[{name:'superset',type:'date',optional:false},{name:'subset',type:'date',optional:false}],returnType:'boolean'},{params:[{name:'superset',type:'date_nanos',optional:false},{name:'subset',type:'date_nanos',optional:false}],returnType:'boolean'},{params:[{name:'superset',type:'double',optional:false},{name:'subset',type:'double',optional:false}],returnType:'boolean'},{params:[{name:'superset',type:'geo_point',optional:false},{name:'subset',type:'geo_point',optional:false}],returnType:'boolean'},{params:[{name:'superset',type:'geo_shape',optional:false},{name:'subset',type:'geo_shape',optional:false}],returnType:'boolean'},{params:[{name:'superset',type:'geohash',optional:false},{name:'subset',type:'geohash',optional:false}],returnType:'boolean'},{params:[{name:'superset',type:'geohex',optional:false},{name:'subset',type:'geohex',optional:false}],returnType:'boolean'},{params:[{name:'superset',type:'geotile',optional:false},{name:'subset',type:'geotile',optional:false}],returnType:'boolean'},{params:[{name:'superset',type:'integer',optional:false},{name:'subset',type:'integer',optional:false}],returnType:'boolean'},{params:[{name:'superset',type:'ip',optional:false},{name:'subset',type:'ip',optional:false}],returnType:'boolean'},{params:[{name:'superset',type:'keyword',optional:false},{name:'subset',type:'keyword',optional:false}],returnType:'boolean'},{params:[{name:'superset',type:'keyword',optional:false},{name:'subset',type:'text',optional:false}],returnType:'boolean'},{params:[{name:'superset',type:'long',optional:false},{name:'subset',type:'long',optional:false}],returnType:'boolean'},{params:[{name:'superset',type:'text',optional:false},{name:'subset',type:'keyword',optional:false}],returnType:'boolean'},{params:[{name:'superset',type:'text',optional:false},{name:'subset',type:'text',optional:false}],returnType:'boolean'},{params:[{name:'superset',type:'unsigned_long',optional:false},{name:'subset',type:'unsigned_long',optional:false}],returnType:'boolean'},{params:[{name:'superset',type:'version',optional:false},{name:'subset',type:'version',optional:false}],returnType:'boolean'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW set = ["a", "b", "c"], element = "a"\n| EVAL set_contains_element = mv_contains(set, element)','ROW setA = ["a","c"], setB = ["a", "b", "c"]\n| EVAL a_subset_of_b = mv_contains(setB, setA)\n| EVAL b_subset_of_a = mv_contains(setA, setB)','FROM airports\n| WHERE mv_contains(type, ["major","military"]) AND scalerank == 9\n| KEEP scalerank, name, country']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const mvCountDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'mv_count',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.mv_count',{defaultMessage:'Converts a multivalued expression into a single valued column containing a count of the number of values.'}),preview:false,alias:undefined,signatures:[{params:[{name:'field',type:'boolean',optional:false}],returnType:'integer'},{params:[{name:'field',type:'cartesian_point',optional:false}],returnType:'integer'},{params:[{name:'field',type:'cartesian_shape',optional:false}],returnType:'integer'},{params:[{name:'field',type:'date',optional:false}],returnType:'integer'},{params:[{name:'field',type:'date_nanos',optional:false}],returnType:'integer'},{params:[{name:'field',type:'double',optional:false}],returnType:'integer'},{params:[{name:'field',type:'geo_point',optional:false}],returnType:'integer'},{params:[{name:'field',type:'geo_shape',optional:false}],returnType:'integer'},{params:[{name:'field',type:'geohash',optional:false}],returnType:'integer'},{params:[{name:'field',type:'geohex',optional:false}],returnType:'integer'},{params:[{name:'field',type:'geotile',optional:false}],returnType:'integer'},{params:[{name:'field',type:'integer',optional:false}],returnType:'integer'},{params:[{name:'field',type:'ip',optional:false}],returnType:'integer'},{params:[{name:'field',type:'keyword',optional:false}],returnType:'integer'},{params:[{name:'field',type:'long',optional:false}],returnType:'integer'},{params:[{name:'field',type:'text',optional:false}],returnType:'integer'},{params:[{name:'field',type:'unsigned_long',optional:false}],returnType:'integer'},{params:[{name:'field',type:'version',optional:false}],returnType:'integer'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW a=["foo", "zoo", "bar"]\n| EVAL count_a = MV_COUNT(a)']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const mvDedupeDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'mv_dedupe',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.mv_dedupe',{defaultMessage:'Remove duplicate values from a multivalued field.'}),preview:false,alias:undefined,signatures:[{params:[{name:'field',type:'boolean',optional:false}],returnType:'boolean'},{params:[{name:'field',type:'cartesian_point',optional:false}],returnType:'cartesian_point'},{params:[{name:'field',type:'cartesian_shape',optional:false}],returnType:'cartesian_shape'},{params:[{name:'field',type:'date',optional:false}],returnType:'date'},{params:[{name:'field',type:'date_nanos',optional:false}],returnType:'date_nanos'},{params:[{name:'field',type:'double',optional:false}],returnType:'double'},{params:[{name:'field',type:'geo_point',optional:false}],returnType:'geo_point'},{params:[{name:'field',type:'geo_shape',optional:false}],returnType:'geo_shape'},{params:[{name:'field',type:'geohash',optional:false}],returnType:'geohash'},{params:[{name:'field',type:'geohex',optional:false}],returnType:'geohex'},{params:[{name:'field',type:'geotile',optional:false}],returnType:'geotile'},{params:[{name:'field',type:'integer',optional:false}],returnType:'integer'},{params:[{name:'field',type:'ip',optional:false}],returnType:'ip'},{params:[{name:'field',type:'keyword',optional:false}],returnType:'keyword'},{params:[{name:'field',type:'long',optional:false}],returnType:'long'},{params:[{name:'field',type:'text',optional:false}],returnType:'keyword'},{params:[{name:'field',type:'unsigned_long',optional:false}],returnType:'unsigned_long'},{params:[{name:'field',type:'version',optional:false}],returnType:'version'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW a=["foo", "foo", "bar", "foo"]\n| EVAL dedupe_a = MV_DEDUPE(a)']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const mvFirstDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'mv_first',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.mv_first',{defaultMessage:'Converts a multivalued expression into a single valued column containing the\nfirst value. This is most useful when reading from a function that emits\nmultivalued columns in a known order like `SPLIT`.'}),preview:false,alias:undefined,signatures:[{params:[{name:'field',type:'boolean',optional:false}],returnType:'boolean'},{params:[{name:'field',type:'cartesian_point',optional:false}],returnType:'cartesian_point'},{params:[{name:'field',type:'cartesian_shape',optional:false}],returnType:'cartesian_shape'},{params:[{name:'field',type:'date',optional:false}],returnType:'date'},{params:[{name:'field',type:'date_nanos',optional:false}],returnType:'date_nanos'},{params:[{name:'field',type:'double',optional:false}],returnType:'double'},{params:[{name:'field',type:'geo_point',optional:false}],returnType:'geo_point'},{params:[{name:'field',type:'geo_shape',optional:false}],returnType:'geo_shape'},{params:[{name:'field',type:'geohash',optional:false}],returnType:'geohash'},{params:[{name:'field',type:'geohex',optional:false}],returnType:'geohex'},{params:[{name:'field',type:'geotile',optional:false}],returnType:'geotile'},{params:[{name:'field',type:'integer',optional:false}],returnType:'integer'},{params:[{name:'field',type:'ip',optional:false}],returnType:'ip'},{params:[{name:'field',type:'keyword',optional:false}],returnType:'keyword'},{params:[{name:'field',type:'long',optional:false}],returnType:'long'},{params:[{name:'field',type:'text',optional:false}],returnType:'keyword'},{params:[{name:'field',type:'unsigned_long',optional:false}],returnType:'unsigned_long'},{params:[{name:'field',type:'version',optional:false}],returnType:'version'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW a="foo;bar;baz"\n| EVAL first_a = MV_FIRST(SPLIT(a, ";"))']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const mvLastDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'mv_last',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.mv_last',{defaultMessage:'Converts a multivalue expression into a single valued column containing the last\nvalue. This is most useful when reading from a function that emits multivalued\ncolumns in a known order like `SPLIT`.'}),preview:false,alias:undefined,signatures:[{params:[{name:'field',type:'boolean',optional:false}],returnType:'boolean'},{params:[{name:'field',type:'cartesian_point',optional:false}],returnType:'cartesian_point'},{params:[{name:'field',type:'cartesian_shape',optional:false}],returnType:'cartesian_shape'},{params:[{name:'field',type:'date',optional:false}],returnType:'date'},{params:[{name:'field',type:'date_nanos',optional:false}],returnType:'date_nanos'},{params:[{name:'field',type:'double',optional:false}],returnType:'double'},{params:[{name:'field',type:'geo_point',optional:false}],returnType:'geo_point'},{params:[{name:'field',type:'geo_shape',optional:false}],returnType:'geo_shape'},{params:[{name:'field',type:'geohash',optional:false}],returnType:'geohash'},{params:[{name:'field',type:'geohex',optional:false}],returnType:'geohex'},{params:[{name:'field',type:'geotile',optional:false}],returnType:'geotile'},{params:[{name:'field',type:'integer',optional:false}],returnType:'integer'},{params:[{name:'field',type:'ip',optional:false}],returnType:'ip'},{params:[{name:'field',type:'keyword',optional:false}],returnType:'keyword'},{params:[{name:'field',type:'long',optional:false}],returnType:'long'},{params:[{name:'field',type:'text',optional:false}],returnType:'keyword'},{params:[{name:'field',type:'unsigned_long',optional:false}],returnType:'unsigned_long'},{params:[{name:'field',type:'version',optional:false}],returnType:'version'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW a="foo;bar;baz"\n| EVAL last_a = MV_LAST(SPLIT(a, ";"))']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const mvMaxDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'mv_max',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.mv_max',{defaultMessage:'Converts a multivalued expression into a single valued column containing the maximum value.'}),preview:false,alias:undefined,signatures:[{params:[{name:'field',type:'boolean',optional:false}],returnType:'boolean'},{params:[{name:'field',type:'date',optional:false}],returnType:'date'},{params:[{name:'field',type:'date_nanos',optional:false}],returnType:'date_nanos'},{params:[{name:'field',type:'double',optional:false}],returnType:'double'},{params:[{name:'field',type:'integer',optional:false}],returnType:'integer'},{params:[{name:'field',type:'ip',optional:false}],returnType:'ip'},{params:[{name:'field',type:'keyword',optional:false}],returnType:'keyword'},{params:[{name:'field',type:'long',optional:false}],returnType:'long'},{params:[{name:'field',type:'text',optional:false}],returnType:'keyword'},{params:[{name:'field',type:'unsigned_long',optional:false}],returnType:'unsigned_long'},{params:[{name:'field',type:'version',optional:false}],returnType:'version'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW a=[3, 5, 1]\n| EVAL max_a = MV_MAX(a)','ROW a=["foo", "zoo", "bar"]\n| EVAL max_a = MV_MAX(a)']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const mvMedianDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'mv_median',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.mv_median',{defaultMessage:'Converts a multivalued field into a single valued field containing the median value.'}),preview:false,alias:undefined,signatures:[{params:[{name:'number',type:'double',optional:false}],returnType:'double'},{params:[{name:'number',type:'integer',optional:false}],returnType:'integer'},{params:[{name:'number',type:'long',optional:false}],returnType:'long'},{params:[{name:'number',type:'unsigned_long',optional:false}],returnType:'unsigned_long'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW a=[3, 5, 1]\n| EVAL median_a = MV_MEDIAN(a)','ROW a=[3, 7, 1, 6]\n| EVAL median_a = MV_MEDIAN(a)']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const mvMedianAbsoluteDeviationDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'mv_median_absolute_deviation',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.mv_median_absolute_deviation',{defaultMessage:'Converts a multivalued field into a single valued field containing the median absolute deviation.\n\nIt is calculated as the median of each data point’s deviation from the median of the entire sample. That is, for a random variable `X`, the median absolute deviation is `median(|median(X) - X|)`.'}),preview:false,alias:undefined,signatures:[{params:[{name:'number',type:'double',optional:false}],returnType:'double'},{params:[{name:'number',type:'integer',optional:false}],returnType:'integer'},{params:[{name:'number',type:'long',optional:false}],returnType:'long'},{params:[{name:'number',type:'unsigned_long',optional:false}],returnType:'unsigned_long'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW values = [0, 2, 5, 6]\n| EVAL median_absolute_deviation = MV_MEDIAN_ABSOLUTE_DEVIATION(values), median = MV_MEDIAN(values)']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const mvMinDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'mv_min',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.mv_min',{defaultMessage:'Converts a multivalued expression into a single valued column containing the minimum value.'}),preview:false,alias:undefined,signatures:[{params:[{name:'field',type:'boolean',optional:false}],returnType:'boolean'},{params:[{name:'field',type:'date',optional:false}],returnType:'date'},{params:[{name:'field',type:'date_nanos',optional:false}],returnType:'date_nanos'},{params:[{name:'field',type:'double',optional:false}],returnType:'double'},{params:[{name:'field',type:'integer',optional:false}],returnType:'integer'},{params:[{name:'field',type:'ip',optional:false}],returnType:'ip'},{params:[{name:'field',type:'keyword',optional:false}],returnType:'keyword'},{params:[{name:'field',type:'long',optional:false}],returnType:'long'},{params:[{name:'field',type:'text',optional:false}],returnType:'keyword'},{params:[{name:'field',type:'unsigned_long',optional:false}],returnType:'unsigned_long'},{params:[{name:'field',type:'version',optional:false}],returnType:'version'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW a=[2, 1]\n| EVAL min_a = MV_MIN(a)','ROW a=["foo", "bar"]\n| EVAL min_a = MV_MIN(a)']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const mvPercentileDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'mv_percentile',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.mv_percentile',{defaultMessage:'Converts a multivalued field into a single valued field containing the value at which a certain percentage of observed values occur.'}),preview:false,alias:undefined,signatures:[{params:[{name:'number',type:'double',optional:false},{name:'percentile',type:'double',optional:false}],returnType:'double'},{params:[{name:'number',type:'double',optional:false},{name:'percentile',type:'integer',optional:false}],returnType:'double'},{params:[{name:'number',type:'double',optional:false},{name:'percentile',type:'long',optional:false}],returnType:'double'},{params:[{name:'number',type:'integer',optional:false},{name:'percentile',type:'double',optional:false}],returnType:'integer'},{params:[{name:'number',type:'integer',optional:false},{name:'percentile',type:'integer',optional:false}],returnType:'integer'},{params:[{name:'number',type:'integer',optional:false},{name:'percentile',type:'long',optional:false}],returnType:'integer'},{params:[{name:'number',type:'long',optional:false},{name:'percentile',type:'double',optional:false}],returnType:'long'},{params:[{name:'number',type:'long',optional:false},{name:'percentile',type:'integer',optional:false}],returnType:'long'},{params:[{name:'number',type:'long',optional:false},{name:'percentile',type:'long',optional:false}],returnType:'long'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW values = [5, 5, 10, 12, 5000]\n| EVAL p50 = MV_PERCENTILE(values, 50), median = MV_MEDIAN(values)']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const mvPseriesWeightedSumDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'mv_pseries_weighted_sum',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.mv_pseries_weighted_sum',{defaultMessage:'Converts a multivalued expression into a single-valued column by multiplying every element on the input list by its corresponding term in P-Series and computing the sum.'}),preview:false,alias:undefined,signatures:[{params:[{name:'number',type:'double',optional:false},{name:'p',type:'double',optional:false}],returnType:'double'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW a = [70.0, 45.0, 21.0, 21.0, 21.0]\n| EVAL sum = MV_PSERIES_WEIGHTED_SUM(a, 1.5)\n| KEEP sum']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const mvSliceDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'mv_slice',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.mv_slice',{defaultMessage:'Returns a subset of the multivalued field using the start and end index values.\nThis is most useful when reading from a function that emits multivalued columns\nin a known order like `SPLIT` or `MV_SORT`.'}),preview:false,alias:undefined,signatures:[{params:[{name:'field',type:'boolean',optional:false},{name:'start',type:'integer',optional:false},{name:'end',type:'integer',optional:true}],returnType:'boolean'},{params:[{name:'field',type:'cartesian_point',optional:false},{name:'start',type:'integer',optional:false},{name:'end',type:'integer',optional:true}],returnType:'cartesian_point'},{params:[{name:'field',type:'cartesian_shape',optional:false},{name:'start',type:'integer',optional:false},{name:'end',type:'integer',optional:true}],returnType:'cartesian_shape'},{params:[{name:'field',type:'date',optional:false},{name:'start',type:'integer',optional:false},{name:'end',type:'integer',optional:true}],returnType:'date'},{params:[{name:'field',type:'date_nanos',optional:false},{name:'start',type:'integer',optional:false},{name:'end',type:'integer',optional:true}],returnType:'date_nanos'},{params:[{name:'field',type:'double',optional:false},{name:'start',type:'integer',optional:false},{name:'end',type:'integer',optional:true}],returnType:'double'},{params:[{name:'field',type:'geo_point',optional:false},{name:'start',type:'integer',optional:false},{name:'end',type:'integer',optional:true}],returnType:'geo_point'},{params:[{name:'field',type:'geo_shape',optional:false},{name:'start',type:'integer',optional:false},{name:'end',type:'integer',optional:true}],returnType:'geo_shape'},{params:[{name:'field',type:'geohash',optional:false},{name:'start',type:'integer',optional:false},{name:'end',type:'integer',optional:true}],returnType:'geohash'},{params:[{name:'field',type:'geohex',optional:false},{name:'start',type:'integer',optional:false},{name:'end',type:'integer',optional:true}],returnType:'geohex'},{params:[{name:'field',type:'geotile',optional:false},{name:'start',type:'integer',optional:false},{name:'end',type:'integer',optional:true}],returnType:'geotile'},{params:[{name:'field',type:'integer',optional:false},{name:'start',type:'integer',optional:false},{name:'end',type:'integer',optional:true}],returnType:'integer'},{params:[{name:'field',type:'ip',optional:false},{name:'start',type:'integer',optional:false},{name:'end',type:'integer',optional:true}],returnType:'ip'},{params:[{name:'field',type:'keyword',optional:false},{name:'start',type:'integer',optional:false},{name:'end',type:'integer',optional:true}],returnType:'keyword'},{params:[{name:'field',type:'long',optional:false},{name:'start',type:'integer',optional:false},{name:'end',type:'integer',optional:true}],returnType:'long'},{params:[{name:'field',type:'text',optional:false},{name:'start',type:'integer',optional:false},{name:'end',type:'integer',optional:true}],returnType:'keyword'},{params:[{name:'field',type:'unsigned_long',optional:false},{name:'start',type:'integer',optional:false},{name:'end',type:'integer',optional:true}],returnType:'unsigned_long'},{params:[{name:'field',type:'version',optional:false},{name:'start',type:'integer',optional:false},{name:'end',type:'integer',optional:true}],returnType:'version'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['row a = [1, 2, 2, 3]\n| eval a1 = mv_slice(a, 1), a2 = mv_slice(a, 2, 3)','row a = [1, 2, 2, 3]\n| eval a1 = mv_slice(a, -2), a2 = mv_slice(a, -3, -1)']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const mvSortDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'mv_sort',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.mv_sort',{defaultMessage:'Sorts a multivalued field in lexicographical order.'}),preview:false,alias:undefined,signatures:[{params:[{name:'field',type:'boolean',optional:false},{name:'order',type:'keyword',optional:true,constantOnly:true,suggestedValues:['asc','desc']}],returnType:'boolean'},{params:[{name:'field',type:'date',optional:false},{name:'order',type:'keyword',optional:true,constantOnly:true,suggestedValues:['asc','desc']}],returnType:'date'},{params:[{name:'field',type:'date_nanos',optional:false},{name:'order',type:'keyword',optional:true,constantOnly:true,suggestedValues:['asc','desc']}],returnType:'date_nanos'},{params:[{name:'field',type:'double',optional:false},{name:'order',type:'keyword',optional:true,constantOnly:true,suggestedValues:['asc','desc']}],returnType:'double'},{params:[{name:'field',type:'integer',optional:false},{name:'order',type:'keyword',optional:true,constantOnly:true,suggestedValues:['asc','desc']}],returnType:'integer'},{params:[{name:'field',type:'ip',optional:false},{name:'order',type:'keyword',optional:true,constantOnly:true,suggestedValues:['asc','desc']}],returnType:'ip'},{params:[{name:'field',type:'keyword',optional:false},{name:'order',type:'keyword',optional:true,constantOnly:true,suggestedValues:['asc','desc']}],returnType:'keyword'},{params:[{name:'field',type:'long',optional:false},{name:'order',type:'keyword',optional:true,constantOnly:true,suggestedValues:['asc','desc']}],returnType:'long'},{params:[{name:'field',type:'text',optional:false},{name:'order',type:'keyword',optional:true,constantOnly:true,suggestedValues:['asc','desc']}],returnType:'keyword'},{params:[{name:'field',type:'version',optional:false},{name:'order',type:'keyword',optional:true,constantOnly:true,suggestedValues:['asc','desc']}],returnType:'version'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW a = [4, 2, -3, 2]\n| EVAL sa = mv_sort(a), sd = mv_sort(a, "DESC")']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const mvSumDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'mv_sum',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.mv_sum',{defaultMessage:'Converts a multivalued field into a single valued field containing the sum of all of the values.'}),preview:false,alias:undefined,signatures:[{params:[{name:'number',type:'double',optional:false}],returnType:'double'},{params:[{name:'number',type:'integer',optional:false}],returnType:'integer'},{params:[{name:'number',type:'long',optional:false}],returnType:'long'},{params:[{name:'number',type:'unsigned_long',optional:false}],returnType:'unsigned_long'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW a=[3, 5, 6]\n| EVAL sum_a = MV_SUM(a)']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const mvZipDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'mv_zip',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.mv_zip',{defaultMessage:'Combines the values from two multivalued fields with a delimiter that joins them together.'}),preview:false,alias:undefined,signatures:[{params:[{name:'string1',type:'keyword',optional:false},{name:'string2',type:'keyword',optional:false}],returnType:'keyword'},{params:[{name:'string1',type:'keyword',optional:false},{name:'string2',type:'keyword',optional:false},{name:'delim',type:'keyword',optional:true}],returnType:'keyword'},{params:[{name:'string1',type:'keyword',optional:false},{name:'string2',type:'keyword',optional:false},{name:'delim',type:'text',optional:true}],returnType:'keyword'},{params:[{name:'string1',type:'keyword',optional:false},{name:'string2',type:'text',optional:false}],returnType:'keyword'},{params:[{name:'string1',type:'keyword',optional:false},{name:'string2',type:'text',optional:false},{name:'delim',type:'keyword',optional:true}],returnType:'keyword'},{params:[{name:'string1',type:'keyword',optional:false},{name:'string2',type:'text',optional:false},{name:'delim',type:'text',optional:true}],returnType:'keyword'},{params:[{name:'string1',type:'text',optional:false},{name:'string2',type:'keyword',optional:false}],returnType:'keyword'},{params:[{name:'string1',type:'text',optional:false},{name:'string2',type:'keyword',optional:false},{name:'delim',type:'keyword',optional:true}],returnType:'keyword'},{params:[{name:'string1',type:'text',optional:false},{name:'string2',type:'keyword',optional:false},{name:'delim',type:'text',optional:true}],returnType:'keyword'},{params:[{name:'string1',type:'text',optional:false},{name:'string2',type:'text',optional:false}],returnType:'keyword'},{params:[{name:'string1',type:'text',optional:false},{name:'string2',type:'text',optional:false},{name:'delim',type:'keyword',optional:true}],returnType:'keyword'},{params:[{name:'string1',type:'text',optional:false},{name:'string2',type:'text',optional:false},{name:'delim',type:'text',optional:true}],returnType:'keyword'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW a = ["x", "y", "z"], b = ["1", "2"]\n| EVAL c = mv_zip(a, b, "-")\n| KEEP a, b, c']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const nowDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'now',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.now',{defaultMessage:'Returns current date and time.'}),preview:false,alias:undefined,signatures:[{params:[],returnType:'date'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW current_date = NOW()','FROM sample_data\n| WHERE @timestamp > NOW() - 1 hour']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const piDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'pi',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.pi',{defaultMessage:'Returns Pi, the ratio of a circle’s circumference to its diameter.'}),preview:false,alias:undefined,signatures:[{params:[],returnType:'double'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW PI()']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const powDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'pow',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.pow',{defaultMessage:'Returns the value of `base` raised to the power of `exponent`.'}),preview:false,alias:undefined,signatures:[{params:[{name:'base',type:'double',optional:false},{name:'exponent',type:'double',optional:false}],returnType:'double'},{params:[{name:'base',type:'double',optional:false},{name:'exponent',type:'integer',optional:false}],returnType:'double'},{params:[{name:'base',type:'double',optional:false},{name:'exponent',type:'long',optional:false}],returnType:'double'},{params:[{name:'base',type:'double',optional:false},{name:'exponent',type:'unsigned_long',optional:false}],returnType:'double'},{params:[{name:'base',type:'integer',optional:false},{name:'exponent',type:'double',optional:false}],returnType:'double'},{params:[{name:'base',type:'integer',optional:false},{name:'exponent',type:'integer',optional:false}],returnType:'double'},{params:[{name:'base',type:'integer',optional:false},{name:'exponent',type:'long',optional:false}],returnType:'double'},{params:[{name:'base',type:'integer',optional:false},{name:'exponent',type:'unsigned_long',optional:false}],returnType:'double'},{params:[{name:'base',type:'long',optional:false},{name:'exponent',type:'double',optional:false}],returnType:'double'},{params:[{name:'base',type:'long',optional:false},{name:'exponent',type:'integer',optional:false}],returnType:'double'},{params:[{name:'base',type:'long',optional:false},{name:'exponent',type:'long',optional:false}],returnType:'double'},{params:[{name:'base',type:'long',optional:false},{name:'exponent',type:'unsigned_long',optional:false}],returnType:'double'},{params:[{name:'base',type:'unsigned_long',optional:false},{name:'exponent',type:'double',optional:false}],returnType:'double'},{params:[{name:'base',type:'unsigned_long',optional:false},{name:'exponent',type:'integer',optional:false}],returnType:'double'},{params:[{name:'base',type:'unsigned_long',optional:false},{name:'exponent',type:'long',optional:false}],returnType:'double'},{params:[{name:'base',type:'unsigned_long',optional:false},{name:'exponent',type:'unsigned_long',optional:false}],returnType:'double'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW base = 2.0, exponent = 2\n| EVAL result = POW(base, exponent)','ROW base = 4, exponent = 0.5\n| EVAL s = POW(base, exponent)']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const qstrDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'qstr',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.qstr',{defaultMessage:'Performs a query string query. Returns true if the provided query string matches the row.'}),preview:false,alias:undefined,signatures:[{params:[{name:'query',type:'keyword',optional:false,constantOnly:true},{name:'options',type:'function_named_parameters',mapParams:"{name='max_determinized_states', values=[10000], description='Maximum number of automaton states required for the query. Default is 10000.'}, {name='fuzziness', values=[AUTO, 1, 2], description='Maximum edit distance allowed for matching.'}, {name='auto_generate_synonyms_phrase_query', values=[true, false], description='If true, match phrase queries are automatically created for multi-term synonyms. Defaults to true.'}, {name='phrase_slop', values=[0], description='Maximum number of positions allowed between matching tokens for phrases. Defaults to 0 (which means exact matches are required).'}, {name='default_field', values=[standard], description='Default field to search if no field is provided in the query string. Supports wildcards (*).'}, {name='allow_leading_wildcard', values=[true, false], description='If true, the wildcard characters * and ? are allowed as the first character of the query string. Defaults to true.'}, {name='minimum_should_match', values=[standard], description='Minimum number of clauses that must match for a document to be returned.'}, {name='fuzzy_transpositions', values=[true, false], description='If true, edits for fuzzy matching include transpositions of two adjacent characters (ab → ba). Defaults to true.'}, {name='fuzzy_prefix_length', values=[0], description='Number of beginning characters left unchanged for fuzzy matching. Defaults to 0.'}, {name='time_zone', values=[standard], description='Coordinated Universal Time (UTC) offset or IANA time zone used to convert date values in the query string to UTC.'}, {name='lenient', values=[true, false], description='If false, format-based errors, such as providing a text query value for a numeric field, are returned. Defaults to false.'}, {name='rewrite', values=[standard], description='Method used to rewrite the query.'}, {name='default_operator', values=[OR, AND], description='Default boolean logic used to interpret text in the query string if no operators are specified.'}, {name='analyzer', values=[standard], description='Analyzer used to convert the text in the query value into token. Defaults to the index-time analyzer mapped for the default_field.'}, {name='fuzzy_max_expansions', values=[50], description='Maximum number of terms to which the query expands for fuzzy matching. Defaults to 50.'}, {name='quote_analyzer', values=[standard], description='Analyzer used to convert quoted text in the query string into tokens. Defaults to the search_quote_analyzer mapped for the default_field.'}, {name='allow_wildcard', values=[false, true], description='If true, the query attempts to analyze wildcard terms in the query string. Defaults to false.'}, {name='boost', values=[2.5], description='Floating point number used to decrease or increase the relevance scores of the query.'}, {name='quote_field_suffix', values=[standard], description='Suffix appended to quoted text in the query string.'}, {name='enable_position_increments', values=[true, false], description='If true, enable position increments in queries constructed from a query_string search. Defaults to true.'}, {name='fields', values=[standard], description='Array of fields to search. Supports wildcards (*).'}",optional:true,constantOnly:true}],returnType:'boolean'},{params:[{name:'query',type:'text',optional:false,constantOnly:true},{name:'options',type:'function_named_parameters',mapParams:"{name='max_determinized_states', values=[10000], description='Maximum number of automaton states required for the query. Default is 10000.'}, {name='fuzziness', values=[AUTO, 1, 2], description='Maximum edit distance allowed for matching.'}, {name='auto_generate_synonyms_phrase_query', values=[true, false], description='If true, match phrase queries are automatically created for multi-term synonyms. Defaults to true.'}, {name='phrase_slop', values=[0], description='Maximum number of positions allowed between matching tokens for phrases. Defaults to 0 (which means exact matches are required).'}, {name='default_field', values=[standard], description='Default field to search if no field is provided in the query string. Supports wildcards (*).'}, {name='allow_leading_wildcard', values=[true, false], description='If true, the wildcard characters * and ? are allowed as the first character of the query string. Defaults to true.'}, {name='minimum_should_match', values=[standard], description='Minimum number of clauses that must match for a document to be returned.'}, {name='fuzzy_transpositions', values=[true, false], description='If true, edits for fuzzy matching include transpositions of two adjacent characters (ab → ba). Defaults to true.'}, {name='fuzzy_prefix_length', values=[0], description='Number of beginning characters left unchanged for fuzzy matching. Defaults to 0.'}, {name='time_zone', values=[standard], description='Coordinated Universal Time (UTC) offset or IANA time zone used to convert date values in the query string to UTC.'}, {name='lenient', values=[true, false], description='If false, format-based errors, such as providing a text query value for a numeric field, are returned. Defaults to false.'}, {name='rewrite', values=[standard], description='Method used to rewrite the query.'}, {name='default_operator', values=[OR, AND], description='Default boolean logic used to interpret text in the query string if no operators are specified.'}, {name='analyzer', values=[standard], description='Analyzer used to convert the text in the query value into token. Defaults to the index-time analyzer mapped for the default_field.'}, {name='fuzzy_max_expansions', values=[50], description='Maximum number of terms to which the query expands for fuzzy matching. Defaults to 50.'}, {name='quote_analyzer', values=[standard], description='Analyzer used to convert quoted text in the query string into tokens. Defaults to the search_quote_analyzer mapped for the default_field.'}, {name='allow_wildcard', values=[false, true], description='If true, the query attempts to analyze wildcard terms in the query string. Defaults to false.'}, {name='boost', values=[2.5], description='Floating point number used to decrease or increase the relevance scores of the query.'}, {name='quote_field_suffix', values=[standard], description='Suffix appended to quoted text in the query string.'}, {name='enable_position_increments', values=[true, false], description='If true, enable position increments in queries constructed from a query_string search. Defaults to true.'}, {name='fields', values=[standard], description='Array of fields to search. Supports wildcards (*).'}",optional:true,constantOnly:true}],returnType:'boolean'}],locationsAvailable:[_types.Location.WHERE,_types.Location.STATS_WHERE],examples:['FROM books\n| WHERE QSTR("author: Faulkner")','FROM books\n| WHERE QSTR("title: Hobbjt~", {"fuzziness": 2})'],customParametersSnippet:'"""$0"""'};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const repeatDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'repeat',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.repeat',{defaultMessage:'Returns a string constructed by concatenating `string` with itself the specified `number` of times.'}),preview:false,alias:undefined,signatures:[{params:[{name:'string',type:'keyword',optional:false},{name:'number',type:'integer',optional:false}],returnType:'keyword'},{params:[{name:'string',type:'text',optional:false},{name:'number',type:'integer',optional:false}],returnType:'keyword'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW a = "Hello!"\n| EVAL triple_a = REPEAT(a, 3)']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const replaceDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'replace',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.replace',{defaultMessage:'The function substitutes in the string `str` any match of the regular expression `regex`\nwith the replacement string `newStr`.'}),preview:false,alias:undefined,signatures:[{params:[{name:'string',type:'keyword',optional:false},{name:'regex',type:'keyword',optional:false},{name:'newString',type:'keyword',optional:false}],returnType:'keyword'},{params:[{name:'string',type:'keyword',optional:false},{name:'regex',type:'keyword',optional:false},{name:'newString',type:'text',optional:false}],returnType:'keyword'},{params:[{name:'string',type:'keyword',optional:false},{name:'regex',type:'text',optional:false},{name:'newString',type:'keyword',optional:false}],returnType:'keyword'},{params:[{name:'string',type:'keyword',optional:false},{name:'regex',type:'text',optional:false},{name:'newString',type:'text',optional:false}],returnType:'keyword'},{params:[{name:'string',type:'text',optional:false},{name:'regex',type:'keyword',optional:false},{name:'newString',type:'keyword',optional:false}],returnType:'keyword'},{params:[{name:'string',type:'text',optional:false},{name:'regex',type:'keyword',optional:false},{name:'newString',type:'text',optional:false}],returnType:'keyword'},{params:[{name:'string',type:'text',optional:false},{name:'regex',type:'text',optional:false},{name:'newString',type:'keyword',optional:false}],returnType:'keyword'},{params:[{name:'string',type:'text',optional:false},{name:'regex',type:'text',optional:false},{name:'newString',type:'text',optional:false}],returnType:'keyword'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW str = "Hello World"\n| EVAL str = REPLACE(str, "World", "Universe")','ROW str = "Hello World"\n| EVAL str = REPLACE(str, "\\\\\\\\s+", "")']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const reverseDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'reverse',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.reverse',{defaultMessage:'Returns a new string representing the input string in reverse order.'}),preview:false,alias:undefined,signatures:[{params:[{name:'str',type:'keyword',optional:false}],returnType:'keyword'},{params:[{name:'str',type:'text',optional:false}],returnType:'keyword'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW message = "Some Text" | EVAL message_reversed = REVERSE(message);','ROW bending_arts = "💧🪨🔥💨" | EVAL bending_arts_reversed = REVERSE(bending_arts);']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const rightDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'right',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.right',{defaultMessage:'Return the substring that extracts *length* chars from *str* starting from the right.'}),preview:false,alias:undefined,signatures:[{params:[{name:'string',type:'keyword',optional:false},{name:'length',type:'integer',optional:false}],returnType:'keyword'},{params:[{name:'string',type:'text',optional:false},{name:'length',type:'integer',optional:false}],returnType:'keyword'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['FROM employees\n| KEEP last_name\n| EVAL right = RIGHT(last_name, 3)']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const roundDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'round',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.round',{defaultMessage:'Rounds a number to the specified number of decimal places.\nDefaults to 0, which returns the nearest integer. If the\nprecision is a negative number, rounds to the number of digits left\nof the decimal point.'}),preview:false,alias:undefined,signatures:[{params:[{name:'number',type:'double',optional:false}],returnType:'double'},{params:[{name:'number',type:'double',optional:false},{name:'decimals',type:'integer',optional:true}],returnType:'double'},{params:[{name:'number',type:'double',optional:false},{name:'decimals',type:'long',optional:true}],returnType:'double'},{params:[{name:'number',type:'integer',optional:false}],returnType:'integer'},{params:[{name:'number',type:'integer',optional:false},{name:'decimals',type:'integer',optional:true}],returnType:'integer'},{params:[{name:'number',type:'integer',optional:false},{name:'decimals',type:'long',optional:true}],returnType:'integer'},{params:[{name:'number',type:'long',optional:false}],returnType:'long'},{params:[{name:'number',type:'long',optional:false},{name:'decimals',type:'integer',optional:true}],returnType:'long'},{params:[{name:'number',type:'long',optional:false},{name:'decimals',type:'long',optional:true}],returnType:'long'},{params:[{name:'number',type:'unsigned_long',optional:false}],returnType:'unsigned_long'},{params:[{name:'number',type:'unsigned_long',optional:false},{name:'decimals',type:'integer',optional:true}],returnType:'unsigned_long'},{params:[{name:'number',type:'unsigned_long',optional:false},{name:'decimals',type:'long',optional:true}],returnType:'unsigned_long'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['FROM employees\n| KEEP first_name, last_name, height\n| EVAL height_ft = ROUND(height * 3.281, 1)']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const roundToDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'round_to',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.round_to',{defaultMessage:'Rounds down to one of a list of fixed points.'}),preview:false,alias:undefined,signatures:[{params:[{name:'field',type:'date',optional:false},{name:'points',type:'date',optional:false}],returnType:'date',minParams:2},{params:[{name:'field',type:'date_nanos',optional:false},{name:'points',type:'date_nanos',optional:false}],returnType:'date_nanos',minParams:2},{params:[{name:'field',type:'double',optional:false},{name:'points',type:'double',optional:false}],returnType:'double',minParams:2},{params:[{name:'field',type:'double',optional:false},{name:'points',type:'integer',optional:false}],returnType:'double',minParams:2},{params:[{name:'field',type:'double',optional:false},{name:'points',type:'long',optional:false}],returnType:'double',minParams:2},{params:[{name:'field',type:'integer',optional:false},{name:'points',type:'double',optional:false}],returnType:'double',minParams:2},{params:[{name:'field',type:'integer',optional:false},{name:'points',type:'integer',optional:false}],returnType:'integer',minParams:2},{params:[{name:'field',type:'integer',optional:false},{name:'points',type:'long',optional:false}],returnType:'long',minParams:2},{params:[{name:'field',type:'long',optional:false},{name:'points',type:'double',optional:false}],returnType:'double',minParams:2},{params:[{name:'field',type:'long',optional:false},{name:'points',type:'integer',optional:false}],returnType:'long',minParams:2},{params:[{name:'field',type:'long',optional:false},{name:'points',type:'long',optional:false}],returnType:'long',minParams:2}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['FROM employees\n| STATS COUNT(*) BY birth_window=ROUND_TO(\n    birth_date,\n    "1900-01-01T00:00:00Z"::DATETIME,\n    "1950-01-01T00:00:00Z"::DATETIME,\n    "1955-01-01T00:00:00Z"::DATETIME,\n    "1960-01-01T00:00:00Z"::DATETIME,\n    "1965-01-01T00:00:00Z"::DATETIME,\n    "1970-01-01T00:00:00Z"::DATETIME,\n    "1975-01-01T00:00:00Z"::DATETIME\n)\n| SORT birth_window ASC']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const rtrimDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'rtrim',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.rtrim',{defaultMessage:'Removes trailing whitespaces from a string.'}),preview:false,alias:undefined,signatures:[{params:[{name:'string',type:'keyword',optional:false}],returnType:'keyword'},{params:[{name:'string',type:'text',optional:false}],returnType:'keyword'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW message = "   some text  ",  color = " red "\n| EVAL message = RTRIM(message)\n| EVAL color = RTRIM(color)\n| EVAL message = CONCAT("\'", message, "\'")\n| EVAL color = CONCAT("\'", color, "\'")']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const scalbDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'scalb',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.scalb',{defaultMessage:"Returns the result of `d * 2 ^ scaleFactor`,\nSimilar to Java's `scalb` function. Result is rounded as if\nperformed by a single correctly rounded floating-point multiply\nto a member of the double value set."}),preview:false,alias:undefined,signatures:[{params:[{name:'d',type:'double',optional:false},{name:'scaleFactor',type:'integer',optional:false}],returnType:'double'},{params:[{name:'d',type:'double',optional:false},{name:'scaleFactor',type:'long',optional:false}],returnType:'double'},{params:[{name:'d',type:'integer',optional:false},{name:'scaleFactor',type:'integer',optional:false}],returnType:'double'},{params:[{name:'d',type:'integer',optional:false},{name:'scaleFactor',type:'long',optional:false}],returnType:'double'},{params:[{name:'d',type:'long',optional:false},{name:'scaleFactor',type:'integer',optional:false}],returnType:'double'},{params:[{name:'d',type:'long',optional:false},{name:'scaleFactor',type:'long',optional:false}],returnType:'double'},{params:[{name:'d',type:'unsigned_long',optional:false},{name:'scaleFactor',type:'integer',optional:false}],returnType:'double'},{params:[{name:'d',type:'unsigned_long',optional:false},{name:'scaleFactor',type:'long',optional:false}],returnType:'double'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['row x = 3.0, y = 10 | eval z = scalb(x, y)']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const scoreDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'score',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.score',{defaultMessage:'Scores an expression. Only full text functions will be scored. Returns scores for all the resulting docs.'}),ignoreAsSuggestion:true,preview:true,alias:undefined,signatures:[{params:[{name:'query',type:'boolean',optional:false}],returnType:'double'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['FROM books METADATA _score\n| WHERE match(title, "Return") AND match(author, "Tolkien")\n| EVAL first_score = score(match(title, "Return"))']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const sha1Definition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'sha1',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.sha1',{defaultMessage:'Computes the SHA1 hash of the input.'}),preview:false,alias:undefined,signatures:[{params:[{name:'input',type:'keyword',optional:false}],returnType:'keyword'},{params:[{name:'input',type:'text',optional:false}],returnType:'keyword'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['FROM sample_data\n| WHERE message != "Connection error"\n| EVAL sha1 = sha1(message)\n| KEEP message, sha1']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const sha256Definition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'sha256',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.sha256',{defaultMessage:'Computes the SHA256 hash of the input.'}),preview:false,alias:undefined,signatures:[{params:[{name:'input',type:'keyword',optional:false}],returnType:'keyword'},{params:[{name:'input',type:'text',optional:false}],returnType:'keyword'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['FROM sample_data\n| WHERE message != "Connection error"\n| EVAL sha256 = sha256(message)\n| KEEP message, sha256']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const signumDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'signum',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.signum',{defaultMessage:'Returns the sign of the given number.\nIt returns `-1` for negative numbers, `0` for `0` and `1` for positive numbers.'}),preview:false,alias:undefined,signatures:[{params:[{name:'number',type:'double',optional:false}],returnType:'double'},{params:[{name:'number',type:'integer',optional:false}],returnType:'double'},{params:[{name:'number',type:'long',optional:false}],returnType:'double'},{params:[{name:'number',type:'unsigned_long',optional:false}],returnType:'double'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW d = 100.0\n| EVAL s = SIGNUM(d)']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const sinDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'sin',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.sin',{defaultMessage:'Returns the sine of an angle.'}),preview:false,alias:undefined,signatures:[{params:[{name:'angle',type:'double',optional:false}],returnType:'double'},{params:[{name:'angle',type:'integer',optional:false}],returnType:'double'},{params:[{name:'angle',type:'long',optional:false}],returnType:'double'},{params:[{name:'angle',type:'unsigned_long',optional:false}],returnType:'double'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW a=1.8\n| EVAL sin=SIN(a)']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const sinhDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'sinh',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.sinh',{defaultMessage:'Returns the hyperbolic sine of a number.'}),preview:false,alias:undefined,signatures:[{params:[{name:'number',type:'double',optional:false}],returnType:'double'},{params:[{name:'number',type:'integer',optional:false}],returnType:'double'},{params:[{name:'number',type:'long',optional:false}],returnType:'double'},{params:[{name:'number',type:'unsigned_long',optional:false}],returnType:'double'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW a=1.8\n| EVAL sinh=SINH(a)']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const spaceDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'space',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.space',{defaultMessage:'Returns a string made of `number` spaces.'}),preview:false,alias:undefined,signatures:[{params:[{name:'number',type:'integer',optional:false}],returnType:'keyword'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW message = CONCAT("Hello", SPACE(1), "World!");']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const splitDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'split',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.split',{defaultMessage:'Split a single valued string into multiple strings.'}),preview:false,alias:undefined,signatures:[{params:[{name:'string',type:'keyword',optional:false},{name:'delim',type:'keyword',optional:false}],returnType:'keyword'},{params:[{name:'string',type:'keyword',optional:false},{name:'delim',type:'text',optional:false}],returnType:'keyword'},{params:[{name:'string',type:'text',optional:false},{name:'delim',type:'keyword',optional:false}],returnType:'keyword'},{params:[{name:'string',type:'text',optional:false},{name:'delim',type:'text',optional:false}],returnType:'keyword'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW words="foo;bar;baz;qux;quux;corge"\n| EVAL word = SPLIT(words, ";")']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const sqrtDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'sqrt',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.sqrt',{defaultMessage:'Returns the square root of a number. The input can be any numeric value, the return value is always a double.\nSquare roots of negative numbers and infinities are null.'}),preview:false,alias:undefined,signatures:[{params:[{name:'number',type:'double',optional:false}],returnType:'double'},{params:[{name:'number',type:'integer',optional:false}],returnType:'double'},{params:[{name:'number',type:'long',optional:false}],returnType:'double'},{params:[{name:'number',type:'unsigned_long',optional:false}],returnType:'double'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW d = 100.0\n| EVAL s = SQRT(d)']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const stContainsDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'st_contains',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.st_contains',{defaultMessage:'Returns whether the first geometry contains the second geometry.\nThis is the inverse of the ST_WITHIN function.'}),preview:false,alias:undefined,signatures:[{params:[{name:'geomA',type:'cartesian_point',optional:false},{name:'geomB',type:'cartesian_point',optional:false}],returnType:'boolean'},{params:[{name:'geomA',type:'cartesian_point',optional:false},{name:'geomB',type:'cartesian_shape',optional:false}],returnType:'boolean'},{params:[{name:'geomA',type:'cartesian_shape',optional:false},{name:'geomB',type:'cartesian_point',optional:false}],returnType:'boolean'},{params:[{name:'geomA',type:'cartesian_shape',optional:false},{name:'geomB',type:'cartesian_shape',optional:false}],returnType:'boolean'},{params:[{name:'geomA',type:'geo_point',optional:false},{name:'geomB',type:'geo_point',optional:false}],returnType:'boolean'},{params:[{name:'geomA',type:'geo_point',optional:false},{name:'geomB',type:'geo_shape',optional:false}],returnType:'boolean'},{params:[{name:'geomA',type:'geo_shape',optional:false},{name:'geomB',type:'geo_point',optional:false}],returnType:'boolean'},{params:[{name:'geomA',type:'geo_shape',optional:false},{name:'geomB',type:'geo_shape',optional:false}],returnType:'boolean'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['FROM airport_city_boundaries\n| WHERE ST_CONTAINS(city_boundary, TO_GEOSHAPE("POLYGON((109.35 18.3, 109.45 18.3, 109.45 18.4, 109.35 18.4, 109.35 18.3))"))\n| KEEP abbrev, airport, region, city, city_location']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const stDisjointDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'st_disjoint',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.st_disjoint',{defaultMessage:'Returns whether the two geometries or geometry columns are disjoint.\nThis is the inverse of the ST_INTERSECTS function.\nIn mathematical terms: ST_Disjoint(A, B) ⇔ A ⋂ B = ∅'}),preview:false,alias:undefined,signatures:[{params:[{name:'geomA',type:'cartesian_point',optional:false},{name:'geomB',type:'cartesian_point',optional:false}],returnType:'boolean'},{params:[{name:'geomA',type:'cartesian_point',optional:false},{name:'geomB',type:'cartesian_shape',optional:false}],returnType:'boolean'},{params:[{name:'geomA',type:'cartesian_shape',optional:false},{name:'geomB',type:'cartesian_point',optional:false}],returnType:'boolean'},{params:[{name:'geomA',type:'cartesian_shape',optional:false},{name:'geomB',type:'cartesian_shape',optional:false}],returnType:'boolean'},{params:[{name:'geomA',type:'geo_point',optional:false},{name:'geomB',type:'geo_point',optional:false}],returnType:'boolean'},{params:[{name:'geomA',type:'geo_point',optional:false},{name:'geomB',type:'geo_shape',optional:false}],returnType:'boolean'},{params:[{name:'geomA',type:'geo_point',optional:false},{name:'geomB',type:'geohash',optional:false}],returnType:'boolean'},{params:[{name:'geomA',type:'geo_point',optional:false},{name:'geomB',type:'geohex',optional:false}],returnType:'boolean'},{params:[{name:'geomA',type:'geo_point',optional:false},{name:'geomB',type:'geotile',optional:false}],returnType:'boolean'},{params:[{name:'geomA',type:'geo_shape',optional:false},{name:'geomB',type:'geo_point',optional:false}],returnType:'boolean'},{params:[{name:'geomA',type:'geo_shape',optional:false},{name:'geomB',type:'geo_shape',optional:false}],returnType:'boolean'},{params:[{name:'geomA',type:'geohash',optional:false},{name:'geomB',type:'geo_point',optional:false}],returnType:'boolean'},{params:[{name:'geomA',type:'geohex',optional:false},{name:'geomB',type:'geo_point',optional:false}],returnType:'boolean'},{params:[{name:'geomA',type:'geotile',optional:false},{name:'geomB',type:'geo_point',optional:false}],returnType:'boolean'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['FROM airport_city_boundaries\n| WHERE ST_DISJOINT(city_boundary, TO_GEOSHAPE("POLYGON((-10 -60, 120 -60, 120 60, -10 60, -10 -60))"))\n| KEEP abbrev, airport, region, city, city_location']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const stDistanceDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'st_distance',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.st_distance',{defaultMessage:'Computes the distance between two points.\nFor cartesian geometries, this is the pythagorean distance in the same units as the original coordinates.\nFor geographic geometries, this is the circular distance along the great circle in meters.'}),preview:false,alias:undefined,signatures:[{params:[{name:'geomA',type:'cartesian_point',optional:false},{name:'geomB',type:'cartesian_point',optional:false}],returnType:'double'},{params:[{name:'geomA',type:'geo_point',optional:false},{name:'geomB',type:'geo_point',optional:false}],returnType:'double'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['FROM airports\n| WHERE abbrev == "CPH"\n| EVAL distance = ST_DISTANCE(location, city_location)\n| KEEP abbrev, name, location, city_location, distance']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const stEnvelopeDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'st_envelope',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.st_envelope',{defaultMessage:'Determines the minimum bounding box of the supplied geometry.'}),preview:true,alias:undefined,signatures:[{params:[{name:'geometry',type:'cartesian_point',optional:false}],returnType:'cartesian_shape'},{params:[{name:'geometry',type:'cartesian_shape',optional:false}],returnType:'cartesian_shape'},{params:[{name:'geometry',type:'geo_point',optional:false}],returnType:'geo_shape'},{params:[{name:'geometry',type:'geo_shape',optional:false}],returnType:'geo_shape'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['FROM airport_city_boundaries\n| WHERE abbrev == "CPH"\n| EVAL envelope = ST_ENVELOPE(city_boundary)\n| KEEP abbrev, airport, envelope']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const stGeohashDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'st_geohash',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.st_geohash',{defaultMessage:'Calculates the `geohash` of the supplied geo_point at the specified precision.\nThe result is long encoded. Use TO_STRING to convert the result to a string,\nTO_LONG to convert it to a `long`, or TO_GEOSHAPE to calculate\nthe `geo_shape` bounding geometry.\n\nThese functions are related to the `geo_grid` query\nand the `geohash_grid` aggregation.'}),preview:true,alias:undefined,signatures:[{params:[{name:'geometry',type:'geo_point',optional:false},{name:'precision',type:'integer',optional:false}],returnType:'geohash'},{params:[{name:'geometry',type:'geo_point',optional:false},{name:'precision',type:'integer',optional:false},{name:'bounds',type:'geo_shape',optional:true}],returnType:'geohash'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['FROM airports\n| EVAL geohash = ST_GEOHASH(location, 1)\n| STATS\n    count = COUNT(geohash),\n    centroid = ST_CENTROID_AGG(location)\n      BY geohash\n| WHERE count >= 10\n| EVAL geohashString = TO_STRING(geohash)\n| KEEP count, centroid, geohashString\n| SORT count DESC, geohashString ASC']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const stGeohexDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'st_geohex',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.st_geohex',{defaultMessage:'Calculates the `geohex`, the H3 cell-id, of the supplied geo_point at the specified precision.\nThe result is long encoded. Use TO_STRING to convert the result to a string,\nTO_LONG to convert it to a `long`, or TO_GEOSHAPE to calculate\nthe `geo_shape` bounding geometry.\n\nThese functions are related to the `geo_grid` query\nand the `geohex_grid` aggregation.'}),preview:true,alias:undefined,signatures:[{params:[{name:'geometry',type:'geo_point',optional:false},{name:'precision',type:'integer',optional:false}],license:'platinum',returnType:'geohex'},{params:[{name:'geometry',type:'geo_point',optional:false},{name:'precision',type:'integer',optional:false},{name:'bounds',type:'geo_shape',optional:true}],license:'platinum',returnType:'geohex'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],license:'platinum',examples:['FROM airports\n| EVAL geohex = ST_GEOHEX(location, 1)\n| STATS\n    count = COUNT(geohex),\n    centroid = ST_CENTROID_AGG(location)\n      BY geohex\n| WHERE count >= 10\n| EVAL geohexString = TO_STRING(geohex)\n| KEEP count, centroid, geohexString\n| SORT count DESC, geohexString ASC']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const stGeotileDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'st_geotile',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.st_geotile',{defaultMessage:'Calculates the `geotile` of the supplied geo_point at the specified precision.\nThe result is long encoded. Use TO_STRING to convert the result to a string,\nTO_LONG to convert it to a `long`, or TO_GEOSHAPE to calculate\nthe `geo_shape` bounding geometry.\n\nThese functions are related to the `geo_grid` query\nand the `geotile_grid` aggregation.'}),preview:true,alias:undefined,signatures:[{params:[{name:'geometry',type:'geo_point',optional:false},{name:'precision',type:'integer',optional:false}],returnType:'geotile'},{params:[{name:'geometry',type:'geo_point',optional:false},{name:'precision',type:'integer',optional:false},{name:'bounds',type:'geo_shape',optional:true}],returnType:'geotile'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['FROM airports\n| EVAL geotile = ST_GEOTILE(location, 2)\n| STATS\n    count = COUNT(geotile),\n    centroid = ST_CENTROID_AGG(location)\n      BY geotile\n| EVAL geotileString = TO_STRING(geotile)\n| SORT count DESC, geotileString ASC\n| KEEP count, centroid, geotileString']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const stIntersectsDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'st_intersects',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.st_intersects',{defaultMessage:'Returns true if two geometries intersect.\nThey intersect if they have any point in common, including their interior points\n(points along lines or within polygons).\nThis is the inverse of the ST_DISJOINT function.\nIn mathematical terms: ST_Intersects(A, B) ⇔ A ⋂ B ≠ ∅'}),preview:false,alias:undefined,signatures:[{params:[{name:'geomA',type:'cartesian_point',optional:false},{name:'geomB',type:'cartesian_point',optional:false}],returnType:'boolean'},{params:[{name:'geomA',type:'cartesian_point',optional:false},{name:'geomB',type:'cartesian_shape',optional:false}],returnType:'boolean'},{params:[{name:'geomA',type:'cartesian_shape',optional:false},{name:'geomB',type:'cartesian_point',optional:false}],returnType:'boolean'},{params:[{name:'geomA',type:'cartesian_shape',optional:false},{name:'geomB',type:'cartesian_shape',optional:false}],returnType:'boolean'},{params:[{name:'geomA',type:'geo_point',optional:false},{name:'geomB',type:'geo_point',optional:false}],returnType:'boolean'},{params:[{name:'geomA',type:'geo_point',optional:false},{name:'geomB',type:'geo_shape',optional:false}],returnType:'boolean'},{params:[{name:'geomA',type:'geo_point',optional:false},{name:'geomB',type:'geohash',optional:false}],returnType:'boolean'},{params:[{name:'geomA',type:'geo_point',optional:false},{name:'geomB',type:'geohex',optional:false}],returnType:'boolean'},{params:[{name:'geomA',type:'geo_point',optional:false},{name:'geomB',type:'geotile',optional:false}],returnType:'boolean'},{params:[{name:'geomA',type:'geo_shape',optional:false},{name:'geomB',type:'geo_point',optional:false}],returnType:'boolean'},{params:[{name:'geomA',type:'geo_shape',optional:false},{name:'geomB',type:'geo_shape',optional:false}],returnType:'boolean'},{params:[{name:'geomA',type:'geohash',optional:false},{name:'geomB',type:'geo_point',optional:false}],returnType:'boolean'},{params:[{name:'geomA',type:'geohex',optional:false},{name:'geomB',type:'geo_point',optional:false}],returnType:'boolean'},{params:[{name:'geomA',type:'geotile',optional:false},{name:'geomB',type:'geo_point',optional:false}],returnType:'boolean'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['FROM airports\n| WHERE ST_INTERSECTS(location, TO_GEOSHAPE("POLYGON((42 14, 43 14, 43 15, 42 15, 42 14))"))']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const stWithinDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'st_within',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.st_within',{defaultMessage:'Returns whether the first geometry is within the second geometry.\nThis is the inverse of the ST_CONTAINS function.'}),preview:false,alias:undefined,signatures:[{params:[{name:'geomA',type:'cartesian_point',optional:false},{name:'geomB',type:'cartesian_point',optional:false}],returnType:'boolean'},{params:[{name:'geomA',type:'cartesian_point',optional:false},{name:'geomB',type:'cartesian_shape',optional:false}],returnType:'boolean'},{params:[{name:'geomA',type:'cartesian_shape',optional:false},{name:'geomB',type:'cartesian_point',optional:false}],returnType:'boolean'},{params:[{name:'geomA',type:'cartesian_shape',optional:false},{name:'geomB',type:'cartesian_shape',optional:false}],returnType:'boolean'},{params:[{name:'geomA',type:'geo_point',optional:false},{name:'geomB',type:'geo_point',optional:false}],returnType:'boolean'},{params:[{name:'geomA',type:'geo_point',optional:false},{name:'geomB',type:'geo_shape',optional:false}],returnType:'boolean'},{params:[{name:'geomA',type:'geo_shape',optional:false},{name:'geomB',type:'geo_point',optional:false}],returnType:'boolean'},{params:[{name:'geomA',type:'geo_shape',optional:false},{name:'geomB',type:'geo_shape',optional:false}],returnType:'boolean'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['FROM airport_city_boundaries\n| WHERE ST_WITHIN(city_boundary, TO_GEOSHAPE("POLYGON((109.1 18.15, 109.6 18.15, 109.6 18.65, 109.1 18.65, 109.1 18.15))"))\n| KEEP abbrev, airport, region, city, city_location']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const stXDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'st_x',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.st_x',{defaultMessage:'Extracts the `x` coordinate from the supplied point.\nIf the points is of type `geo_point` this is equivalent to extracting the `longitude` value.'}),preview:false,alias:undefined,signatures:[{params:[{name:'point',type:'cartesian_point',optional:false}],returnType:'double'},{params:[{name:'point',type:'geo_point',optional:false}],returnType:'double'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW point = TO_GEOPOINT("POINT(42.97109629958868 14.7552534006536)")\n| EVAL x =  ST_X(point), y = ST_Y(point)']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const stXmaxDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'st_xmax',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.st_xmax',{defaultMessage:'Extracts the maximum value of the `x` coordinates from the supplied geometry.\nIf the geometry is of type `geo_point` or `geo_shape` this is equivalent to extracting the maximum `longitude` value.'}),preview:true,alias:undefined,signatures:[{params:[{name:'point',type:'cartesian_point',optional:false}],returnType:'double'},{params:[{name:'point',type:'cartesian_shape',optional:false}],returnType:'double'},{params:[{name:'point',type:'geo_point',optional:false}],returnType:'double'},{params:[{name:'point',type:'geo_shape',optional:false}],returnType:'double'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['FROM airport_city_boundaries\n| WHERE abbrev == "CPH"\n| EVAL envelope = ST_ENVELOPE(city_boundary)\n| EVAL xmin = ST_XMIN(envelope), xmax = ST_XMAX(envelope), ymin = ST_YMIN(envelope), ymax = ST_YMAX(envelope)\n| KEEP abbrev, airport, xmin, xmax, ymin, ymax']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const stXminDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'st_xmin',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.st_xmin',{defaultMessage:'Extracts the minimum value of the `x` coordinates from the supplied geometry.\nIf the geometry is of type `geo_point` or `geo_shape` this is equivalent to extracting the minimum `longitude` value.'}),preview:true,alias:undefined,signatures:[{params:[{name:'point',type:'cartesian_point',optional:false}],returnType:'double'},{params:[{name:'point',type:'cartesian_shape',optional:false}],returnType:'double'},{params:[{name:'point',type:'geo_point',optional:false}],returnType:'double'},{params:[{name:'point',type:'geo_shape',optional:false}],returnType:'double'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['FROM airport_city_boundaries\n| WHERE abbrev == "CPH"\n| EVAL envelope = ST_ENVELOPE(city_boundary)\n| EVAL xmin = ST_XMIN(envelope), xmax = ST_XMAX(envelope), ymin = ST_YMIN(envelope), ymax = ST_YMAX(envelope)\n| KEEP abbrev, airport, xmin, xmax, ymin, ymax']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const stYDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'st_y',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.st_y',{defaultMessage:'Extracts the `y` coordinate from the supplied point.\nIf the points is of type `geo_point` this is equivalent to extracting the `latitude` value.'}),preview:false,alias:undefined,signatures:[{params:[{name:'point',type:'cartesian_point',optional:false}],returnType:'double'},{params:[{name:'point',type:'geo_point',optional:false}],returnType:'double'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW point = TO_GEOPOINT("POINT(42.97109629958868 14.7552534006536)")\n| EVAL x =  ST_X(point), y = ST_Y(point)']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const stYmaxDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'st_ymax',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.st_ymax',{defaultMessage:'Extracts the maximum value of the `y` coordinates from the supplied geometry.\nIf the geometry is of type `geo_point` or `geo_shape` this is equivalent to extracting the maximum `latitude` value.'}),preview:true,alias:undefined,signatures:[{params:[{name:'point',type:'cartesian_point',optional:false}],returnType:'double'},{params:[{name:'point',type:'cartesian_shape',optional:false}],returnType:'double'},{params:[{name:'point',type:'geo_point',optional:false}],returnType:'double'},{params:[{name:'point',type:'geo_shape',optional:false}],returnType:'double'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['FROM airport_city_boundaries\n| WHERE abbrev == "CPH"\n| EVAL envelope = ST_ENVELOPE(city_boundary)\n| EVAL xmin = ST_XMIN(envelope), xmax = ST_XMAX(envelope), ymin = ST_YMIN(envelope), ymax = ST_YMAX(envelope)\n| KEEP abbrev, airport, xmin, xmax, ymin, ymax']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const stYminDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'st_ymin',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.st_ymin',{defaultMessage:'Extracts the minimum value of the `y` coordinates from the supplied geometry.\nIf the geometry is of type `geo_point` or `geo_shape` this is equivalent to extracting the minimum `latitude` value.'}),preview:true,alias:undefined,signatures:[{params:[{name:'point',type:'cartesian_point',optional:false}],returnType:'double'},{params:[{name:'point',type:'cartesian_shape',optional:false}],returnType:'double'},{params:[{name:'point',type:'geo_point',optional:false}],returnType:'double'},{params:[{name:'point',type:'geo_shape',optional:false}],returnType:'double'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['FROM airport_city_boundaries\n| WHERE abbrev == "CPH"\n| EVAL envelope = ST_ENVELOPE(city_boundary)\n| EVAL xmin = ST_XMIN(envelope), xmax = ST_XMAX(envelope), ymin = ST_YMIN(envelope), ymax = ST_YMAX(envelope)\n| KEEP abbrev, airport, xmin, xmax, ymin, ymax']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const startsWithDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'starts_with',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.starts_with',{defaultMessage:'Returns a boolean that indicates whether a keyword string starts with another string.'}),preview:false,alias:undefined,signatures:[{params:[{name:'str',type:'keyword',optional:false},{name:'prefix',type:'keyword',optional:false}],returnType:'boolean'},{params:[{name:'str',type:'keyword',optional:false},{name:'prefix',type:'text',optional:false}],returnType:'boolean'},{params:[{name:'str',type:'text',optional:false},{name:'prefix',type:'keyword',optional:false}],returnType:'boolean'},{params:[{name:'str',type:'text',optional:false},{name:'prefix',type:'text',optional:false}],returnType:'boolean'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['FROM employees\n| KEEP last_name\n| EVAL ln_S = STARTS_WITH(last_name, "B")']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const substringDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'substring',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.substring',{defaultMessage:'Returns a substring of a string, specified by a start position and an optional length.'}),preview:false,alias:undefined,signatures:[{params:[{name:'string',type:'keyword',optional:false},{name:'start',type:'integer',optional:false},{name:'length',type:'integer',optional:true}],returnType:'keyword'},{params:[{name:'string',type:'text',optional:false},{name:'start',type:'integer',optional:false},{name:'length',type:'integer',optional:true}],returnType:'keyword'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['FROM employees\n| KEEP last_name\n| EVAL ln_sub = SUBSTRING(last_name, 1, 3)','FROM employees\n| KEEP last_name\n| EVAL ln_sub = SUBSTRING(last_name, -3, 3)','FROM employees\n| KEEP last_name\n| EVAL ln_sub = SUBSTRING(last_name, 2)']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const tanDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'tan',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.tan',{defaultMessage:'Returns the tangent of an angle.'}),preview:false,alias:undefined,signatures:[{params:[{name:'angle',type:'double',optional:false}],returnType:'double'},{params:[{name:'angle',type:'integer',optional:false}],returnType:'double'},{params:[{name:'angle',type:'long',optional:false}],returnType:'double'},{params:[{name:'angle',type:'unsigned_long',optional:false}],returnType:'double'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW a=1.8\n| EVAL tan=TAN(a)']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const tanhDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'tanh',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.tanh',{defaultMessage:'Returns the hyperbolic tangent of a number.'}),preview:false,alias:undefined,signatures:[{params:[{name:'number',type:'double',optional:false}],returnType:'double'},{params:[{name:'number',type:'integer',optional:false}],returnType:'double'},{params:[{name:'number',type:'long',optional:false}],returnType:'double'},{params:[{name:'number',type:'unsigned_long',optional:false}],returnType:'double'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW a=1.8\n| EVAL tanh=TANH(a)']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const tauDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'tau',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.tau',{defaultMessage:'Returns the ratio of a circle’s circumference to its radius.'}),preview:false,alias:undefined,signatures:[{params:[],returnType:'double'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW TAU()']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const termDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'term',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.term',{defaultMessage:'Performs a Term query on the specified field. Returns true if the provided term matches the row.'}),ignoreAsSuggestion:true,preview:true,alias:undefined,signatures:[{params:[{name:'field',type:'keyword',optional:false},{name:'query',type:'keyword',optional:false}],returnType:'boolean'},{params:[{name:'field',type:'keyword',optional:false},{name:'query',type:'text',optional:false}],returnType:'boolean'},{params:[{name:'field',type:'text',optional:false},{name:'query',type:'keyword',optional:false}],returnType:'boolean'},{params:[{name:'field',type:'text',optional:false},{name:'query',type:'text',optional:false}],returnType:'boolean'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['FROM books\n| WHERE TERM(author, "gabriel")']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const textEmbeddingDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'text_embedding',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.text_embedding',{defaultMessage:'Generates dense vector embeddings from text input using a specified inference endpoint. Use this function to generate query vectors for KNN searches against your vectorized data or others dense vector based operations.'}),preview:true,alias:undefined,signatures:[{params:[{name:'text',type:'keyword',optional:false},{name:'inference_id',type:'keyword',optional:false}],returnType:'dense_vector'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW input="Who is Victor Hugo?"\n| EVAL embedding = TEXT_EMBEDDING("Who is Victor Hugo?", "test_dense_inference")','FROM semantic_text METADATA _score\n| EVAL query_embedding = TEXT_EMBEDDING("be excellent to each other", "test_dense_inference")\n| WHERE KNN(semantic_text_dense_field, query_embedding)','FROM semantic_text METADATA _score\n| WHERE KNN(semantic_text_dense_field, TEXT_EMBEDDING("be excellent to each other", "test_dense_inference"))']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const toAggregateMetricDoubleDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'to_aggregate_metric_double',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.to_aggregate_metric_double',{defaultMessage:'Encode a numeric to an aggregate_metric_double.'}),preview:false,alias:undefined,signatures:[{params:[{name:'number',type:'aggregate_metric_double',optional:false}],returnType:'aggregate_metric_double'},{params:[{name:'number',type:'double',optional:false}],returnType:'aggregate_metric_double'},{params:[{name:'number',type:'integer',optional:false}],returnType:'aggregate_metric_double'},{params:[{name:'number',type:'long',optional:false}],returnType:'aggregate_metric_double'},{params:[{name:'number',type:'unsigned_long',optional:false}],returnType:'aggregate_metric_double'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW x = 3892095203\n| EVAL agg_metric = TO_AGGREGATE_METRIC_DOUBLE(x)','ROW x = [5032, 11111, 40814]\n| EVAL agg_metric = TO_AGGREGATE_METRIC_DOUBLE(x)']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const toBase64Definition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'to_base64',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.to_base64',{defaultMessage:'Encode a string to a base64 string.'}),preview:false,alias:undefined,signatures:[{params:[{name:'string',type:'keyword',optional:false}],returnType:'keyword'},{params:[{name:'string',type:'text',optional:false}],returnType:'keyword'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW a = "elastic"\n| EVAL e = TO_BASE64(a)']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const toBooleanDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'to_boolean',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.to_boolean',{defaultMessage:'Converts an input value to a boolean value.\nA string value of `true` will be case-insensitive converted to the Boolean `true`.\nFor anything else, including the empty string, the function will return `false`.\nThe numerical value of `0` will be converted to `false`, anything else will be converted to `true`.'}),preview:false,alias:['to_bool'],signatures:[{params:[{name:'field',type:'boolean',optional:false}],returnType:'boolean'},{params:[{name:'field',type:'double',optional:false}],returnType:'boolean'},{params:[{name:'field',type:'integer',optional:false}],returnType:'boolean'},{params:[{name:'field',type:'keyword',optional:false}],returnType:'boolean'},{params:[{name:'field',type:'long',optional:false}],returnType:'boolean'},{params:[{name:'field',type:'text',optional:false}],returnType:'boolean'},{params:[{name:'field',type:'unsigned_long',optional:false}],returnType:'boolean'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW str = ["true", "TRuE", "false", "", "yes", "1"]\n| EVAL bool = TO_BOOLEAN(str)']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const toCartesianpointDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'to_cartesianpoint',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.to_cartesianpoint',{defaultMessage:'Converts an input value to a `cartesian_point` value.\nA string will only be successfully converted if it respects the\nWKT Point format.'}),preview:false,alias:undefined,signatures:[{params:[{name:'field',type:'cartesian_point',optional:false}],returnType:'cartesian_point'},{params:[{name:'field',type:'keyword',optional:false}],returnType:'cartesian_point'},{params:[{name:'field',type:'text',optional:false}],returnType:'cartesian_point'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW wkt = ["POINT(4297.11 -1475.53)", "POINT(7580.93 2272.77)"]\n| MV_EXPAND wkt\n| EVAL pt = TO_CARTESIANPOINT(wkt)']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const toCartesianshapeDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'to_cartesianshape',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.to_cartesianshape',{defaultMessage:'Converts an input value to a `cartesian_shape` value.\nA string will only be successfully converted if it respects the\nWKT format.'}),preview:false,alias:undefined,signatures:[{params:[{name:'field',type:'cartesian_point',optional:false}],returnType:'cartesian_shape'},{params:[{name:'field',type:'cartesian_shape',optional:false}],returnType:'cartesian_shape'},{params:[{name:'field',type:'keyword',optional:false}],returnType:'cartesian_shape'},{params:[{name:'field',type:'text',optional:false}],returnType:'cartesian_shape'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW wkt = ["POINT(4297.11 -1475.53)", "POLYGON ((3339584.72 1118889.97, 4452779.63 4865942.27, 2226389.81 4865942.27, 1113194.90 2273030.92, 3339584.72 1118889.97))"]\n| MV_EXPAND wkt\n| EVAL geom = TO_CARTESIANSHAPE(wkt)']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const toDateNanosDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'to_date_nanos',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.to_date_nanos',{defaultMessage:'Converts an input to a nanosecond-resolution date value (aka date_nanos).'}),preview:false,alias:undefined,signatures:[{params:[{name:'field',type:'date',optional:false}],returnType:'date_nanos'},{params:[{name:'field',type:'date_nanos',optional:false}],returnType:'date_nanos'},{params:[{name:'field',type:'double',optional:false}],returnType:'date_nanos'},{params:[{name:'field',type:'keyword',optional:false}],returnType:'date_nanos'},{params:[{name:'field',type:'long',optional:false}],returnType:'date_nanos'},{params:[{name:'field',type:'text',optional:false}],returnType:'date_nanos'},{params:[{name:'field',type:'unsigned_long',optional:false}],returnType:'date_nanos'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['FROM date_nanos\n| WHERE MV_MIN(nanos) < TO_DATE_NANOS("2023-10-23T12:27:28.948Z")\n    AND millis > "2000-01-01"\n| SORT nanos DESC']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const toDateperiodDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'to_dateperiod',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.to_dateperiod',{defaultMessage:'Converts an input value into a `date_period` value.'}),preview:false,alias:undefined,signatures:[{params:[{name:'field',type:'date_period',optional:false}],returnType:'date_period'},{params:[{name:'field',type:'keyword',optional:false}],returnType:'date_period'},{params:[{name:'field',type:'text',optional:false}],returnType:'date_period'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW x = "2024-01-01"::datetime\n| EVAL y = x + "3 DAYS"::date_period, z = x - TO_DATEPERIOD("3 days");']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const toDatetimeDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'to_datetime',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.to_datetime',{defaultMessage:"Converts an input value to a date value.\nA string will only be successfully converted if it’s respecting the format `yyyy-MM-dd'T'HH:mm:ss.SSS'Z'`.\nTo convert dates in other formats, use `DATE_PARSE`."}),preview:false,alias:['to_dt'],signatures:[{params:[{name:'field',type:'date',optional:false}],returnType:'date'},{params:[{name:'field',type:'date_nanos',optional:false}],returnType:'date'},{params:[{name:'field',type:'double',optional:false}],returnType:'date'},{params:[{name:'field',type:'integer',optional:false}],returnType:'date'},{params:[{name:'field',type:'keyword',optional:false}],returnType:'date'},{params:[{name:'field',type:'long',optional:false}],returnType:'date'},{params:[{name:'field',type:'text',optional:false}],returnType:'date'},{params:[{name:'field',type:'unsigned_long',optional:false}],returnType:'date'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW string = ["1953-09-02T00:00:00.000Z", "1964-06-02T00:00:00.000Z", "1964-06-02 00:00:00"]\n| EVAL datetime = TO_DATETIME(string)','ROW int = [0, 1]\n| EVAL dt = TO_DATETIME(int)']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const toDegreesDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'to_degrees',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.to_degrees',{defaultMessage:'Converts a number in radians to degrees.'}),preview:false,alias:undefined,signatures:[{params:[{name:'number',type:'double',optional:false}],returnType:'double'},{params:[{name:'number',type:'integer',optional:false}],returnType:'double'},{params:[{name:'number',type:'long',optional:false}],returnType:'double'},{params:[{name:'number',type:'unsigned_long',optional:false}],returnType:'double'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW rad = [1.57, 3.14, 4.71]\n| EVAL deg = TO_DEGREES(rad)']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const toDenseVectorDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'to_dense_vector',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.to_dense_vector',{defaultMessage:'Converts a multi-valued input of numbers, or a hexadecimal string, to a dense_vector.'}),preview:true,alias:undefined,signatures:[{params:[{name:'field',type:'double',optional:false}],returnType:'dense_vector'},{params:[{name:'field',type:'integer',optional:false}],returnType:'dense_vector'},{params:[{name:'field',type:'keyword',optional:false}],returnType:'dense_vector'},{params:[{name:'field',type:'long',optional:false}],returnType:'dense_vector'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['row ints = [1, 2, 3]\n| eval vector = to_dense_vector(ints)\n| keep vector']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const toDoubleDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'to_double',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.to_double',{defaultMessage:'Converts an input value to a double value. If the input parameter is of a date type,\nits value will be interpreted as milliseconds since the Unix epoch,\nconverted to double. Boolean `true` will be converted to double `1.0`, `false` to `0.0`.'}),preview:false,alias:['to_dbl'],signatures:[{params:[{name:'field',type:'boolean',optional:false}],returnType:'double'},{params:[{name:'field',type:'counter_double',optional:false}],returnType:'double'},{params:[{name:'field',type:'counter_integer',optional:false}],returnType:'double'},{params:[{name:'field',type:'counter_long',optional:false}],returnType:'double'},{params:[{name:'field',type:'date',optional:false}],returnType:'double'},{params:[{name:'field',type:'double',optional:false}],returnType:'double'},{params:[{name:'field',type:'integer',optional:false}],returnType:'double'},{params:[{name:'field',type:'keyword',optional:false}],returnType:'double'},{params:[{name:'field',type:'long',optional:false}],returnType:'double'},{params:[{name:'field',type:'text',optional:false}],returnType:'double'},{params:[{name:'field',type:'unsigned_long',optional:false}],returnType:'double'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW str1 = "5.20128E11", str2 = "foo"\n| EVAL dbl = TO_DOUBLE("520128000000"), dbl1 = TO_DOUBLE(str1), dbl2 = TO_DOUBLE(str2)']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const toGeohashDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'to_geohash',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.to_geohash',{defaultMessage:'Converts an input value to a `geohash` value.\nA string will only be successfully converted if it respects the\n`geohash` format, as described for the\ngeohash grid aggregation.'}),preview:true,alias:undefined,signatures:[{params:[{name:'field',type:'geohash',optional:false}],returnType:'geohash'},{params:[{name:'field',type:'keyword',optional:false}],returnType:'geohash'},{params:[{name:'field',type:'long',optional:false}],returnType:'geohash'},{params:[{name:'field',type:'text',optional:false}],returnType:'geohash'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW string = "u3bu"\n| EVAL geohash = TO_GEOHASH(string)']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const toGeohexDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'to_geohex',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.to_geohex',{defaultMessage:'Converts an input value to a `geohex` value.\nA string will only be successfully converted if it respects the\n`geohex` format, as described for the\ngeohex grid aggregation.'}),preview:true,alias:undefined,signatures:[{params:[{name:'field',type:'geohex',optional:false}],returnType:'geohex'},{params:[{name:'field',type:'keyword',optional:false}],returnType:'geohex'},{params:[{name:'field',type:'long',optional:false}],returnType:'geohex'},{params:[{name:'field',type:'text',optional:false}],returnType:'geohex'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW string = "841f059ffffffff"\n| EVAL geohex = TO_GEOHEX(string)']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const toGeopointDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'to_geopoint',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.to_geopoint',{defaultMessage:'Converts an input value to a `geo_point` value.\nA string will only be successfully converted if it respects the\nWKT Point format.'}),preview:false,alias:undefined,signatures:[{params:[{name:'field',type:'geo_point',optional:false}],returnType:'geo_point'},{params:[{name:'field',type:'keyword',optional:false}],returnType:'geo_point'},{params:[{name:'field',type:'text',optional:false}],returnType:'geo_point'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW wkt = "POINT(42.97109630194 14.7552534413725)"\n| EVAL pt = TO_GEOPOINT(wkt)']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const toGeoshapeDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'to_geoshape',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.to_geoshape',{defaultMessage:'Converts an input value to a `geo_shape` value.\nA string will only be successfully converted if it respects the\nWKT format.'}),preview:false,alias:undefined,signatures:[{params:[{name:'field',type:'geo_point',optional:false}],returnType:'geo_shape'},{params:[{name:'field',type:'geo_shape',optional:false}],returnType:'geo_shape'},{params:[{name:'field',type:'geohash',optional:false}],returnType:'geo_shape'},{params:[{name:'field',type:'geohex',optional:false}],returnType:'geo_shape'},{params:[{name:'field',type:'geotile',optional:false}],returnType:'geo_shape'},{params:[{name:'field',type:'keyword',optional:false}],returnType:'geo_shape'},{params:[{name:'field',type:'text',optional:false}],returnType:'geo_shape'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW wkt = "POLYGON ((30 10, 40 40, 20 40, 10 20, 30 10))"\n| EVAL geom = TO_GEOSHAPE(wkt)']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const toGeotileDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'to_geotile',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.to_geotile',{defaultMessage:'Converts an input value to a `geotile` value.\nA string will only be successfully converted if it respects the\n`geotile` format, as described for the\ngeotile grid aggregation.'}),preview:true,alias:undefined,signatures:[{params:[{name:'field',type:'geotile',optional:false}],returnType:'geotile'},{params:[{name:'field',type:'keyword',optional:false}],returnType:'geotile'},{params:[{name:'field',type:'long',optional:false}],returnType:'geotile'},{params:[{name:'field',type:'text',optional:false}],returnType:'geotile'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW string = "4/8/5"\n| EVAL geotile = TO_GEOTILE(string)']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const toIntegerDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'to_integer',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.to_integer',{defaultMessage:'Converts an input value to an integer value.\nIf the input parameter is of a date type, its value will be interpreted as milliseconds\nsince the Unix epoch, converted to integer.\nBoolean `true` will be converted to integer `1`, `false` to `0`.'}),preview:false,alias:['to_int'],signatures:[{params:[{name:'field',type:'boolean',optional:false}],returnType:'integer'},{params:[{name:'field',type:'counter_integer',optional:false}],returnType:'integer'},{params:[{name:'field',type:'date',optional:false}],returnType:'integer'},{params:[{name:'field',type:'double',optional:false}],returnType:'integer'},{params:[{name:'field',type:'integer',optional:false}],returnType:'integer'},{params:[{name:'field',type:'keyword',optional:false}],returnType:'integer'},{params:[{name:'field',type:'long',optional:false}],returnType:'integer'},{params:[{name:'field',type:'text',optional:false}],returnType:'integer'},{params:[{name:'field',type:'unsigned_long',optional:false}],returnType:'integer'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW long = [5013792, 2147483647, 501379200000]\n| EVAL int = TO_INTEGER(long)']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const toIpDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'to_ip',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.to_ip',{defaultMessage:'Converts an input string to an IP value.'}),preview:false,alias:undefined,signatures:[{params:[{name:'field',type:'ip',optional:false}],returnType:'ip'},{params:[{name:'field',type:'keyword',optional:false}],returnType:'ip'},{params:[{name:'field',type:'text',optional:false}],returnType:'ip'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW str1 = "1.1.1.1", str2 = "foo"\n| EVAL ip1 = TO_IP(str1), ip2 = TO_IP(str2)\n| WHERE CIDR_MATCH(ip1, "1.0.0.0/8")','ROW s = "1.1.010.1" | EVAL ip = TO_IP(s, {"leading_zeros":"octal"})','ROW s = "1.1.010.1" | EVAL ip = TO_IP(s, {"leading_zeros":"decimal"})']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const toLongDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'to_long',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.to_long',{defaultMessage:'Converts an input value to a long value. If the input parameter is of a date type,\nits value will be interpreted as milliseconds since the Unix epoch, converted to long.\nBoolean `true` will be converted to long `1`, `false` to `0`.'}),preview:false,alias:undefined,signatures:[{params:[{name:'field',type:'boolean',optional:false}],returnType:'long'},{params:[{name:'field',type:'counter_integer',optional:false}],returnType:'long'},{params:[{name:'field',type:'counter_long',optional:false}],returnType:'long'},{params:[{name:'field',type:'date',optional:false}],returnType:'long'},{params:[{name:'field',type:'date_nanos',optional:false}],returnType:'long'},{params:[{name:'field',type:'double',optional:false}],returnType:'long'},{params:[{name:'field',type:'geohash',optional:false}],returnType:'long'},{params:[{name:'field',type:'geohex',optional:false}],returnType:'long'},{params:[{name:'field',type:'geotile',optional:false}],returnType:'long'},{params:[{name:'field',type:'integer',optional:false}],returnType:'long'},{params:[{name:'field',type:'keyword',optional:false}],returnType:'long'},{params:[{name:'field',type:'long',optional:false}],returnType:'long'},{params:[{name:'field',type:'text',optional:false}],returnType:'long'},{params:[{name:'field',type:'unsigned_long',optional:false}],returnType:'long'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW str1 = "2147483648", str2 = "2147483648.2", str3 = "foo"\n| EVAL long1 = TO_LONG(str1), long2 = TO_LONG(str2), long3 = TO_LONG(str3)']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const toLowerDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'to_lower',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.to_lower',{defaultMessage:'Returns a new string representing the input string converted to lower case.'}),preview:false,alias:undefined,signatures:[{params:[{name:'str',type:'keyword',optional:false}],returnType:'keyword'},{params:[{name:'str',type:'text',optional:false}],returnType:'keyword'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW message = "Some Text"\n| EVAL message_lower = TO_LOWER(message)','ROW v = TO_LOWER(["Some", "Text"])']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const toRadiansDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'to_radians',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.to_radians',{defaultMessage:'Converts a number in degrees to radians.'}),preview:false,alias:undefined,signatures:[{params:[{name:'number',type:'double',optional:false}],returnType:'double'},{params:[{name:'number',type:'integer',optional:false}],returnType:'double'},{params:[{name:'number',type:'long',optional:false}],returnType:'double'},{params:[{name:'number',type:'unsigned_long',optional:false}],returnType:'double'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW deg = [90.0, 180.0, 270.0]\n| EVAL rad = TO_RADIANS(deg)']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const toStringDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'to_string',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.to_string',{defaultMessage:'Converts an input value into a string.'}),preview:false,alias:['to_str'],signatures:[{params:[{name:'field',type:'aggregate_metric_double',optional:false}],returnType:'keyword'},{params:[{name:'field',type:'boolean',optional:false}],returnType:'keyword'},{params:[{name:'field',type:'cartesian_point',optional:false}],returnType:'keyword'},{params:[{name:'field',type:'cartesian_shape',optional:false}],returnType:'keyword'},{params:[{name:'field',type:'date',optional:false}],returnType:'keyword'},{params:[{name:'field',type:'date_nanos',optional:false}],returnType:'keyword'},{params:[{name:'field',type:'dense_vector',optional:false}],returnType:'keyword'},{params:[{name:'field',type:'double',optional:false}],returnType:'keyword'},{params:[{name:'field',type:'geo_point',optional:false}],returnType:'keyword'},{params:[{name:'field',type:'geo_shape',optional:false}],returnType:'keyword'},{params:[{name:'field',type:'geohash',optional:false}],returnType:'keyword'},{params:[{name:'field',type:'geohex',optional:false}],returnType:'keyword'},{params:[{name:'field',type:'geotile',optional:false}],returnType:'keyword'},{params:[{name:'field',type:'integer',optional:false}],returnType:'keyword'},{params:[{name:'field',type:'ip',optional:false}],returnType:'keyword'},{params:[{name:'field',type:'keyword',optional:false}],returnType:'keyword'},{params:[{name:'field',type:'long',optional:false}],returnType:'keyword'},{params:[{name:'field',type:'text',optional:false}],returnType:'keyword'},{params:[{name:'field',type:'unsigned_long',optional:false}],returnType:'keyword'},{params:[{name:'field',type:'version',optional:false}],returnType:'keyword'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW a=10\n| EVAL j = TO_STRING(a)','ROW a=[10, 9, 8]\n| EVAL j = TO_STRING(a)']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const toTimedurationDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'to_timeduration',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.to_timeduration',{defaultMessage:'Converts an input value into a `time_duration` value.'}),preview:false,alias:undefined,signatures:[{params:[{name:'field',type:'keyword',optional:false}],returnType:'time_duration'},{params:[{name:'field',type:'text',optional:false}],returnType:'time_duration'},{params:[{name:'field',type:'time_duration',optional:false}],returnType:'time_duration'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW x = "2024-01-01"::datetime\n| EVAL y = x + "3 hours"::time_duration, z = x - TO_TIMEDURATION("3 hours");']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const toUnsignedLongDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'to_unsigned_long',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.to_unsigned_long',{defaultMessage:'Converts an input value to an unsigned long value. If the input parameter is of a date type,\nits value will be interpreted as milliseconds since the Unix epoch, converted to unsigned long.\nBoolean `true` will be converted to unsigned long `1`, `false` to `0`.'}),preview:true,alias:['to_ul','to_ulong'],signatures:[{params:[{name:'field',type:'boolean',optional:false}],returnType:'unsigned_long'},{params:[{name:'field',type:'date',optional:false}],returnType:'unsigned_long'},{params:[{name:'field',type:'double',optional:false}],returnType:'unsigned_long'},{params:[{name:'field',type:'integer',optional:false}],returnType:'unsigned_long'},{params:[{name:'field',type:'keyword',optional:false}],returnType:'unsigned_long'},{params:[{name:'field',type:'long',optional:false}],returnType:'unsigned_long'},{params:[{name:'field',type:'text',optional:false}],returnType:'unsigned_long'},{params:[{name:'field',type:'unsigned_long',optional:false}],returnType:'unsigned_long'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW str1 = "2147483648", str2 = "2147483648.2", str3 = "foo"\n| EVAL long1 = TO_UNSIGNED_LONG(str1), long2 = TO_ULONG(str2), long3 = TO_UL(str3)']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const toUpperDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'to_upper',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.to_upper',{defaultMessage:'Returns a new string representing the input string converted to upper case.'}),preview:false,alias:undefined,signatures:[{params:[{name:'str',type:'keyword',optional:false}],returnType:'keyword'},{params:[{name:'str',type:'text',optional:false}],returnType:'keyword'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW message = "Some Text"\n| EVAL message_upper = TO_UPPER(message)']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const toVersionDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'to_version',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.to_version',{defaultMessage:'Converts an input string to a version value.'}),preview:false,alias:['to_ver'],signatures:[{params:[{name:'field',type:'keyword',optional:false}],returnType:'version'},{params:[{name:'field',type:'text',optional:false}],returnType:'version'},{params:[{name:'field',type:'version',optional:false}],returnType:'version'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW v = TO_VERSION("1.2.3")']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const trimDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'trim',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.trim',{defaultMessage:'Removes leading and trailing whitespaces from a string.'}),preview:false,alias:undefined,signatures:[{params:[{name:'string',type:'keyword',optional:false}],returnType:'keyword'},{params:[{name:'string',type:'text',optional:false}],returnType:'keyword'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW message = "   some text  ",  color = " red "\n| EVAL message = TRIM(message)\n| EVAL color = TRIM(color)']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const urlDecodeDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'url_decode',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.url_decode',{defaultMessage:'URL-decodes the input, or returns `null` and adds a warning header to the response if the input cannot be decoded.'}),preview:false,alias:undefined,signatures:[{params:[{name:'string',type:'keyword',optional:false}],returnType:'keyword'},{params:[{name:'string',type:'text',optional:false}],returnType:'keyword'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW u = "https%3A%2F%2Fexample.com%2F%3Fx%3Dfoo%20bar%26y%3Dbaz"\n| EVAL u = URL_DECODE(u)']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const urlEncodeDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'url_encode',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.url_encode',{defaultMessage:'URL-encodes the input. All characters are percent-encoded except for alphanumerics, `.`, `-`, `_`, and `~`. Spaces are encoded as `+`.'}),preview:false,alias:undefined,signatures:[{params:[{name:'string',type:'keyword',optional:false}],returnType:'keyword'},{params:[{name:'string',type:'text',optional:false}],returnType:'keyword'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW u = "https://example.com/?x=foo bar&y=baz" | EVAL u = URL_ENCODE(u)']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const urlEncodeComponentDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'url_encode_component',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.url_encode_component',{defaultMessage:'URL-encodes the input. All characters are percent-encoded except for alphanumerics, `.`, `-`, `_`, and `~`. Spaces are encoded as `%20`.'}),preview:false,alias:undefined,signatures:[{params:[{name:'string',type:'keyword',optional:false}],returnType:'keyword'},{params:[{name:'string',type:'text',optional:false}],returnType:'keyword'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['ROW u = "https://example.com/?x=foo bar&y=baz"\n| EVAL u = URL_ENCODE_COMPONENT(u)']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const vCosineDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'v_cosine',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.v_cosine',{defaultMessage:'Calculates the cosine similarity between two dense_vectors.'}),ignoreAsSuggestion:true,preview:true,alias:undefined,signatures:[{params:[{name:'left',type:'dense_vector',optional:false},{name:'right',type:'dense_vector',optional:false}],returnType:'double'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:[' from colors\n | where color != "black"\n | eval similarity = v_cosine(rgb_vector, [0, 255, 255])\n | sort similarity desc, color asc']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const vDotProductDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'v_dot_product',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.v_dot_product',{defaultMessage:'Calculates the dot product between two dense_vectors.'}),ignoreAsSuggestion:true,preview:true,alias:undefined,signatures:[{params:[{name:'left',type:'dense_vector',optional:false},{name:'right',type:'dense_vector',optional:false}],returnType:'double'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:[' from colors\n | eval similarity = v_dot_product(rgb_vector, [0, 255, 255])\n | sort similarity desc, color asc']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const vHammingDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'v_hamming',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.v_hamming',{defaultMessage:'Calculates the Hamming distance between two dense vectors.'}),ignoreAsSuggestion:true,preview:true,alias:undefined,signatures:[{params:[{name:'left',type:'dense_vector',optional:false},{name:'right',type:'dense_vector',optional:false}],returnType:'double'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:[' from colors\n | eval similarity = v_hamming(rgb_vector, [0, 255, 255])\n | sort similarity desc, color asc']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const vL1NormDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'v_l1_norm',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.v_l1_norm',{defaultMessage:'Calculates the l1 norm between two dense_vectors.'}),ignoreAsSuggestion:true,preview:true,alias:undefined,signatures:[{params:[{name:'left',type:'dense_vector',optional:false},{name:'right',type:'dense_vector',optional:false}],returnType:'double'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:[' from colors\n | eval similarity = v_l1_norm(rgb_vector, [0, 255, 255])\n | sort similarity desc, color asc']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const vL2NormDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'v_l2_norm',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.v_l2_norm',{defaultMessage:'Calculates the l2 norm between two dense_vectors.'}),ignoreAsSuggestion:true,preview:true,alias:undefined,signatures:[{params:[{name:'left',type:'dense_vector',optional:false},{name:'right',type:'dense_vector',optional:false}],returnType:'double'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:[' from colors\n | eval similarity = v_l2_norm(rgb_vector, [0, 255, 255])\n | sort similarity desc, color asc']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const vMagnitudeDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'v_magnitude',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.v_magnitude',{defaultMessage:'Calculates the magnitude of a dense_vector.'}),ignoreAsSuggestion:true,preview:true,alias:undefined,signatures:[{params:[{name:'input',type:'dense_vector',optional:false}],returnType:'double'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:[' from colors\n | eval magnitude = v_magnitude(rgb_vector)\n | sort magnitude desc, color asc']};// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const caseDefinition={type:_types2.FunctionDefinitionTypes.SCALAR,name:'case',description:_i18n.i18n.translate('kbn-esql-ast.esql.definitions.case',{defaultMessage:'Accepts pairs of conditions and values. The function returns the value that belongs to the first condition that evaluates to `true`. If the number of arguments is odd, the last argument is the default value which is returned when no condition matches.'}),preview:false,alias:undefined,signatures:[{params:[{name:'condition',type:'boolean'},{name:'value',type:'any'}],minParams:2,returnType:'unknown'}],locationsAvailable:[_types.Location.EVAL,_types.Location.ROW,_types.Location.SORT,_types.Location.WHERE,_types.Location.STATS,_types.Location.STATS_BY,_types.Location.STATS_WHERE,_types.Location.STATS_TIMESERIES,_types.Location.COMPLETION,_types.Location.RERANK],examples:['from index | eval type = case(languages <= 1, "monolingual", languages <= 2, "bilingual", "polyglot")']};const scalarFunctionDefinitions=exports.scalarFunctionDefinitions=[absDefinition,acosDefinition,asinDefinition,atanDefinition,atan2Definition,bitLengthDefinition,byteLengthDefinition,cbrtDefinition,ceilDefinition,cidrMatchDefinition,clampDefinition,clampMaxDefinition,clampMinDefinition,coalesceDefinition,concatDefinition,containsDefinition,copySignDefinition,cosDefinition,coshDefinition,dateDiffDefinition,dateExtractDefinition,dateFormatDefinition,dateParseDefinition,dateTruncDefinition,dayNameDefinition,decayDefinition,eDefinition,endsWithDefinition,expDefinition,floorDefinition,fromBase64Definition,greatestDefinition,hashDefinition,hypotDefinition,ipPrefixDefinition,knnDefinition,kqlDefinition,leastDefinition,leftDefinition,lengthDefinition,locateDefinition,logDefinition,log10Definition,ltrimDefinition,matchDefinition,matchPhraseDefinition,md5Definition,monthNameDefinition,multiMatchDefinition,mvAppendDefinition,mvAvgDefinition,mvConcatDefinition,mvContainsDefinition,mvCountDefinition,mvDedupeDefinition,mvFirstDefinition,mvLastDefinition,mvMaxDefinition,mvMedianDefinition,mvMedianAbsoluteDeviationDefinition,mvMinDefinition,mvPercentileDefinition,mvPseriesWeightedSumDefinition,mvSliceDefinition,mvSortDefinition,mvSumDefinition,mvZipDefinition,nowDefinition,piDefinition,powDefinition,qstrDefinition,repeatDefinition,replaceDefinition,reverseDefinition,rightDefinition,roundDefinition,roundToDefinition,rtrimDefinition,scalbDefinition,scoreDefinition,sha1Definition,sha256Definition,signumDefinition,sinDefinition,sinhDefinition,spaceDefinition,splitDefinition,sqrtDefinition,stContainsDefinition,stDisjointDefinition,stDistanceDefinition,stEnvelopeDefinition,stGeohashDefinition,stGeohexDefinition,stGeotileDefinition,stIntersectsDefinition,stWithinDefinition,stXDefinition,stXmaxDefinition,stXminDefinition,stYDefinition,stYmaxDefinition,stYminDefinition,startsWithDefinition,substringDefinition,tanDefinition,tanhDefinition,tauDefinition,termDefinition,textEmbeddingDefinition,toAggregateMetricDoubleDefinition,toBase64Definition,toBooleanDefinition,toCartesianpointDefinition,toCartesianshapeDefinition,toDateNanosDefinition,toDateperiodDefinition,toDatetimeDefinition,toDegreesDefinition,toDenseVectorDefinition,toDoubleDefinition,toGeohashDefinition,toGeohexDefinition,toGeopointDefinition,toGeoshapeDefinition,toGeotileDefinition,toIntegerDefinition,toIpDefinition,toLongDefinition,toLowerDefinition,toRadiansDefinition,toStringDefinition,toTimedurationDefinition,toUnsignedLongDefinition,toUpperDefinition,toVersionDefinition,trimDefinition,urlDecodeDefinition,urlEncodeDefinition,urlEncodeComponentDefinition,vCosineDefinition,vDotProductDefinition,vHammingDefinition,vL1NormDefinition,vL2NormDefinition,vMagnitudeDefinition,caseDefinition];