"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.autocomplete = autocomplete;
var _i18n = require("@kbn/i18n");
var _helpers = require("../../../definitions/utils/autocomplete/helpers");
var _settings = require("../../../definitions/utils/settings");
var _ = require("../../../..");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

// SET <setting> = <value>;
async function autocomplete(query, command, callbacks, context, cursorPosition) {
  var _COMPLETIONS_BY_SETTI;
  const innerText = query.substring(0, cursorPosition);
  const settingArg = command.args[0];
  const settingLeftSide = (0, _.isBinaryExpression)(settingArg) ? settingArg.args[0] : null;
  const settingRightSide = (0, _.isBinaryExpression)(settingArg) ? settingArg.args[1] : null;

  // SET /
  if (!settingArg) {
    // settingLeftSide is not built until user types '=', so we need to check with regex if the leftside is present
    const hasSettingLeftSide = /SET\s+\S+\s+$/.test(innerText);
    if (hasSettingLeftSide) {
      return [{
        ..._.assignCompletionItem,
        detail: ''
      }];
    } else {
      return (0, _settings.getSettingsCompletionItems)(callbacks === null || callbacks === void 0 ? void 0 : callbacks.isServerless);
    }
  }

  // The value completions depends on the setting name.
  const settingsValueCompletions = (_COMPLETIONS_BY_SETTI = COMPLETIONS_BY_SETTING_NAME[(0, _.isIdentifier)(settingLeftSide) ? settingLeftSide.text : '']) !== null && _COMPLETIONS_BY_SETTI !== void 0 ? _COMPLETIONS_BY_SETTI : [];

  // SET <setting> = /
  if (!settingRightSide || (0, _.isUnknownNode)(settingRightSide)) {
    return settingsValueCompletions.map(item => ({
      ...item,
      text: `"${item.text}";`
    }));
  }

  // SET <setting> = "/  --- Within the value quotes.
  if ((0, _.isStringLiteral)(settingRightSide)) {
    if (cursorPosition && (0, _.within)(cursorPosition, settingRightSide)) {
      const isFragmentComplete = () => {
        return settingRightSide.valueUnquoted.length > 0 && innerText.endsWith('"');
      };
      const getSuggestionsForIncomplete = () => {
        return settingsValueCompletions.map(item => {
          return {
            ...item,
            rangeToReplace: {
              start: settingRightSide.location.min + 1,
              end: innerText.length
            }
          };
        });
      };
      const getSuggestionsForComplete = () => [];
      return (0, _helpers.handleFragment)(innerText, isFragmentComplete, getSuggestionsForIncomplete, getSuggestionsForComplete);
    }
  }

  // SET <setting> = <value>/
  if ((0, _.isBinaryExpression)(settingArg) && !settingArg.incomplete) {
    return [{
      ..._.semiColonCompleteItem,
      text: ';\n' // Add a new line so the actual query starts in the line below.
    }];
  }
  return [];
}
const getProjectRoutingCommonCompletionItems = () => {
  return [{
    label: '_alias:_origin',
    text: '_alias:_origin',
    kind: 'Value',
    detail: _i18n.i18n.translate('kbn-esql-ast.esql.autocomplete.set.projectRouting.currentProjectDoc', {
      defaultMessage: 'Search only the current project'
    }),
    sortText: '1'
  }, {
    label: '_alias: *',
    text: '_alias: *',
    kind: 'Value',
    detail: _i18n.i18n.translate('kbn-esql-ast.esql.autocomplete.set.projectRouting.allProjectsDoc', {
      defaultMessage: 'Search all projects'
    }),
    sortText: '1'
  }];
};
const COMPLETIONS_BY_SETTING_NAME = {
  project_routing: getProjectRoutingCommonCompletionItems()
};