"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Complex = Complex;
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _components = require("../../../components");
var _helpers = require("../../../helpers");
var _hooks = require("../../hooks");
var _use_field = require("../use_field");
var _use_array = require("../use_array");
var _form_utils = require("./form_utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/es_ui_shared/static/forms/hook_form_lib/components/__stories__/use_array_complex.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const {
  emptyField
} = _helpers.fieldValidators;
const typeOptions = [{
  value: 'type_one',
  text: 'Type one'
}, {
  value: 'type_two',
  text: 'Type two'
}];
const processorTypeOptions = [{
  value: 'percentage',
  text: 'Percentage'
}, {
  value: 'value',
  text: 'Value'
}];
const percentageOptions = [{
  value: 'percentage_config_1',
  inputDisplay: /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: "subdued",
    css: {
      lineHeight: 'inherit'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 7
    }
  }, "Percentage 1")
}, {
  value: 'percentage_config_2',
  inputDisplay: /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: "warning",
    css: {
      lineHeight: 'inherit'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 7
    }
  }, "Percentage 2")
}, {
  value: 'percentage_config_3',
  inputDisplay: /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: "danger",
    css: {
      lineHeight: 'inherit'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 7
    }
  }, "Percentage 3")
}];
const valueOptions = [{
  value: 'value_config_1',
  inputDisplay: /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: "subdued",
    css: {
      lineHeight: 'inherit'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 7
    }
  }, "Value 1")
}, {
  value: 'value_config_2',
  inputDisplay: /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: "warning",
    css: {
      lineHeight: 'inherit'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 7
    }
  }, "Value 2")
}, {
  value: 'value_config_3',
  inputDisplay: /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: "danger",
    css: {
      lineHeight: 'inherit'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 7
    }
  }, "Value 3")
}];
const configSelect = {
  label: 'Config'
};
const PercentageConfigSelect = ({
  path
}) => {
  return /*#__PURE__*/_react.default.createElement(_use_field.UseField, {
    path: path,
    component: _components.SuperSelectField,
    config: {
      ...configSelect,
      defaultValue: percentageOptions[0].value
    },
    componentProps: {
      euiFieldProps: {
        options: percentageOptions
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 5
    }
  });
};
const ValueConfigSelect = ({
  path
}) => {
  return /*#__PURE__*/_react.default.createElement(_use_field.UseField, {
    path: path,
    component: _components.SuperSelectField,
    config: {
      ...configSelect,
      defaultValue: valueOptions[0].value
    },
    componentProps: {
      euiFieldProps: {
        options: valueOptions
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 5
    }
  });
};
const percentageProcessorTypeConfig = {
  label: 'Processor type',
  defaultValue: 'percentage'
};
const ProcessorTypeConfigurator = ({
  basePath
}) => {
  const processorTypePath = `${basePath}.type`;
  const processorConfigPath = `${basePath}.config`;
  const [formData] = (0, _hooks.useFormData)({
    watch: processorTypePath
  });
  const processorType = (0, _lodash.get)(formData, processorTypePath);
  const renderSelect = () => {
    if (!processorType) {
      return null;
    }
    return processorType === 'percentage' ? /*#__PURE__*/_react.default.createElement(PercentageConfigSelect, {
      path: processorConfigPath,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 143,
        columnNumber: 7
      }
    }) : /*#__PURE__*/_react.default.createElement(ValueConfigSelect, {
      path: processorConfigPath,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 145,
        columnNumber: 7
      }
    });
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_use_field.UseField, {
    path: processorTypePath,
    config: percentageProcessorTypeConfig,
    component: _components.SelectField,
    componentProps: {
      euiFieldProps: {
        options: processorTypeOptions
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 7
    }
  }, renderSelect()));
};
const ProcessorsConfigurator = ({
  ruleType
}) => {
  return /*#__PURE__*/_react.default.createElement(_use_array.UseArray, {
    key: ruleType,
    path: "processors",
    initialNumberOfItems: ruleType === 'type_one' ? 1 : 3,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 5
    }
  }, ({
    items,
    addItem,
    removeItem
  }) => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, items.map(({
      id,
      path
    }) => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        key: id,
        alignItems: "center",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 180,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 181,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement(_use_field.UseField, {
        path: `${path}.name`,
        config: {
          label: 'Name',
          validations: [{
            validator: emptyField('A name is required.')
          }]
        },
        component: _components.TextField,
        componentProps: {
          euiFieldProps: {
            css: {
              maxWidth: '180px'
            }
          }
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 183,
          columnNumber: 21
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 199,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement(ProcessorTypeConfigurator, {
        basePath: path,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 201,
          columnNumber: 21
        }
      })), items.length > 1 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 204,
          columnNumber: 21
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        iconType: "minusInCircle",
        onClick: () => removeItem(id),
        "aria-label": "Remove processor",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 205,
          columnNumber: 23
        }
      })));
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 215,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "flexEnd",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 218,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: addItem,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 219,
        columnNumber: 15
      }
    }, "Add processor")));
  });
};
const FormContent = () => {
  const [{
    ruleType
  }] = (0, _hooks.useFormData)({
    watch: 'ruleType'
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 233,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 234,
      columnNumber: 9
    }
  }, "Rule configurator")), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 236,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_use_field.UseField, {
    path: "ruleType",
    component: _components.SelectField,
    componentProps: {
      euiFieldProps: {
        options: typeOptions
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 239,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 248,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 250,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 251,
      columnNumber: 9
    }
  }, "Processors")), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 253,
      columnNumber: 7
    }
  }), ruleType !== undefined && /*#__PURE__*/_react.default.createElement(ProcessorsConfigurator, {
    ruleType: ruleType,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 254,
      columnNumber: 34
    }
  }));
};
const defaultValue = {
  ruleType: 'type_one',
  processors_type_one: [{
    name: 'Processor 1 name',
    type: 'value',
    config: 'value_config_3'
  }, {
    name: 'Processor 2 name',
    type: 'percentage',
    config: 'percentage_config_2'
  }]
};
const schema = {
  ruleType: {
    label: 'Rule type',
    defaultValue: 'type_one'
  }
};
const formConfig = {
  schema,
  defaultValue
};
function Complex() {
  return /*#__PURE__*/_react.default.createElement(_form_utils.FormWrapper, {
    formConfig: formConfig,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 281,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(FormContent, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 282,
      columnNumber: 7
    }
  }));
}
Complex.storyName = 'Complex';
Complex.parameters = {
  docs: {
    source: {
      code: `
const typeOptions = [
  { value: 'type_one', text: 'Type one' },
  { value: 'type_two', text: 'Type two' },
];

const processorTypeOptions = [
  { value: 'percentage', text: 'Percentage' },
  { value: 'value', text: 'Value' },
];

const percentageOptions = [
  {
    value: 'percentage_config_1',
    inputDisplay: (
      <EuiHealth color="subdued" css={{ lineHeight: 'inherit' }}>
        Percentage 1
      </EuiHealth>
    ),
  },
  {
    value: 'percentage_config_2',
    inputDisplay: (
      <EuiHealth color="warning" css={{ lineHeight: 'inherit' }}>
        Percentage 2
      </EuiHealth>
    ),
  },
  {
    value: 'percentage_config_3',
    inputDisplay: (
      <EuiHealth color="danger" css={{ lineHeight: 'inherit' }}>
        Percentage 3
      </EuiHealth>
    ),
  },
];

const valueOptions = [
  {
    value: 'value_config_1',
    inputDisplay: (
      <EuiHealth color="subdued" css={{ lineHeight: 'inherit' }}>
        Value 1
      </EuiHealth>
    ),
  },
  {
    value: 'value_config_2',
    inputDisplay: (
      <EuiHealth color="warning" css={{ lineHeight: 'inherit' }}>
        Value 2
      </EuiHealth>
    ),
  },
  {
    value: 'value_config_3',
    inputDisplay: (
      <EuiHealth color="danger" css={{ lineHeight: 'inherit' }}>
        Value 3
      </EuiHealth>
    ),
  },
];

const configSelect = { label: 'Config' };

const PercentageConfigSelect = ({ path }: { path: string }) => {
  return (
    <UseField
      path={path}
      component={SuperSelectField}
      config={{ ...configSelect, defaultValue: percentageOptions[0].value }}
      componentProps={{
        euiFieldProps: {
          options: percentageOptions,
        },
      }}
    />
  );
};

const ValueConfigSelect = ({ path }: { path: string }) => {
  return (
    <UseField
      path={path}
      component={SuperSelectField}
      config={{ ...configSelect, defaultValue: valueOptions[0].value }}
      componentProps={{
        euiFieldProps: {
          options: valueOptions,
        },
      }}
    />
  );
};

const percentageProcessorTypeConfig = { label: 'Processor type', defaultValue: 'percentage' };

const ProcessorTypeConfigurator = ({ basePath }: { basePath: string }) => {
  const processorTypePath = \`\${basePath}.type\`;
  const processorConfigPath = \`\${basePath}.config\`;
  const [formData] = useFormData({ watch: processorTypePath });
  const processorType = get(formData, processorTypePath);

  const renderSelect = () => {
    if (!processorType) {
      return null;
    }

    return processorType === 'percentage' ? (
      <PercentageConfigSelect path={processorConfigPath} />
    ) : (
      <ValueConfigSelect path={processorConfigPath} />
    );
  };

  return (
    <EuiFlexGroup>
      <EuiFlexItem>
        <UseField
          path={processorTypePath}
          config={percentageProcessorTypeConfig}
          component={SelectField}
          componentProps={{
            euiFieldProps: {
              options: processorTypeOptions,
            },
          }}
        />
      </EuiFlexItem>
      <EuiFlexItem>{renderSelect()}</EuiFlexItem>
    </EuiFlexGroup>
  );
};

const ProcessorsConfigurator: FC<{ ruleType: string }> = ({ ruleType }) => {
  return (
    <UseArray
      key={ruleType}
      path="processors"
      initialNumberOfItems={ruleType === 'type_one' ? 1 : 3}
    >
      {({ items, addItem, removeItem }) => {
        return (
          <>
            {items.map(({ id, path }) => {
              return (
                <EuiFlexGroup key={id} alignItems="center">
                  <EuiFlexItem grow={false}>
                    {/* Processor name */}
                    <UseField
                      path={\`\${path}.name\`}
                      config={{
                        label: 'Name',
                        validations: [{ validator: emptyField('A name is required.') }],
                      }}
                      component={TextField}
                      componentProps={{
                        euiFieldProps: {
                          css: {
                            maxWidth: '180px',
                          },
                        },
                      }}
                    />
                  </EuiFlexItem>
                  <EuiFlexItem>
                    {/* Processor type & config */}
                    <ProcessorTypeConfigurator basePath={path} />
                  </EuiFlexItem>
                  {items.length > 1 && (
                    <EuiFlexItem grow={false}>
                      <EuiButtonIcon
                        iconType="minusInCircle"
                        onClick={() => removeItem(id)}
                        aria-label="Remove processor"
                      />
                    </EuiFlexItem>
                  )}
                </EuiFlexGroup>
              );
            })}
            <EuiSpacer size="m" />

            {/* Add processor button */}
            <EuiFlexGroup justifyContent="flexEnd">
              <EuiButtonEmpty onClick={addItem}>Add processor</EuiButtonEmpty>
            </EuiFlexGroup>
          </>
        );
      }}
    </UseArray>
  );
};

const defaultValue = {
  ruleType: 'type_one',
  processors_type_one: [
    { name: 'Processor 1 name', type: 'value', config: 'value_config_3' },
    { name: 'Processor 2 name', type: 'percentage', config: 'percentage_config_2' },
  ],
};

const schema = {
  ruleType: {
    label: 'Rule type',
    defaultValue: 'type_one',
  },
};

const MyFormComponent = () => {
  const { form } = useForm({ schema, defaultValue });

  const submitForm = async () => {
    const { isValid, data } = await form.submit();
    if (isValid) {
      // ... do something with the data
    }
  };

  return (
    <Form form={form}>
      <EuiTitle>
        <h2>Rule configurator</h2>
      </EuiTitle>
      <EuiSpacer size="xl" />

      {/* Rule type */}
      <UseField
        path="ruleType"
        component={SelectField}
        componentProps={{
          euiFieldProps: {
            options: typeOptions,
          },
        }}
      />
      <EuiSpacer />

      <EuiTitle size="s">
        <h2>Processors</h2>
      </EuiTitle>
      <EuiSpacer size="s" />
      {ruleType !== undefined && <ProcessorsConfigurator ruleType={ruleType} />}
      <EuiSpacer />
      <EuiButton onClick={submitForm}>Send</EuiButton>
    </Form>
  );
}
      `,
      language: 'tsx'
    }
  }
};