"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getApiKeyById = exports.GetApiKeyByIdLogic = void 0;
var _create_api_logic = require("../../../shared/api_logic/create_api_logic");
var _http = require("../../../shared/http");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getApiKeyById = async id => {
  const route = `/internal/enterprise_search/api_keys/${id}`;
  return await _http.HttpLogic.values.http.get(route);
};
exports.getApiKeyById = getApiKeyById;
const GetApiKeyByIdLogic = exports.GetApiKeyByIdLogic = (0, _create_api_logic.createApiLogic)(['get_api_key_by_id_logic'], getApiKeyById);