"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initializeDynamicActionsManager = initializeDynamicActionsManager;
var _presentationPublishing = require("@kbn/presentation-publishing");
var _public = require("@kbn/ui-actions-enhanced-plugin/public");
var _reactFastCompare = _interopRequireDefault(require("react-fast-compare"));
var _rxjs = require("rxjs");
var _dynamic_action_storage = require("./dynamic_action_storage");
var _get_dynamic_actions_state = require("./get_dynamic_actions_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function initializeDynamicActionsManager(uuid, getTitle, state, services) {
  var _state$rawState$enhan, _state$references;
  const enhancement = services.embeddable.getEnhancement('dynamicActions');
  const initialEnhancementsState = enhancement && (_state$rawState$enhan = state.rawState.enhancements) !== null && _state$rawState$enhan !== void 0 && _state$rawState$enhan.dynamicActions ? {
    dynamicActions: enhancement.inject(state.rawState.enhancements.dynamicActions, (_state$references = state.references) !== null && _state$references !== void 0 ? _state$references : [])
  } : state.rawState.enhancements;
  const dynamicActionsState$ = new _rxjs.BehaviorSubject((0, _get_dynamic_actions_state.getDynamicActionsState)(initialEnhancementsState));
  const api = {
    dynamicActionsState$,
    setDynamicActions: enhancements => {
      dynamicActionsState$.next((0, _get_dynamic_actions_state.getDynamicActionsState)(enhancements));
    }
  };
  const storage = new _dynamic_action_storage.DynamicActionStorage(uuid, getTitle, api);
  const dynamicActions = new _public.UiActionsEnhancedDynamicActionManager({
    isCompatible: async context => {
      const {
        embeddable
      } = context;
      return (0, _presentationPublishing.apiHasUniqueId)(embeddable) && embeddable.uuid === uuid;
    },
    storage,
    uiActions: services.uiActionsEnhanced
  });
  function getLatestState() {
    return {
      enhancements: dynamicActionsState$.getValue()
    };
  }
  return {
    api: {
      ...api,
      enhancements: {
        dynamicActions
      }
    },
    comparators: {
      enhancements: (a, b) => {
        return (0, _reactFastCompare.default)((0, _get_dynamic_actions_state.getDynamicActionsState)(a), (0, _get_dynamic_actions_state.getDynamicActionsState)(b));
      }
    },
    anyStateChange$: dynamicActionsState$.pipe((0, _rxjs.map)(() => undefined)),
    getLatestState,
    serializeState: () => {
      var _latestState$enhancem;
      const latestState = getLatestState();
      if (!enhancement || !((_latestState$enhancem = latestState.enhancements) !== null && _latestState$enhancem !== void 0 && _latestState$enhancem.dynamicActions)) {
        return {
          rawState: latestState,
          references: []
        };
      }
      const extractResults = enhancement.extract(latestState.enhancements.dynamicActions);
      return {
        rawState: {
          enhancements: {
            dynamicActions: extractResults.state
          }
        },
        references: extractResults.references
      };
    },
    reinitializeState: lastState => {
      api.setDynamicActions(lastState.enhancements);
    },
    startDynamicActions: () => {
      dynamicActions.start().catch(error => {
        /* eslint-disable no-console */
        console.log('Failed to start embeddable dynamic actions', dynamicActions);
        console.error(error);
        /* eslint-enable */
      });
      return {
        stopDynamicActions: () => {
          dynamicActions.stop().catch(error => {
            /* eslint-disable no-console */
            console.log('Failed to stop embeddable dynamic actions', dynamicActions);
            console.error(error);
            /* eslint-enable */
          });
        }
      };
    }
  };
}